/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.CodeSpaceRange;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.TD;

class CIDTextUtils {
    CIDTextUtils() {
    }

    static int getNonEmbedCIDCharValues(int i, byte[] stream, int streamLength, GlyphData glyphData, PdfFont currentFontData) {
        float actualWidth;
        CodeSpaceRange cmap = glyphData.getCodeSpaceRange();
        int nn = 0;
        int v = 0;
        int p = 1;
        while (i + nn < stream.length) {
            int b1 = stream[i + nn] & 0xFF;
            ++nn;
            if (b1 == 92) {
                b1 = stream[i + nn] & 0xFF;
                ++nn;
                if (CIDTextUtils.isDigit(b1)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append((char)b1);
                    if (i + nn < streamLength && CIDTextUtils.isDigit(stream[i + nn] & 0xFF)) {
                        sb.append((char)(stream[i + nn] & 0xFF));
                        if (i + ++nn < streamLength && CIDTextUtils.isDigit(stream[i + nn] & 0xFF)) {
                            sb.append((char)(stream[i + nn] & 0xFF));
                            ++nn;
                        }
                    }
                    b1 = Integer.parseInt(sb.toString(), 8);
                } else {
                    b1 = CIDTextUtils.convertEscapeChar(b1);
                }
            }
            if (cmap.isInCodeSpaceRange(v = v << 8 | b1, p)) break;
            ++p;
        }
        int cid = cmap.cidMap[v];
        int uni = cmap.uniMap[cid];
        glyphData.setRawInt(v);
        glyphData.setRawChar((char)v);
        glyphData.setDisplayValue(String.valueOf((char)uni));
        glyphData.setUnicodeValue(String.valueOf((char)uni));
        if (p > 1) {
            actualWidth = currentFontData.getDefaultWidth(cid);
            if (actualWidth == -1.0f) {
                actualWidth = currentFontData.getDefaultWidth(-1);
            }
        } else {
            actualWidth = -1.0f;
            if ((currentFontData.getFontType() == -1684566726 || currentFontData.getFontType() == -1684566724) && (actualWidth = currentFontData.getDefaultWidth(cid)) == -1.0f) {
                actualWidth = currentFontData.getDefaultWidth(-1) / 2.0f;
            }
        }
        if (actualWidth > 0.0f) {
            glyphData.setActualWidth(actualWidth);
        }
        return i + nn - 1;
    }

    static int getCIDtoGIDandUNICharValues(int i, byte[] stream, int streamLength, GlyphData glyphData, PdfFont currentFontData) {
        float actualWidth;
        int nn = 0;
        int v = 0;
        int p = 1;
        while (i + nn < stream.length) {
            int b1 = stream[i + nn] & 0xFF;
            ++nn;
            if (b1 == 92) {
                b1 = stream[i + nn] & 0xFF;
                ++nn;
                if (CIDTextUtils.isDigit(b1)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append((char)b1);
                    if (i + nn < streamLength && CIDTextUtils.isDigit(stream[i + nn] & 0xFF)) {
                        sb.append((char)(stream[i + nn] & 0xFF));
                        if (i + ++nn < streamLength && CIDTextUtils.isDigit(stream[i + nn] & 0xFF)) {
                            sb.append((char)(stream[i + nn] & 0xFF));
                            ++nn;
                        }
                    }
                    b1 = Integer.parseInt(sb.toString(), 8);
                } else {
                    b1 = CIDTextUtils.convertEscapeChar(b1);
                }
            }
            if (currentFontData.getUnicodeMapping(v = v << 8 | b1) != null || p == 2) break;
            ++p;
        }
        glyphData.setRawInt(v);
        glyphData.setRawChar((char)v);
        int cid = v;
        glyphData.setDisplayValue(currentFontData.getUnicodeMapping(cid));
        glyphData.setUnicodeValue(currentFontData.getUnicodeMapping(cid));
        if (p > 1) {
            actualWidth = currentFontData.getDefaultWidth(cid);
            if (actualWidth == -1.0f) {
                actualWidth = currentFontData.getDefaultWidth(-1);
            }
        } else {
            actualWidth = -1.0f;
            if ((currentFontData.getFontType() == -1684566726 || currentFontData.getFontType() == -1684566724) && (actualWidth = currentFontData.getDefaultWidth(cid)) == -1.0f) {
                actualWidth = currentFontData.getDefaultWidth(-1) / 2.0f;
            }
        }
        if (actualWidth > 0.0f) {
            glyphData.setActualWidth(actualWidth);
        }
        return i + nn - 1;
    }

    private static boolean isDigit(int v) {
        return v >= 48 && v <= 57;
    }

    static int getCIDCharValues(int i, byte[] stream, int streamLength, GlyphData glyphData, PdfFont currentFontData, ParserOptions parserOptions) {
        boolean hasCharString;
        float actualWidth = 0.0f;
        if (StandardFonts.CMAP == null) {
            StandardFonts.readCMAP();
        }
        int firstVal = glyphData.getRawInt();
        String newValue = null;
        if (firstVal == 92) {
            firstVal = stream[++i] & 0xFF;
            if (streamLength > i + 2 && Character.isDigit((char)stream[i])) {
                int numberCount = CIDTextUtils.getNumberCount(i, stream);
                firstVal = TD.readEscapeValue(i, numberCount, 8, stream);
                i = i + numberCount - 1;
                if (firstVal > 255) {
                    firstVal -= 256;
                }
            } else if (firstVal == 117) {
                firstVal = TD.readEscapeValue(i + 1, 4, 16, stream);
                i += 4;
            } else {
                firstVal = CIDTextUtils.convertEscapeChar(firstVal);
            }
            glyphData.setRaw(firstVal);
        } else {
            firstVal = glyphData.getRawChar();
        }
        String firstValue = StandardFonts.CMAP[glyphData.getRawChar()];
        boolean isEmbedded = currentFontData.isFontEmbedded;
        boolean bl = hasCharString = glyphData.getRawInt() > 0 && currentFontData.CMapName != null && currentFontData.getFontType() == -1684566726 && currentFontData.getGlyphData().containsKey(String.valueOf(glyphData.getRawInt()));
        if (currentFontData.CMapName == null || !currentFontData.CMapName.equals("OneByteIdentityH")) {
            if (!hasCharString && (currentFontData.hasDoubleBytes || firstValue == null || currentFontData.isDoubleBytes() != 0 || glyphData.getRawInt() > 128 && glyphData.getRawInt() != 233)) {
                int iBefore = i++;
                int secondVal = stream[i] & 0xFF;
                boolean secondByteIsEscaped = false;
                if (stream[i] == 92) {
                    ++i;
                    secondByteIsEscaped = true;
                    if (glyphData.getRawInt() == 0) {
                        while (stream[i] == 13 || stream[i] == 92 && stream[i - 1] == 13) {
                            ++i;
                        }
                    }
                    secondVal = stream[i] & 0xFF;
                    if (streamLength > i + 2 && Character.isDigit((char)stream[i])) {
                        int numberCount = CIDTextUtils.getNumberCount(i, stream);
                        secondVal = TD.readEscapeValue(i, numberCount, 8, stream);
                        i = i + numberCount - 1;
                        if (secondVal > 255) {
                            secondVal -= 256;
                        }
                    } else if (secondVal == 117) {
                        secondVal = TD.readEscapeValue(i + 1, 4, 16, stream);
                        i += 4;
                    } else {
                        secondVal = CIDTextUtils.convertEscapeChar(secondVal);
                    }
                }
                int secondByte = secondVal;
                char combinedVal = (char)((glyphData.getRawChar() << 8) + secondVal);
                newValue = StandardFonts.CMAP[combinedVal];
                int isDouble = -1;
                if (currentFontData.isCIDFont() && currentFontData.getGlyphData().getTable(2) == null) {
                    int first = currentFontData.getEncodedCMAPValue(firstVal);
                    int second = currentFontData.getEncodedCMAPValue(secondVal);
                    int combined = currentFontData.getEncodedCMAPValue(combinedVal);
                    if (combined <= 0 && (first > 0 || second > 0)) {
                        newValue = null;
                        isDouble = 0;
                    }
                }
                if (isDouble == -1) {
                    isDouble = currentFontData.isDoubleBytes(firstVal, secondByte, secondByteIsEscaped);
                }
                if (isEmbedded && (isDouble == 1 || combinedVal < '\u0100' || newValue != null)) {
                    glyphData.setRawInt(combinedVal);
                    glyphData.setRawChar(combinedVal);
                } else if (!isEmbedded && isDouble == 1 && (newValue != null || combinedVal < '\u0100' || !secondByteIsEscaped && secondByte != 41)) {
                    glyphData.setRawInt(combinedVal);
                    glyphData.setRawChar(combinedVal);
                } else if (isDouble == 0 && !isEmbedded && firstVal > 128 && newValue != null && firstValue == null) {
                    glyphData.setRawInt(combinedVal);
                    glyphData.setRawChar(combinedVal);
                } else if (isDouble == 0 && !isEmbedded && firstVal > 128 && newValue == null && firstValue != null) {
                    i = iBefore;
                    newValue = firstValue;
                } else {
                    i = iBefore;
                }
                if (!isEmbedded && (actualWidth = currentFontData.getDefaultWidth(glyphData.getRawInt())) == -1.0f) {
                    actualWidth = currentFontData.getDefaultWidth(-1);
                }
            } else {
                actualWidth = -1.0f;
                if (!(isEmbedded || currentFontData.getFontType() != -1684566726 && currentFontData.getFontType() != -1684566724 || (actualWidth = currentFontData.getDefaultWidth(glyphData.getRawInt())) != -1.0f)) {
                    actualWidth = currentFontData.getDefaultWidth(-1) / 2.0f;
                }
            }
        }
        glyphData.setActualWidth(actualWidth);
        if (newValue != null) {
            glyphData.setDisplayValue(newValue);
        } else {
            glyphData.setDisplayValue(String.valueOf(glyphData.getRawChar()));
        }
        if (parserOptions.isTextExtracted()) {
            glyphData.setUnicodeValue(currentFontData.getUnicodeValue(glyphData.getDisplayValue(), glyphData.getRawChar()));
            if (!currentFontData.isFontEmbedded) {
                glyphData.setDisplayValue(String.valueOf(currentFontData.getUnicodeValue(glyphData.getDisplayValue(), glyphData.getRawChar())));
            }
        }
        if (glyphData.getRawChar() == '\\') {
            glyphData.setValueForHTML(92);
            glyphData.setRawChar('x');
        }
        return i;
    }

    private static int getNumberCount(int i, byte[] stream) {
        int numberCount = 1;
        if (Character.isDigit((char)stream[i + 1])) {
            ++numberCount;
            if (Character.isDigit((char)stream[i + 2])) {
                ++numberCount;
            }
        }
        return numberCount;
    }

    private static int convertEscapeChar(int secondVal) {
        switch (secondVal) {
            case 110: {
                return 10;
            }
            case 98: {
                return 8;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 102: {
                return 12;
            }
        }
        return secondVal;
    }
}

