/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.mask;

import com.idrsolutions.pdf.color.shading.BitReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.data.ImageData;

public class MaskDataDecoder {
    public static BufferedImage applyMaskArray(ImageData imageData, int[] maskArray) {
        int bitDepth = imageData.getDepth();
        int nComp = maskArray.length / 2;
        int dim = imageData.getWidth() * imageData.getHeight();
        BufferedImage img = new BufferedImage(imageData.getWidth(), imageData.getHeight(), 2);
        int[] output = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        byte[] data = imageData.getObjectData();
        block0 : switch (bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                MaskDataDecoder.handleNonByteBitMask(maskArray, bitDepth, nComp, dim, output, data);
                break;
            }
            case 8: {
                switch (nComp) {
                    case 1: {
                        MaskDataDecoder.apply1CompMask(maskArray, dim, output, data);
                        break block0;
                    }
                    case 3: {
                        MaskDataDecoder.apply3CompMask(maskArray, dim, output, data);
                        break block0;
                    }
                    case 4: {
                        ExternalHandlers.ImageLib.processJPEG(dim, data, maskArray, output);
                        break block0;
                    }
                }
            }
        }
        return img;
    }

    private static void apply3CompMask(int[] maskArray, int dim, int[] output, byte[] data) {
        int p = 0;
        for (int i = 0; i < dim; ++i) {
            boolean isMask;
            int r = data[p++] & 0xFF;
            int g = data[p++] & 0xFF;
            int b = data[p++] & 0xFF;
            boolean bl = isMask = r >= maskArray[0] && r <= maskArray[1] && g >= maskArray[2] && g <= maskArray[3] && b >= maskArray[4] && b <= maskArray[5];
            if (isMask) continue;
            output[i] = 0xFF000000 | r << 16 | g << 8 | b;
        }
    }

    private static void apply1CompMask(int[] maskArray, int dim, int[] output, byte[] data) {
        int p = 0;
        for (int i = 0; i < dim; ++i) {
            int t;
            boolean isMask;
            boolean bl = isMask = (t = data[p++] & 0xFF) >= maskArray[0] && t <= maskArray[1];
            if (isMask) continue;
            output[i] = 0xFF000000 | t << 16 | t << 8 | t;
        }
    }

    private static void handleNonByteBitMask(int[] maskArray, int bitDepth, int nComp, int dim, int[] output, byte[] data) {
        BitReader reader = new BitReader(data, true);
        for (int i = 0; i < dim; ++i) {
            boolean isMask;
            if (nComp == 1) {
                int t = reader.getPositive(bitDepth);
                boolean bl = isMask = t >= maskArray[0] && t <= maskArray[1];
                if (isMask) continue;
                output[i] = 0xFF000000 | (t ^= 0xFF) << 16 | t << 8 | t;
                continue;
            }
            int r = reader.getPositive(bitDepth);
            int g = reader.getPositive(bitDepth);
            int b = reader.getPositive(bitDepth);
            boolean bl = isMask = r >= maskArray[0] && r <= maskArray[1] && g >= maskArray[2] && g <= maskArray[3] && b >= maskArray[4] && b <= maskArray[5];
            if (isMask) continue;
            output[i] = 0xFF000000 | (r ^= 0xFF) << 16 | (g ^= 0xFF) << 8 | (b ^= 0xFF);
        }
    }

    static byte[] convertData(GenericColorSpace decodeColorData, byte[] objectData, int w, int h, ImageData imageData, int d) {
        byte[] index = decodeColorData.getIndexedMap();
        if (index != null) {
            index = decodeColorData.convertIndexToRGB(index);
            objectData = ColorSpaceConvertor.convertIndexToRGBByte(index, w, h, imageData.getDepth(), objectData, false, false);
        } else if (decodeColorData.getID() != 1008872003) {
            if (decodeColorData.getID() == 1785221209) {
                if (d == 8) {
                    MaskDataDecoder.check4BitData(objectData);
                }
            } else if (!(decodeColorData.getID() == 1568372915 && imageData.isJPX() || imageData.isDCT() || imageData.isJPX() || d == 1)) {
                objectData = decodeColorData.dataToRGBByteArray(objectData, w, h);
            }
        }
        return objectData;
    }

    private static void check4BitData(byte[] objectData) {
        int size = objectData.length;
        boolean is4Bit = true;
        for (byte b : objectData) {
            if (b >= 0 && b <= 15) continue;
            is4Bit = false;
            break;
        }
        if (is4Bit) {
            int ii = 0;
            while (ii < size) {
                int n = ii++;
                objectData[n] = (byte)(objectData[n] << 4);
            }
        }
    }

    public static byte[] getSMaskData(byte[] maskData, ImageData smaskData, PdfObject newSMask, GenericColorSpace maskColorData) {
        smaskData.getFilter(newSMask);
        if (smaskData.isDCT()) {
            maskData = JPEGDecoder.getBytesFromJPEG(maskData, maskColorData, newSMask);
            newSMask.setMixedArray(1011108731, null);
            newSMask.setDecodedStream(maskData);
        }
        return maskData;
    }
}

