/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.downsample;

import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.images.SamplingFactory;
import org.jpedal.parser.image.PdfImageTypes;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.downsample.KernelUtils;

class OneBitDownSampler {
    OneBitDownSampler() {
    }

    private static GenericColorSpace downSample(int sampling, ImageData imageData, GenericColorSpace decodeColorData) {
        byte[] data = imageData.getObjectData();
        int[] flag = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int newW = imageData.getWidth() / sampling;
        int newH = imageData.getHeight() / sampling;
        int size = newW * newH;
        byte[] newData = new byte[size];
        int origLineLength = imageData.getWidth() + 7 >> 3;
        for (int y = 0; y < newH; ++y) {
            for (int x = 0; x < newW; ++x) {
                int wCount = sampling;
                int hCount = sampling;
                int wGapLeft = imageData.getWidth() - x;
                int hGapLeft = imageData.getHeight() - y;
                if (wCount > wGapLeft) {
                    wCount = wGapLeft;
                }
                if (hCount > hGapLeft) {
                    hCount = hGapLeft;
                }
                int bytes = OneBitDownSampler.getPixelSetCount(sampling, false, data, flag, origLineLength, y, x, wCount, hCount);
                int count = wCount * hCount;
                int offset = x + newW * y;
                newData[offset] = count > 0 ? (int)(255 * bytes / count) : -1;
            }
        }
        imageData.setWidth(newW);
        imageData.setHeight(newH);
        imageData.setCompCount(1);
        if (decodeColorData.getID() == -2073385820 || decodeColorData.getID() == 960981604) {
            decodeColorData = new DeviceRGBColorSpace();
            imageData.setCompCount(1);
            OneBitDownSampler.invertBytes(newData);
        }
        imageData.setObjectData(newData);
        imageData.setDepth(8);
        return decodeColorData;
    }

    private static void invertBytes(byte[] newData) {
        int count = newData.length;
        int aa = 0;
        while (aa < count) {
            int n = aa++;
            newData[n] = (byte)(newData[n] ^ 0xFF);
        }
    }

    private static void downsampleTo8Bit(int sampling, ImageData imageData, boolean isMask) {
        byte[] data = imageData.getObjectData();
        int newW = imageData.getWidth() / sampling;
        int newH = imageData.getHeight() / sampling;
        int size = newW * newH;
        byte[] newData = new byte[size];
        int[] flag = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int origLineLength = imageData.getWidth() + 7 >> 3;
        for (int y = 0; y < newH; ++y) {
            for (int x = 0; x < newW; ++x) {
                int wCount = sampling;
                int hCount = sampling;
                int wGapLeft = imageData.getWidth() - x;
                int hGapLeft = imageData.getHeight() - y;
                if (wCount > wGapLeft) {
                    wCount = wGapLeft;
                }
                if (hCount > hGapLeft) {
                    hCount = hGapLeft;
                }
                int bytes = OneBitDownSampler.getPixelSetCount(sampling, isMask, data, flag, origLineLength, y, x, wCount, hCount);
                int count = wCount * hCount;
                int offset = x + newW * y;
                if (bytes <= 0) continue;
                newData[offset] = (byte)(255 * bytes / count);
            }
        }
        imageData.setWidth(newW);
        imageData.setHeight(newH);
        imageData.setObjectData(newData);
        imageData.setDepth(8);
        imageData.setCompCount(1);
    }

    private static void convertToARGB(ImageData imageData, byte[] maskCol, boolean scaleTransparency) {
        byte[] data = imageData.getObjectData();
        int newW = imageData.getWidth();
        int newH = imageData.getHeight();
        int size = newW * newH * 4;
        byte[] newData = new byte[size];
        for (int y = 0; y < newH; ++y) {
            for (int x = 0; x < newW; ++x) {
                int offset = x + newW * y;
                int bytes = data[offset] & 0xFF;
                int ptr = 4;
                if (bytes < 128) {
                    ptr = 0;
                }
                System.arraycopy(maskCol, 0 + ptr, newData, offset * 4 + 0, 3);
                newData[offset * 4 + 3] = scaleTransparency ? (byte)((maskCol[3 + ptr] & 0xFF) * bytes >> 8) : maskCol[3 + ptr];
            }
        }
        imageData.setWidth(newW);
        imageData.setHeight(newH);
        imageData.setObjectData(newData);
        imageData.setDepth(8);
    }

    private static int getPixelSetCount(int sampling, boolean imageMask, byte[] data, int[] flag, int origLineLength, int y, int x, int wCount, int hCount) {
        int bytes = 0;
        for (int yy = 0; yy < hCount; ++yy) {
            for (int xx = 0; xx < wCount; ++xx) {
                int bit;
                int ptr = (yy + y * sampling) * origLineLength + (x * sampling + xx >> 3);
                byte currentByte = ptr < data.length ? data[ptr] : (byte)0;
                if (imageMask) {
                    currentByte = (byte)(currentByte ^ 0xFF);
                }
                if ((bit = currentByte & flag[7 - (x * sampling + xx & 7)]) == 0) continue;
                ++bytes;
            }
        }
        return bytes;
    }

    public static GenericColorSpace downSample(GenericColorSpace decodeColorData, byte[] maskCol, int sampling, ImageData imageData) {
        byte[] index = decodeColorData.getIndexedMap();
        boolean needsSharpening = SamplingFactory.kernelSharpen || SamplingFactory.downsampleLevel == 5 || SamplingFactory.downsampleLevel == 6;
        byte[] colIndex = null;
        boolean scaleTransparency = true;
        boolean isMask = false;
        if (index != null) {
            index = decodeColorData.convertIndexToRGB(index);
            colIndex = new byte[]{index[0], index[1], index[2], -1, index[3], index[4], index[5], -1};
            decodeColorData = new DeviceRGBColorSpace();
            scaleTransparency = false;
        } else if (maskCol != null) {
            isMask = true;
            colIndex = new byte[]{0, 0, 0, -1, maskCol[0], maskCol[1], maskCol[2], -1};
        }
        if (colIndex != null) {
            OneBitDownSampler.downsampleTo8Bit(sampling, imageData, isMask);
            if (needsSharpening && sampling < 8) {
                KernelUtils.applyKernel(imageData, 1);
            }
            OneBitDownSampler.convertToARGB(imageData, colIndex, scaleTransparency);
            imageData.setIsConvertedToARGB(true);
        } else {
            decodeColorData = OneBitDownSampler.downSample(sampling, imageData, decodeColorData);
            imageData.setImageType(PdfImageTypes.Binary);
            if (needsSharpening && sampling < 8) {
                KernelUtils.applyKernel(imageData, 1);
            }
        }
        return decodeColorData;
    }
}

