/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.data;

import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.PdfImageTypes;

public class ImageData {
    private int pX;
    private int pY;
    private int width;
    private int height;
    private int depth = 1;
    private byte[] objectData;
    private boolean isDCT;
    private boolean isJPX;
    private boolean isJBIG;
    private boolean wasDCT;
    private int numComponents;
    private boolean isDownsampled;
    private int mode = 2;
    private boolean removed;
    private float[] decodeArray;
    private PdfImageTypes rawType = PdfImageTypes.Other;
    private boolean isConvertedToARGB;

    public ImageData(byte[] objectData) {
        this.objectData = objectData;
    }

    public ImageData(PdfObject XObject2, byte[] objectData) {
        this.objectData = objectData;
        this.width = XObject2.getInt(959726687);
        this.height = XObject2.getInt(959926393);
        int newDepth = XObject2.getInt(-1344207655);
        if (newDepth != -1) {
            this.depth = newDepth;
        }
    }

    public ImageData(int mode) {
        this.mode = mode;
    }

    public void setIsDownsampled(boolean isDownsampled) {
        this.isDownsampled = isDownsampled;
    }

    public boolean isDownsampled() {
        return this.isDownsampled;
    }

    public int getMode() {
        return this.mode;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public byte[] getObjectData() {
        return this.objectData;
    }

    public byte[] getObjectDataAs8Bit() {
        switch (this.depth) {
            case 1: {
                int size = this.objectData.length;
                byte[] newData = new byte[size * 8];
                int ptr = 0;
                block3: for (byte anObjectData : this.objectData) {
                    for (int bit = 7; bit >= 0; --bit) {
                        if ((anObjectData >> bit & 1) == 1) {
                            newData[ptr] = -1;
                        }
                        if (++ptr % this.width == 0) continue block3;
                    }
                }
                return newData;
            }
        }
        return this.objectData;
    }

    public void setObjectData(byte[] objectData) {
        this.objectData = objectData;
    }

    public void setpX(int pX) {
        this.pX = pX;
    }

    public void setpY(int pY) {
        this.pY = pY;
    }

    public int getpX() {
        return this.pX;
    }

    public int getpY() {
        return this.pY;
    }

    public boolean isJPX() {
        return this.isJPX;
    }

    public void setDCT(boolean isDCT) {
        this.isDCT = isDCT;
    }

    public boolean isDCT() {
        return this.isDCT;
    }

    public boolean isJBIG() {
        return this.isJBIG;
    }

    public void getFilter(PdfObject XObject2) {
        PdfArrayIterator Filters = XObject2.getMixedArray(1011108731);
        if (Filters != null && Filters.hasMoreTokens()) {
            while (Filters.hasMoreTokens()) {
                int firstValue = Filters.getNextValueAsConstant(true);
                this.isDCT = firstValue == 1180911742;
                this.isJPX = firstValue == 1399277700;
                this.isJBIG = firstValue == 1247500931;
            }
        }
        this.decodeArray = XObject2.getFloatArray(859785322);
    }

    public void setCompCount(int numComponents) {
        this.numComponents = numComponents;
    }

    public int getCompCount() {
        return this.numComponents;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public void setIsJPX(boolean b) {
        this.isJPX = b;
    }

    public boolean wasDCT() {
        return this.wasDCT;
    }

    public void wasDCT(boolean b) {
        this.wasDCT = b;
    }

    public void setDecodeArray(float[] value) {
        this.decodeArray = value;
    }

    public float[] getDecodeArray() {
        return this.decodeArray;
    }

    public void setImageType(PdfImageTypes rawType) {
        this.rawType = rawType;
    }

    public PdfImageTypes getImageType() {
        return this.rawType;
    }

    public void setIsConvertedToARGB(boolean b) {
        this.isConvertedToARGB = b;
    }

    public boolean isConvertedToARGB() {
        return this.isConvertedToARGB;
    }
}

