/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.ImageDisplay;
import org.jpedal.utils.LogWriter;

public class PDFObjectToImage {
    public static BufferedImage getImageFromPdfObject(PdfObject newSMask, int x1, int x2, int y1, int y2, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer, boolean useTransparency, float scaling) {
        BufferedImage smaskImage;
        int h;
        int w;
        if (x1 < 0 || y1 < 0) {
            throw new RuntimeException("Negative values should not be used");
        }
        byte[] objectData = currentPdfFile.readStream(newSMask, true, true, false, false, false, newSMask.getCacheName(currentPdfFile.getObjectReader()));
        ObjectStore localStore = new ObjectStore();
        ImageDisplay glyphDisplay = new ImageDisplay(0, false, 20, localStore);
        PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile);
        glyphDecoder.setParameters(parserOptions.isPageContent(), parserOptions.isRenderPage(), parserOptions.getRenderMode(), parserOptions.getExtractionMode(), false, false);
        glyphDecoder.setObjectValue(-8, localStore);
        glyphDecoder.setRenderer(glyphDisplay);
        glyphDecoder.setMultiplyer(multiplyer);
        glyphDecoder.setFormLevel(formLevel);
        PdfObject SMaskResources = newSMask.getDictionary(2004251818);
        if (SMaskResources != null) {
            glyphDecoder.readResources(SMaskResources, false);
        }
        if ((w = x2 - x1) < 0) {
            w = -w;
            x1 -= w;
        }
        if (w == 0) {
            w = 1;
        }
        if ((h = y2 - y1) < 0) {
            h = -h;
            y1 -= h;
        }
        if (h == 0) {
            h = 1;
        }
        try {
            PdfObject group;
            float maxWidth = 2000.0f * scaling;
            float maxHeight = 2000.0f * scaling;
            while ((float)w * scaling > maxWidth && (float)h * scaling > maxHeight) {
                scaling /= 2.0f;
            }
            smaskImage = new BufferedImage((int)((float)w * scaling), (int)((float)h * scaling), 2);
            Graphics2D formG2 = smaskImage.createGraphics();
            formG2.scale(scaling, scaling);
            formG2.translate(-x1, -y1);
            glyphDisplay.setG2(formG2);
            if (useTransparency && (group = newSMask.getDictionary(1111442775)) != null) {
                currentPdfFile.checkResolved(group);
                String Tname = group.getName(35);
                PdfArrayIterator ColorSpace2 = group.getMixedArray(2087749783);
                if (ColorSpace2 != null && ColorSpace2.getTokenCount() > 0) {
                    GenericColorSpace newColorSpace = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, ColorSpace2);
                    if ((group.getBoolean(25) || group.getBoolean(27) || newColorSpace == null || newColorSpace.getID() != 1498837125) && Tname.equals("Transparency")) {
                        formG2.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    }
                }
            }
        }
        catch (Error err) {
            LogWriter.writeLog("Exception: " + err.getMessage());
            smaskImage = null;
        }
        if (objectData != null) {
            glyphDecoder.decodeStreamIntoObjects(objectData, false);
        }
        glyphDecoder.dispose();
        localStore.flush();
        return smaskImage;
    }
}

