/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.image.BinaryImage;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.parser.image.IndexedImage;
import org.jpedal.parser.image.OneBitImage;
import org.jpedal.parser.image.ThreeComponentImage;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.mask.MaskDecoder;
import org.jpedal.parser.image.utils.ConvertImageToShape;
import org.jpedal.parser.image.utils.ConvertMaskToShape;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class ImageDataToJavaImage {
    private static byte[] correctDataArraySize(int d, int w, int h, byte[] data) {
        int requiredSize;
        int oldSize;
        if (d == 1) {
            int oldSize2 = data.length;
            int requiredSize2 = (w + 7 >> 3) * h;
            if (oldSize2 < requiredSize2) {
                byte[] oldData = data;
                data = new byte[requiredSize2];
                System.arraycopy(oldData, 0, data, 0, oldSize2);
                for (int aa = oldSize2; aa < requiredSize2; ++aa) {
                    data[aa] = -1;
                }
            }
        } else if (d == 8 && (oldSize = data.length) < (requiredSize = w * h)) {
            byte[] oldData = data;
            data = new byte[requiredSize];
            System.arraycopy(oldData, 0, data, 0, oldSize);
        }
        return data;
    }

    public static BufferedImage makeImage(GenericColorSpace decodeColorData, ImageData imageData) {
        int comp = imageData.getCompCount();
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int d = imageData.getDepth();
        byte[] data = imageData.getObjectData();
        int ID2 = decodeColorData.getID();
        boolean isConverted = imageData.isConvertedToARGB();
        byte[] index = decodeColorData.getIndexedMap();
        if (ID2 == 1568372915) {
            data = ImageDataToJavaImage.correctDataArraySize(d, w, h, data);
        }
        BufferedImage image = null;
        if (isConverted) {
            DataBufferByte db = new DataBufferByte(data, data.length);
            int[] bands = new int[]{0, 1, 2, 3};
            image = new BufferedImage(w, h, 2);
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 4, 4, bands, null);
            image.setData(raster);
        } else if (index != null) {
            image = IndexedImage.make(decodeColorData, imageData);
        } else if (d == 1) {
            image = BinaryImage.make(w, h, data, decodeColorData, 1);
        } else if (ID2 == -2073385820 || ID2 == 960981604 || ID2 == 1847602) {
            LogWriter.writeLog("Converting Separation/DeviceN colorspace to sRGB ");
            image = decodeColorData.dataToRGB(data, w, h);
        } else {
            switch (comp) {
                case 4: {
                    if (decodeColorData.getID() == 1785221209) {
                        image = ColorSpaceConvertor.createARGBImage(w, h, data);
                        break;
                    }
                    image = ColorSpaceConvertor.convertFromICCCMYK(w, h, data);
                    break;
                }
                case 3: {
                    image = ThreeComponentImage.make(d, data, null, w, h);
                    break;
                }
                case 1: {
                    image = OneBitImage.make(d, w, h, data);
                }
            }
        }
        return image;
    }

    public static BufferedImage makeMaskImage(ParserOptions parserOptions, GraphicsState gs, DynamicVectorRenderer current, ImageData imageData, GenericColorSpace decodeColorData, byte[] maskCol) {
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int d = imageData.getDepth();
        byte[] data = imageData.getObjectData();
        BufferedImage image = null;
        float ratio = (float)h / (float)w;
        if (parserOptions.isPrinting() && ratio < 0.1f && w > 4000 && h > 1 || ratio < 0.001f && w > 4000 && h > 1 || w == 1 && h == 1) {
            ConvertMaskToShape.convert(gs, current, parserOptions);
            imageData.setRemoved(true);
        } else if (h == 2 && d == 1 && ImageCommands.isRepeatingLine(data, h)) {
            ConvertImageToShape.convert(data, 2, gs, current, parserOptions);
            imageData.setRemoved(true);
        } else {
            image = MaskDecoder.createMaskImage(parserOptions.isPrinting() && !ImageDecoder.allowPrintTransparency, data, w, h, imageData, d, decodeColorData, maskCol);
        }
        return image;
    }
}

