/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.util.Iterator;
import org.jpedal.parser.PdfStreamDecoder;

public class DecoderResults {
    private boolean imagesProcessedFully = true;
    private boolean hasNonEmbeddedCIDFonts;
    private boolean pageSuccessful;
    private boolean ttHintingRequired;
    private Iterator<Integer> colorSpacesUsed;
    private String nonEmbeddedCIDFonts = "";
    private boolean tooManyShapes;
    private boolean hasEmbeddedFonts;

    public boolean getImagesProcessedFully() {
        return this.imagesProcessedFully;
    }

    public void update(PdfStreamDecoder current, boolean includeAll) {
        this.colorSpacesUsed = (Iterator)current.getObjectValue(1);
        this.nonEmbeddedCIDFonts = (String)current.getObjectValue(4);
        this.pageSuccessful = current.getBooleanValue(1);
        this.imagesProcessedFully = current.getBooleanValue(2);
        this.tooManyShapes = current.getBooleanValue(64);
        this.hasNonEmbeddedCIDFonts = current.getBooleanValue(4);
        this.ttHintingRequired = current.getBooleanValue(32);
        if (includeAll) {
            this.hasEmbeddedFonts = current.getBooleanValue(-1);
        }
    }

    public boolean getPageDecodeStatus(int status) {
        switch (status) {
            case 4: {
                return this.hasNonEmbeddedCIDFonts;
            }
            case 2: {
                return this.imagesProcessedFully;
            }
            case 1: {
                return this.pageSuccessful;
            }
            case 64: {
                return this.tooManyShapes;
            }
            case 32: {
                return this.ttHintingRequired;
            }
        }
        throw new RuntimeException("Unknown parameter " + status);
    }

    public Iterator<Integer> getPageInfo(int type) {
        switch (type) {
            case 1: {
                return this.colorSpacesUsed;
            }
        }
        return null;
    }

    public String getPageDecodeStatusReport(int status) {
        if (status == 4) {
            return this.nonEmbeddedCIDFonts;
        }
        throw new RuntimeException("Unknown parameter");
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public void resetColorSpaces() {
        this.colorSpacesUsed = null;
    }
}

