/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.util.ArrayList;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.parser.Cmd;
import org.jpedal.utils.NumberUtils;

public class CommandParser {
    private final byte[] characterStream;
    private int commandID = -1;
    private static final int[] prefixes = new int[]{60, 40};
    private static final int[] suffixes = new int[]{62, 41};
    private static final int[][] intValues = new int[][]{{0, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000}, {0, 10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000}, {0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000}, {0, 100, 200, 300, 400, 500, 600, 700, 800, 900}, {0, 10, 20, 30, 40, 50, 60, 70, 80, 90}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}};
    private static final int MAXOPS = 50;
    private int[] opStart = new int[50];
    private int[] opEnd = new int[50];
    private int operandCount;
    private int currentOp;
    private final int streamSize;

    public CommandParser(byte[] characterStr) {
        this.characterStream = characterStr;
        this.streamSize = characterStr.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    int getCommandValues(int dataPointer, int tokenNumber) {
        byte nextChar;
        block17: {
            DataObject data = new DataObject();
            int count = prefixes.length;
            this.commandID = -1;
            int sLen = this.characterStream.length;
            if ((dataPointer = StreamReaderUtils.skipSpacesOrOtherCharacter(this.characterStream, dataPointer, 0)) == this.streamSize) {
                return dataPointer;
            }
            while (dataPointer < this.streamSize && this.characterStream[dataPointer] == 37) {
                dataPointer = StreamReaderUtils.skipComment(this.characterStream, dataPointer);
            }
            if (dataPointer >= this.streamSize) {
                return dataPointer;
            }
            data.current = this.characterStream[dataPointer];
            int type = this.getType(data.current, dataPointer);
            if (type == 3) {
                dataPointer = CommandParser.option3(dataPointer, data, sLen, this.characterStream);
                if (data.end >= sLen) {
                    return data.end;
                }
                byte endC = this.characterStream[data.end];
                if (endC == 47 || endC == 91 || endC == 60 || endC == 37) {
                    --data.end;
                }
                if (data.end - data.start < 3) {
                    this.commandID = CommandParser.getCommandID(data, this.characterStream);
                }
                if (this.commandID == -1) {
                    this.addToStack(tokenNumber, data.start, data.end);
                    break block17;
                } else {
                    if (this.operandCount > 0) {
                        this.reverseOperands();
                    }
                    return -dataPointer;
                }
            }
            if (type != 4) {
                byte next;
                data.start = dataPointer;
                if (type == 1 || type == 2) {
                    dataPointer = CommandParser.option1Or2(dataPointer, data, sLen, type, this.characterStream);
                }
                if (!data.matchFound) {
                    dataPointer = this.option3(dataPointer, data, count, sLen);
                }
                if (!data.matchFound) {
                    dataPointer = CommandParser.option2(dataPointer, data, sLen, this.characterStream);
                }
                if (data.end >= this.characterStream.length || (next = this.characterStream[data.end]) == 47 || next == 91) {
                    // empty if block
                }
                this.opStart[this.currentOp] = data.start;
                this.opEnd[this.currentOp] = --data.end;
                ++this.currentOp;
                if (this.currentOp == 50) {
                    this.currentOp = 0;
                }
                ++this.operandCount;
            }
        }
        if (dataPointer < this.streamSize && (nextChar = this.characterStream[dataPointer]) != 47 && nextChar != 40 && nextChar != 91 && nextChar != 60) {
            ++dataPointer;
        }
        return dataPointer;
    }

    private static int option3(int dataPointer, DataObject data, int sLen, byte[] characterStream) {
        data.start = dataPointer;
        int current = characterStream[dataPointer];
        while (++dataPointer < sLen && (current = characterStream[dataPointer]) != 13 && current != 10 && current != 32 && current != 40 && current != 47 && current != 91 && current != 9 && current != 60) {
        }
        data.current = current;
        data.end = dataPointer - 1;
        return dataPointer;
    }

    private static int option1Or2(int dataPointer, DataObject data, int sLen, int type, byte[] characterStream) {
        boolean isBreak;
        boolean inStream = false;
        data.matchFound = true;
        int last = 32;
        do {
            last = last == 92 && data.current == 92 ? 120 : data.current;
            if (++dataPointer == sLen) break;
            data.current = characterStream[dataPointer];
            if (data.current == 13 || data.current == 10 || data.current == 9) {
                data.current = 32;
            }
            isBreak = false;
            if (data.current == 62 && last == 62 && type == 1) {
                if (characterStream[dataPointer + 1] == 62) {
                    ++dataPointer;
                }
                isBreak = true;
            }
            if (type != 2) continue;
            if (data.current == 40 && last != 92) {
                inStream = true;
            } else if (data.current == 41 && last != 92) {
                inStream = false;
            }
            if (inStream || data.current != 93 || last == 92) continue;
            isBreak = true;
        } while (!isBreak);
        data.end = dataPointer;
        return dataPointer;
    }

    private int option3(int dataPointer, DataObject data, int count, int sLen) {
        int last = 32;
        for (int startChars = 0; startChars < count; ++startChars) {
            if (data.current != prefixes[startChars]) continue;
            data.matchFound = true;
            data.start = dataPointer;
            int numOfPrefixs = 0;
            while (true) {
                last = last == 92 && data.current == 92 ? 120 : data.current;
                if (++dataPointer == sLen) break;
                int current = this.characterStream[dataPointer];
                if (current == 13 || current == 10 || current == 9) {
                    current = 32;
                }
                data.current = current;
                if (current == prefixes[startChars] && last != 92) {
                    ++numOfPrefixs;
                }
                if (current != suffixes[startChars] || last == 92) continue;
                if (numOfPrefixs == 0) break;
                --numOfPrefixs;
            }
            startChars = count;
        }
        data.end = dataPointer;
        return dataPointer;
    }

    private static int option2(int dataPointer, DataObject data, int sLen, byte[] characterStream) {
        byte firstChar = characterStream[data.start];
        int current = characterStream[dataPointer];
        while (++dataPointer != sLen && (current = characterStream[dataPointer]) != 13 && current != 10 && current != 32 && current != 40 && current != 47 && current != 91 && current != 9 && (firstChar != 47 || current != 60)) {
        }
        data.current = current;
        data.end = dataPointer;
        return dataPointer;
    }

    private static int getCommandID(DataObject data, byte[] characterStream) {
        int start = data.start;
        int end = data.end;
        int key = 0;
        int x = 0;
        for (int i2 = end; i2 > start - 1; --i2) {
            key += characterStream[i2] << x;
            x += 8;
        }
        return Cmd.getCommandID(key);
    }

    private void addToStack(int tokenNumber, int start, int end) {
        this.opStart[this.currentOp] = start;
        this.opEnd[this.currentOp] = end;
        ++this.currentOp;
        if (this.currentOp == 50) {
            this.currentOp = 0;
        }
        ++this.operandCount;
    }

    private void reverseOperands() {
        int jj;
        int[] orderedOpStart = new int[50];
        int[] orderedOpEnd = new int[50];
        int opid = 0;
        for (jj = this.currentOp - 1; jj > -1; --jj) {
            orderedOpStart[opid] = this.opStart[jj];
            orderedOpEnd[opid] = this.opEnd[jj];
            if (opid == this.operandCount) {
                jj = -1;
            }
            ++opid;
        }
        if (opid == this.operandCount) {
            --this.currentOp;
            for (jj = 49; jj > this.currentOp; --jj) {
                orderedOpStart[opid] = this.opStart[jj];
                orderedOpEnd[opid] = this.opEnd[jj];
                if (opid == this.operandCount) {
                    jj = this.currentOp;
                }
                ++opid;
            }
            ++this.currentOp;
        }
        this.opStart = orderedOpStart;
        this.opEnd = orderedOpEnd;
    }

    public int getCommandID() {
        return this.commandID;
    }

    private int getType(int current, int dataPointer) {
        int type = 0;
        if (current == 60 && this.characterStream[dataPointer + 1] == 60) {
            type = 1;
        } else if (current == 32) {
            type = 4;
        } else if (current == 91) {
            type = 2;
        } else if (current >= 97 && current <= 122) {
            type = 3;
        } else if (current >= 65 && current <= 90) {
            type = 3;
        } else if (current == 39 || current == 34) {
            type = 3;
        }
        return type;
    }

    public String generateOpAsString(int p, boolean loseSlashPrefix) {
        byte[] dataStream = this.characterStream;
        int start = this.opStart[p];
        if (loseSlashPrefix && dataStream[start] == 47) {
            ++start;
        }
        int end = this.opEnd[p];
        while (dataStream[end] == 32 || dataStream[end] == 13 || dataStream[end] == 10) {
            --end;
        }
        int count = end - start + 1;
        int spaces = 0;
        for (int ii = 0; ii < count; ++ii) {
            if (ii <= 0 || dataStream[start + ii] != 32 && dataStream[start + ii] != 13 && dataStream[start + ii] != 10 || dataStream[start + ii - 1] != 32 && dataStream[start + ii - 1] != 13 && dataStream[start + ii - 1] != 10) continue;
            ++spaces;
        }
        char[] charString = new char[count - spaces];
        int pos = 0;
        for (int ii = 0; ii < count; ++ii) {
            if (ii > 0 && (dataStream[start + ii] == 32 || dataStream[start + ii] == 13 || dataStream[start + ii] == 10) && (dataStream[start + ii - 1] == 32 || dataStream[start + ii - 1] == 13 || dataStream[start + ii - 1] == 10)) continue;
            charString[pos] = dataStream[start + ii] == 10 || dataStream[start + ii] == 13 ? 32 : (char)dataStream[start + ii];
            ++pos;
        }
        String s = String.copyValueOf(charString);
        return s;
    }

    public final float parseFloat(int id) {
        float f;
        int charCount;
        byte[] stream = this.characterStream;
        int start = this.opStart[id];
        int floatptr = charCount = this.opEnd[id] - start;
        int intStart = 0;
        boolean isMinus = false;
        for (int j = charCount - 1; j > -1; --j) {
            if (stream[start + j] != 46) continue;
            floatptr = j;
            break;
        }
        int intChars = floatptr;
        if (stream[start] == 43) {
            --intChars;
            ++intStart;
        } else if (stream[start] == 45) {
            ++intStart;
            isMinus = true;
        }
        int intNumbers = intChars - intStart;
        int decNumbers = charCount - floatptr;
        if (intNumbers > 3 || decNumbers > 11) {
            isMinus = false;
            f = Float.parseFloat(this.generateOpAsString(id, false));
        } else {
            if (decNumbers > 6) {
                decNumbers = 6;
            }
            f = NumberUtils.convertFloatFromStream(stream, start + intStart, start + floatptr, intNumbers, decNumbers);
        }
        if (isMinus) {
            return -f;
        }
        return f;
    }

    public float[] getValuesAsFloat() {
        if (this.characterStream[this.opStart[0]] == 91) {
            return this.readFloatArray();
        }
        float[] op = new float[this.operandCount];
        for (int i = 0; i < this.operandCount; ++i) {
            op[i] = this.parseFloat(i);
        }
        return op;
    }

    private float[] readFloatArray() {
        int start = this.opStart[0];
        int end = this.opEnd[0];
        int count = 0;
        ArrayList<Float> values = new ArrayList<Float>();
        int chars = start + 1;
        while (chars < end) {
            char c = (char)this.characterStream[chars];
            while (c != '.' && c != '-' && (c < '0' || c > '9')) {
                c = (char)this.characterStream[++chars];
            }
            int startPtr = chars;
            while (c == '.' || c == '-' || c >= '0' && c <= '9') {
                c = (char)this.characterStream[++chars];
            }
            int endPtr = chars++;
            ++count;
            values.add(Float.valueOf(NumberUtils.parseFloat(startPtr, endPtr - startPtr, this.characterStream)));
        }
        float[] op = new float[count];
        for (int i = 0; i < count; ++i) {
            op[i] = ((Float)values.get(i)).floatValue();
        }
        return op;
    }

    public String[] getValuesAsString() {
        String[] op = new String[this.operandCount];
        for (int i = 0; i < this.operandCount; ++i) {
            op[i] = this.generateOpAsString(i, true);
        }
        return op;
    }

    public final int parseInt() {
        int start = this.opStart[0];
        int end = this.opEnd[0];
        byte[] stream = this.characterStream;
        int number = 0;
        boolean id = false;
        int charCount = end - start;
        int intStart = 0;
        boolean isMinus = false;
        int intChars = charCount;
        if (stream[start] == 43) {
            --intChars;
            ++intStart;
        } else if (stream[start] == 45) {
            ++intStart;
            isMinus = true;
        }
        int intNumbers = intChars - intStart;
        if (intNumbers > 6) {
            isMinus = false;
            number = Integer.parseInt(this.generateOpAsString(0, false));
        } else {
            for (int jj = 5; jj > -1; --jj) {
                if (intNumbers <= jj) continue;
                int c = stream[start + intStart] - 48;
                number += intValues[5 - jj][c];
                ++intStart;
            }
        }
        if (isMinus) {
            return -number;
        }
        return number;
    }

    public void reset() {
        this.currentOp = 0;
        this.operandCount = 0;
    }

    public int getOperandCount() {
        return this.operandCount;
    }

    public byte[] getStream() {
        return this.characterStream;
    }

    final class DataObject {
        int start;
        int end;
        int current;
        boolean matchFound;

        DataObject() {
        }
    }
}

