/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;

public class OCObject
extends PdfObject {
    private float max;
    private float min;
    private int Event = -1;
    private byte[] rawBaseState;
    private byte[] rawListMode;
    private byte[] rawViewState;
    private String BaseState;
    private String ListMode;
    private PdfObject D;
    private PdfObject Layer;
    private PdfObject OCGs_dictionary;
    private PdfObject Usage;
    private PdfObject View;
    private PdfObject Zoom;
    private Object[] Order;
    private byte[][] AS;
    private byte[][] Category;
    private byte[][] Locked;
    private byte[][] ON;
    private byte[][] OFF;
    private byte[][] OCGs;
    private byte[][] Configs;
    private byte[][] RBGroups;

    public OCObject(String ref) {
        super(ref);
    }

    public OCObject(int ref, int gen) {
        super(ref, gen);
    }

    @Override
    public PdfObject getDictionary(int id) {
        switch (id) {
            case 20: {
                return this.D;
            }
            case 826881374: {
                return this.Layer;
            }
            case 521344835: {
                return this.OCGs_dictionary;
            }
            case 1127298906: {
                return this.Usage;
            }
            case 641283399: {
                return this.View;
            }
            case 708788029: {
                return this.Zoom;
            }
        }
        return super.getDictionary(id);
    }

    @Override
    public void setFloatNumber(int id, float value) {
        switch (id) {
            case 4010312: {
                this.max = value;
                break;
            }
            case 4012350: {
                this.min = value;
                break;
            }
            default: {
                super.setFloatNumber(id, value);
            }
        }
    }

    @Override
    public float getFloatNumber(int id) {
        switch (id) {
            case 4010312: {
                return this.max;
            }
            case 4012350: {
                return this.min;
            }
        }
        return super.getFloatNumber(id);
    }

    @Override
    public void setDictionary(int id, PdfObject value) {
        value.setID(id);
        switch (id) {
            case 20: {
                this.D = value;
                break;
            }
            case 826881374: {
                this.Layer = value;
                break;
            }
            case 521344835: {
                this.OCGs_dictionary = value;
                break;
            }
            case 1127298906: {
                this.Usage = value;
                break;
            }
            case 641283399: {
                this.View = value;
                break;
            }
            case 708788029: {
                this.Zoom = value;
                break;
            }
            default: {
                super.setDictionary(id, value);
            }
        }
    }

    @Override
    public int setConstant(int pdfKeyType, int keyStart, int keyLength, byte[] raw) {
        int id = PdfObject.getId(keyStart, keyLength, raw);
        int PDFvalue = super.setConstant(pdfKeyType, id);
        switch (pdfKeyType) {
            case 1177894489: {
                this.Event = PDFvalue;
            }
        }
        return PDFvalue;
    }

    @Override
    public int getParameterConstant(int key) {
        switch (key) {
            case 1177894489: {
                return this.Event;
            }
        }
        return super.getParameterConstant(key);
    }

    @Override
    public void setName(int id, byte[] value) {
        switch (id) {
            case 964196217: {
                this.rawListMode = value;
                break;
            }
            case 2103872382: {
                this.rawViewState = value;
                break;
            }
            default: {
                super.setName(id, value);
            }
        }
    }

    @Override
    public int getNameAsConstant(int id) {
        byte[] raw;
        switch (id) {
            case 1970567530: {
                raw = this.rawBaseState;
                break;
            }
            case 964196217: {
                raw = this.rawListMode;
                break;
            }
            case 2103872382: {
                raw = this.rawViewState;
                break;
            }
            default: {
                return super.getNameAsConstant(id);
            }
        }
        if (raw == null) {
            return super.getNameAsConstant(id);
        }
        return PdfDictionary.generateChecksum(0, raw.length, raw);
    }

    @Override
    public String getName(int id) {
        switch (id) {
            case 1970567530: {
                if (this.BaseState == null && this.rawBaseState != null) {
                    this.BaseState = new String(this.rawBaseState);
                }
                return this.BaseState;
            }
            case 964196217: {
                if (this.ListMode == null && this.rawListMode != null) {
                    this.ListMode = new String(this.rawListMode);
                }
                return this.ListMode;
            }
        }
        return super.getName(id);
    }

    @Override
    public byte[][] getKeyArray(int id) {
        switch (id) {
            case 4387: {
                return this.AS;
            }
            case 1248888446: {
                return this.Category;
            }
            case 910980737: {
                return this.Configs;
            }
            case 859525491: {
                return this.Locked;
            }
            case 521344835: {
                return this.OCGs;
            }
            case 0x1F1616: {
                return this.OFF;
            }
            case 7966: {
                return this.ON;
            }
            case 1633113989: {
                return this.RBGroups;
            }
        }
        return super.getKeyArray(id);
    }

    @Override
    public void setObjectArray(int id, Object[] objectValues) {
        switch (id) {
            case 1110717793: {
                this.Order = objectValues;
                break;
            }
            default: {
                super.setObjectArray(id, objectValues);
            }
        }
    }

    @Override
    public Object[] getObjectArray(int id) {
        switch (id) {
            case 1110717793: {
                return OCObject.deepCopy(this.Order);
            }
        }
        return super.getObjectArray(id);
    }

    private static Object[] deepCopy(Object[] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        Object[] deepCopy = new Object[count];
        for (int aa = 0; aa < count; ++aa) {
            if (input[aa] instanceof byte[]) {
                byte[] byteVal = (byte[])input[aa];
                int byteCount = byteVal.length;
                byte[] newValue = new byte[byteCount];
                deepCopy[aa] = newValue;
                System.arraycopy(byteVal, 0, newValue, 0, byteCount);
                continue;
            }
            deepCopy[aa] = OCObject.deepCopy((Object[])input[aa]);
        }
        return deepCopy;
    }

    @Override
    public void setKeyArray(int id, byte[][] value) {
        switch (id) {
            case 4387: {
                this.AS = value;
                break;
            }
            case 1248888446: {
                this.Category = value;
                break;
            }
            case 910980737: {
                this.Configs = value;
                break;
            }
            case 859525491: {
                this.Locked = value;
                break;
            }
            case 521344835: {
                this.OCGs = value;
                break;
            }
            case 0x1F1616: {
                this.OFF = value;
                break;
            }
            case 7966: {
                this.ON = value;
                break;
            }
            case 1633113989: {
                this.RBGroups = value;
                break;
            }
            default: {
                super.setKeyArray(id, value);
            }
        }
    }

    @Override
    public int getObjectType() {
        return -1567847737;
    }
}

