/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;

public class FormStream {
    private static final boolean debug = false;
    private static boolean showFontMessage;
    protected PdfObjectReader currentPdfFile;
    protected boolean isXFA;
    private static final int[] id;

    public static Object[] getRolloverKeyValues(PdfObject form, PdfFileReader pdfFileReader) {
        String key = null;
        PdfObject val = null;
        PdfObject rollOffDic = null;
        PdfKeyPairsIterator APkeys = form.getKeyPairsIterator();
        if (APkeys != null && APkeys.getTokenCount() > 0) {
            while (APkeys.hasMorePairs()) {
                String glyphKey = APkeys.getNextKeyAsString();
                byte[] data = APkeys.getNextValueAsBytes();
                if (data != null) {
                    if (glyphKey.equals("Off")) {
                        rollOffDic = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    } else {
                        key = glyphKey;
                        val = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    }
                }
                APkeys.nextPair();
            }
        } else {
            if (form.getDictionary(2045494) != null) {
                rollOffDic = form.getDictionary(2045494);
            } else if (form.getDecodedStream() != null) {
                rollOffDic = form;
            }
            if (form.getDictionary(7998) != null) {
                key = "On";
                val = form.getDictionary(7998);
            }
        }
        return new Object[]{key, val, rollOffDic};
    }

    public static Object[] getNormalKeyValues(PdfObject form, PdfFileReader pdfFileReader) {
        PdfObject APobjN = form.getDictionary(4384).getDictionary(30);
        String key = null;
        PdfObject val = null;
        PdfObject normalOffDic = null;
        PdfKeyPairsIterator APkeys = APobjN.getKeyPairsIterator();
        if (APkeys != null && APkeys.getTokenCount() > 0) {
            while (APkeys.hasMorePairs()) {
                String glyphKey = APkeys.getNextKeyAsString();
                byte[] data = APkeys.getNextValueAsBytes();
                if (data != null) {
                    if (glyphKey.equals("Off")) {
                        normalOffDic = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    } else {
                        key = glyphKey;
                        val = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    }
                }
                APkeys.nextPair();
            }
        } else {
            if (APobjN.getDictionary(2045494) != null) {
                normalOffDic = APobjN.getDictionary(2045494);
            } else if (form.getDictionary(7451).getDictionary(25) != null && form.getDictionary(7451).getDictionary(6422) == null) {
                normalOffDic = form.getDictionary(7451).getDictionary(25);
            } else if (APobjN.getDecodedStream() != null) {
                normalOffDic = APobjN;
            }
            if (APobjN.getDictionary(7998) != null) {
                val = APobjN.getDictionary(7998);
                key = "On";
            }
        }
        return new Object[]{key, val, normalOffDic};
    }

    public static Object[] getDownKeyValues(PdfObject form, PdfFileReader pdfFileReader) {
        String key = null;
        PdfObject val = null;
        PdfObject downOffDic = null;
        PdfKeyPairsIterator APkeys = form.getKeyPairsIterator();
        if (APkeys != null && APkeys.getTokenCount() > 0) {
            while (APkeys.hasMorePairs()) {
                String glyphKey = APkeys.getNextKeyAsString();
                byte[] data = APkeys.getNextValueAsBytes();
                if (data != null) {
                    if (glyphKey.equals("Off")) {
                        downOffDic = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    } else {
                        key = glyphKey;
                        val = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    }
                }
                APkeys.nextPair();
            }
        } else {
            if (form.getDictionary(7998) != null) {
                key = "On";
                val = form.getDictionary(7998);
            }
            if (form.getDecodedStream() != null) {
                downOffDic = form;
            } else if (form.getDictionary(2045494) != null) {
                downOffDic = form.getDictionary(2045494);
            }
        }
        return new Object[]{key, val, downOffDic};
    }

    public void createAppearanceString(FormObject formObj, PdfObjectReader inCurrentPdfFile) {
        this.currentPdfFile = inCurrentPdfFile;
        this.init(formObj);
    }

    private void init(FormObject formObject) {
        String textStream;
        int Ff = formObject.getInt(5686);
        if (Ff != -1) {
            formObject.commandFf(Ff);
        }
        this.resolveAdditionalAction(formObject);
        FormStream.setupAPimages(formObject, this.currentPdfFile.getObjectReader());
        int key = formObject.getNameAsConstant(24);
        if (key != -1) {
            switch (key) {
                case 32: 
                case 36: {
                    if (formObject.hasDownImage()) break;
                    formObject.setOffsetDownApp();
                    break;
                }
                case 30: {
                    formObject.setNoDownIcon();
                    break;
                }
                case 25: {
                    formObject.setInvertForDownIcon();
                    break;
                }
            }
        }
        if ((textStream = formObject.getTextStreamValue(5137)) != null) {
            FormStream.decodeFontCommandObj(textStream, formObject);
        }
    }

    private static void setupAPimages(FormObject formObject, PdfFileReader pdfFileReader) {
        PdfObject APobjN = formObject.getDictionary(4384).getDictionary(30);
        if (APobjN != null) {
            String ASvalue = formObject.getName(4387);
            formObject.setAppreancesUsed(true);
            String key = (String)FormStream.getNormalKeyValues(formObject, pdfFileReader)[0];
            if (key != null) {
                formObject.setNormalOnState(key);
                if (ASvalue != null && ASvalue.equals(key)) {
                    formObject.setSelected(true);
                }
            }
        }
    }

    private void resolveAdditionalAction(FormObject formObject) {
        int[] nArray = id;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int anId;
            int idValue = anId = nArray[i];
            this.currentPdfFile.setJavascriptForObject(formObject, 4369, idValue);
            this.currentPdfFile.setJavascriptForObject(formObject, 17, idValue);
        }
    }

    public static BufferedImage decode(PdfObject formObj, PdfObjectReader currentPdfFile, PdfObject XObject2, int subtype, int width, int height, int offsetImage, float pageScaling) {
        if (XObject2.getObjectType() == 129) {
            return ExternalHandlers.decode(formObj, currentPdfFile, XObject2, subtype, width, height, offsetImage, pageScaling);
        }
        currentPdfFile.checkResolved(XObject2);
        try {
            float scaling;
            T3Glyph form = FormStream.decodeStream(currentPdfFile, XObject2);
            float[] matrix = XObject2.getFloatArray(1145198201);
            float[] BBox = XObject2.getFloatArray(303185736);
            float rectX1 = 0.0f;
            float rectY1 = 0.0f;
            if (BBox != null) {
                float hs;
                float ws;
                float diff;
                int diffInt;
                int boxHeight;
                int ii = 0;
                while (ii < 4) {
                    int n = ii++;
                    BBox[n] = BBox[n] * pageScaling;
                }
                rectX1 = BBox[0];
                rectY1 = BBox[1];
                int boxWidth = (int)(BBox[2] + 0.5f - BBox[0]);
                if (boxWidth < 0) {
                    boxWidth = -boxWidth;
                }
                if ((boxHeight = (int)(BBox[3] + 0.5f - BBox[1])) < 0) {
                    boxHeight = -boxHeight;
                }
                if (boxWidth == 0 && boxHeight > 0) {
                    boxWidth = 1;
                }
                if (boxWidth > 0 && boxHeight == 0) {
                    boxHeight = 1;
                }
                if ((diffInt = (int)(diff = (ws = (float)width / (float)boxWidth) - (hs = (float)height / (float)boxHeight))) != 0) {
                    int tmpI = width;
                    width = height;
                    height = tmpI;
                    ws = (float)width / (float)boxWidth;
                    hs = (float)height / (float)boxHeight;
                }
                if (ws < 1.0f || hs < 1.0f) {
                    scaling = 1.0f;
                    width = boxWidth;
                    height = boxHeight;
                } else {
                    if (ws > hs) {
                        scaling = ws;
                        height = (int)((float)boxHeight * scaling);
                    } else {
                        scaling = hs;
                        width = (int)((float)boxWidth * scaling);
                    }
                    rectX1 *= scaling;
                    rectY1 *= scaling;
                }
            } else {
                float hs;
                float ws;
                float defaultSize = 20.0f;
                if ((float)height < 20.0f) {
                    height = 20;
                }
                if ((float)width < 20.0f) {
                    width = 20;
                }
                if ((ws = (float)width / 20.0f) > (hs = (float)height / 20.0f)) {
                    scaling = ws;
                    height = (int)(20.0f * scaling);
                } else {
                    scaling = hs;
                    width = (int)(20.0f * scaling);
                }
                rectX1 *= scaling;
                rectY1 *= scaling;
            }
            if (width == 0 || height == 0) {
                return null;
            }
            if (offsetImage == 1) {
                width += 2;
                height += 2;
            }
            BufferedImage aa = matrix != null && matrix[2] != 0.0f ? new BufferedImage(height, width, 2) : new BufferedImage(width, height, 2);
            Graphics2D g2 = FormStream.createGraphics(aa, formObj, matrix, BBox, pageScaling, scaling, rectX1, rectY1, width, height);
            if (offsetImage == 2) {
                g2.scale(-1.0, -1.0);
            } else if (offsetImage == 1) {
                g2.translate(1, 1);
            }
            form.render(0, g2, scaling * pageScaling, true);
            g2.dispose();
            if (subtype == 1919840408) {
                BufferedImage i = new BufferedImage(aa.getWidth(), aa.getHeight(), aa.getType());
                Graphics2D gg = i.createGraphics();
                gg.setComposite(AlphaComposite.getInstance(3, 0.5f));
                gg.drawImage((Image)aa, 0, 0, null);
                gg.dispose();
                return i;
            }
            return aa;
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            return null;
        }
        catch (Error e) {
            LogWriter.writeLog("Error: " + e.getMessage());
            return null;
        }
    }

    private static Graphics2D createGraphics(BufferedImage aa, PdfObject formObj, float[] matrix, float[] BBox, float pageScaling, float scaling, float transformOffsetX, float transformOffsetY, int width, int height) {
        Graphics2D g2;
        int offset = height;
        if (matrix != null) {
            if (pageScaling == 1.0f && matrix[4] > 0.0f && matrix[5] > 0.0f) {
                matrix = FormStream.createMatrixFromBoundingBoxes(BBox, formObj.getFloatArray(573911876));
            } else {
                matrix[4] = matrix[4] * scaling * pageScaling;
                matrix[5] = matrix[5] * scaling * pageScaling;
            }
            if (matrix[2] != 0.0f) {
                offset = width;
            } else if (matrix[1] >= 0.0f) {
                if (matrix[4] != 0.0f) {
                    matrix[4] = -transformOffsetX;
                }
                if (matrix[5] != 0.0f) {
                    matrix[5] = -transformOffsetY;
                }
            }
            g2 = (Graphics2D)aa.getGraphics();
            AffineTransform flip = new AffineTransform();
            flip.translate(0.0, offset);
            flip.scale(1.0, -1.0);
            g2.setTransform(flip);
            AffineTransform affineTransform = new AffineTransform(matrix);
            g2.transform(affineTransform);
        } else {
            g2 = (Graphics2D)aa.getGraphics();
            AffineTransform flip = new AffineTransform();
            flip.translate((int)(-((BBox[0] + 0.5f) * scaling)), (int)((BBox[3] + 0.5f) * scaling));
            flip.scale(1.0, -1.0);
            g2.setTransform(flip);
        }
        return g2;
    }

    private static float[] createMatrixFromBoundingBoxes(float[] BBox, float[] BBox2) {
        float t;
        float[] matrix = new float[6];
        if (BBox2[1] > BBox2[3]) {
            t = BBox2[1];
            BBox2[1] = BBox2[3];
            BBox2[3] = t;
        }
        if (BBox2[0] > BBox2[2]) {
            t = BBox2[0];
            BBox2[0] = BBox2[2];
            BBox2[2] = t;
        }
        matrix[0] = (BBox2[2] - BBox2[0]) / (BBox[2] - BBox[0]);
        matrix[1] = 0.0f;
        matrix[2] = 0.0f;
        matrix[3] = (BBox2[3] - BBox2[1]) / (BBox[3] - BBox[1]);
        matrix[4] = BBox2[0] - BBox[0];
        matrix[5] = BBox2[1] - BBox[1];
        return matrix;
    }

    private static T3Glyph decodeStream(PdfObjectReader currentPdfFile, PdfObject XObject2) {
        ObjectStore localStore = new ObjectStore();
        T3Display glyphDisplay = new T3Display(0, false, 20, localStore);
        PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile);
        glyphDecoder.setParameters(false, true, 15, 0, false, false);
        glyphDecoder.setStreamType(1);
        glyphDecoder.setObjectValue(-8, localStore);
        glyphDecoder.setRenderer(glyphDisplay);
        try {
            PdfObject Resources = XObject2.getDictionary(2004251818);
            if (Resources != null) {
                glyphDecoder.readResources(Resources, false);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        byte[] commands = XObject2.getDecodedStream();
        if (commands != null) {
            glyphDecoder.decodeStreamIntoObjects(commands, false);
        }
        boolean ignoreColors = glyphDecoder.ignoreColors;
        localStore.flush();
        return new T3Glyph(glyphDisplay, 0, 0, ignoreColors);
    }

    public static String decipherTextFromAP(PdfObjectReader currentPdfFile, PdfObject Xobject) {
        try {
            ObjectStore localStore = new ObjectStore();
            T3Display glyphDisplay = new T3Display(0, false, 20, localStore);
            PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile, null);
            glyphDecoder.setParameters(false, true, 15, 0, false, false);
            glyphDecoder.setObjectValue(-8, localStore);
            glyphDecoder.setRenderer(glyphDisplay);
            try {
                PdfObject Resources = Xobject.getDictionary(2004251818);
                if (Resources != null) {
                    glyphDecoder.readResources(Resources, false);
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            byte[] commands = Xobject.getDecodedStream();
            String textString = "";
            if (commands != null) {
                textString = glyphDecoder.decodeStreamIntoObjects(commands, true);
            }
            if (textString == null || textString.isEmpty()) {
                textString = null;
            }
            localStore.flush();
            return textString;
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            return null;
        }
        catch (Error e) {
            LogWriter.writeLog("Error: " + e.getMessage());
            return null;
        }
    }

    public static BufferedImage rotate(BufferedImage src, int rotation) {
        if (src == null) {
            return null;
        }
        if (rotation == 0) {
            return src;
        }
        double angle = (double)rotation * Math.PI / 180.0;
        int w = src.getWidth();
        int h = src.getHeight();
        int newW = (int)Math.round((double)h * Math.abs(Math.sin(angle)) + (double)w * Math.abs(Math.cos(angle)));
        int newH = (int)Math.round((double)h * Math.abs(Math.cos(angle)) + (double)w * Math.abs(Math.sin(angle)));
        AffineTransform at = AffineTransform.getTranslateInstance((newW - w) / 2, (newH - h) / 2);
        at.rotate(angle, w / 2, h / 2);
        BufferedImage dst = new BufferedImage(newW, newH, 2);
        Graphics2D g2 = dst.createGraphics();
        g2.drawRenderedImage(src, at);
        g2.dispose();
        return dst;
    }

    public boolean hasXFADataSet() {
        return false;
    }

    public static void decodeFontCommandObj(String fontStream, FormObject formObject) {
        StringTokenizer tokens = new StringTokenizer(fontStream, "() []");
        int tokenCount = tokens.countTokens();
        String[] tokenValues = new String[tokenCount];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            tokenValues[i] = tokens.nextToken();
            ++i;
        }
        for (i = tokenCount - 1; i > -1; --i) {
            if (tokenValues[i].equals("g")) {
                --i;
                float col = 0.0f;
                try {
                    col = Float.parseFloat(FormStream.handleComma(tokenValues[i]));
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating g value " + tokenValues[i] + ' ' + e);
                }
                formObject.setTextColor(new float[]{col});
                continue;
            }
            if (tokenValues[i].equals("Tf")) {
                --i;
                int textSize = 8;
                try {
                    textSize = (int)Float.parseFloat(FormStream.handleComma(tokenValues[i]));
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating Tf size " + tokenValues[i] + ' ' + e);
                }
                --i;
                String font = null;
                try {
                    font = tokenValues[i];
                    if (font.startsWith("/")) {
                        font = font.substring(1);
                    }
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating Tf font " + tokenValues[i] + "  " + e);
                }
                PdfFont currentFont = new PdfFont();
                currentFont.setFont(font, textSize);
                String fontName = StandardFonts.expandName(font);
                String altName = FontMappings.fontSubstitutionAliasTable.get(fontName.toLowerCase());
                if (altName != null) {
                    fontName = altName;
                }
                formObject.setFontName(fontName);
                formObject.setTextFont(currentFont.getGlyphData().getUnscaledFont());
                formObject.setTextSize(textSize);
                continue;
            }
            if (tokenValues[i].equals("rg") || tokenValues[i].equals("r")) {
                float b = Float.parseFloat(FormStream.handleComma(tokenValues[--i]));
                float g = Float.parseFloat(FormStream.handleComma(tokenValues[--i]));
                float r = Float.parseFloat(FormStream.handleComma(tokenValues[--i]));
                formObject.setTextColor(new float[]{r, g, b});
                continue;
            }
            if (tokenValues[i].equals("Sig")) {
                LogWriter.writeLog("[forms] Sig-  UNIMPLEMENTED=" + fontStream + "< " + i);
                continue;
            }
            if (tokenValues[i].equals("\\n") || showFontMessage) continue;
            showFontMessage = true;
            LogWriter.writeLog("[forms] {stream} Unknown FONT command " + tokenValues[i] + ' ' + i + " string=" + fontStream);
        }
    }

    private static String handleComma(String tokenValue) {
        int comma = tokenValue.indexOf(44);
        if (comma != -1) {
            tokenValue = tokenValue.substring(0, comma);
        }
        return tokenValue;
    }

    public byte[] getXFA(int xfaTemplate) {
        throw new RuntimeException("getXFA Should never be called in base class");
    }

    public boolean isXFA() {
        return this.isXFA;
    }

    static {
        id = new int[]{17, 4866, 4668, 21, 40, 20, 37, 5695, 8223, 8211, 8230, 8217, 31, 4865, 27, 22, 38, 4866, 5139, 10019, 5155, 10016, 5152};
    }
}

