/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.utils;

import java.awt.Rectangle;
import org.jpedal.objects.raw.FormObject;

public class FormUtils {
    public static FormObject[] sortGroupLargestFirst(FormObject[] comps) {
        return FormUtils.sortCompsDesending(comps);
    }

    private static FormObject[] sortCompsDesending(FormObject[] array) {
        int items = array.length;
        int left = items / 2;
        int right = items - 1;
        while (left > 0) {
            FormUtils.siftCompsDesending(array, --left, right);
        }
        while (right > 0) {
            FormObject tempA = array[0];
            array[0] = array[right];
            array[right] = tempA;
            FormUtils.siftCompsDesending(array, left, --right);
        }
        return array;
    }

    private static void siftCompsDesending(FormObject[] array, int left, int right) {
        int currentLeft = left;
        FormObject primaryTMP = array[currentLeft];
        int childL = 2 * left + 1;
        if (childL < right && FormUtils.shouldSwapControlDesending(array[childL], array[childL + 1])) {
            ++childL;
        }
        while (childL <= right && FormUtils.shouldSwapControlDesending(primaryTMP, array[childL])) {
            array[currentLeft] = array[childL];
            currentLeft = childL;
            if ((childL = 2 * childL + 1) >= right || !FormUtils.shouldSwapControlDesending(array[childL], array[childL + 1])) continue;
            ++childL;
        }
        array[currentLeft] = primaryTMP;
    }

    private static boolean shouldSwapControlDesending(FormObject arg1, FormObject arg2) {
        if (arg1 == null) {
            return arg2 != null;
        }
        if (arg2 == null) {
            return false;
        }
        Rectangle first = arg1.getBoundingRectangle();
        Rectangle second = arg2.getBoundingRectangle();
        return first.width * first.height < second.width * second.height;
    }
}

