/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.FormTypes;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.SwingFormCreator;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.FormFlattener;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.PdfStreamDecoderForPrinting;
import org.jpedal.parser.PrintStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class AcroRenderer {
    private static final boolean flattenForms;
    private static final boolean ignoreAllForms;
    FormObject[] Fforms;
    private FormObject[] Aforms;
    private PdfObject AcroRes;
    private float dpi = 72.0f;
    private Object[] CO;
    PdfArrayIterator fieldList;
    private PdfArrayIterator[] annotList;
    private boolean ignoreForms;
    private boolean alwaysUseXFA;
    private FormFactory formFactory;
    private GUIData compData;
    private Set<FormObject> sigObject;
    private Map<String, String> sigKeys;
    private PdfPageData pageData;
    private int[] AfieldCount;
    private int ATotalCount;
    private int FfieldCount;
    private int additionalOBjectRef;
    private boolean addedMissingPopup;
    int pageCount;
    private PdfObjectReader currentPdfFile;
    FormStream fDecoder;
    private ActionHandler formsActionHandler;
    private Javascript javascript;
    boolean hasXFA;
    private boolean isContainXFAStream;
    boolean useXFA;
    Enum<FormTypes> PDFformType;
    private SwingFormCreator formCreator;

    public void useXFAIfAvailable(boolean useXFA) {
        this.useXFA = useXFA;
    }

    public void resetHandler(ActionHandler formsActionHandler, float dpi, Javascript javascript) {
        this.formsActionHandler = formsActionHandler;
        this.dpi = dpi;
        this.javascript = javascript;
        if (this.formFactory != null) {
            this.formFactory.reset(this.getFormResources(), formsActionHandler, this.pageData, this.currentPdfFile);
        }
    }

    public void removeDisplayComponentsFromScreen() {
        if (this.compData != null) {
            this.compData.removeAllComponentsFromScreen();
        }
    }

    public int openFile(int pageCount, int insetW, int insetH, PdfPageData pageData, PdfObjectReader currentPdfFile, PdfObject acroObj) {
        this.pageCount = pageCount;
        this.currentPdfFile = currentPdfFile;
        this.pageData = pageData;
        this.compData.flushFormData();
        this.sigObject = null;
        this.sigKeys = null;
        this.compData.setPageData(pageData, insetW, insetH);
        if (acroObj == null) {
            this.FfieldCount = 0;
            this.fieldList = null;
        } else {
            PdfArrayIterator XFAasArray = null;
            PdfObject XFAasStream = acroObj.getDictionary(2627089);
            if (XFAasStream == null && (XFAasArray = acroObj.getMixedArray(2627089)) != null && XFAasArray.getTokenCount() == 0) {
                XFAasArray = null;
            }
            this.isContainXFAStream = this.hasXFA = XFAasStream != null || XFAasArray != null;
            this.fieldList = acroObj.getMixedArray(893143676);
            this.CO = acroObj.getObjectArray(4895);
            if (this.fieldList != null) {
                this.FfieldCount = this.fieldList.getTokenCount();
                this.AcroRes = acroObj.getDictionary(5154);
                if (this.AcroRes != null) {
                    currentPdfFile.checkResolved(this.AcroRes);
                }
            } else {
                this.FfieldCount = 0;
                this.AcroRes = null;
            }
            if (this.hasXFA && this.useXFA) {
                this.processXFAFields(acroObj, currentPdfFile, pageData);
            }
            if (!this.hasXFA) {
                this.resolveIndirectFieldList(false);
            }
        }
        this.resetContainers(true);
        return pageCount;
    }

    void processXFAFields(PdfObject acroObj1, PdfObjectReader currentPdfFile1, PdfPageData pageData1) {
        throw new RuntimeException("This code (processXFAFields) should never be called");
    }

    void resolveIndirectFieldList(boolean resolveParents) {
        while (this.FfieldCount == 1) {
            this.fieldList.resetToStart();
            String key = this.fieldList.getNextValueAsString(false);
            FormObject kidObject = new FormObject(key);
            this.currentPdfFile.readObject(kidObject);
            byte[][] childList = this.getKid(kidObject, resolveParents);
            if (childList == null) break;
            this.fieldList = new PdfArrayIterator(childList);
            this.FfieldCount = this.fieldList.getTokenCount();
        }
    }

    public void resetAnnotData(int insetW, int insetH, PdfPageData pageData, int page, PdfObjectReader currentPdfFile, byte[][] currentAnnotList) {
        this.currentPdfFile = currentPdfFile;
        this.pageData = pageData;
        boolean resetToEmpty = true;
        this.addedMissingPopup = false;
        this.compData.setPageData(pageData, insetW, insetH);
        if (currentAnnotList == null) {
            this.AfieldCount = null;
            this.ATotalCount = 0;
            if (this.annotList != null) {
                this.annotList[page] = null;
            }
            this.annotList = null;
        } else {
            int size;
            int pageCount = pageData.getPageCount() + 1;
            if (pageCount <= page) {
                pageCount = page + 1;
            }
            if (this.annotList == null) {
                this.annotList = new PdfArrayIterator[pageCount];
                this.AfieldCount = new int[pageCount];
            } else if (page >= this.annotList.length) {
                PdfArrayIterator[] tempList = this.annotList;
                int[] tempCount = this.AfieldCount;
                this.AfieldCount = new int[pageCount];
                this.annotList = new PdfArrayIterator[pageCount];
                for (int ii = 0; ii < tempList.length; ++ii) {
                    this.AfieldCount[ii] = tempCount[ii];
                    this.annotList[ii] = tempList[ii];
                }
            } else if (this.AfieldCount == null) {
                this.AfieldCount = new int[pageCount];
            }
            this.annotList[page] = new PdfArrayIterator(currentAnnotList);
            this.AfieldCount[page] = size = this.annotList[page].getTokenCount();
            this.ATotalCount += size;
            resetToEmpty = false;
            if (this.fDecoder == null) {
                this.PDFformType = FormTypes.NON_XFA;
                this.fDecoder = new FormStream();
            }
        }
        this.resetContainers(resetToEmpty);
    }

    private void resetContainers(boolean resetToEmpty) {
        if (resetToEmpty) {
            this.compData.resetComponents(this.ATotalCount + this.FfieldCount, this.pageCount, false);
        } else {
            this.compData.resetComponents(this.ATotalCount + this.FfieldCount, this.pageCount, true);
        }
        if (this.formFactory == null) {
            this.formFactory = this.formCreator.createFormFactory();
            this.formFactory.reset(this.getFormResources(), this.formsActionHandler, this.pageData, this.currentPdfFile);
        } else {
            this.formFactory.reset(this.getFormResources(), this.formsActionHandler, this.pageData, this.currentPdfFile);
        }
    }

    public void createDisplayComponentsForPage(int page, PdfStreamDecoder current) {
        if (flattenForms) {
            this.compData.setRasterizeForms(true);
        }
        if (!ignoreAllForms && (!this.compData.hasformsOnPageDecoded(page) || this.formsRasterizedForDisplay() && current != null)) {
            this.compData.initParametersForPage(this.pageData, page, this.formFactory, this.dpi);
            HashMap<String, String> formsProcessed = new HashMap<String, String>();
            int Acount = 0;
            if (this.AfieldCount != null && this.AfieldCount.length > page) {
                Acount = this.AfieldCount[page];
            }
            this.Fforms = new FormObject[this.FfieldCount];
            this.Aforms = new FormObject[Acount];
            int decodeToForm = 2;
            for (int forms = 0; forms < 2; ++forms) {
                int count;
                int i = 0;
                if (forms == 0) {
                    count = 0;
                    if (this.fieldList != null) {
                        this.fieldList.resetToStart();
                        count = this.fieldList.getTokenCount() - 1;
                    }
                } else {
                    if (this.annotList != null && this.annotList.length > page && this.annotList[page] != null) {
                        if (!this.isContainXFAStream && this.formFactory.getType() == 3) {
                            AcroRenderer.setOrder(page, this.annotList, this.formFactory);
                        }
                        this.annotList[page].resetToStart();
                    }
                    count = Acount - 1;
                }
                for (int fieldNum = count; fieldNum > -1; --fieldNum) {
                    byte[][] kids;
                    FormObject formObject;
                    String objRef;
                    block15: {
                        objRef = AcroRenderer.getObjRef(page, forms, this.fieldList, this.addedMissingPopup, this.annotList);
                        if (objRef == null || formsProcessed.get(objRef) != null || objRef.isEmpty()) continue;
                        try {
                            formObject = this.convertRefToFormObject(objRef, page);
                            if (!AcroRenderer.isAnnotation(formObject)) {
                            }
                            break block15;
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception " + e + " with " + objRef);
                        }
                        continue;
                    }
                    if (forms == 0 && formObject.getFormType() == -1) continue;
                    if (AcroRenderer.allowsPopup(formObject) && formObject.getDictionary(1061176672) == null) {
                        this.handlePopup(page, formObject);
                    }
                    i = (kids = formObject.getKeyArray(456733763)) != null ? this.flattenKids(page, formsProcessed, formObject, i, forms) : this.processFormObject(page, formsProcessed, formObject, objRef, i, forms);
                }
            }
            ArrayList<FormObject> unsortedForms = new ArrayList<FormObject>();
            ArrayList<FormObject> sortedForms = new ArrayList<FormObject>();
            Map<String, String> formsCreated = this.createAndStoreFormComponents(current, unsortedForms, sortedForms, page);
            this.compData.setListForPage(page, unsortedForms, false);
            this.compData.setListForPage(page, sortedForms, true);
            if (!this.formsRasterizedForDisplay()) {
                this.setJScode(page, formsCreated);
            }
        }
    }

    private void setJScode(int page, Map<String, String> formsCreated) {
        try {
            String ref = this.currentPdfFile.getReferenceforPage(page);
            PageObject pageObj = new PageObject(ref);
            this.currentPdfFile.readObject(pageObj);
            if (this.javascript != null && this.formsActionHandler != null) {
                this.formsActionHandler.O(pageObj, 4369);
                this.formsActionHandler.O(pageObj, 17);
                this.formsActionHandler.PO(pageObj, 4369);
                this.formsActionHandler.PO(pageObj, 17);
            }
            if (this.formFactory.getType() != 3 && this.formFactory.getType() != 4) {
                this.initJSonFields(formsCreated);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    private void handlePopup(int page, FormObject formObject) {
        FormObject po = new FormObject(1044266837);
        ++this.additionalOBjectRef;
        po.setRef(-this.additionalOBjectRef + " 0 X");
        po.setIntNumber(22, 24);
        po.setBoolean(524301630, formObject.getBoolean(524301630));
        po.setConstant(1147962727, 1061176672);
        float[] rect = formObject.getFloatArray(573911876);
        if (this.pageData.getRotation(page) % 180 != 0) {
            po.setFloatArray(573911876, new float[]{rect[2], this.pageData.getCropBoxHeight(page) - 100, rect[2] + 160.0f, this.pageData.getCropBoxHeight(page)});
        } else {
            po.setFloatArray(573911876, new float[]{this.pageData.getCropBoxWidth(page), rect[3] - 100.0f, this.pageData.getCropBoxWidth(page) + 160, rect[3]});
        }
        po.setStringKey(1110793845, formObject.getObjectRefAsString().getBytes());
        po.setParentPdfObj(formObject);
        po.setPageNumber(page);
        formObject.setDictionary(1061176672, po);
        FormObject[] newForms = new FormObject[this.Aforms.length + 1];
        for (int ii = 0; ii != this.Aforms.length; ++ii) {
            newForms[ii] = this.Aforms[ii];
        }
        newForms[this.Aforms.length] = po;
        this.Aforms = newForms;
        this.addedMissingPopup = true;
    }

    private static String getObjRef(int page, int forms, PdfArrayIterator fieldList, boolean addedMissingPopup, PdfArrayIterator[] annotList) {
        String objRef = null;
        if (forms == 0) {
            if (fieldList != null) {
                objRef = fieldList.getNextValueAsString(true);
            }
        } else if ((!addedMissingPopup || annotList[page].hasMoreTokens()) && annotList.length > page && annotList[page] != null) {
            objRef = annotList[page].getNextValueAsString(true);
        }
        return objRef;
    }

    private static void setOrder(int page, PdfArrayIterator[] annotList, FormFactory formFactory) {
        int formIndexOffset = 0;
        for (int j = 1; j != page; ++j) {
            if (annotList[j] == null) continue;
            formIndexOffset += annotList[j].getTokenCount();
        }
        annotList[page].resetToStart();
        HashMap<String, String> annotOrder = new HashMap<String, String>();
        int count2 = annotList[page].getTokenCount();
        for (int ii = 0; ii < count2; ++ii) {
            String val = annotList[page].getNextValueAsString(true);
            annotOrder.put(val, String.valueOf(ii + formIndexOffset + 1));
        }
        formFactory.setAnnotOrder(annotOrder);
    }

    Map<String, String> createAndStoreFormComponents(PdfStreamDecoder current, List<FormObject> unsortedForms, List<FormObject> sortedForms, int page) {
        return this.createComponents(current, unsortedForms, sortedForms, page, null);
    }

    Map<String, String> createComponents(PdfStreamDecoder current, List<FormObject> unsortedForms, List<FormObject> sortedForms, int page, FormObject[] xfaFormList) {
        HashMap<String, String> formsCreated = new HashMap<String, String>();
        int readToForm = 3;
        for (int forms = 0; forms < 3; ++forms) {
            int count = 0;
            switch (forms) {
                case 0: {
                    if (xfaFormList == null) break;
                    count = xfaFormList.length;
                    break;
                }
                case 1: {
                    if (this.Fforms == null) {
                        count = 0;
                        break;
                    }
                    for (FormObject Fform : this.Fforms) {
                        if (Fform == null) continue;
                        unsortedForms.add(Fform);
                    }
                    this.Fforms = FormUtils.sortGroupLargestFirst(this.Fforms);
                    count = this.Fforms.length;
                    break;
                }
                default: {
                    for (FormObject Aform : this.Aforms) {
                        if (Aform == null) continue;
                        unsortedForms.add(Aform);
                    }
                    if (!this.formsRasterizedForDisplay()) {
                        this.Aforms = FormUtils.sortGroupLargestFirst(this.Aforms);
                    }
                    if (this.isContainXFAStream) {
                        this.handleXFAStream();
                    }
                    count = this.Aforms.length;
                }
            }
            boolean firstPopup = true;
            for (int k = 0; k < count; ++k) {
                FormObject formObject;
                switch (forms) {
                    case 0: {
                        formObject = xfaFormList[k];
                        break;
                    }
                    case 1: {
                        formObject = this.Fforms[k];
                        break;
                    }
                    default: {
                        formObject = this.Aforms[k];
                    }
                }
                if (formObject == null || formsCreated.get(formObject.getObjectRefAsString()) != null || page != formObject.getPageNumber()) continue;
                firstPopup = this.processFieldValue(current, sortedForms, formsCreated, formObject, firstPopup);
            }
        }
        return formsCreated;
    }

    private boolean processFieldValue(PdfStreamDecoder current, List<FormObject> sortedForms, Map<String, String> formsCreated, FormObject formObject, boolean firstPopup) {
        int type = this.formFactory.getType();
        if (this.formsRasterizedForDisplay() && current != null || this.formFactory.flattenForm(formObject)) {
            try {
                this.getFormFlattener().drawFlattenedForm(current, formObject, type == 3 || type == 4, (PdfObject)this.getFormResources()[0]);
            }
            catch (PdfException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        } else {
            this.createField(formObject);
            this.compData.storeRawData(formObject);
            formsCreated.put(formObject.getObjectRefAsString(), "x");
            if (type == 3 || type == 4 || type == 5) {
                sortedForms.add(formObject);
            } else if (formObject.getParameterConstant(1147962727) == 1061176672) {
                if (firstPopup) {
                    sortedForms.add(formObject);
                    firstPopup = false;
                } else {
                    sortedForms.add(sortedForms.size() - 1, formObject);
                }
            } else {
                sortedForms.add(0, formObject);
            }
        }
        return firstPopup;
    }

    private void handleXFAStream() {
        HashMap tabMap = new HashMap();
        double maxY = 0.0;
        for (FormObject obj : this.Aforms) {
            if (obj == null) continue;
            int x = obj.getBoundingRectangle().x;
            Double y = obj.getBounding2DRectangleForTabbing().getY();
            maxY = Math.max(y, maxY);
            if (tabMap.containsKey(y)) {
                ArrayList fList = (ArrayList)tabMap.get(y);
                int insertion = -1;
                for (int z = 0; z < fList.size(); ++z) {
                    int nextX = ((FormObject)fList.get((int)z)).getBoundingRectangle().x;
                    if (nextX >= x) continue;
                    insertion = z;
                }
                if (insertion == -1) {
                    fList.add(0, obj);
                    continue;
                }
                fList.add(insertion + 1, obj);
                continue;
            }
            ArrayList<FormObject> list = new ArrayList<FormObject>();
            list.add(obj);
            tabMap.put(y, list);
        }
        FormObject[] finalList = new FormObject[this.Aforms.length];
        int objCount = 0;
        Object[] keys = new Object[tabMap.size()];
        int cc = 0;
        Object[] x = tabMap.keySet().toArray();
        int y = x.length;
        for (int i = 0; i < y; ++i) {
            Object k;
            keys[cc] = k = x[i];
            ++cc;
        }
        Arrays.sort(keys);
        for (int k = keys.length; k > 0; --k) {
            ArrayList objList = (ArrayList)tabMap.get(keys[k - 1]);
            if (objList == null) continue;
            Iterator iterator = objList.iterator();
            while (iterator.hasNext()) {
                FormObject f;
                finalList[objCount] = f = (FormObject)iterator.next();
                ++objCount;
            }
        }
        this.Aforms = finalList;
    }

    private static boolean allowsPopup(FormObject formObject) {
        switch (formObject.getParameterConstant(1147962727)) {
            case 607471684: 
            case 1144077667: 
            case 1160865142: 
            case 1919840408: 
            case 2036432546: 
            case 2053993372: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotation(FormObject formObject) {
        if (formObject.getParameterConstant(608780341) == 1044266837) {
            return true;
        }
        switch (formObject.getParameterConstant(1147962727)) {
            case -2089577293: 
            case -1113876231: 
            case 788: 
            case 1654331: 
            case 473513525: 
            case 473513531: 
            case 607471684: 
            case 826422615: 
            case 876043389: 
            case 980909433: 
            case 1014528638: 
            case 1061176672: 
            case 1061502534: 
            case 1061566802: 
            case 1078097781: 
            case 1110658926: 
            case 1110792305: 
            case 1144077667: 
            case 1160865142: 
            case 1230470778: 
            case 1517846914: 
            case 1536539062: 
            case 1852273008: 
            case 1853192100: 
            case 1919840408: 
            case 2036432546: 
            case 2053993372: {
                return true;
            }
        }
        return false;
    }

    private void storeSignatures(FormObject formObject, int formType) {
        if (formType == 2308407) {
            if (this.sigObject == null) {
                this.sigObject = new HashSet<FormObject>();
                this.sigKeys = new HashMap<String, String>();
            }
            if (!this.sigKeys.containsKey(formObject.getObjectRefAsString())) {
                this.sigObject.add(formObject);
                this.sigKeys.put(formObject.getObjectRefAsString(), "x");
            }
        }
    }

    private int flattenKids(int page, Map<String, String> formsProcessed, FormObject formObject, int i, int forms) {
        FormObject[] temp;
        int oldCount;
        byte[][] kidList = formObject.getKeyArray(456733763);
        int kidCount = kidList.length;
        if (forms == 0) {
            oldCount = this.Fforms.length;
            temp = this.Fforms;
            this.Fforms = new FormObject[oldCount + kidCount - 1];
            System.arraycopy(temp, 0, this.Fforms, 0, oldCount);
        } else {
            oldCount = this.Aforms.length;
            temp = this.Aforms;
            this.Aforms = new FormObject[oldCount + kidCount - 1];
            System.arraycopy(temp, 0, this.Aforms, 0, oldCount);
        }
        for (byte[] aKidList : kidList) {
            String key = new String(aKidList);
            FormObject childObj = new FormObject(key);
            childObj.copyInheritedValuesFromParent(formObject);
            this.currentPdfFile.readObject(childObj);
            childObj.setRef(key);
            if (childObj.getKeyArray(456733763) == null) {
                if (!childObj.isAppearanceUsed()) {
                    new FormStream().createAppearanceString(childObj, this.currentPdfFile);
                }
                i = this.processFormObject(page, formsProcessed, childObj, key, i, forms);
                continue;
            }
            i = this.flattenKids(page, formsProcessed, childObj, i, forms);
        }
        return i;
    }

    private int processFormObject(int page, Map<String, String> formsProcessed, FormObject formObject, String objRef, int i, int forms) {
        boolean isOnPage = false;
        if (forms == 0) {
            isOnPage = this.isFormObjectOnPage(formObject, page);
        }
        if (forms == 1 || isOnPage) {
            formObject.setPageNumber(page);
            String parent = formObject.getStringKey(1110793845);
            if (parent != null) {
                FormObject parentObj = this.getParent(parent, formObject);
                if (formObject.getParameterConstant(1147962727) == 1061176672) {
                    parentObj.setDictionary(1061176672, formObject);
                }
                if (parentObj != null) {
                    formObject.setParent(parent, parentObj, true);
                }
            }
            if (!formObject.isAppearanceUsed()) {
                this.fDecoder.createAppearanceString(formObject, this.currentPdfFile);
            }
            if (formObject.getParameterConstant(1147962727) != -1) {
                if (parent != null) {
                    formObject.setParent(parent);
                }
                if (forms == 0) {
                    this.Fforms[i++] = formObject;
                } else {
                    this.Aforms[i++] = formObject;
                }
                if (objRef != null) {
                    formsProcessed.put(objRef, "x");
                }
            }
        }
        return i;
    }

    private boolean isFormObjectOnPage(FormObject formObject, int page) {
        byte[][] kidList;
        FormObject parentObj;
        String parent;
        PdfObject pageObj = formObject.getDictionary(32);
        byte[] pageRef = null;
        if (pageObj != null) {
            pageRef = pageObj.getUnresolvedData();
        }
        if (pageRef == null && (parent = formObject.getStringKey(1110793845)) != null && (pageObj = ((PdfObject)(parentObj = this.getParent(parent, null))).getDictionary(32)) != null) {
            pageRef = pageObj.getUnresolvedData();
        }
        if (pageRef == null && (kidList = this.getKid(formObject, false)) != null && kidList.length > 0) {
            int kidCount = kidList.length;
            for (int jj = 0; jj < kidCount; ++jj) {
                String key = new String(kidList[jj]);
                FormObject kidObject = this.compData.getRawFormData().get(key);
                if (kidObject == null) {
                    kidObject = new FormObject(key);
                    this.currentPdfFile.readObject(kidObject);
                    this.compData.storeRawData(kidObject);
                }
                if ((pageObj = kidObject.getDictionary(32)) != null) {
                    pageRef = pageObj.getUnresolvedData();
                }
                if (pageRef == null) continue;
                jj = kidCount;
            }
        }
        int objPage = -1;
        if (pageRef != null) {
            objPage = this.currentPdfFile.convertObjectToPageNumber(new String(pageRef));
        }
        return objPage == page;
    }

    private FormObject getParent(String parent, FormObject formObj) {
        FormObject parentObj = this.compData.getRawFormData().get(parent);
        if (parentObj == null && parent != null) {
            parentObj = new FormObject(parent);
            this.currentPdfFile.readObject(parentObj);
            parentObj.setKeyArray(456733763, null);
            this.compData.storeRawData(parentObj);
        }
        if (parentObj != null && formObj != null) {
            byte[][] kidsInParent = parentObj.getRawKids();
            formObj.setRawKids(kidsInParent);
        }
        return parentObj;
    }

    private byte[][] getKid(FormObject formObject, boolean ignoreParent) {
        String parentRef;
        FormObject parentObj;
        int formType = formObject.getNameAsConstant(5668);
        if (formType == 9288 || formType == 1197118) {
            return null;
        }
        byte[][] kidList = formObject.getKeyArray(456733763);
        if (kidList != null && !ignoreParent && (parentObj = this.getFormObject(parentRef = formObject.getStringKey(1110793845))) != null && ((PdfObject)parentObj).getKeyArray(456733763) != null) {
            kidList = null;
        }
        return kidList;
    }

    public void displayComponentsOnscreen(int startPage, int endPage) {
        if (this.compData != null) {
            this.compData.displayComponents(startPage, ++endPage);
        }
    }

    private void initJSonFields(Map<String, String> formsCreated) {
        for (String ref : formsCreated.keySet()) {
            FormObject formObject = this.getFormObject(ref);
            this.javascript.execute(formObject, 27, 6, ' ');
        }
    }

    private void createField(FormObject formObject) {
        boolean[] flags;
        if (ExternalHandlers.isULCPresent() && this.formFactory.getType() == 1) {
            return;
        }
        int formType = formObject.getNameAsConstant(5668);
        int formFactoryType = this.formFactory.getType();
        this.storeSignatures(formObject, formType);
        if (formObject.getDictionary(1061176672) != null) {
            formObject.setActionFlag(1);
        }
        if ((flags = formObject.getFieldFlags()) != null) {
            boolean readOnly = flags[1];
            boolean required = flags[2];
            boolean bl = flags[3];
        }
        Integer widgetType = !ExternalHandlers.isXFAPresent() && (formFactoryType == 3 || formFactoryType == 4) ? FormFactory.ANNOTATION : (formType == 1197118 ? Integer.valueOf(AcroRenderer.createButtonField(flags)) : Integer.valueOf(AcroRenderer.createInteractiveField(flags, formType)));
        formObject.setFormType(widgetType);
        if (this.formFactory.getType() == 3 || this.formFactory.getType() == 4) {
            this.compData.checkGUIObjectResolved(formObject);
        }
    }

    private static int createInteractiveField(boolean[] flags, int formType) {
        int widgetType;
        switch (formType) {
            case 9288: {
                boolean isMultiline = false;
                boolean hasPassword = false;
                if (flags != null) {
                    isMultiline = flags[13];
                    hasPassword = flags[14];
                }
                if (isMultiline) {
                    if (hasPassword) {
                        widgetType = FormFactory.MULTILINEPASSWORD;
                        break;
                    }
                    widgetType = FormFactory.MULTILINETEXT;
                    break;
                }
                if (hasPassword) {
                    widgetType = FormFactory.SINGLELINEPASSWORD;
                    break;
                }
                widgetType = FormFactory.SINGLELINETEXT;
                break;
            }
            case 4920: {
                boolean isCombo = false;
                if (flags != null) {
                    isCombo = flags[18];
                }
                if (isCombo) {
                    widgetType = FormFactory.COMBOBOX;
                    break;
                }
                widgetType = FormFactory.LIST;
                break;
            }
            case 2308407: {
                widgetType = FormFactory.SIGNATURE;
                break;
            }
            default: {
                widgetType = FormFactory.ANNOTATION;
            }
        }
        return widgetType;
    }

    private static int createButtonField(boolean[] flags) {
        boolean isPushButton = false;
        boolean isRadio = false;
        if (flags != null) {
            isPushButton = flags[17];
            isRadio = flags[16];
        }
        int widgetType = isPushButton ? FormFactory.PUSHBUTTON : (isRadio ? FormFactory.RADIOBUTTON.intValue() : FormFactory.CHECKBOXBUTTON.intValue());
        return widgetType;
    }

    public Object[] getFormComponents(String objectName, ReturnValues value, int pageNumber) {
        switch (value) {
            case EMBEDDED_FILES: {
                if (this.currentPdfFile.getNamesLookup() == null) {
                    return new Object[0];
                }
                return this.currentPdfFile.getNamesLookup().getEmbeddedFiles();
            }
        }
        if (pageNumber == -1) {
            for (int p = 1; p < this.pageCount + 1; ++p) {
                this.createDisplayComponentsForPage(p, null);
            }
        } else {
            this.createDisplayComponentsForPage(pageNumber, null);
        }
        return this.compData.getFormComponents(objectName, value, pageNumber).toArray();
    }

    public void setFormFactory(FormFactory newFormFactory) {
        this.formFactory = newFormFactory;
        this.compData = this.formFactory.getCustomCompData();
    }

    public GUIData getCompData() {
        return this.compData;
    }

    public Iterator<FormObject> getSignatureObjects() {
        if (this.sigObject == null) {
            return null;
        }
        return this.sigObject.iterator();
    }

    public ActionHandler getActionHandler() {
        return this.formsActionHandler;
    }

    public FormFactory getFormFactory() {
        return this.formFactory;
    }

    public void setIgnoreForms(boolean ignoreForms) {
        this.ignoreForms = ignoreForms;
    }

    public boolean ignoreForms() {
        return this.ignoreForms || ignoreAllForms;
    }

    public void dispose() {
        this.AfieldCount = null;
        this.fDecoder = null;
        this.formsActionHandler = null;
        if (this.javascript != null) {
            this.javascript.dispose();
        }
        this.javascript = null;
        this.Fforms = null;
        this.Aforms = null;
        this.fieldList = null;
        this.annotList = null;
        this.formFactory = null;
        if (this.compData != null) {
            this.compData.dispose();
        }
        this.compData = null;
        if (this.sigObject != null) {
            this.sigObject.clear();
        }
        this.sigObject = null;
        if (this.sigKeys != null) {
            this.sigKeys.clear();
        }
        this.sigKeys = null;
        this.pageData = null;
        if (this.currentPdfFile != null) {
            this.currentPdfFile.dispose();
        }
        this.currentPdfFile = null;
        this.fDecoder = null;
        this.formCreator = null;
    }

    @Deprecated
    public PdfArrayIterator getAnnotsOnPage(int page) {
        this.createDisplayComponentsForPage(page, null);
        if (this.annotList != null && this.annotList.length > page && this.annotList[page] != null) {
            this.annotList[page].resetToStart();
            return this.annotList[page];
        }
        return null;
    }

    public boolean isXFA() {
        return this.hasXFA;
    }

    public boolean useXFA() {
        return this.useXFA;
    }

    public boolean hasFormsOnPage(int page) {
        boolean hasAnnots = this.annotList != null && this.annotList.length > page && this.annotList[page] != null;
        boolean hasForm = this.hasXFA && this.useXFA && this.fDecoder.hasXFADataSet() || this.fieldList != null;
        return hasAnnots || hasForm;
    }

    public Object[] getFormResources() {
        return new Object[]{this.AcroRes, this.CO};
    }

    public boolean formsRasterizedForDisplay() {
        return this.compData.formsRasterizedForDisplay();
    }

    public FormObject getFormObject(String ref) {
        FormObject obj = this.compData.getRawFormData().get(ref);
        if (obj == null && this.formFactory.getType() != 3 && this.formFactory.getType() != 4) {
            for (int ii = 1; ii < this.pageCount; ++ii) {
                this.createDisplayComponentsForPage(ii, null);
                obj = this.compData.getRawFormData().get(ref);
                if (obj != null) break;
            }
        }
        return obj;
    }

    public void setInsets(int width, int height) {
        this.compData.setPageData(this.compData.pageData, width, height);
    }

    FormObject convertRefToFormObject(String objRef, int page) {
        FormObject formObject = this.compData.getRawFormData().get(objRef);
        if (formObject == null) {
            formObject = new FormObject(objRef);
            if (page != -1) {
                formObject.setPageRotation(this.pageData.getRotation(page));
            }
            if (objRef.charAt(objRef.length() - 1) == 'R') {
                this.currentPdfFile.readObject(formObject);
            } else {
                formObject.setStatus(1);
                formObject.setUnresolvedData(StringUtils.toBytes(objRef), -1);
                this.currentPdfFile.checkResolved(formObject);
            }
            this.compData.storeRawData(formObject);
        }
        return formObject;
    }

    public Enum<FormTypes> getPDFformType() {
        return this.PDFformType;
    }

    public void alwaysuseXFA(boolean alwaysUseXFA) {
        this.alwaysUseXFA = alwaysUseXFA;
    }

    public boolean alwaysuseXFA() {
        return this.alwaysUseXFA;
    }

    public void init(SwingFormCreator formCreator) {
        this.formCreator = formCreator;
        this.compData = formCreator.getData();
    }

    public PdfStreamDecoder getStreamDecoder(PdfObjectReader currentPdfFile, PdfLayerList layer, boolean isFirst) {
        if (isFirst) {
            return new PdfStreamDecoder(currentPdfFile);
        }
        return new PdfStreamDecoder(currentPdfFile, layer);
    }

    public boolean showFormWarningMessage(int page) {
        boolean warnOnceOnForms = false;
        if (this.hasXFA) {
            warnOnceOnForms = true;
            System.out.println("[WARNING] This file contains XFA forms that are not supported by BuildVu. To convert into functional HTML forms, FormVu must be used.");
        } else if (this.hasFormsOnPage(page)) {
            warnOnceOnForms = true;
            System.out.println("[WARNING] This file contains form components that have been rasterized. To convert into functional HTML forms, FormVu must be used.");
        }
        return warnOnceOnForms;
    }

    public byte[] getXMLContentAsBytes(int dataType) {
        return null;
    }

    public void outputJavascriptXFA(String path, String name) {
        throw new UnsupportedOperationException("outputJavascriptXFA should never be called");
    }

    public PrintStreamDecoder getStreamDecoderForPrinting(PdfObjectReader currentPdfFile, PdfLayerList pdfLayerList) {
        return new PdfStreamDecoderForPrinting(currentPdfFile, pdfLayerList);
    }

    public BufferedImage decode(PdfObject pdfObject, PdfObjectReader currentPdfFile, PdfObject XObject2, int subtype, int width, int height, int offsetImage, float pageScaling) {
        LogWriter.writeLog("called decode(" + pdfObject + ", " + currentPdfFile + ", " + XObject2 + ", " + subtype + ", " + width + ", " + height + ", " + offsetImage + ", " + pageScaling);
        return null;
    }

    public FormFlattener getFormFlattener() {
        return new FormFlattener();
    }

    static {
        String s = System.getProperty("org.jpedal.flattenForm");
        flattenForms = s != null && s.equalsIgnoreCase("true");
        s = System.getProperty("org.jpedal.ignoreAllForms");
        ignoreAllForms = s != null && s.equalsIgnoreCase("true");
    }
}

