/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.text;

import java.io.IOException;
import java.util.ArrayList;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.ArithmeticDecoder;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.SegmentHeader;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.region.RegionFlags;
import org.jpedal.jbig2.segment.region.RegionSegment;
import org.jpedal.jbig2.segment.region.text.HuffManTables;
import org.jpedal.jbig2.segment.region.text.TextRegionFlags;
import org.jpedal.jbig2.segment.region.text.TextRegionHuffmanFlags;
import org.jpedal.jbig2.segment.symboldictionary.SymbolDictionarySegment;
import org.jpedal.jbig2.util.BinaryOperation;

public class TextRegionSegment
extends RegionSegment {
    private final TextRegionFlags textRegionFlags = new TextRegionFlags();
    private final TextRegionHuffmanFlags textRegionHuffmanFlags = new TextRegionHuffmanFlags();
    private final boolean inlineImage;
    private final short[] symbolRegionAdaptiveTemplateX = new short[2];
    private final short[] symbolRegionAdaptiveTemplateY = new short[2];

    public TextRegionSegment(JBIG2StreamDecoder streamDecoder, boolean inlineImage) {
        super(streamDecoder);
        this.inlineImage = inlineImage;
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        super.readSegment();
        this.readTextRegionFlags();
        short[] buff = new short[4];
        this.decoder.readByte(buff);
        int noOfSymbolInstances = BinaryOperation.getInt32(buff);
        int noOfReferredToSegments = this.segmentHeader.getReferredToSegmentCount();
        int[] referredToSegments = this.segmentHeader.getReferredToSegments();
        ArrayList<Segment> codeTables = new ArrayList<Segment>();
        ArrayList<Segment> segmentsReferenced = new ArrayList<Segment>();
        int noOfSymbols = TextRegionSegment.getNoOfSymbols(noOfReferredToSegments, referredToSegments, codeTables, segmentsReferenced, this.decoder);
        int symbolCodeLength = 0;
        for (int count = 1; count < noOfSymbols; count <<= 1) {
            ++symbolCodeLength;
        }
        JBIG2Bitmap[] symbols = TextRegionSegment.setSymbols(segmentsReferenced, noOfSymbols);
        boolean sbHuffman = this.textRegionFlags.getFlagValue("SB_HUFF") != 0;
        HuffManTables huffManTables = new HuffManTables();
        huffManTables.create(this.textRegionHuffmanFlags, sbHuffman, codeTables);
        int[][] symbolCodeTable = TextRegionSegment.createUnlengthTables(noOfSymbols, symbolCodeLength, sbHuffman, this.decoder, this.huffmanDecoder, this.arithmeticDecoder);
        boolean symbolRefine = this.textRegionFlags.getFlagValue("SB_REFINE") != 0;
        int logStrips = this.textRegionFlags.getFlagValue("LOG_SB_STRIPES");
        int defaultPixel = this.textRegionFlags.getFlagValue("SB_DEF_PIXEL");
        int combinationOperator = this.textRegionFlags.getFlagValue("SB_COMB_OP");
        boolean transposed = this.textRegionFlags.getFlagValue("TRANSPOSED") != 0;
        int referenceCorner = this.textRegionFlags.getFlagValue("REF_CORNER");
        int sOffset = this.textRegionFlags.getFlagValue("SB_DS_OFFSET");
        int template = this.textRegionFlags.getFlagValue("SB_R_TEMPLATE");
        if (symbolRefine) {
            this.arithmeticDecoder.resetRefinementStats(template, null);
        }
        JBIG2Bitmap bitmap = new JBIG2Bitmap(this.regionBitmapWidth, this.regionBitmapHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        bitmap.readTextRegion(sbHuffman, symbolRefine, noOfSymbolInstances, logStrips, noOfSymbols, symbolCodeTable, symbolCodeLength, symbols, defaultPixel, combinationOperator, transposed, referenceCorner, sOffset, huffManTables, template, this.symbolRegionAdaptiveTemplateX, this.symbolRegionAdaptiveTemplateY, this.decoder);
        if (this.inlineImage) {
            TextRegionSegment.processInlineImage(bitmap, this.decoder, this.segmentHeader, this.regionFlags, this.regionBitmapXLocation, this.regionBitmapYLocation);
        } else {
            bitmap.setBitmapNumber(this.getSegmentHeader().getSegmentNumber());
            this.decoder.appendBitmap(bitmap);
        }
        this.decoder.consumeRemainingBits();
    }

    private static int getNoOfSymbols(int noOfReferredToSegments, int[] referredToSegments, ArrayList<Segment> codeTables, ArrayList<Segment> segmentsReferenced, JBIG2StreamDecoder decoder) {
        int noOfSymbols = 0;
        for (int i = 0; i < noOfReferredToSegments; ++i) {
            Segment seg = decoder.findSegment(referredToSegments[i]);
            int type = seg.getSegmentHeader().getSegmentType();
            if (type == 0) {
                segmentsReferenced.add(seg);
                noOfSymbols += ((SymbolDictionarySegment)seg).getNoOfExportedSymbols();
                continue;
            }
            if (type != 53) continue;
            codeTables.add(seg);
        }
        return noOfSymbols;
    }

    private static int[][] createUnlengthTables(int noOfSymbols, int symbolCodeLength, boolean sbHuffman, JBIG2StreamDecoder decoder, HuffmanDecoder huffmanDecoder, ArithmeticDecoder arithmeticDecoder) {
        int[][] runLengthTable = new int[36][4];
        int[][] symbolCodeTable = new int[noOfSymbols + 1][4];
        if (sbHuffman) {
            int i;
            decoder.consumeRemainingBits();
            for (i = 0; i < 32; ++i) {
                runLengthTable[i] = new int[]{i, decoder.readBits(4), 0, 0};
            }
            runLengthTable[32] = new int[]{259, decoder.readBits(4), 2, 0};
            runLengthTable[33] = new int[]{515, decoder.readBits(4), 3, 0};
            runLengthTable[34] = new int[]{523, decoder.readBits(4), 7, 0};
            runLengthTable[35] = new int[]{0, 0, -1, 0};
            runLengthTable = HuffmanDecoder.buildTable(runLengthTable, 35);
            for (i = 0; i < noOfSymbols; ++i) {
                symbolCodeTable[i] = new int[]{i, 0, 0, 0};
            }
            i = 0;
            while (i < noOfSymbols) {
                int j = huffmanDecoder.decodeInt(runLengthTable).intResult();
                if (j > 512) {
                    j -= 512;
                    while (j != 0 && i < noOfSymbols) {
                        symbolCodeTable[i++][1] = 0;
                        --j;
                    }
                    continue;
                }
                if (j > 256) {
                    j -= 256;
                    while (j != 0 && i < noOfSymbols) {
                        symbolCodeTable[i][1] = symbolCodeTable[i - 1][1];
                        ++i;
                        --j;
                    }
                    continue;
                }
                symbolCodeTable[i++][1] = j;
            }
            symbolCodeTable[noOfSymbols][1] = 0;
            symbolCodeTable[noOfSymbols][2] = -1;
            symbolCodeTable = HuffmanDecoder.buildTable(symbolCodeTable, noOfSymbols);
            decoder.consumeRemainingBits();
        } else {
            symbolCodeTable = null;
            arithmeticDecoder.resetIntStats(symbolCodeLength);
            arithmeticDecoder.start();
        }
        return symbolCodeTable;
    }

    private static JBIG2Bitmap[] setSymbols(ArrayList<Segment> segmentsReferenced, int noOfSymbols) {
        int currentSymbol = 0;
        JBIG2Bitmap[] symbols = new JBIG2Bitmap[noOfSymbols];
        for (Segment seg : segmentsReferenced) {
            JBIG2Bitmap[] bitmaps;
            if (seg.getSegmentHeader().getSegmentType() != 0) continue;
            JBIG2Bitmap[] jBIG2BitmapArray = bitmaps = seg.getBitmaps();
            int n = jBIG2BitmapArray.length;
            for (int i = 0; i < n; ++i) {
                JBIG2Bitmap bitmap;
                symbols[currentSymbol] = bitmap = jBIG2BitmapArray[i];
                ++currentSymbol;
            }
        }
        return symbols;
    }

    private static void processInlineImage(JBIG2Bitmap bitmap, JBIG2StreamDecoder decoder, SegmentHeader segmentHeader, RegionFlags regionFlags, int regionBitmapXLocation, int regionBitmapYLocation) {
        PageInformationSegment pageSegment = decoder.findPageSegment(segmentHeader.getPageAssociation());
        JBIG2Bitmap pageBitmap = pageSegment.getPageBitmap();
        int externalCombinationOperator = regionFlags.getFlagValue("EXTERNAL_COMBINATION_OPERATOR");
        pageBitmap.combine(bitmap, regionBitmapXLocation, regionBitmapYLocation, externalCombinationOperator);
        bitmap.getDataWriter().clearResources();
    }

    private void readTextRegionFlags() {
        boolean sbHuff;
        short[] textRegionFlagsField = new short[2];
        this.decoder.readByte(textRegionFlagsField);
        int flags = BinaryOperation.getInt16(textRegionFlagsField);
        this.textRegionFlags.setFlags(flags);
        boolean bl = sbHuff = this.textRegionFlags.getFlagValue("SB_HUFF") != 0;
        if (sbHuff) {
            short[] textRegionHuffmanFlagsField = new short[2];
            this.decoder.readByte(textRegionHuffmanFlagsField);
            flags = BinaryOperation.getInt16(textRegionHuffmanFlagsField);
            this.textRegionHuffmanFlags.setFlags(flags);
        }
        boolean sbRefine = this.textRegionFlags.getFlagValue("SB_REFINE") != 0;
        int sbrTemplate = this.textRegionFlags.getFlagValue("SB_R_TEMPLATE");
        if (sbRefine && sbrTemplate == 0) {
            this.symbolRegionAdaptiveTemplateX[0] = this.readATValue();
            this.symbolRegionAdaptiveTemplateY[0] = this.readATValue();
            this.symbolRegionAdaptiveTemplateX[1] = this.readATValue();
            this.symbolRegionAdaptiveTemplateY[1] = this.readATValue();
        }
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return null;
    }
}

