/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.halftone;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.pattern.PatternDictionarySegment;
import org.jpedal.jbig2.segment.region.RegionSegment;
import org.jpedal.jbig2.segment.region.halftone.HalftoneRegionFlags;
import org.jpedal.jbig2.util.BinaryOperation;

public class HalftoneRegionSegment
extends RegionSegment {
    private final HalftoneRegionFlags halftoneRegionFlags = new HalftoneRegionFlags();
    private final boolean inlineImage;

    public HalftoneRegionSegment(JBIG2StreamDecoder streamDecoder, boolean inlineImage) {
        super(streamDecoder);
        this.inlineImage = inlineImage;
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        int i;
        Segment segment;
        super.readSegment();
        this.readHalftoneRegionFlags();
        SegmentData segData = new SegmentData(this.decoder);
        int[] referredToSegments = this.segmentHeader.getReferredToSegments();
        if (referredToSegments.length != 1) {
            System.out.println("Error in halftone Segment. referredToSegments should == 1.");
        }
        if ((segment = this.decoder.findSegment(referredToSegments[0])).getSegmentHeader().getSegmentType() != 16) {
            // empty if block
        }
        PatternDictionarySegment patternDictionarySegment = (PatternDictionarySegment)segment;
        int bitsPerValue = 0;
        for (i = 1; i < patternDictionarySegment.getSize(); i <<= 1) {
            ++bitsPerValue;
        }
        JBIG2Bitmap bitmap = patternDictionarySegment.getBitmaps()[0];
        int patternWidth = bitmap.getWidth();
        int patternHeight = bitmap.getHeight();
        boolean useMMR = this.halftoneRegionFlags.getFlagValue("H_MMR") != 0;
        int template = this.halftoneRegionFlags.getFlagValue("H_TEMPLATE");
        if (!useMMR) {
            this.arithmeticDecoder.resetGenericStats(template, null);
            this.arithmeticDecoder.start();
        }
        int halftoneDefaultPixel = this.halftoneRegionFlags.getFlagValue("H_DEF_PIXEL");
        bitmap = new JBIG2Bitmap(this.regionBitmapWidth, this.regionBitmapHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        bitmap.clear(halftoneDefaultPixel);
        boolean enableSkip = this.halftoneRegionFlags.getFlagValue("H_ENABLE_SKIP") != 0;
        JBIG2Bitmap skipBitmap = null;
        if (enableSkip) {
            skipBitmap = new JBIG2Bitmap(segData.gridWidth, segData.gridHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
            skipBitmap.clear(0);
            for (int y = 0; y < segData.gridHeight; ++y) {
                for (int x = 0; x < segData.gridWidth; ++x) {
                    int xx = segData.gridX + y * segData.stepY + x * segData.stepX;
                    int yy = segData.gridY + y * segData.stepX - x * segData.stepY;
                    if (xx + patternWidth >> 8 > 0 && xx >> 8 < this.regionBitmapWidth && yy + patternHeight >> 8 > 0 && yy >> 8 < this.regionBitmapHeight) continue;
                    skipBitmap.setPixel(y, x, 1);
                }
            }
            skipBitmap.getDataWriter().clearResources();
        }
        int[] grayScaleImage = new int[segData.gridWidth * segData.gridHeight];
        short[] genericBAdaptiveTemplateX = new short[4];
        short[] genericBAdaptiveTemplateY = new short[4];
        genericBAdaptiveTemplateX[0] = (short)(template <= 1 ? 3 : 2);
        genericBAdaptiveTemplateY[0] = -1;
        genericBAdaptiveTemplateX[1] = -3;
        genericBAdaptiveTemplateY[1] = -1;
        genericBAdaptiveTemplateX[2] = 2;
        genericBAdaptiveTemplateY[2] = -2;
        genericBAdaptiveTemplateX[3] = -2;
        genericBAdaptiveTemplateY[3] = -2;
        for (int j = bitsPerValue - 1; j >= 0; --j) {
            JBIG2Bitmap grayBitmap = new JBIG2Bitmap(segData.gridWidth, segData.gridHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
            if (useMMR) {
                grayBitmap.readBitmapWithMMR(-1);
            } else {
                grayBitmap.readBitmap(template, false, enableSkip, skipBitmap, genericBAdaptiveTemplateX, genericBAdaptiveTemplateY);
            }
            i = 0;
            for (int row = 0; row < segData.gridHeight; ++row) {
                for (int col = 0; col < segData.gridWidth; ++col) {
                    int bit = grayBitmap.getPixel(col, row) ^ grayScaleImage[i] & 1;
                    grayScaleImage[i] = grayScaleImage[i] << 1 | bit;
                    ++i;
                }
            }
            grayBitmap.getDataWriter().clearResources();
        }
        int combinationOperator = this.halftoneRegionFlags.getFlagValue("H_COMB_OP");
        i = 0;
        for (int col = 0; col < segData.gridHeight; ++col) {
            int xx = segData.gridX + col * segData.stepY;
            int yy = segData.gridY + col * segData.stepX;
            for (int row = 0; row < segData.gridWidth; ++row) {
                if (!enableSkip || skipBitmap.getPixel(col, row) != 1) {
                    JBIG2Bitmap patternBitmap = patternDictionarySegment.getBitmaps()[grayScaleImage[i]];
                    bitmap.combine(patternBitmap, xx >> 8, yy >> 8, combinationOperator);
                }
                xx += segData.stepX;
                yy -= segData.stepY;
                ++i;
            }
        }
        if (this.inlineImage) {
            PageInformationSegment pageSegment = this.decoder.findPageSegment(this.segmentHeader.getPageAssociation());
            JBIG2Bitmap pageBitmap = pageSegment.getPageBitmap();
            int externalCombinationOperator = this.regionFlags.getFlagValue("EXTERNAL_COMBINATION_OPERATOR");
            pageBitmap.combine(bitmap, this.regionBitmapXLocation, this.regionBitmapYLocation, externalCombinationOperator);
            bitmap.getDataWriter().clearResources();
        } else {
            bitmap.setBitmapNumber(this.getSegmentHeader().getSegmentNumber());
            this.decoder.appendBitmap(bitmap);
        }
    }

    private void readHalftoneRegionFlags() {
        short halftoneRegionFlagsField = this.decoder.readByte();
        this.halftoneRegionFlags.setFlags(halftoneRegionFlagsField);
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return null;
    }

    class SegmentData {
        final int gridWidth;
        final int gridHeight;
        final int gridX;
        final int gridY;
        final int stepX;
        final int stepY;

        SegmentData(JBIG2StreamDecoder decoder) {
            short[] buf = new short[4];
            decoder.readByte(buf);
            this.gridWidth = BinaryOperation.getInt32(buf);
            buf = new short[4];
            decoder.readByte(buf);
            this.gridHeight = BinaryOperation.getInt32(buf);
            buf = new short[4];
            decoder.readByte(buf);
            this.gridX = BinaryOperation.getInt32(buf);
            buf = new short[4];
            decoder.readByte(buf);
            this.gridY = BinaryOperation.getInt32(buf);
            buf = new short[2];
            decoder.readByte(buf);
            this.stepX = BinaryOperation.getInt16(buf);
            buf = new short[2];
            decoder.readByte(buf);
            this.stepY = BinaryOperation.getInt16(buf);
        }
    }
}

