/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.objects.raw.PdfObject;

public class Stream {
    public static void readStreamData(PdfObject pdfObject, int i, byte[] raw, int length, PdfFileReader objectReader) {
        for (int xx = i; xx < length - 5 && (raw[xx] != 62 || raw[xx + 1] != 62); ++xx) {
            if (raw[xx] != 115 || raw[xx + 1] != 116 || raw[xx + 2] != 114 || raw[xx + 3] != 101 || raw[xx + 4] != 97 || raw[xx + 5] != 109) continue;
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "1. Stream found afterwards");
            }
            if (!pdfObject.isCached()) {
                Stream.readStreamIntoObject(pdfObject, xx, raw, objectReader);
            }
            xx = length;
        }
    }

    private static void readStreamIntoObject(PdfObject pdfObject, int j, byte[] data, PdfFileReader objectReader) {
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        int count = data.length;
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "Looking for stream");
        }
        byte[] stream = null;
        for (int a = j; a < count; ++a) {
            if (data[a] != 115 || data[a + 1] != 116 || data[a + 2] != 114 || data[a + 3] != 101 || data[a + 4] != 97 || data[a + 5] != 109) continue;
            a += 6;
            while (data[a] == 32) {
                ++a;
            }
            if (data[a] == 13 && data[a + 1] == 10) {
                a += 2;
            } else if (data[a] == 10 && data[a + 1] == 10 && data[a + 2] == 10 && data[a + 3] == -1) {
                a += 3;
            } else if (data[a] == 10 && data[a + 1] == 10 && data[a + 2] == -1) {
                a += 2;
            } else if (data[a] == 10 || data[a] == 13) {
                // empty if block
            }
            int start = ++a;
            --a;
            int streamLength = 0;
            int setStreamLength = pdfObject.getInt(1043816557);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "setStreamLength=" + setStreamLength);
            }
            if (setStreamLength > 0) {
                setStreamLength = Stream.validateLengthValue(count, setStreamLength, data, start);
                if (decryption != null && decryption.getBooleanValue(101)) {
                    streamLength = pdfObject.getInt(1043816557);
                } else if (setStreamLength != -1) {
                    streamLength = setStreamLength;
                }
            }
            if (setStreamLength < 1) {
                streamLength = Stream.getStreamLengthManually(data, count, a, start, streamLength, setStreamLength);
            }
            if (!(streamLength <= 1 || decryption != null && decryption.getBooleanValue(101))) {
                boolean ignoreOddCase;
                int ptr = start + streamLength - 1;
                boolean bl = ignoreOddCase = count - ptr > 4 && data[ptr] == 10 && data[ptr + 1] == 13 && data[ptr + 2] == 10 && data[ptr + 3] == 101;
                if (ptr < count && (data[ptr] == 10 && !ignoreOddCase || data[ptr] == 13 && ptr > 0 && data[ptr - 1] == 10)) {
                    --streamLength;
                }
            }
            if (start + streamLength > count) {
                streamLength = count - start;
            }
            if (streamLength < 0) {
                return;
            }
            stream = new byte[streamLength];
            System.arraycopy(data, start, stream, 0, streamLength);
            a = count;
        }
        if (ObjectDecoder.debugFastCode && stream != null) {
            System.out.println(ObjectDecoder.padding + "stream read saved into " + pdfObject);
        }
        if (pdfObject != null) {
            pdfObject.setStream(stream);
            if (pdfObject.decompressStreamWhenRead()) {
                objectReader.readStream(pdfObject, true, true, false, pdfObject.getObjectType() == 1365674082, pdfObject.isCompressedStream(), null);
            }
        }
    }

    private static int validateLengthValue(int count, int setStreamLength, byte[] data, int start) {
        boolean isValid = false;
        int a = start + setStreamLength;
        if (a < count && data[a] == 13 && a + 1 < count && data[a + 1] == 10) {
            a += 2;
        }
        if (count > a + 9 && data[a] == 101 && data[a + 1] == 110 && data[a + 2] == 100 && data[a + 3] == 115 && data[a + 4] == 116 && data[a + 5] == 114 && data[a + 6] == 101 && data[a + 7] == 97 && data[a + 8] == 109) {
            return setStreamLength;
        }
        if (count > a - 7 && data[a - 7] == 115 && data[a - 6] == 116 && data[a - 5] == 114 && data[a - 4] == 101 && data[a - 3] == 97 && data[a - 2] == 109) {
            return setStreamLength;
        }
        if (count > a - 8 && data[a - 8] == 115 && data[a - 7] == 116 && data[a - 6] == 114 && data[a - 5] == 101 && data[a - 4] == 97 && data[a - 3] == 109) {
            return setStreamLength;
        }
        int current = a;
        if (a < count) {
            while (!isValid && ++a != count) {
                if (count - a <= 9 || data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109) continue;
                setStreamLength = a - start;
                isValid = true;
            }
        }
        if (!isValid) {
            a = current;
            if (a > count) {
                a = count;
            }
            while (!isValid && --a >= 0) {
                if (data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109) continue;
                setStreamLength = a - start;
                isValid = true;
            }
        }
        if (!isValid) {
            setStreamLength = -1;
        }
        return setStreamLength;
    }

    private static int getStreamLengthManually(byte[] data, int count, int a, int start, int streamLength, int setStreamLength) {
        while (++a != count && (data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109)) {
        }
        int end = a - 1;
        if (end > start) {
            streamLength = end - start + 1;
        }
        if (setStreamLength == 0 && streamLength == 2 && data[start] == 13 && data[start + 1] == 10) {
            streamLength = 0;
        }
        return streamLength;
    }
}

