/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class Name {
    public static int setNameTreeValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        boolean isRef = false;
        while (raw[i] != 91 && raw[i] != 40) {
            if (raw[i] >= 48 && raw[i] <= 57) {
                isRef = true;
                break;
            }
            ++i;
        }
        byte[] data = raw;
        int start = i;
        int j = i;
        int count = 0;
        if (isRef) {
            int[] values = StreamReaderUtils.readRefFromStream(raw, i);
            i = values[2];
            int generation = values[1];
            int number = values[0];
            if (raw[i] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + raw[i] + " - please send to IDRsolutions for analysis");
            }
            data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
            if (data == null) {
                pdfObject.setFullyResolved(false);
                if (ObjectDecoder.debugFastCode) {
                    System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                }
                return raw.length;
            }
            j = 3;
            while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111 && data[j - 3] != 60) {
                ++j;
            }
            start = j = StreamReaderUtils.skipSpaces(data, j);
        }
        while (j < data.length) {
            if (data[j] == 91 || data[j] == 40) {
                ++count;
            } else if (data[j] == 93 || data[j] == 41) {
                --count;
            }
            if (count == 0) break;
            ++j;
        }
        byte[] newString = Name.getString(pdfObject, objectReader, data, start, j);
        pdfObject.setTextStreamValue(PDFkeyInt, newString);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "name=" + new String(newString) + " set in " + pdfObject);
        }
        if (!isRef) {
            i = j;
        }
        return i;
    }

    private static byte[] getString(PdfObject pdfObject, PdfFileReader objectReader, byte[] data, int start, int j) {
        DecryptionFactory decryption;
        int stringLength = j - start + 1;
        byte[] newString = new byte[stringLength];
        System.arraycopy(data, start, newString, 0, stringLength);
        if (pdfObject.getObjectType() != 1113489015 && (decryption = objectReader.getDecryptionObject()) != null) {
            try {
                newString = decryption.decrypt(newString, pdfObject.getObjectRefAsString(), false, null, false, false);
            }
            catch (PdfSecurityException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return newString;
    }

    public static int setNameStringValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        byte[] stringBytes;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 40 && raw[i] != 60) {
            ++i;
        }
        int j2 = i = StreamReaderUtils.skipSpaces(raw, i);
        byte[] arrayData = raw;
        boolean isIndirect = raw[i] != 47 && raw[i] != 40 && raw[i] != 60 && raw[i] >= 48 && raw[i] <= 57;
        boolean startsWithBrace = raw[i] == 40;
        boolean isInsideArray = false;
        if (isIndirect) {
            int aa = i + 1;
            if (raw[aa = StreamReaderUtils.skipSpaces(raw, aa)] == 47 || raw[aa] == 93) {
                isIndirect = false;
                i = aa + 1;
                isInsideArray = true;
            }
        }
        if (isIndirect) {
            int[] values = StreamReaderUtils.readRefFromStream(raw, i);
            int ref = values[0];
            int generation = values[1];
            i = values[2];
            if (raw[i] != 82) {
                throw new RuntimeException(ObjectDecoder.padding + "2. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            arrayData = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(ref, generation), ref, generation);
            if (arrayData == null) {
                pdfObject.setFullyResolved(false);
                if (ObjectDecoder.debugFastCode) {
                    System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                }
                return raw.length;
            }
            if (arrayData[0] == 47) {
                j2 = 0;
            } else {
                j2 = 3;
                while (arrayData[j2] != 47) {
                    ++j2;
                }
            }
        }
        if (arrayData[++j2] == 47) {
            return j2 - 1;
        }
        int end = j2 + 1;
        if (isInsideArray) {
            j2 = StreamReaderUtils.skipSpacesOrOtherCharacter(arrayData, j2, 47);
            int slashes = 0;
            int lastChar = 0;
            while (arrayData[end] != 93) {
                if (arrayData[end] == 47 && (lastChar == 32 || lastChar == 10 || lastChar == 13)) {
                    ++slashes;
                }
                lastChar = arrayData[end];
                if (++end != arrayData.length) continue;
            }
            int charCount = end - slashes;
            int ptr = 0;
            stringBytes = new byte[charCount - j2];
            int previous = 0;
            for (int ii = j2; ii < charCount; ++ii) {
                int nextChar = arrayData[ii];
                if (nextChar == 47) {
                    if (previous != 32 && previous != 10 && previous != 13) {
                        stringBytes[ptr] = 32;
                        ++ptr;
                    }
                } else {
                    stringBytes[ptr] = nextChar;
                    ++ptr;
                }
                previous = nextChar;
            }
        } else {
            while (!(!startsWithBrace ? arrayData[end] == 32 || arrayData[end] == 10 || arrayData[end] == 13 || arrayData[end] == 47 || arrayData[end] == 62 : arrayData[end] == 41 && !ObjectUtils.isEscaped(arrayData, end))) {
                if (++end != arrayData.length) continue;
            }
            int charCount = end - j2;
            stringBytes = new byte[charCount];
            System.arraycopy(arrayData, j2, stringBytes, 0, charCount);
        }
        pdfObject.setName(PDFkeyInt, stringBytes);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "String set as =" + new String(stringBytes) + "< written to " + pdfObject);
        }
        if (!isIndirect) {
            i = end - 1;
        }
        return i;
    }
}

