/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.Offsets;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class CompressedObjects {
    public static void extractCompressedObjectOffset(Map<String, String> offsetStart, Map<String, String> offsetEnd, int First2, byte[] compressedStream, int compressedID, Offsets offset) {
        String lastKey = null;
        for (int ii = 0; ii < First2; ++ii) {
            int startKey;
            if (compressedStream.length == 0 || (startKey = (ii = StreamReaderUtils.skipSpaces(compressedStream, ii))) == First2) continue;
            while (compressedStream[ii] != 32 && compressedStream[ii] != 13 && compressedStream[ii] != 10) {
                ++ii;
            }
            int endKey = ii - 1;
            int length = endKey - startKey + 1;
            String key = CompressedObjects.getString(compressedStream, startKey, length);
            int id = NumberUtils.parseInt(startKey, startKey + length, compressedStream);
            int startOff = ii = StreamReaderUtils.skipSpaces(compressedStream, ii);
            while (compressedStream[ii] != 32 && compressedStream[ii] != 13 && compressedStream[ii] != 10 && ii < First2) {
                ++ii;
            }
            int endOff = ii - 1;
            length = endOff - startOff + 1;
            String offsetRef = CompressedObjects.getString(compressedStream, startOff, length);
            if (compressedID != offset.elementAt(id)) continue;
            offsetStart.put(key, offsetRef);
            if (lastKey != null) {
                offsetEnd.put(lastKey, offsetRef);
            }
            lastKey = key;
        }
    }

    private static String getString(byte[] compressedStream, int startOff, int length) {
        char[] newCommand = new char[length];
        for (int i = 0; i < length; ++i) {
            newCommand[i] = (char)compressedStream[startOff + i];
        }
        return new String(newCommand);
    }

    public static int readCompressedOffsets(int pntr, int current, int numbEntries, int[] fieldSizes, byte[] xrefs, Offsets offset, RandomAccessBuffer pdf_datafile) throws PdfException {
        int[] defaultValue = new int[]{1, 0, 0};
        boolean hasCase0 = false;
        block7: for (int i = 0; i < numbEntries; ++i) {
            int[] nextValue = new int[3];
            for (int ii = 0; ii < 3; ++ii) {
                if (fieldSizes[ii] == 0) {
                    nextValue[ii] = defaultValue[ii];
                    continue;
                }
                nextValue[ii] = CompressedObjects.getWord(xrefs, pntr, fieldSizes[ii]);
                pntr += fieldSizes[ii];
            }
            switch (nextValue[0]) {
                case 0: {
                    ++current;
                    hasCase0 = nextValue[1] == 0 && nextValue[2] == 0;
                    continue block7;
                }
                case 1: {
                    int id = nextValue[1];
                    int gen = nextValue[2];
                    boolean refIsvalid = true;
                    if (current == id) {
                        refIsvalid = false;
                        try {
                            int ref;
                            int size = 20;
                            byte[] data = new byte[20];
                            pdf_datafile.seek(current);
                            pdf_datafile.read(data);
                            int ptr = 0;
                            for (int ii = 0; ii < 20; ++ii) {
                                if (data[ii] != 32 && data[ii] != 10 && data[ii] != 13) continue;
                                ptr = ii;
                                ii = 20;
                            }
                            if (ptr > 0 && (ref = NumberUtils.parseInt(0, ptr, data)) == current) {
                                refIsvalid = true;
                            }
                        }
                        catch (Exception ee) {
                            LogWriter.writeLog("Ref is invalid " + ee);
                        }
                    }
                    if (refIsvalid || !hasCase0) {
                        offset.storeObjectOffset(current, id, gen, false, false);
                    }
                    ++current;
                    continue block7;
                }
                case 2: {
                    int id = nextValue[1];
                    offset.storeObjectOffset(current, id, 0, true, false);
                    ++current;
                    continue block7;
                }
                default: {
                    throw new PdfException("Exception Unsupported Compression mode with value " + nextValue[0]);
                }
            }
        }
        return pntr;
    }

    private static int getWord(byte[] content, int index, int size) {
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result = (result << 8) + (content[index + i] & 0xFF);
        }
        return result;
    }
}

