/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.security;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;

public class TempStoreImage {
    public static byte[] getBytes(BufferedImage img) {
        byte[] data = new byte[img.getWidth() * img.getHeight() * 4 + 9];
        byte[] w = TempStoreImage.numToBytes(img.getWidth());
        System.arraycopy(w, 0, data, 0, 4);
        byte[] h = TempStoreImage.numToBytes(img.getHeight());
        System.arraycopy(h, 0, data, 4, 4);
        data[8] = 2;
        int p = 9;
        int pp = 0;
        int xx = img.getRaster().getSampleModelTranslateX();
        int yy = img.getRaster().getSampleModelTranslateY();
        if (xx != 0 || yy != 0) {
            for (int y = 0; y < img.getHeight(); ++y) {
                for (int x = 0; x < img.getWidth(); ++x) {
                    int v = img.getRGB(x, y);
                    data[p++] = (byte)(v >> 24 & 0xFF);
                    data[p++] = (byte)(v >> 16 & 0xFF);
                    data[p++] = (byte)(v >> 8 & 0xFF);
                    data[p++] = (byte)(v & 0xFF);
                }
            }
            return data;
        }
        switch (img.getType()) {
            case 1: {
                data = new byte[img.getWidth() * img.getHeight() * 3 + 9];
                w = TempStoreImage.numToBytes(img.getWidth());
                System.arraycopy(w, 0, data, 0, 4);
                h = TempStoreImage.numToBytes(img.getHeight());
                System.arraycopy(h, 0, data, 4, 4);
                data[8] = 1;
                int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                int dim = img.getWidth() * img.getHeight();
                for (int i = 0; i < dim; ++i) {
                    int v = pixels[i];
                    data[p++] = (byte)(v >> 16 & 0xFF);
                    data[p++] = (byte)(v >> 8 & 0xFF);
                    data[p++] = (byte)(v & 0xFF);
                }
                break;
            }
            case 2: 
            case 3: {
                int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                int ii = img.getWidth() * img.getHeight();
                for (int i = 0; i < ii; ++i) {
                    int v = pixels[i];
                    data[p++] = (byte)(v >> 24 & 0xFF);
                    data[p++] = (byte)(v >> 16 & 0xFF);
                    data[p++] = (byte)(v >> 8 & 0xFF);
                    data[p++] = (byte)(v & 0xFF);
                }
                break;
            }
            case 4: {
                int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                int ii = img.getWidth() * img.getHeight();
                for (int i = 0; i < ii; ++i) {
                    int v = pixels[i];
                    data[p++] = -1;
                    data[p++] = (byte)(v & 0xFF);
                    data[p++] = (byte)(v >> 8 & 0xFF);
                    data[p++] = (byte)(v >> 16 & 0xFF);
                }
                break;
            }
            case 5: {
                byte[] pixBytes = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                int ii = img.getWidth() * img.getHeight();
                for (int i = 0; i < ii; ++i) {
                    data[p++] = -1;
                    data[p++] = pixBytes[pp + 2];
                    data[p++] = pixBytes[pp + 1];
                    data[p++] = pixBytes[pp];
                    pp += 3;
                }
                break;
            }
            case 6: 
            case 7: {
                byte[] pixBytes = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                int ii = img.getWidth() * img.getHeight();
                for (int i = 0; i < ii; ++i) {
                    data[p++] = pixBytes[pp];
                    data[p++] = pixBytes[pp + 3];
                    data[p++] = pixBytes[pp + 2];
                    data[p++] = pixBytes[pp + 1];
                    pp += 4;
                }
                break;
            }
            default: {
                BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), 2);
                img2.getGraphics().drawImage(img, 0, 0, null);
                int[] pixels = ((DataBufferInt)img2.getRaster().getDataBuffer()).getData();
                int ii = img.getWidth() * img.getHeight();
                for (int i = 0; i < ii; ++i) {
                    int v = pixels[i];
                    data[p++] = (byte)(v >> 24 & 0xFF);
                    data[p++] = (byte)(v >> 16 & 0xFF);
                    data[p++] = (byte)(v >> 8 & 0xFF);
                    data[p++] = (byte)(v & 0xFF);
                }
            }
        }
        return data;
    }

    public static BufferedImage getImage(byte[] data) {
        int w = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        int h = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        byte type = data[8];
        if (type == 1) {
            BufferedImage img = new BufferedImage(w, h, 1);
            int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
            int p = 0;
            int pp = 9;
            int dim = w * h;
            for (int i = 0; i < dim; ++i) {
                pixels[p++] = (data[pp++] & 0xFF) << 16 | (data[pp++] & 0xFF) << 8 | data[pp++] & 0xFF;
            }
            return img;
        }
        BufferedImage img = new BufferedImage(w, h, 2);
        int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int p = 0;
        int pp = 9;
        int ii = w * h;
        for (int i = 0; i < ii; ++i) {
            pixels[p++] = (data[pp++] & 0xFF) << 24 | (data[pp++] & 0xFF) << 16 | (data[pp++] & 0xFF) << 8 | data[pp++] & 0xFF;
        }
        return img;
    }

    private static byte[] numToBytes(int num) {
        return new byte[]{(byte)(num >> 24), (byte)(num >> 16 & 0xFF), (byte)(num >> 8 & 0xFF), (byte)(num & 0xFF)};
    }
}

