/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.security;

import java.security.Key;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.security.BaseDecryption;
import org.jpedal.utils.LogWriter;

public class JCADecryption
implements BaseDecryption {
    @Override
    public byte[] v5Decrypt(byte[] rawValue, byte[] encKey) throws PdfSecurityException {
        byte[] returnKey;
        try {
            SecretKeySpec key = new SecretKeySpec(encKey, "AES");
            Cipher c = Cipher.getInstance("AES/CBC/NOPADDING");
            c.init(2, (Key)key, new IvParameterSpec(new byte[16]));
            returnKey = c.doFinal(rawValue);
        }
        catch (Exception e) {
            throw new PdfSecurityException("Exception " + e.getMessage() + " with v5 encoding");
        }
        return returnKey;
    }

    @Override
    public byte[] r6PermissionsDecoder(byte[] encryptedData, byte[] encryptionKeyBytes) throws PdfSecurityException {
        byte[] decryptedData;
        SecretKeySpec key = new SecretKeySpec(encryptionKeyBytes, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(2, key);
            decryptedData = cipher.doFinal(encryptedData);
        }
        catch (Exception e) {
            LogWriter.writeLog(e.getMessage());
            throw new PdfSecurityException("Error decrypting r6 permissions: " + e.getMessage());
        }
        return decryptedData;
    }

    @Override
    public byte[] r6Cryptographer(byte[] encryptedData, byte[] encryptionKeyBytes, byte[] iv, int encryptMode) throws PdfSecurityException {
        byte[] data;
        SecretKeySpec key = new SecretKeySpec(encryptionKeyBytes, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(encryptMode, (Key)key, ivSpec);
            data = cipher.doFinal(encryptedData);
        }
        catch (Exception e) {
            LogWriter.writeLog(e.getMessage());
            throw new PdfSecurityException("Error in r6 cryptography method: " + e.getMessage());
        }
        return data;
    }

    @Override
    public byte[] decodeAES(byte[] encKey, byte[] encData, byte[] ivData) {
        byte[] out = null;
        try {
            SecretKeySpec key = new SecretKeySpec(encKey, "AES");
            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            c.init(2, (Key)key, new IvParameterSpec(ivData));
            out = c.doFinal(encData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    @Override
    public byte[] readCertificate(byte[][] recipients, Certificate certificate, Key key) {
        String message = "This method is not supported without the BouncyCastle mail jar added to the classpath. " + System.getProperty("line.separator") + "See https://www.idrsolutions.com/jpedal/support/additional-jars/ for more details.";
        ShowGUIMessage.showGUIMessage(message, "Unsupported Certificate operation");
        throw new UnsupportedOperationException(message);
    }
}

