/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.io.filter.ccitt.CCITT1D;
import org.jpedal.io.filter.ccitt.CCITT2D;
import org.jpedal.io.filter.ccitt.CCITTMix;
import org.jpedal.objects.raw.PdfObject;

public class CCITT
extends BaseFilter
implements PdfFilter {
    private final int width;
    private final int height;

    public CCITT(PdfObject decodeParms, int width, int height) {
        super(decodeParms);
        this.width = width;
        this.height = height;
    }

    @Override
    public byte[] decode(byte[] data) {
        return this.decodeCCITT(data);
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) throws Exception {
        int size = bis.available();
        byte[] data = new byte[size];
        bis.read(data);
        data = this.decodeCCITT(data);
        streamCache.write(data);
    }

    private byte[] decodeCCITT(byte[] rawData) {
        int K2 = 0;
        if (this.decodeParms != null) {
            K2 = this.decodeParms.getInt(27);
        }
        CCITT1D ccitt = K2 == 0 ? new CCITT1D(rawData, this.width, this.height, this.decodeParms) : (K2 < 0 ? new CCITT2D(rawData, this.width, this.height, this.decodeParms) : new CCITTMix(rawData, this.width, this.height, this.decodeParms));
        byte[] data = ccitt.decode();
        return data;
    }
}

