/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoderInt;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.creation.AnnotationFactory;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.ResourcesObject;
import org.jpedal.utils.LogWriter;

public class AnnotationUtils {
    public static boolean isEditableAnnotation(FormObject form) {
        int annotType = form.getParameterConstant(1147962727);
        return annotType == 1110658926 || annotType == 1160865142 || annotType == 473513525 || annotType == 1654331 || annotType == 1230470778 || annotType == 1014528638 || annotType == 1919840408 || annotType == 980909433 || annotType == 607471684 || AnnotationUtils.isURLLink(form);
    }

    public static boolean isDraggableAnnotation(FormObject form) {
        int annotType = form.getParameterConstant(1147962727);
        return annotType == 1110658926 || annotType == 1160865142 || annotType == 473513525 || annotType == 1654331 || annotType == 1230470778 || annotType == 1014528638 || annotType == 980909433 || annotType == 607471684;
    }

    public static boolean isResizableAnnotation(FormObject form) {
        int annotType = form.getParameterConstant(1147962727);
        return annotType == 1110658926 || annotType == 1160865142 || annotType == 473513525 || annotType == 1654331 || annotType == 980909433 || annotType == 1230470778 || annotType == 1014528638;
    }

    public static boolean isURLLink(FormObject form) {
        FormObject link;
        boolean isLink = false;
        if (form != null && form.getParameterConstant(1147962727) == 473513531 && (link = (FormObject)form.getDictionary(17)) != null) {
            isLink = "URI".equals(link.getName(35));
        }
        return isLink;
    }

    public static FormObject isOverForm(PdfDecoderInt decode_pdf, int x, int y) {
        return AnnotationUtils.isOverForm(decode_pdf, x, y, 0);
    }

    public static FormObject isOverForm(PdfDecoderInt decode_pdf, int x, int y, int range) {
        List<FormObject> forms;
        List<FormObject>[] formList;
        GUIData compData;
        AcroRenderer formRenderer;
        if (decode_pdf.isOpen() && (formRenderer = decode_pdf.getFormRenderer()) != null && (compData = formRenderer.getCompData()) != null && (formList = compData.getFormList(true)) != null && decode_pdf.getPageNumber() < formList.length && (forms = formList[decode_pdf.getPageNumber()]) != null) {
            for (FormObject form : forms) {
                if (form == null) continue;
                Rectangle bounds = form.getBoundingRectangle();
                if (bounds.x - range > x || x > bounds.x + bounds.width + range || bounds.y - range > y || y > bounds.y + bounds.height + range) continue;
                return form;
            }
        }
        return null;
    }

    public static float[] validateCoordinates(float sx, float sy, float ex, float ey) {
        float[] values = new float[4];
        if (sx < ex) {
            values[0] = sx;
            values[2] = ex;
        } else {
            values[0] = ex;
            values[2] = sx;
        }
        if (sy < ey) {
            values[1] = sy;
            values[3] = ey;
        } else {
            values[1] = ey;
            values[3] = sy;
        }
        return values;
    }

    public static String getFontNameFromFormDS(FormObject form) {
        int startOfFont;
        String DSString = form.getTextStreamValue(5155);
        if (DSString != null && (startOfFont = DSString.indexOf("font:")) > -1) {
            String fontString = DSString.substring(startOfFont, DSString.indexOf(59, startOfFont + 1));
            int firstSpace = fontString.indexOf(32);
            int secondSpace = fontString.lastIndexOf(32);
            return fontString.substring(firstSpace + 1, secondSpace);
        }
        return form.getFontName();
    }

    public static String getFontHexColorFromFormDS(FormObject form) {
        int startOfFont;
        String DSString = form.getTextStreamValue(5155);
        if (DSString != null && (startOfFont = DSString.indexOf("color:")) > -1) {
            int end = DSString.indexOf(59, startOfFont + 1);
            if (end < 0) {
                end = DSString.length();
            }
            String fontString = DSString.substring(startOfFont, end);
            int firstSpace = fontString.indexOf(58);
            int last = fontString.length();
            if (fontString.endsWith(" ")) {
                --last;
            }
            return fontString.substring(firstSpace + 1, last);
        }
        return "#000000";
    }

    public static float getFontSizeFromFormDS(FormObject form) {
        int startOfFont;
        String DSString = form.getTextStreamValue(5155);
        if (DSString != null && (startOfFont = DSString.indexOf("font:")) > -1) {
            String fontString = DSString.substring(startOfFont, DSString.indexOf(59, startOfFont + 1));
            int sizeStart = fontString.lastIndexOf(32);
            String size = fontString.substring(sizeStart + 1, fontString.indexOf(112, sizeStart + 1));
            return Float.parseFloat(size);
        }
        return form.getFontSize();
    }

    public static void createAPObjectForFormObject(FormObject form, PdfObjectReader currentPdfFile) {
        switch (form.getParameterConstant(1147962727)) {
            case 980909433: {
                AnnotationUtils.createBasicAPObject(form, currentPdfFile);
                break;
            }
            case 473513525: {
                AnnotationUtils.createBasicAPObject(form, currentPdfFile);
                break;
            }
            case 1160865142: {
                AnnotationUtils.createBasicAPObject(form, currentPdfFile);
                break;
            }
            case 607471684: {
                AnnotationUtils.createTextAPObject(form, currentPdfFile);
                break;
            }
            case 1230470778: {
                AnnotationUtils.createBasicAPObject(form, currentPdfFile);
                break;
            }
            case 1014528638: {
                AnnotationUtils.createBasicAPObject(form, currentPdfFile);
                break;
            }
            case 1654331: {
                AnnotationUtils.createInkAPObject(form, currentPdfFile);
                break;
            }
            case 1110658926: {
                AnnotationUtils.createBasicAPObject(form, currentPdfFile);
                break;
            }
            case 1919840408: {
                float[] quads = form.getFloatArray(1785890247);
                if (quads == null) break;
                AnnotationUtils.createHighlightAPObject(form, currentPdfFile);
            }
        }
    }

    private static String createBasicAPObject(FormObject form, PdfObjectReader currentPdfFile) {
        String APString = AnnotationUtils.createAPStream(form);
        if (APString != null) {
            PdfObject N2;
            boolean newAP = false;
            PdfObject AP = form.getDictionary(4384);
            if (AP != null) {
                N2 = AP.getDictionary(30);
                if (N2 == null) {
                    N2 = new FormObject(30);
                    newAP = true;
                }
            } else {
                AP = new FormObject(4384);
                N2 = new FormObject(30);
            }
            float ca = form.getFloatNumber(4881);
            StringBuilder builder = new StringBuilder();
            builder.append("<<");
            if (ca != 1.0f) {
                builder.append("/ExtGState <</GS0 <</Type /ExtGState /AIS false /CA ").append(ca).append(" /ca ").append(ca).append(" >> >>");
                APString = "/GS0 gs " + APString;
            }
            if (form.getParameterConstant(1147962727) == 980909433) {
                String fontName = StandardFonts.expandName(AnnotationUtils.getFontNameFromFormDS(form));
                builder.append("/Font <</").append(fontName).append(" <</Type /Font /Subtype /Type1 /Name /").append(fontName).append(" /BaseFont /").append(fontName).append(" >> >>");
            }
            builder.append(" >>");
            ResourcesObject resources = AnnotationUtils.getResObjectFromDirect(currentPdfFile, builder.toString().getBytes());
            N2.setDictionary(2004251818, resources);
            float[] rect = form.getFloatArray(573911876);
            byte[] bytes = APString.getBytes();
            N2.setDecodedStream(bytes);
            N2.setIntNumber(1043816557, bytes.length);
            N2.setFloatArray(303185736, new float[]{0.0f, 0.0f, rect[2] - rect[0], rect[3] - rect[1]});
            if (newAP) {
                N2.setConstant(1147962727, 373244477);
                N2.setConstant(608780341, 979194486);
                N2.setIntNumber(982024818, 1);
                AP.setDictionary(30, N2);
            }
            N2.setName(1011108731, new byte[0]);
            N2.setFloatArray(1145198201, null);
            form.setDictionary(4384, AP);
        }
        return APString;
    }

    private static void createInkAPObject(FormObject form, PdfObjectReader currentPdfFile) {
        AnnotationUtils.createBasicAPObject(form, currentPdfFile);
        PdfObject AP = form.getDictionary(4384);
        PdfObject N2 = AP.getDictionary(30);
        float[] rect = form.getFloatArray(573911876);
        N2.setFloatArray(303185736, new float[]{rect[0], rect[1], rect[2], rect[3]});
        N2.setFloatArray(1145198201, new float[]{1.0f, 0.0f, 0.0f, 1.0f, -rect[0], -rect[1]});
    }

    private static void createTextAPObject(FormObject form, PdfObjectReader currentPdfFile) {
        String apStream = AnnotationUtils.createBasicAPObject(form, currentPdfFile);
        PdfObject AP = form.getDictionary(4384);
        PdfObject N2 = AP.getDictionary(30);
        float[] apSize = AnnotationUtils.getTextIconDimensions(form.getName(506543413));
        N2.setFloatArray(303185736, new float[]{0.0f, 0.0f, apSize[0], apSize[1]});
        if (apStream.contains("GS0")) {
            String sb = "<</ExtGState << /GS0 << /ca 0.6 /Type /ExtGState /CA 0.6 /AIS false /BM /Normal >> >> >>";
            ResourcesObject resources = AnnotationUtils.getResObjectFromDirect(currentPdfFile, "<</ExtGState << /GS0 << /ca 0.6 /Type /ExtGState /CA 0.6 /AIS false /BM /Normal >> >> >>".getBytes());
            N2.setDictionary(2004251818, resources);
        }
    }

    private static void createHighlightAPObject(FormObject form, PdfObjectReader currentPdfFile) {
        String apStream = AnnotationUtils.createBasicAPObject(form, currentPdfFile);
        PdfObject AP = form.getDictionary(4384);
        PdfObject N2 = AP.getDictionary(30);
        float[] rect = form.getFloatArray(573911876);
        N2.setFloatArray(303185736, new float[]{rect[0], rect[1], rect[2], rect[3]});
        N2.setFloatArray(1145198201, new float[]{1.0f, 0.0f, 0.0f, 1.0f, -rect[0], -rect[1]});
        if (apStream.contains("GS0")) {
            String sb = "<</ExtGState << /GS0 << /Type /ExtGState /AIS false /BM /Multiply >> >> >>";
            ResourcesObject resources = AnnotationUtils.getResObjectFromDirect(currentPdfFile, "<</ExtGState << /GS0 << /Type /ExtGState /AIS false /BM /Multiply >> >> >>".getBytes());
            N2.setDictionary(2004251818, resources);
        }
    }

    public static String createAPStream(FormObject form) {
        switch (form.getParameterConstant(1147962727)) {
            case 980909433: {
                return AnnotationUtils.createFreeTextAPStream(form);
            }
            case 1160865142: {
                return AnnotationUtils.createSquareAPStream(form);
            }
            case 473513525: {
                return AnnotationUtils.createLineAPStream(form);
            }
            case 607471684: {
                return AnnotationUtils.createTextAPStream(form);
            }
            case 1230470778: {
                return AnnotationUtils.createPolygonAPStream(form, true);
            }
            case 1014528638: {
                return AnnotationUtils.createPolygonAPStream(form, false);
            }
            case 1654331: {
                return AnnotationUtils.createInkAPStream(form);
            }
            case 1110658926: {
                return AnnotationUtils.createCircleAPStream(form);
            }
            case 1919840408: {
                return AnnotationUtils.createHighlightAPStream(form);
            }
        }
        return null;
    }

    private static String createCircleAPStream(FormObject form) {
        float[] rect;
        int width;
        String fillCommand;
        StringBuilder stream = new StringBuilder();
        String drawCommand = null;
        String strokeCommand = AnnotationUtils.createStrokeColorCommands(form);
        if (!strokeCommand.isEmpty()) {
            stream.append(strokeCommand);
            drawCommand = "S";
        }
        if (!(fillCommand = AnnotationUtils.createFillColorCommands(form)).isEmpty()) {
            stream.append(fillCommand);
            drawCommand = drawCommand != null ? "B" : "F";
        }
        int w = 1;
        PdfObject bs = form.getDictionary(4643);
        if (bs != null && (width = bs.getInt(39)) != -1) {
            w = width;
            stream.append(w);
            stream.append(" w\n");
        }
        if ((rect = form.getFloatArray(573911876))[0] == rect[2] && rect[1] == rect[3]) {
            stream.append(rect[0]);
            stream.append(' ');
            stream.append(rect[1]);
            stream.append(" m\n");
            stream.append(rect[0]);
            stream.append(' ');
            stream.append(rect[1]);
            stream.append(" l\n");
            stream.append(" S\n");
        } else {
            float width2 = rect[2] - rect[0] - (float)(w * 2);
            float height = rect[3] - rect[1] - (float)(w * 2);
            float longRatio = 0.777f;
            float shortRatio = 0.222f;
            stream.append(w);
            stream.append(' ');
            stream.append((float)w + height / 2.0f);
            stream.append(" m\n");
            stream.append(w);
            stream.append(' ');
            stream.append((float)w + height * 0.777f);
            stream.append(' ');
            stream.append((float)w + width2 * 0.222f);
            stream.append(' ');
            stream.append((float)w + height);
            stream.append(' ');
            stream.append((float)w + width2 / 2.0f);
            stream.append(' ');
            stream.append((float)w + height);
            stream.append(" c\n");
            stream.append((float)w + width2 * 0.777f);
            stream.append(' ');
            stream.append((float)w + height);
            stream.append(' ');
            stream.append((float)w + width2);
            stream.append(' ');
            stream.append((float)w + height * 0.777f);
            stream.append(' ');
            stream.append((float)w + width2);
            stream.append(' ');
            stream.append((float)w + height / 2.0f);
            stream.append(" c\n");
            stream.append((float)w + width2);
            stream.append(' ');
            stream.append((float)w + height * 0.222f);
            stream.append(' ');
            stream.append((float)w + width2 * 0.777f);
            stream.append(' ');
            stream.append(w);
            stream.append(' ');
            stream.append((float)w + width2 / 2.0f);
            stream.append(' ');
            stream.append(w);
            stream.append(" c\n");
            stream.append((float)w + width2 * 0.222f);
            stream.append(' ');
            stream.append(w);
            stream.append(' ');
            stream.append(w);
            stream.append(' ');
            stream.append((float)w + height * 0.222f);
            stream.append(' ');
            stream.append(w);
            stream.append(' ');
            stream.append((float)w + height / 2.0f);
            stream.append(" c\n");
            stream.append("h\n");
            stream.append(drawCommand);
        }
        return stream.toString();
    }

    private static String createSquareAPStream(FormObject form) {
        int width;
        String fillCommand;
        StringBuilder stream = new StringBuilder();
        String drawCommand = null;
        String strokeCommand = AnnotationUtils.createStrokeColorCommands(form);
        if (!strokeCommand.isEmpty()) {
            stream.append(strokeCommand);
            drawCommand = "S";
        }
        if (!(fillCommand = AnnotationUtils.createFillColorCommands(form)).isEmpty()) {
            stream.append(fillCommand);
            drawCommand = drawCommand != null ? "B" : "F";
        }
        int w = 1;
        PdfObject bs = form.getDictionary(4643);
        if (bs != null && (width = bs.getInt(39)) != -1) {
            w = width;
            stream.append(w);
            stream.append(" w\n");
        }
        float[] rect = form.getFloatArray(573911876);
        stream.append((float)(w / 2));
        stream.append(' ');
        stream.append((float)w);
        stream.append(' ');
        stream.append(rect[2] - rect[0] - (float)w);
        stream.append(' ');
        stream.append(rect[3] - rect[1] - (float)(w * 2));
        stream.append(" re\n");
        stream.append(drawCommand);
        return stream.toString();
    }

    private static String createHighlightAPStream(FormObject form) {
        StringBuilder stream = new StringBuilder();
        stream.append("/GS0 gs\n");
        float[] color = form.getFloatArray(19);
        if (color != null && color.length == 3) {
            stream.append(color[0]);
            stream.append(' ');
            stream.append(color[1]);
            stream.append(' ');
            stream.append(color[2]);
            stream.append(" rg\n");
        }
        float[] quads = form.getFloatArray(1785890247);
        float[] rect = form.getFloatArray(573911876);
        float[] modRect = new float[4];
        System.arraycopy(rect, 0, modRect, 0, 4);
        for (int i = 0; i < quads.length; i += 8) {
            float controlPointDistance = (quads[i + 1] - rect[1] - (quads[i + 7] - rect[1])) / 4.24f;
            if (modRect[0] > quads[i] - controlPointDistance) {
                modRect[0] = quads[i] - controlPointDistance;
            }
            if (modRect[2] < quads[i + 2] + controlPointDistance) {
                modRect[2] = quads[i + 2] + controlPointDistance;
            }
            stream.append((int)quads[i + 4]);
            stream.append(' ');
            stream.append((int)quads[i + 5]);
            stream.append(" m\n");
            stream.append((float)((int)quads[i + 4]) - controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i + 5]) + controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i]) - controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i + 1]) - controlPointDistance);
            stream.append(' ');
            stream.append((int)quads[i]);
            stream.append(' ');
            stream.append((int)quads[i + 1]);
            stream.append(" c\n");
            stream.append((int)quads[i + 2]);
            stream.append(' ');
            stream.append((int)quads[i + 3]);
            stream.append(" l\n");
            stream.append((float)((int)quads[i + 2]) + controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i + 3]) - controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i + 6]) + controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i + 7]) + controlPointDistance);
            stream.append(' ');
            stream.append((int)quads[i + 6]);
            stream.append(' ');
            stream.append((int)quads[i + 7]);
            stream.append(" c\n");
            stream.append("f\n");
        }
        form.setFloatArray(573911876, modRect);
        return stream.toString();
    }

    private static String createTextAPStream(FormObject form) {
        String name = form.getName(506543413);
        if (name == null || name.isEmpty()) {
            name = "Note";
        }
        return AnnotationUtils.loadApTemplate(form, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadApTemplate(FormObject form, String name) {
        StringBuilder stream = new StringBuilder();
        String iconFile = "/org/jpedal/objects/acroforms/res/" + name + ".txt";
        URL apFile = AnnotationUtils.class.getResource(iconFile);
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(apFile.openStream()));
            while ((line = in.readLine()) != null) {
                stream.append(line);
                if (line.endsWith(" ")) continue;
                stream.append(' ');
            }
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                LogWriter.writeLog(e.getMessage());
            }
        }
        String apStream = stream.toString();
        float[] color = form.getFloatArray(19);
        if (color != null && color.length == 3) {
            String colorString = color[0] + " " + color[1] + ' ' + color[2] + " rg";
            apStream = apStream.replace("1 0.819611 0 rg", colorString);
        }
        return apStream;
    }

    private static String createFreeTextAPStream(FormObject form) {
        float[] rect = form.getFloatArray(573911876);
        String bounds = "0 0 " + (rect[2] - rect[0]) + ' ' + (rect[3] - rect[1]) + " re\n";
        String fontName = StandardFonts.expandName(AnnotationUtils.getFontNameFromFormDS(form));
        float fontSize = AnnotationUtils.getFontSizeFromFormDS(form);
        String fontString = '/' + fontName + ' ' + fontSize + " Tf\n";
        Color c = Color.decode(AnnotationUtils.getFontHexColorFromFormDS(form));
        String colorString = (float)c.getRed() / 255.0f + " " + (float)c.getGreen() / 255.0f + ' ' + (float)c.getBlue() / 255.0f + " rg\n";
        String content = new String(form.getTextStreamValueAsByte(1216184967));
        String[] contentLines = content.split("\\r\\n|\\n|\\r");
        StringBuilder stream = new StringBuilder();
        stream.append("0 w\n");
        stream.append(bounds);
        stream.append("n\n");
        stream.append("q\n");
        stream.append("1 0 0 1 0 0 cm\n");
        stream.append(bounds);
        stream.append("W\n");
        stream.append("n\n");
        stream.append("0 g\n");
        stream.append("1 w\n");
        stream.append("BT\n");
        stream.append(fontString);
        stream.append(colorString);
        stream.append(0.01);
        stream.append(' ');
        stream.append(rect[3] - rect[1] - fontSize);
        stream.append(" Td\n");
        FontRenderContext fontContext = new FontRenderContext(null, true, true);
        Font font = new Font(fontName, 0, (int)fontSize);
        for (int i = 0; i != contentLines.length; ++i) {
            int lineCurrentPoint = 0;
            StringTokenizer tokens = new StringTokenizer(contentLines[i], Character.toString('\t'), true);
            if (tokens.countTokens() == 1) {
                stream.append('(');
                stream.append(contentLines[i]);
                stream.append(") Tj\n");
            } else {
                int tabWidth = 36;
                int textWidth = 0;
                while (tokens.hasMoreTokens()) {
                    String tab = tokens.nextToken();
                    if (tab.equals(Character.toString('\t'))) {
                        int nextTab = lineCurrentPoint + textWidth;
                        nextTab += 36 - nextTab % 36;
                        stream.append(nextTab - lineCurrentPoint);
                        stream.append(' ');
                        stream.append(0);
                        stream.append(" Td\n");
                        lineCurrentPoint += nextTab - lineCurrentPoint;
                        continue;
                    }
                    stream.append('(');
                    stream.append(tab);
                    stream.append(") Tj\n");
                    textWidth = (int)font.getStringBounds(tab, fontContext).getWidth();
                }
            }
            if (i == contentLines.length - 1) continue;
            stream.append(-lineCurrentPoint);
            stream.append(' ');
            stream.append(-fontSize * 1.3f);
            stream.append(" Td\n");
        }
        stream.append("ET\n");
        stream.append('Q');
        return stream.toString();
    }

    private static String createPolygonAPStream(FormObject form, boolean closeShape) {
        String fillCommand;
        int width;
        float[] coords = form.getFloatArray(1600681863);
        float[] rect = form.getFloatArray(573911876);
        int w = 1;
        PdfObject bs = form.getDictionary(4643);
        if (bs != null && (width = bs.getInt(39)) != -1) {
            w = width;
        }
        StringBuilder stream = new StringBuilder();
        String drawCommand = null;
        stream.append(w);
        stream.append(" w\n");
        String strokeCommand = AnnotationUtils.createStrokeColorCommands(form);
        if (!strokeCommand.isEmpty()) {
            stream.append(strokeCommand);
            drawCommand = "s";
        }
        if (!(fillCommand = AnnotationUtils.createFillColorCommands(form)).isEmpty()) {
            stream.append(fillCommand);
            drawCommand = drawCommand != null ? "b" : "f";
        }
        stream.append(coords[0] - rect[0]);
        stream.append(' ');
        stream.append(coords[1] - rect[1]);
        stream.append(" m\n");
        for (int i = 2; i != coords.length; i += 2) {
            stream.append(coords[i] - rect[0]);
            stream.append(' ');
            stream.append(coords[i + 1] - rect[1]);
            stream.append(" l\n");
        }
        if (closeShape) {
            stream.append("h\n");
            stream.append(drawCommand);
        } else if (drawCommand != null) {
            stream.append(drawCommand.toUpperCase());
        }
        return stream.toString();
    }

    private static String createInkAPStream(FormObject form) {
        int width;
        float[][] inkList = form.getFloat2DArray(475169151);
        int w = 1;
        PdfObject bs = form.getDictionary(4643);
        if (bs != null && (width = bs.getInt(39)) != -1) {
            w = width;
        }
        StringBuilder stream = new StringBuilder();
        stream.append(w);
        stream.append(" w\n");
        stream.append(AnnotationUtils.createStrokeColorCommands(form));
        float[] rect = form.getFloatArray(573911876);
        Rectangle2D bounds = new Rectangle2D.Float(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1]);
        for (float[] coords : inkList) {
            stream.append(coords[0]);
            stream.append(' ');
            stream.append(coords[1]);
            stream.append(" m\n");
            if (coords.length > 4) {
                coords = AnnotationFactory.createInkCurve(coords);
                CubicCurve2D.Float curve = new CubicCurve2D.Float();
                for (int i = 2; i < coords.length - 5; i += 6) {
                    stream.append(coords[i]);
                    stream.append(' ');
                    stream.append(coords[i + 1]);
                    stream.append(' ');
                    stream.append(coords[i + 2]);
                    stream.append(' ');
                    stream.append(coords[i + 3]);
                    stream.append(' ');
                    stream.append(coords[i + 4]);
                    stream.append(' ');
                    stream.append(coords[i + 5]);
                    stream.append(" c\n");
                    ((CubicCurve2D)curve).setCurve(coords[i - 2], coords[i - 1], coords[i], coords[i + 1], coords[i + 2], coords[i + 3], coords[i + 4], coords[i + 5]);
                    bounds = ((Rectangle2D)bounds).createUnion(curve.getBounds2D());
                }
                continue;
            }
            if (coords.length == 4) {
                stream.append(coords[2]);
                stream.append(' ');
                stream.append(coords[3]);
                stream.append(" l\n");
                continue;
            }
            stream.append(coords[0]);
            stream.append(' ');
            stream.append(coords[1]);
            stream.append(" l\n");
        }
        stream.append("S\n");
        form.setFloatArray(573911876, AnnotationUtils.validateCoordinates((float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getMaxX(), (float)bounds.getMaxY()));
        return stream.toString();
    }

    private static String createLineAPStream(FormObject form) {
        int width;
        StringBuilder stream = new StringBuilder();
        float[] coords = form.getFloatArray(28);
        float[] rect = form.getFloatArray(573911876);
        String coordString = coords[0] - rect[0] + " " + (coords[1] - rect[1]) + " m\n" + (coords[2] - rect[0]) + ' ' + (coords[3] - rect[1]) + " l\n";
        int w = 1;
        PdfObject bs = form.getDictionary(4643);
        if (bs != null && (width = bs.getInt(39)) != -1) {
            w = width;
        }
        String widthString = w + " w\n";
        stream.append(widthString);
        stream.append(AnnotationUtils.createStrokeColorCommands(form));
        stream.append(coordString);
        stream.append('S');
        return stream.toString();
    }

    private static ResourcesObject getResObjectFromDirect(PdfObjectReader currentPdfFile, byte[] data) {
        ResourcesObject resObj = new ResourcesObject(new String(data));
        resObj.setStatus(2);
        resObj.setUnresolvedData(data, 2004251818);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
        objectDecoder.checkResolved(resObj);
        return resObj;
    }

    public static float[] getTextIconDimensions(String name) {
        if (name == null || name.isEmpty()) {
            name = "Note";
        }
        if (name.equals("Comment")) {
            return new float[]{18.0f, 18.0f};
        }
        if (name.equals("Check")) {
            return new float[]{19.0f, 19.0f};
        }
        if (name.equals("Checkmark")) {
            return new float[]{20.0f, 20.0f};
        }
        if (name.equals("Circle")) {
            return new float[]{20.0f, 20.0f};
        }
        if (name.equals("Cross")) {
            return new float[]{19.0f, 19.0f};
        }
        if (name.equals("CrossHairs")) {
            return new float[]{20.0f, 20.0f};
        }
        if (name.equals("Help")) {
            return new float[]{20.0f, 20.0f};
        }
        if (name.equals("Insert")) {
            return new float[]{17.0f, 20.0f};
        }
        if (name.equals("Key")) {
            return new float[]{13.0f, 18.0f};
        }
        if (name.equals("NewParagraph")) {
            return new float[]{13.0f, 20.0f};
        }
        if (name.equals("Paragraph")) {
            return new float[]{20.0f, 20.0f};
        }
        if (name.equals("RightArrow")) {
            return new float[]{20.0f, 20.0f};
        }
        if (name.equals("RightPointer")) {
            return new float[]{20.0f, 17.0f};
        }
        if (name.equals("Star")) {
            return new float[]{20.0f, 19.0f};
        }
        if (name.equals("UpLeftArrow")) {
            return new float[]{17.0f, 17.0f};
        }
        if (name.equals("UpArrow")) {
            return new float[]{17.0f, 20.0f};
        }
        return new float[]{18.0f, 20.0f};
    }

    private static String createStrokeColorCommands(FormObject form) {
        StringBuilder stream = new StringBuilder();
        float[] stroke = form.getFloatArray(19);
        if (stroke != null && stroke.length == 3) {
            stream.append(stroke[0]);
            stream.append(' ');
            stream.append(stroke[1]);
            stream.append(' ');
            stream.append(stroke[2]);
            stream.append(" RG\n");
        }
        return stream.toString();
    }

    private static String createFillColorCommands(FormObject form) {
        StringBuilder stream = new StringBuilder();
        float[] fill = form.getFloatArray(6419);
        if (fill != null && fill.length == 3) {
            stream.append(fill[0]);
            stream.append(' ');
            stream.append(fill[1]);
            stream.append(' ');
            stream.append(fill[2]);
            stream.append(" rg\n");
        }
        return stream.toString();
    }
}

