/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import org.jpedal.exception.PdfException;
import org.jpedal.grouping.GroupingUtils;
import org.jpedal.grouping.PdfTextExtractionUtils;
import org.jpedal.objects.PdfData;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;

class PdfTextInRectangle
extends PdfTextExtractionUtils {
    PdfTextInRectangle(PdfData pdf_data, boolean isXMLExtraction) {
        super(pdf_data, isXMLExtraction);
    }

    final String extractTextInRectangle(int x1, int y1, int x2, int y2, boolean estimateParagraphs, boolean breakFragments) throws PdfException {
        this.reset();
        if (breakFragments && !this.pdf_data.IsEmbedded()) {
            throw new PdfException("[PDF] Request to breakfragments and width not added. Please add call to init(true) of PdfDecoder to your code.");
        }
        int[] v = GroupingUtils.validateCoordinates(x1, y1, x2, y2);
        x1 = v[0];
        y1 = v[1];
        x2 = v[2];
        y2 = v[3];
        if (breakFragments) {
            this.copyToArrays(x1, y2, x2, y1, this.isXMLExtraction, false, null, false);
        } else {
            this.copyToArrays();
        }
        GroupingUtils.removeEncoding(this.isUsed, this.content);
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        int count = items.length;
        if (count == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int currentWritingMode = this.getWritingMode(items, count);
        this.createLines(count, items, currentWritingMode, false, this.isXMLExtraction);
        int[] indices = new int[4];
        int masterIndex = -1;
        for (int mode = 0; mode != indices.length; ++mode) {
            indices[mode] = this.mergeLinesTogether(mode, estimateParagraphs, x1, x2, y1, y2);
            if (indices[mode] == -1) continue;
            if (this.isXMLExtraction) {
                this.content[indices[mode]] = new StringBuilder(Fonts.cleanupTokens(this.content[indices[mode]].toString()));
                this.content[indices[mode]].insert(0, "<p>");
                this.content[indices[mode]].append("</p>");
            }
            if (masterIndex != -1) {
                this.merge(masterIndex, indices[mode], "\n", false);
                continue;
            }
            masterIndex = indices[mode];
        }
        LogWriter.writeLog("Text extraction completed");
        if (this.isXMLExtraction) {
            return GroupingUtils.cleanup(this.content[masterIndex]).toString();
        }
        return this.content[masterIndex].toString();
    }

    private void reset() {
        this.nextSlot = 0;
        this.master = 0;
        this.colorExtracted = false;
    }

    private int mergeLinesTogether(int currentWritingMode, boolean estimateParagraphs, int x1, int x2, int y1, int y2) throws PdfException {
        int middlePage;
        int[] indices;
        float[] l_y2;
        float[] l_y1;
        float[] l_x2;
        float[] l_x1;
        switch (currentWritingMode) {
            case 0: {
                l_x1 = this.f_x1;
                l_x2 = this.f_x2;
                l_y1 = this.f_y1;
                l_y2 = this.f_y2;
                indices = this.getsortedUnusedFragments(false, true);
                middlePage = (x1 + x2) / 2;
                break;
            }
            case 1: {
                l_x2 = this.f_x1;
                l_x1 = this.f_x2;
                l_y1 = this.f_y1;
                l_y2 = this.f_y2;
                indices = this.getsortedUnusedFragments(false, true);
                middlePage = (x1 + x2) / 2;
                break;
            }
            case 3: {
                l_x1 = this.f_y1;
                l_x2 = this.f_y2;
                l_y1 = this.f_x2;
                l_y2 = this.f_x1;
                indices = this.getsortedUnusedFragments(true, true);
                indices = GroupingUtils.reverse(indices);
                middlePage = (y1 + y2) / 2;
                break;
            }
            case 2: {
                l_x1 = this.f_y2;
                l_x2 = this.f_y1;
                l_y2 = this.f_x2;
                l_y1 = this.f_x1;
                indices = this.getsortedUnusedFragments(true, true);
                middlePage = (y1 + y2) / 2;
                break;
            }
            default: {
                throw new PdfException("Illegal value " + currentWritingMode + "for currentWritingMode");
            }
        }
        int quarter = middlePage / 2;
        int count = indices.length;
        int check = indices.length - 1;
        int masterIndex = indices[count - 1];
        while (this.writingMode[masterIndex] != currentWritingMode) {
            masterIndex = indices[check];
            if (--check >= 0) continue;
            return -1;
        }
        for (int i = count - 1; i > -1; --i) {
            int child = indices[i];
            StringBuilder separator = new StringBuilder();
            int ClastChar = GroupingUtils.getLastChar(this.content[child], this.isXMLExtraction);
            if (ClastChar == -1 || this.writingMode[child] != this.writingMode[masterIndex] || child == masterIndex) continue;
            this.addAlignmentFormatting(estimateParagraphs, middlePage, l_x1, l_x2, quarter, child);
            String lineSpace = "</p>" + SYSTEM_LINE_SEPARATOR + "<p>";
            if (this.isXMLExtraction) {
                lineSpace = SYSTEM_LINE_SEPARATOR;
            }
            float gap = l_y2[masterIndex] - l_y1[child];
            float line_height = l_y1[child] - l_y2[child];
            if (line_height <= 1.0f) {
                line_height = l_y1[masterIndex] - l_y2[masterIndex];
            }
            if (currentWritingMode == 3) {
                gap = -gap;
                line_height = -line_height;
            }
            if (gap > line_height && line_height > 0.0f) {
                while (gap > line_height) {
                    separator.append(lineSpace);
                    gap -= line_height;
                }
                if (this.isXMLExtraction) {
                    separator.append("</p>").append(SYSTEM_LINE_SEPARATOR).append("<p>");
                } else {
                    separator = new StringBuilder(SYSTEM_LINE_SEPARATOR);
                }
            } else if (estimateParagraphs) {
                int CFirstChar = GroupingUtils.getFirstChar(this.content[child], this.isXMLExtraction);
                int MlastChar = GroupingUtils.getLastChar(this.content[masterIndex], this.isXMLExtraction);
                if ((MlastChar == 46 || MlastChar == 34) && CFirstChar >= 65 && CFirstChar <= 90) {
                    if (this.isXMLExtraction) {
                        separator.append("</p>").append(SYSTEM_LINE_SEPARATOR).append("<p>");
                    } else {
                        separator = new StringBuilder(SYSTEM_LINE_SEPARATOR);
                    }
                } else if (this.fontSize[child] > 70 && this.fontSize[child] == this.fontSize[masterIndex] && line_height > 70.0f && gap > 5.0f && line_height > 0.0f) {
                    if (this.isXMLExtraction) {
                        this.content[child].insert(0, ' ');
                    } else {
                        this.content[masterIndex].append(' ');
                    }
                }
            } else if (this.isXMLExtraction) {
                this.content[child].insert(0, "</p>" + SYSTEM_LINE_SEPARATOR + "<p>");
            } else {
                this.content[masterIndex].append(SYSTEM_LINE_SEPARATOR);
            }
            this.merge(masterIndex, child, separator.toString(), false);
        }
        return masterIndex;
    }

    private void addAlignmentFormatting(boolean estimateParagraphs, int middlePage, float[] f_x1, float[] f_x2, int quarter, int child) {
        float left_gap = (float)middlePage - f_x1[child];
        float right_gap = f_x2[child] - (float)middlePage;
        if (!estimateParagraphs && this.isXMLExtraction && left_gap > 0.0f && right_gap > 0.0f && f_x1[child] > (float)quarter && f_x1[child] < (float)(middlePage + quarter)) {
            float ratio = left_gap / right_gap;
            if (ratio > 1.0f) {
                ratio = 1.0f / ratio;
            }
            if ((double)ratio > 0.95) {
                this.content[child] = new StringBuilder(Fonts.cleanupTokens(this.content[child].toString()));
                this.content[child].insert(0, "<center>");
                this.content[child].append("</center>\n");
            } else if (right_gap < 10.0f & left_gap > 30.0f) {
                this.content[child] = new StringBuilder(Fonts.cleanupTokens(this.content[child].toString()));
                this.content[child].insert(0, "<right>");
                this.content[child].append("</right>\n");
            }
        }
    }
}

