/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import org.jpedal.exception.PdfException;
import org.jpedal.grouping.Fragment;
import org.jpedal.grouping.GroupingUtils;
import org.jpedal.grouping.LineData;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfData;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;

abstract class PdfTextExtractionUtils {
    static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    boolean[] isUsed;
    float[] f_x1;
    float[] f_x2;
    float[] f_y1;
    float[] f_y2;
    private boolean[] hadSpace;
    String[] f_colorTag;
    protected int[] writingMode;
    int[] fontSize;
    private float[] spaceWidth;
    StringBuilder[] content;
    private int[] textLength;
    final PdfData pdf_data;
    int nextSlot;
    int master;
    boolean colorExtracted;
    private static final int CONTENT_ARRAY_INCREMENT = 100;
    final boolean isXMLExtraction;

    PdfTextExtractionUtils(PdfData pdf_data, boolean isXMLExtraction) {
        this.pdf_data = pdf_data;
        this.isXMLExtraction = isXMLExtraction;
        this.colorExtracted = pdf_data.isColorExtracted();
    }

    void cleanupShadowsAndDrownedObjects(boolean avoidSpaces) {
        int[] items = GroupingUtils.getUnusedFragments(this.isUsed);
        int count = items.length;
        for (int p = 0; p < count; ++p) {
            int c = items[p];
            if (this.isUsed[c]) continue;
            float midX = (this.f_x1[c] + this.f_x2[c]) / 2.0f;
            float midY = (this.f_y1[c] + this.f_y2[c]) / 2.0f;
            for (int p2 = p + 1; p2 < count; ++p2) {
                String separator;
                boolean b_in_a;
                float diff;
                int n = items[p2];
                if (this.f_x1[n] == this.f_x2[n] || this.isUsed[n] || this.isUsed[c]) continue;
                float fontDiff = this.fontSize[n] - this.fontSize[c];
                if (fontDiff < 0.0f) {
                    fontDiff = -fontDiff;
                }
                if ((diff = this.f_x2[n] - this.f_x1[n] - (this.f_x2[c] - this.f_x1[c])) < 0.0f) {
                    diff = -diff;
                }
                if (fontDiff == 0.0f && midX > this.f_x1[n] && midX < this.f_x2[n] && diff < 10.0f && midY < this.f_y1[n] && midY > this.f_y2[n]) {
                    String contentForC;
                    if (avoidSpaces) {
                        this.isUsed[n] = true;
                        continue;
                    }
                    String contentForN = Strip.stripXML(GroupingUtils.removeHiddenMarkers(this.content[n]), true).toString();
                    if (!contentForN.equals(contentForC = Strip.stripXML(GroupingUtils.removeHiddenMarkers(this.content[c]), true).toString())) continue;
                    this.isUsed[n] = true;
                    continue;
                }
                boolean a_in_b = this.f_x1[n] > this.f_x1[c] && this.f_x2[n] < this.f_x2[c] && this.f_y1[n] < this.f_y1[c] && this.f_y2[n] > this.f_y2[c];
                boolean bl = b_in_a = this.f_x1[c] > this.f_x1[n] && this.f_x2[c] < this.f_x2[n] && this.f_y1[c] < this.f_y1[n] && this.f_y2[c] > this.f_y2[n];
                if (!a_in_b && !b_in_a) continue;
                if (this.f_y2[c] > this.f_y2[n]) {
                    separator = GroupingUtils.getLineDownSeparator(this.content[c], this.content[n], this.isXMLExtraction);
                    if (!avoidSpaces || separator.indexOf(32) == -1) {
                        this.merge(c, n, separator, true);
                    }
                } else {
                    separator = GroupingUtils.getLineDownSeparator(this.content[n], this.content[c], this.isXMLExtraction);
                    if (!avoidSpaces || separator.indexOf(32) == -1) {
                        this.merge(n, c, separator, true);
                    }
                }
                midX = (this.f_x1[c] + this.f_x2[c]) / 2.0f;
                midY = (this.f_y1[c] + this.f_y2[c]) / 2.0f;
            }
        }
    }

    private String isGapASpace(int c, int l, float actualGap, boolean addMultiplespaceXMLTag, int writingMode) {
        int spaceCount;
        String sep = "";
        float gapA = this.spaceWidth[c] * (float)this.fontSize[c];
        float gapB = this.spaceWidth[l] * (float)this.fontSize[l];
        float gap = gapA > gapB ? gapB : gapA;
        if ((gap = actualGap / (gap / 1000.0f)) > 0.51f && gap < 1.0f) {
            gap = 1.0f;
        }
        if ((spaceCount = (int)gap) > 0) {
            sep = " ";
        }
        if (spaceCount > 1 && addMultiplespaceXMLTag && writingMode == 0) {
            sep = " <SpaceCount space=\"" + spaceCount + "\" />";
        }
        return sep;
    }

    void merge(int m, int c, String separator, boolean moveFont) {
        if (this.f_x1[m] > this.f_x1[c]) {
            this.f_x1[m] = this.f_x1[c];
        }
        if (this.f_y1[m] < this.f_y1[c]) {
            this.f_y1[m] = this.f_y1[c];
        }
        if (this.f_x2[m] < this.f_x2[c]) {
            this.f_x2[m] = this.f_x2[c];
        }
        if (this.f_y2[m] > this.f_y2[c]) {
            this.f_y2[m] = this.f_y2[c];
        }
        if (this.isXMLExtraction) {
            String test = "</font>";
            if (this.colorExtracted) {
                test = "</font></color>";
            }
            if (moveFont && this.content[m].toString().lastIndexOf(test) != -1) {
                String masterContent = this.content[m].toString();
                this.content[m] = new StringBuilder(masterContent.substring(0, masterContent.lastIndexOf(test)));
                this.content[m].append(separator);
                this.content[m].append(masterContent.substring(masterContent.lastIndexOf(test)));
            } else {
                this.content[m].append(separator);
            }
            if (this.textLength[c] > 1 && this.content[m].toString().endsWith(" ")) {
                this.content[m].deleteCharAt(this.content[m].lastIndexOf(" "));
            }
            if (this.content[c].indexOf("<color") != -1 && this.content[m].indexOf("<color") != -1 && this.content[c].toString().startsWith(this.content[m].substring(this.content[m].lastIndexOf("<color"), this.content[m].indexOf(">", this.content[m].lastIndexOf("<color")))) && this.content[m].lastIndexOf("</color>") + 7 == this.content[m].lastIndexOf(">")) {
                this.content[c].replace(this.content[c].indexOf("<color"), this.content[c].indexOf(">") + 1, "");
                this.content[m].replace(this.content[m].lastIndexOf("</color>"), this.content[m].lastIndexOf("</color>") + 8, "");
            }
            if (this.content[c].indexOf("<font") != -1 && this.content[m].indexOf("<font") != -1 && this.content[c].toString().startsWith(this.content[m].substring(this.content[m].lastIndexOf("<font"), this.content[m].indexOf(">", this.content[m].lastIndexOf("<font")))) && this.content[m].lastIndexOf("</font>") + 6 == this.content[m].lastIndexOf(">")) {
                this.content[c].replace(this.content[c].indexOf("<font"), this.content[c].indexOf(">") + 1, "");
                this.content[m].replace(this.content[m].lastIndexOf("</font>"), this.content[m].lastIndexOf("</font>") + 7, "");
            }
            this.content[m] = this.content[m].append((CharSequence)this.content[c]);
        } else {
            this.content[m] = this.content[m].append(separator).append((CharSequence)this.content[c]);
        }
        int n = m;
        this.textLength[n] = this.textLength[n] + this.textLength[c];
        this.isUsed[c] = true;
        this.content[c] = null;
    }

    void copyToArrays() {
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int count = this.pdf_data.getRawTextElementCount();
        this.isUsed = new boolean[count];
        this.fontSize = new int[count];
        this.writingMode = new int[count];
        this.spaceWidth = new float[count];
        this.content = new StringBuilder[count];
        this.textLength = new int[count];
        this.f_x1 = new float[count];
        this.f_colorTag = new String[count];
        this.f_x2 = new float[count];
        this.f_y1 = new float[count];
        this.f_y2 = new float[count];
        for (int i = 0; i < count; ++i) {
            this.content[i] = new StringBuilder(this.pdf_data.contents[i]);
            this.fontSize[i] = this.pdf_data.f_end_font_size[i];
            this.writingMode[i] = this.pdf_data.f_writingMode[i];
            this.f_x1[i] = this.pdf_data.f_x1[i];
            this.f_colorTag[i] = this.pdf_data.colorTag[i];
            this.f_x2[i] = this.pdf_data.f_x2[i];
            this.f_y1[i] = this.pdf_data.f_y1[i];
            this.f_y2[i] = this.pdf_data.f_y2[i];
            this.spaceWidth[i] = this.pdf_data.space_width[i];
            this.textLength[i] = this.pdf_data.text_length[i];
        }
    }

    void copyToArrays(float minX, float minY, float maxX, float maxY, boolean keepFont, boolean breakOnSpace, String punctuation, boolean isWordlist) {
        int count = this.pdf_data.getRawTextElementCount();
        this.initArrays(count + 100);
        for (int i = 0; i < count; ++i) {
            Fragment fragment = new Fragment(this.pdf_data, i);
            if (!GroupingUtils.isFragmentWithinArea(fragment, minX, minY, maxX, maxY)) continue;
            this.processFragment(minX, minY, maxX, maxY, keepFont, breakOnSpace, punctuation, isWordlist, fragment, i);
        }
        this.isUsed = new boolean[this.nextSlot];
    }

    private void processFragment(float minX, float minY, float maxX, float maxY, boolean keepFont, boolean breakOnSpace, String punctuation, boolean isWordlist, Fragment fragment, int i) {
        StringBuilder text = new StringBuilder();
        fragment.init(minX, minY, maxX, maxY);
        char[] line = fragment.getRawData().toCharArray();
        int end = line.length;
        int pointer = 0;
        if (!fragment.getRawData().contains(PdfData.marker)) {
            text = new StringBuilder(fragment.getRawData());
        }
        boolean isFirstValue = true;
        boolean breakPointset = false;
        while (pointer < end) {
            boolean endsWithPunctuation;
            do {
                if (line[pointer] != PdfGroupingAlgorithms.MARKER2) {
                    pointer = fragment.getValue(pointer, end);
                } else {
                    pointer = fragment.getPtReached(pointer, end);
                    pointer = fragment.getCharWidth(pointer, end);
                    pointer = fragment.getValue(pointer, end);
                    fragment.textValue = fragment.value;
                    if (!fragment.pt_reached.isEmpty()) {
                        float nextPt = Float.parseFloat(fragment.pt_reached);
                        fragment.updatePoints(nextPt);
                        if (breakPointset) {
                            fragment.alterCoordsBasedOnWritingMode(nextPt);
                            breakPointset = false;
                        }
                    }
                    if (this.isXMLExtraction) {
                        fragment.addXMLTag();
                    }
                }
                if (fragment.isValid()) {
                    fragment.setFragmentCoord();
                    break;
                }
                fragment.reset();
            } while (pointer < end);
            if (isFirstValue) {
                isFirstValue = false;
                if (this.isXMLExtraction && keepFont && !fragment.value.startsWith("<font ") && !fragment.value.startsWith("<color ")) {
                    text.append(Fonts.getActiveFontTag(text.toString(), fragment.getRawData()));
                }
            }
            if ((endsWithPunctuation = GroupingUtils.checkForPunctuation(fragment.textValue, punctuation)) || fragment.isSpace(breakOnSpace)) {
                this.writeOut(keepFont, isWordlist, text, fragment, i, endsWithPunctuation);
                if (!fragment.char_width.isEmpty()) {
                    breakPointset = GroupingUtils.handleSpaces(isWordlist, fragment);
                }
                if (breakOnSpace && this.nextSlot > 0) {
                    this.hadSpace[this.nextSlot - 1] = true;
                }
                text = new StringBuilder(Fonts.getActiveFontTag(text.toString(), fragment.getRawData()));
                fragment.alterCoordsBasedOnWritingMode(fragment.pt);
                continue;
            }
            if (this.isXMLExtraction && fragment.value.endsWith(" </font>")) {
                fragment.value = "</font>";
                fragment.textValue = "";
                fragment.alterCoordsBasedOnWritingMode(fragment.last_pt);
            }
            text.append(fragment.value);
        }
        if (keepFont && this.isXMLExtraction && !text.toString().endsWith("</font>") && !text.toString().endsWith("</color>")) {
            text.append("</font>");
        }
        this.completeLine(keepFont, isWordlist, text, fragment, i);
    }

    private void completeLine(boolean keepFont, boolean isWordlist, StringBuilder text, Fragment fragment, int i) {
        if (fragment.getWritingMode() == 0 || fragment.getWritingMode() == 1) {
            if (fragment.getX1() < fragment.getX2()) {
                this.addFragment(i, text, fragment.getX1(), fragment.getX2(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
            } else {
                this.addFragment(i, text, fragment.getX2(), fragment.getX1(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
            }
        } else if ((fragment.getWritingMode() == 3 || fragment.getWritingMode() == 2) && fragment.getY1() > fragment.getY2()) {
            this.addFragment(i, text, fragment.getX1(), fragment.getX2(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
        }
    }

    private void writeOut(boolean keepFont, boolean isWordlist, StringBuilder text, Fragment fragment, int i, boolean endsWithPunctuation) {
        int ptr;
        float pt = fragment.pt;
        String textValue = fragment.textValue;
        if (textValue.length() > 1 && textValue.indexOf(32) != -1 && (ptr = textValue.indexOf(32)) > 0) {
            String char_width = fragment.char_width;
            pt = textValue.length() == 2 ? (float)((double)pt + (double)Float.parseFloat(char_width) * 0.7) : (pt += (float)ptr * (Float.parseFloat(char_width) / (float)textValue.length()));
        }
        if (!endsWithPunctuation) {
            text.append(fragment.value.trim());
        }
        switch (fragment.getWritingMode()) {
            case 0: {
                this.addFragment(i, text, fragment.getX1(), pt, fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
                break;
            }
            case 1: {
                this.addFragment(i, text, pt, fragment.getX2(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
                break;
            }
            case 3: {
                this.addFragment(i, text, fragment.getX1(), fragment.getX2(), pt, fragment.getY2(), keepFont, fragment, isWordlist);
                break;
            }
            case 2: {
                this.addFragment(i, text, fragment.getX1(), fragment.getX2(), fragment.getY1(), pt, keepFont, fragment, isWordlist);
                break;
            }
        }
        fragment.pt = pt;
    }

    private void initArrays(int count) {
        this.f_x1 = new float[count];
        this.f_colorTag = new String[count];
        this.hadSpace = new boolean[count];
        this.f_x2 = new float[count];
        this.f_y1 = new float[count];
        this.f_y2 = new float[count];
        this.spaceWidth = new float[count];
        this.content = new StringBuilder[count];
        this.fontSize = new int[count];
        this.textLength = new int[count];
        this.writingMode = new int[count];
        this.isUsed = new boolean[count];
    }

    private void addFragment(int index, StringBuilder contentss, float x1, float x2, float y1, float y2, boolean keepFontTokens, Fragment fragment, boolean isWordlist) {
        StringBuilder current_text = contentss;
        String str = current_text.toString();
        int text_len = fragment.getTextLength();
        String currentColorTag = fragment.getColorTag();
        if (isWordlist) {
            if (str.contains("&#")) {
                current_text = Strip.stripAmpHash(current_text);
            }
            if (this.isXMLExtraction && (str.contains("&lt;") || str.contains("&gt;"))) {
                current_text = Strip.stripXMLArrows(current_text, true);
            } else if (!(this.isXMLExtraction || str.indexOf(60) == -1 && str.indexOf(62) == -1)) {
                current_text = Strip.stripArrows(current_text);
            }
        }
        if (GroupingUtils.getFirstChar(current_text, this.isXMLExtraction) != -1) {
            if (!keepFontTokens) {
                current_text = Strip.stripXML(current_text, this.isXMLExtraction);
            } else if (this.isXMLExtraction) {
                if (this.pdf_data.isColorExtracted() && !current_text.toString().endsWith("</color>")) {
                    if (!current_text.toString().endsWith("</font>")) {
                        current_text = current_text.append("</font>");
                    }
                    current_text = current_text.append("</color>");
                } else if (!this.pdf_data.isColorExtracted() && !current_text.toString().endsWith("</font>")) {
                    current_text = current_text.append("</font>");
                }
            }
            int count = this.f_x1.length;
            if (this.nextSlot < count) {
                this.f_x1[this.nextSlot] = x1;
                this.f_colorTag[this.nextSlot] = currentColorTag;
                this.f_x2[this.nextSlot] = x2;
                this.f_y1[this.nextSlot] = y1;
                this.f_y2[this.nextSlot] = y2;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[index];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[index];
                this.textLength[this.nextSlot] = text_len;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[index];
                this.content[this.nextSlot] = current_text;
                ++this.nextSlot;
            } else {
                float[] t_x1 = new float[count += 100];
                String[] t_colorTag = new String[count];
                float[] t_x2 = new float[count];
                float[] t_y1 = new float[count];
                float[] t_y2 = new float[count];
                float[] t_spaceWidth = new float[count];
                StringBuilder[] t_content = new StringBuilder[count];
                int[] t_font_size = new int[count];
                int[] t_text_len = new int[count];
                int[] t_writingMode = new int[count];
                boolean[] t_isUsed = new boolean[count];
                boolean[] t_hadSpace = new boolean[count];
                for (int i = 0; i < count - 100; ++i) {
                    t_x1[i] = this.f_x1[i];
                    t_colorTag[i] = this.f_colorTag[i];
                    t_x2[i] = this.f_x2[i];
                    t_y1[i] = this.f_y1[i];
                    t_y2[i] = this.f_y2[i];
                    t_hadSpace[i] = this.hadSpace[i];
                    t_spaceWidth[i] = this.spaceWidth[i];
                    t_content[i] = this.content[i];
                    t_font_size[i] = this.fontSize[i];
                    t_writingMode[i] = this.writingMode[i];
                    t_text_len[i] = this.textLength[i];
                    t_isUsed[i] = this.isUsed[i];
                }
                this.f_x1 = t_x1;
                this.f_colorTag = t_colorTag;
                this.hadSpace = t_hadSpace;
                this.f_x2 = t_x2;
                this.f_y1 = t_y1;
                this.f_y2 = t_y2;
                this.isUsed = t_isUsed;
                this.fontSize = t_font_size;
                this.writingMode = t_writingMode;
                this.textLength = t_text_len;
                this.spaceWidth = t_spaceWidth;
                this.content = t_content;
                this.f_x1[this.nextSlot] = x1;
                this.f_colorTag[this.nextSlot] = currentColorTag;
                this.f_x2[this.nextSlot] = x2;
                this.f_y1[this.nextSlot] = y1;
                this.f_y2[this.nextSlot] = y2;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[index];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[index];
                t_text_len[this.nextSlot] = text_len;
                this.content[this.nextSlot] = current_text;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[index];
                ++this.nextSlot;
            }
        }
    }

    int[] getsortedUnusedFragments(boolean sortOnX, boolean use_y1) {
        int total_fragments = this.isUsed.length;
        int ii = 0;
        int[] sorted_temp_index = new int[total_fragments];
        for (int i = 0; i < total_fragments; ++i) {
            if (this.isUsed[i]) continue;
            sorted_temp_index[ii] = i;
            ++ii;
        }
        int[] unsorted_items = new int[ii];
        int[] sorted_temp_x1 = new int[ii];
        int[] sorted_temp_y1 = new int[ii];
        int[] sorted_temp_y2 = new int[ii];
        for (int pointer = 0; pointer < ii; ++pointer) {
            int i;
            unsorted_items[pointer] = i = sorted_temp_index[pointer];
            sorted_temp_x1[pointer] = (int)this.f_x1[i];
            sorted_temp_y1[pointer] = (int)this.f_y1[i];
            sorted_temp_y2[pointer] = (int)this.f_y2[i];
        }
        int[] sorted_items = !sortOnX ? (use_y1 ? Sorts.quicksort(sorted_temp_y1, sorted_temp_x1, unsorted_items) : Sorts.quicksort(sorted_temp_y2, sorted_temp_x1, unsorted_items)) : Sorts.quicksort(sorted_temp_x1, sorted_temp_y1, unsorted_items);
        return sorted_items;
    }

    int getWritingMode(int[] items, int count) {
        int[] counts = new int[4];
        for (int j = 0; j < count; ++j) {
            int c = items[j];
            if (this.isUsed[c]) continue;
            int n = this.writingMode[c];
            counts[n] = counts[n] + 1;
        }
        int mode = 0;
        for (int i = 1; i != counts.length; ++i) {
            if (counts[i] <= counts[mode]) continue;
            mode = i;
        }
        return mode;
    }

    void createLines(int count, int[] items, int mode, boolean breakOnSpace, boolean addMultiplespaceXMLTag) throws PdfException {
        LineData data = new LineData(this.f_x1, this.f_x2, this.f_y1, this.f_y2, mode);
        if (mode == 1 || mode == 2) {
            items = GroupingUtils.reverse(items);
        }
        block0: for (int j = 0; j < count; ++j) {
            int id = -1;
            int c = items[j];
            float smallest_gap = -1.0f;
            if (!breakOnSpace) {
                smallest_gap = -(this.fontSize[c] / 2 + 1);
            }
            if (this.isUsed[c] || this.writingMode[c] != mode) continue;
            while ((id = this.findSmallestGap(count, items, mode, breakOnSpace, data, id, c, smallest_gap)) != -1) {
                float possSpace = data.l_x1[id] - data.l_x2[c];
                if (mode == 1 || mode == 2) {
                    possSpace = -possSpace;
                } else if (mode == 3) {
                    possSpace = data.l_x2[id] - data.l_x1[c];
                }
                String separator = this.isGapASpace(c, id, possSpace, addMultiplespaceXMLTag, mode);
                if (breakOnSpace && this.hadSpace != null && (this.hadSpace[c] || separator.startsWith(" "))) continue block0;
                this.merge(c, id, separator, true);
                id = -1;
                smallest_gap = 1000000.0f;
            }
        }
    }

    private int findSmallestGap(int count, int[] items, int mode, boolean breakOnSpace, LineData data, int id, int c, float smallest_gap) {
        for (int j2 = 0; j2 < count; ++j2) {
            float lineOverlap;
            int i = items[j2];
            if (this.isUsed[i]) continue;
            int topLineDifference = (int)(data.l_y1[i] - data.l_y1[c]);
            if (topLineDifference < 0) {
                topLineDifference = -topLineDifference;
            }
            boolean overlapTopLine = (lineOverlap = Math.max(0.0f, Math.min(data.l_y1[c], data.l_y1[i]) - Math.max(data.l_y2[c], data.l_y2[i]))) >= (data.l_y1[i] - data.l_y2[i]) * 0.69f;
            boolean containedAndValid = data.l_y1[c] > data.l_y1[i] && data.l_y2[c] < data.l_y2[i] && data.l_y1[i] - data.l_y2[i] > (data.l_y1[c] - data.l_y2[c]) * 0.44444f;
            int fontSizeChange = this.fontSize[c] - this.fontSize[i];
            if (fontSizeChange < 0) {
                fontSizeChange = -fontSizeChange;
            }
            if (this.writingMode[c] != mode || !((float)fontSizeChange <= (float)this.fontSize[c] * 0.667f && overlapTopLine && topLineDifference <= 6) && !containedAndValid || i == c || !(data.l_x1[i] > data.l_x1[c] && mode != 2) && (!(data.l_x1[i] < data.l_x1[c]) || mode != 2)) continue;
            float gap = data.l_x1[i] - data.l_x2[c];
            if (mode == 1 || mode == 2) {
                gap = -gap;
            }
            if (gap < 0.0f && gap > -2.0f) {
                gap = 0.0f;
            }
            float allowedOverlap = 0.0f;
            if (!breakOnSpace) {
                allowedOverlap = -(this.fontSize[c] / 2);
            }
            if (!(smallest_gap < allowedOverlap) && !(gap < smallest_gap)) continue;
            smallest_gap = gap;
            id = i;
        }
        return id;
    }
}

