/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFSampled
extends PDFGenericFunction
implements PDFFunction {
    private final int[] size;
    private final int m;
    private final int n;
    private final float[] outputs;
    private final double[] sampleArray;
    private float[] prevInputs;
    private final double[] cubeN;
    private final int[] cubeVertex;
    private final int cubeVertices;

    public PDFSampled(byte[] stream, int bits, float[] domain, float[] range, float[] encode, float[] decode, int[] size) {
        super(domain, range);
        int defaultSize;
        int i;
        this.size = size;
        this.m = domain.length / 2;
        this.n = range.length / 2;
        int sampleLen = 1;
        for (int aSize : size) {
            sampleLen *= aSize;
        }
        this.sampleArray = new double[sampleLen *= range.length / 2];
        int pos = 0;
        int buffer = 0;
        double sampleMul = 1.0 / (Math.pow(2.0, bits) - 1.0);
        int index = 0;
        for (i = 0; i < sampleLen; ++i) {
            while (pos < bits) {
                buffer <<= 8;
                buffer |= stream[index++] & 0xFF;
                pos += 8;
            }
            this.sampleArray[i] = (double)(buffer >> (pos -= bits)) * sampleMul;
            buffer = (int)((long)buffer & (1L << pos) - 1L);
        }
        if (encode != null) {
            this.encode = encode;
        } else {
            defaultSize = size.length;
            this.encode = new float[defaultSize * 2];
            for (int ii = 0; ii < defaultSize; ++ii) {
                this.encode[ii * 2 + 1] = size[ii] - 1;
            }
        }
        if (decode != null) {
            this.decode = decode;
        } else {
            defaultSize = range.length;
            this.decode = new float[defaultSize];
            System.arraycopy(range, 0, this.decode, 0, defaultSize);
        }
        this.outputs = new float[this.n];
        this.prevInputs = new float[this.m];
        for (i = 0; i < this.m; ++i) {
            this.prevInputs[i] = Float.MAX_VALUE;
        }
        this.cubeVertices = 1 << this.m;
        this.cubeN = new double[this.cubeVertices];
        this.cubeVertex = new int[this.cubeVertices];
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    private static boolean isSame(float[] arr0, float[] arr1) {
        for (int i = 0; i < arr0.length; ++i) {
            if (arr0[i] == arr1[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public float[] compute(float[] input) {
        int j;
        int i;
        if (PDFSampled.isSame(input, this.prevInputs)) {
            return this.outputs;
        }
        this.prevInputs = (float[])input.clone();
        for (i = 0; i < this.cubeVertices; ++i) {
            this.cubeN[i] = 1.0;
            this.cubeVertex[i] = 0;
        }
        int k = this.n;
        int pos = 1;
        for (i = 0; i < this.m; ++i) {
            int first = 2 * i;
            int next = first + 1;
            double xi = Math.min(Math.max(input[i], this.domain[first]), this.domain[next]);
            double e = PDFSampled.interpolateDouble(xi, this.domain[first], this.domain[next], this.encode[first], this.encode[next]);
            int cur = this.size[i];
            double e0 = (e = Math.min(Math.max(e, 0.0), (double)(cur - 1))) < (double)(cur - 1) ? (double)((int)e) : e - 1.0;
            double n0 = e0 + 1.0 - e;
            double n1 = e - e0;
            double offset0 = e0 * (double)k;
            double offset1 = offset0 + (double)k;
            for (j = 0; j < this.cubeVertices; ++j) {
                if ((j & pos) != 0) {
                    int n = j;
                    this.cubeN[n] = this.cubeN[n] * n1;
                    int n2 = j;
                    this.cubeVertex[n2] = (int)((double)this.cubeVertex[n2] + offset1);
                    continue;
                }
                int n = j;
                this.cubeN[n] = this.cubeN[n] * n0;
                int n3 = j;
                this.cubeVertex[n3] = (int)((double)this.cubeVertex[n3] + offset0);
            }
            k *= cur;
            pos <<= 1;
        }
        for (i = 0; i < this.n; ++i) {
            int ff = i << 1;
            int nn = ff + 1;
            double pp = 0.0;
            for (j = 0; j < this.cubeVertices; ++j) {
                int kk = this.cubeVertex[j] + 1;
                if (kk <= -1) continue;
                pp += this.sampleArray[this.cubeVertex[j] + i] * this.cubeN[j];
            }
            pp = PDFSampled.interpolateDouble(pp, 0.0, 1.0, this.decode[ff], this.decode[nn]);
            this.outputs[i] = (float)Math.min(Math.max(pp, (double)this.range[ff]), (double)this.range[nn]);
        }
        return this.outputs;
    }

    private static double interpolateDouble(double x, double xmin, double xmax, double ymin, double ymax) {
        return (x - xmin) * (ymax - ymin) / (xmax - xmin) + ymin;
    }
}

