/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.function.PostScriptCompiler;
import org.jpedal.utils.LogWriter;

public class PDFCalculator
extends PDFGenericFunction
implements PDFFunction {
    private final PostScriptCompiler comp;
    private final int n;
    private final float[] result;

    public PDFCalculator(byte[] stream, float[] domain, float[] range) {
        super(domain, range);
        this.comp = new PostScriptCompiler(stream);
        this.n = range.length / 2;
        this.result = new float[this.n];
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    @Override
    public float[] compute(float[] values) {
        try {
            double[] stack = this.comp.executeScript(values);
            for (int i = 0; i < this.n; ++i) {
                this.result[i] = PDFCalculator.min(PDFCalculator.max((float)stack[i], this.range[i * 2]), this.range[i * 2 + 1]);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return this.result;
    }
}

