/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.hinting.Cvt;
import org.jpedal.fonts.tt.hinting.TTGraphicsState;
import org.jpedal.utils.LogWriter;

public class TTVM
implements Serializable {
    private static final int TWILIGHT_ZONE = 0;
    static final int GLYPH_ZONE = 1;
    private static final int ORIGINAL = 2;
    private static final boolean showDebugWindow = false;
    private static final boolean printGlyphInstructions = false;
    private static final boolean printCoordsAfterEachInstruction = false;
    private static final boolean watchAPoint = false;
    private static final int watchPoint = 53;
    private int watchX;
    private int watchY;
    private int debugPointer;
    private int instructionsExecuted;
    private int functionsLineCount;
    private int[] programToDebug;
    private boolean[] programToDebugIsData;
    private JFrame debugWindow;
    private TTGraphicsState dGS;
    private JComponent stateDisplay;
    private JComponent debugGlyphDisplay;
    private JCheckBox showInterpolatedShadow;
    private boolean stepInto;
    private boolean debuggerRunningInBackground;
    private static JList currentInstructionList;
    private static JList stackList;
    private static JList cvtList;
    private static JList storageList;
    private JLabel currentCode;
    private JLabel debugXLabel;
    private JLabel debugYLabel;
    private final java.util.Stack<int[]> codeStack = new java.util.Stack();
    private final java.util.Stack<Integer> numberStack = new java.util.Stack();
    private JButton stepOutButton;
    private String currentFunc;
    private boolean printOut;
    private final int[] preProgram;
    private final int[] fontProgram;
    private boolean fontProgramRun;
    private boolean scalerRun;
    private double ptSize;
    private double ppem;
    private double scaler;
    private final int[][] x;
    private final int[][] y;
    private final boolean[][] curve;
    private final boolean[][] contour;
    private boolean[][][] touched;
    private final Maxp maxp;
    private boolean useDefaultGS;
    private Stack stack = new Stack();
    private final Cvt cvt;
    private final TTGraphicsState graphicsState;
    private final int[] storage;
    private final HashMap<Integer, int[]> functions;
    private final HashMap<Integer, int[]> instructions;
    private static final int SVTCAy = 0;
    private static final int SVTCAx = 1;
    private static final int SPVTCAy = 2;
    private static final int SPVTCAx = 3;
    private static final int SFVTCAy = 4;
    private static final int SFVTCAx = 5;
    private static final int SPVTL0 = 6;
    private static final int SPVTL1 = 7;
    private static final int SFVTL0 = 8;
    private static final int SFVTL1 = 9;
    private static final int SPVFS = 10;
    private static final int SFVFS = 11;
    private static final int GPV = 12;
    private static final int GFV = 13;
    private static final int SFVTPV = 14;
    private static final int ISECT = 15;
    private static final int SRP0 = 16;
    private static final int SRP1 = 17;
    private static final int SRP2 = 18;
    private static final int SZP0 = 19;
    private static final int SZP1 = 20;
    private static final int SZP2 = 21;
    private static final int SZPS = 22;
    private static final int SLOOP = 23;
    private static final int RTG = 24;
    private static final int RTHG = 25;
    private static final int SMD = 26;
    private static final int ELSE = 27;
    private static final int JMPR = 28;
    private static final int SCVTCI = 29;
    private static final int SSWCI = 30;
    private static final int SSW = 31;
    private static final int DUP = 32;
    private static final int POP = 33;
    private static final int CLEAR = 34;
    private static final int SWAP = 35;
    private static final int DEPTH = 36;
    private static final int CINDEX = 37;
    private static final int MINDEX = 38;
    private static final int ALIGNPTS = 39;
    private static final int UTP = 41;
    private static final int LOOPCALL = 42;
    private static final int CALL = 43;
    private static final int FDEF = 44;
    private static final int ENDF = 45;
    private static final int MDAP0 = 46;
    private static final int MDAP1 = 47;
    private static final int IUPy = 48;
    private static final int IUPx = 49;
    private static final int SHP0 = 50;
    private static final int SHP1 = 51;
    private static final int SHC0 = 52;
    private static final int SHC1 = 53;
    private static final int SHZ0 = 54;
    private static final int SHZ1 = 55;
    private static final int SHPIX = 56;
    private static final int IP = 57;
    private static final int MSIRP0 = 58;
    private static final int MSIRP1 = 59;
    private static final int ALIGNRP = 60;
    private static final int RTDG = 61;
    private static final int MIAP0 = 62;
    private static final int MIAP1 = 63;
    private static final int NPUSHB = 64;
    private static final int NPUSHW = 65;
    private static final int WS = 66;
    private static final int RS = 67;
    private static final int WCVTP = 68;
    private static final int RCVT = 69;
    private static final int GC0 = 70;
    private static final int GC1 = 71;
    private static final int SCFS = 72;
    private static final int MD0 = 73;
    private static final int MD1 = 74;
    private static final int MPPEM = 75;
    private static final int MPS = 76;
    private static final int FLIPON = 77;
    private static final int FLIPOFF = 78;
    private static final int DEBUG = 79;
    private static final int LT = 80;
    private static final int LTEQ = 81;
    private static final int GT = 82;
    private static final int GTEQ = 83;
    private static final int EQ = 84;
    private static final int NEQ = 85;
    private static final int ODD = 86;
    private static final int EVEN = 87;
    private static final int IF = 88;
    private static final int EIF = 89;
    private static final int AND = 90;
    private static final int OR = 91;
    private static final int NOT = 92;
    private static final int DELTAP1 = 93;
    private static final int SDB = 94;
    private static final int SDS = 95;
    private static final int ADD = 96;
    private static final int SUB = 97;
    private static final int DIV = 98;
    private static final int MUL = 99;
    private static final int ABS = 100;
    private static final int NEG = 101;
    private static final int FLOOR = 102;
    private static final int CEILING = 103;
    private static final int ROUND00 = 104;
    private static final int ROUND01 = 105;
    private static final int ROUND10 = 106;
    private static final int ROUND11 = 107;
    private static final int NROUND00 = 108;
    private static final int NROUND01 = 109;
    private static final int NROUND10 = 110;
    private static final int NROUND11 = 111;
    private static final int WCVTF = 112;
    private static final int DELTAP2 = 113;
    private static final int DELTAP3 = 114;
    private static final int DELTAC1 = 115;
    private static final int DELTAC2 = 116;
    private static final int DELTAC3 = 117;
    private static final int SROUND = 118;
    private static final int S45ROUND = 119;
    private static final int JROT = 120;
    private static final int JROF = 121;
    private static final int ROFF = 122;
    private static final int RUTG = 124;
    private static final int RDTG = 125;
    private static final int SANGW = 126;
    private static final int AA = 127;
    private static final int FLIPPT = 128;
    private static final int FLIPRGON = 129;
    private static final int FLIPRGOFF = 130;
    private static final int SCANCTRL = 133;
    private static final int SDPVTL0 = 134;
    private static final int SDPVTL1 = 135;
    private static final int GETINFO = 136;
    private static final int IDEF = 137;
    private static final int ROLL = 138;
    private static final int MAX = 139;
    private static final int MIN = 140;
    private static final int SCANTYPE = 141;
    private static final int INSTCTRL = 142;
    private static final int PUSHB = 176;
    private static final int PUSHW = 184;
    private static final int MDRP = 192;
    private static final int MIRP = 224;
    private static final String[] OPCODE_DESCRIPTIONS;
    private static final int paramRESETRP0 = 16;
    private static final int paramUSEMINDIST = 8;
    private static final int paramROUND = 4;

    public TTVM(FontFile2 currentFontFile, Maxp maxp) {
        this.cvt = new Cvt(currentFontFile);
        this.graphicsState = new TTGraphicsState();
        this.preProgram = TTVM.readProgramTable(currentFontFile, 14);
        this.fontProgram = TTVM.readProgramTable(currentFontFile, 10);
        this.storage = new int[maxp.getMaxStorage()];
        this.functions = new HashMap();
        this.instructions = new HashMap();
        this.maxp = maxp;
        int len = maxp.getMaxPoints();
        this.x = new int[4][len];
        this.y = new int[4][len];
        this.curve = new boolean[2][len];
        this.contour = new boolean[2][len];
        this.touched = new boolean[4][len][2];
        this.x[0] = new int[maxp.getMaxTwilightPoints()];
        this.y[0] = new int[maxp.getMaxTwilightPoints()];
    }

    private void setScaleVars(double scaler, double ppem, double ptSize) {
        this.scalerRun = false;
        boolean forceRunPrep = false;
        this.ppem = (int)(ppem + 0.5);
        this.ptSize = ptSize;
        if (!this.fontProgramRun) {
            this.execute(this.fontProgram, this.graphicsState);
            this.fontProgramRun = true;
            forceRunPrep = true;
        }
        if (scaler != this.scaler || forceRunPrep) {
            this.scaler = scaler;
            this.cvt.scale(scaler);
            this.execute(this.preProgram, this.graphicsState);
            this.scalerRun = true;
        }
    }

    public boolean processGlyph(int[] instructions, int[] glyfX, int[] glyfY, boolean[] curves, boolean[] contours, double pixelSize, double scaler) {
        TTGraphicsState gs;
        this.x[2] = new int[this.x[0].length];
        this.x[0] = new int[this.x[0].length];
        this.y[0] = new int[this.y[0].length];
        this.y[2] = new int[this.y[0].length];
        this.setScaleVars(scaler, pixelSize, pixelSize * 72.0 / 96.0);
        this.x[1] = glyfX;
        this.x[3] = new int[glyfX.length];
        System.arraycopy(this.x[1], 0, this.x[3], 0, this.x[1].length);
        this.y[1] = glyfY;
        this.y[3] = new int[glyfY.length];
        System.arraycopy(this.y[1], 0, this.y[3], 0, this.y[1].length);
        this.curve[1] = curves;
        this.contour[1] = contours;
        int max = this.maxp.getMaxTwilightPoints();
        if (glyfX.length > max) {
            max = glyfX.length;
        }
        this.touched = new boolean[4][max][2];
        this.stack = new Stack();
        if (this.useDefaultGS) {
            gs = new TTGraphicsState();
        } else {
            try {
                gs = (TTGraphicsState)this.graphicsState.clone();
                gs.resetForGlyph();
            }
            catch (CloneNotSupportedException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
                gs = new TTGraphicsState();
            }
        }
        if (gs.instructControl != 0) {
            return false;
        }
        boolean failedOnHinting = this.execute(instructions, gs);
        return failedOnHinting;
    }

    private boolean execute(int[] program, TTGraphicsState gs) {
        boolean failedOnHinting = false;
        if (program == null) {
            return false;
        }
        for (int currentPointer = 0; currentPointer < program.length; ++currentPointer) {
            if (this.printOut) {
                System.out.print(currentPointer + "\t");
            }
            if ((currentPointer = this.process(program[currentPointer], currentPointer, program, gs)) < 0) {
                currentPointer = -currentPointer;
                failedOnHinting = true;
            }
            if (!failedOnHinting) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private int process(int code, int currentPointer, int[] program, TTGraphicsState gs) {
        failedOnHinting = false;
        originalPointer = currentPointer;
        bytesToRead = 0;
        if (code >= 176 && code <= 191) {
            bytesToRead = code % 8;
            code -= bytesToRead;
            ++bytesToRead;
        }
        if (this.printOut && code < TTVM.OPCODE_DESCRIPTIONS.length) {
            System.out.println(TTVM.OPCODE_DESCRIPTIONS[code]);
        }
        try {
            switch (code) {
                case 0: {
                    gs.freedomVector = 16384;
                    gs.projectionVector = 16384;
                    gs.dualProjectionVector = 16384;
                    ** break;
                }
                case 1: {
                    gs.freedomVector = 0x40000000;
                    gs.projectionVector = 0x40000000;
                    gs.dualProjectionVector = 0x40000000;
                    ** break;
                }
                case 2: {
                    gs.projectionVector = 16384;
                    gs.dualProjectionVector = 16384;
                    ** break;
                }
                case 3: {
                    gs.projectionVector = 0x40000000;
                    gs.dualProjectionVector = 0x40000000;
                    ** break;
                }
                case 4: {
                    gs.freedomVector = 16384;
                    ** break;
                }
                case 5: {
                    gs.freedomVector = 0x40000000;
                    ** break;
                }
                case 6: {
                    p1 = this.stack.pop();
                    p2 = this.stack.pop();
                    xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp2][p2] - this.x[gs.zp1][p1]);
                    ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp2][p2] - this.y[gs.zp1][p1]);
                    factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    gs.dualProjectionVector = gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(xdiff /= factor), TTVM.storeDoubleAsF2Dot14(ydiff /= factor));
                    ** break;
                }
                case 7: {
                    p1 = this.stack.pop();
                    p2 = this.stack.pop();
                    xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp2][p2] - this.x[gs.zp1][p1]);
                    ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp2][p2] - this.y[gs.zp1][p1]);
                    factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    gs.dualProjectionVector = gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(-(ydiff /= factor)), TTVM.storeDoubleAsF2Dot14(xdiff /= factor));
                    ** break;
                }
                case 8: {
                    p1 = this.stack.pop();
                    p2 = this.stack.pop();
                    xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp1][p2] - this.x[gs.zp2][p1]);
                    ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp1][p2] - this.y[gs.zp2][p1]);
                    factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    gs.freedomVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(xdiff /= factor), TTVM.storeDoubleAsF2Dot14(ydiff /= factor));
                    ** break;
                }
                case 9: {
                    p1 = this.stack.pop();
                    p2 = this.stack.pop();
                    xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp1][p2] - this.x[gs.zp2][p1]);
                    ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp1][p2] - this.y[gs.zp2][p1]);
                    factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    gs.freedomVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(-(ydiff /= factor)), TTVM.storeDoubleAsF2Dot14(xdiff /= factor));
                    ** break;
                }
                case 10: {
                    y = this.stack.pop();
                    x = this.stack.pop();
                    gs.dualProjectionVector = gs.projectionVector = TTGraphicsState.createVector(x, y);
                    ** break;
                }
                case 11: {
                    y = this.stack.pop();
                    x = this.stack.pop();
                    gs.freedomVector = TTGraphicsState.createVector(x, y);
                    ** break;
                }
                case 12: {
                    pv = TTGraphicsState.getVectorComponents(gs.projectionVector);
                    this.stack.push(pv[0], currentPointer, this.currentFunc);
                    this.stack.push(pv[1], currentPointer, this.currentFunc);
                    ** break;
                }
                case 13: {
                    fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    this.stack.push(fv[0], currentPointer, this.currentFunc);
                    this.stack.push(fv[1], currentPointer, this.currentFunc);
                    ** break;
                }
                case 14: {
                    gs.freedomVector = gs.projectionVector;
                    ** break;
                }
                case 15: {
                    b1 = this.stack.pop();
                    b0 = this.stack.pop();
                    a1 = this.stack.pop();
                    a0 = this.stack.pop();
                    ax = this.x[gs.zp1][a0];
                    ay = this.y[gs.zp1][a0];
                    adx = this.x[gs.zp1][a1] - ax;
                    ady = this.y[gs.zp1][a1] - ay;
                    bx = this.x[gs.zp0][b0];
                    by = this.y[gs.zp0][b0];
                    bdx = this.x[gs.zp0][b1] - bx;
                    bdy = this.y[gs.zp0][b1] - by;
                    if (adx == 0 && bdx == 0) {
                        x = ax + bx / 2;
                        y = (ay + by + (ay + ady) + (by + bdy)) / 4;
                    } else if (adx == 0) {
                        bm = TTVM.getDoubleFromF26Dot6(bdy) / TTVM.getDoubleFromF26Dot6(bdx);
                        bc = TTVM.getDoubleFromF26Dot6(by) - bm * TTVM.getDoubleFromF26Dot6(bx);
                        x = ax;
                        y = TTVM.storeDoubleAsF26Dot6(bm * TTVM.getDoubleFromF26Dot6(ax) + bc);
                    } else if (bdx == 0) {
                        am = TTVM.getDoubleFromF26Dot6(ady) / TTVM.getDoubleFromF26Dot6(adx);
                        ac = TTVM.getDoubleFromF26Dot6(ay) - am * TTVM.getDoubleFromF26Dot6(ax);
                        x = bx;
                        y = TTVM.storeDoubleAsF26Dot6(am * TTVM.getDoubleFromF26Dot6(bx) + ac);
                    } else {
                        am = TTVM.getDoubleFromF26Dot6(ady) / TTVM.getDoubleFromF26Dot6(adx);
                        ac = TTVM.getDoubleFromF26Dot6(ay) - am * TTVM.getDoubleFromF26Dot6(ax);
                        bm = TTVM.getDoubleFromF26Dot6(bdy) / TTVM.getDoubleFromF26Dot6(bdx);
                        bc = TTVM.getDoubleFromF26Dot6(by) - bm * TTVM.getDoubleFromF26Dot6(bx);
                        if (am == bm) {
                            x = (ax + bx + (ax + adx) + (bx + bdx)) / 4;
                            y = (ay + by + (ay + ady) + (by + bdy)) / 4;
                        } else {
                            fx = (bc - ac) / (am - bm);
                            x = TTVM.storeDoubleAsF26Dot6(fx);
                            y = TTVM.storeDoubleAsF26Dot6(am * fx + ac);
                        }
                    }
                    p = this.stack.pop();
                    this.x[gs.zp2][p] = x;
                    this.y[gs.zp2][p] = y;
                    ** break;
                }
                case 16: {
                    gs.rp0 = this.stack.pop();
                    ** break;
                }
                case 17: {
                    gs.rp1 = this.stack.pop();
                    ** break;
                }
                case 18: {
                    gs.rp2 = this.stack.pop();
                    ** break;
                }
                case 19: {
                    value = this.stack.pop();
                    if (value > 1 || value < 0) {
                        LogWriter.writeLog("ZP0 set incorrectly! " + value);
                    }
                    gs.zp0 = value;
                    ** break;
                }
                case 20: {
                    value = this.stack.pop();
                    if (value > 1 || value < 0) {
                        LogWriter.writeLog("ZP1 set incorrectly! " + value);
                    }
                    gs.zp1 = value;
                    ** break;
                }
                case 21: {
                    value = this.stack.pop();
                    if (value > 1 || value < 0) {
                        LogWriter.writeLog("ZP2 set incorrectly! " + value);
                    }
                    gs.zp2 = value;
                    ** break;
                }
                case 22: {
                    value = this.stack.pop();
                    if (value > 1 || value < 0) {
                        LogWriter.writeLog("All zone pointers set incorrectly! " + value);
                    }
                    gs.zp0 = value;
                    gs.zp1 = value;
                    gs.zp2 = value;
                    ** break;
                }
                case 23: {
                    gs.loop = this.stack.pop();
                    ** break;
                }
                case 24: {
                    gs.roundState = 72;
                    gs.gridPeriod = 1.0;
                    ** break;
                }
                case 25: {
                    gs.roundState = 104;
                    gs.gridPeriod = 1.0;
                    ** break;
                }
                case 26: {
                    gs.minimumDistance = this.stack.pop();
                    ** break;
                }
                case 27: {
                    curr = 0;
                    nest = 0;
                    do {
                        if (curr == 89) {
                            --nest;
                        }
                        if ((curr = program[++currentPointer]) == 88) {
                            ++nest;
                        }
                        if (curr == 64) {
                            ++currentPointer;
                            currentPointer += program[currentPointer];
                            continue;
                        }
                        if (curr == 65) {
                            ++currentPointer;
                            currentPointer += program[currentPointer] * 2;
                            continue;
                        }
                        if (curr >= 176 && curr <= 183) {
                            currentPointer += curr + 1 - 176;
                            continue;
                        }
                        if (curr < 184 || curr > 191) continue;
                        currentPointer += (curr + 1 - 184) * 2;
                    } while (curr != 89 || nest != 0);
                    ** break;
                }
                case 28: {
                    value = this.stack.pop();
                    currentPointer = currentPointer + value - 1;
                    if (currentPointer < 0) {
                        throw new RuntimeException("Jumped back further than the start of the instruction.");
                    }
                    break;
                }
                case 29: {
                    gs.controlValueTableCutIn = this.stack.pop();
                    ** break;
                }
                case 30: {
                    gs.singleWidthCutIn = this.stack.pop();
                    ** break;
                }
                case 31: {
                    gs.singleWidthValue = this.stack.pop();
                    ** break;
                }
                case 32: {
                    value = this.stack.pop();
                    this.stack.push(value, currentPointer, this.currentFunc);
                    this.stack.push(value, currentPointer, this.currentFunc);
                    ** break;
                }
                case 33: {
                    this.stack.pop();
                    ** break;
                }
                case 34: {
                    this.stack = new Stack();
                    ** break;
                }
                case 35: {
                    top = this.stack.pop();
                    under = this.stack.pop();
                    this.stack.push(top, currentPointer, this.currentFunc);
                    this.stack.push(under, currentPointer, this.currentFunc);
                    ** break;
                }
                case 36: {
                    this.stack.push(this.stack.size(), currentPointer, this.currentFunc);
                    ** break;
                }
                case 37: {
                    key = this.stack.pop();
                    value = this.stack.elementAt(key);
                    this.stack.push(value, currentPointer, this.currentFunc);
                    ** break;
                }
                case 38: {
                    key = this.stack.pop();
                    value = this.stack.remove(key);
                    this.stack.push(value, currentPointer, this.currentFunc);
                    ** break;
                }
                case 39: {
                    p1 = this.stack.pop();
                    p2 = this.stack.pop();
                    p1loc = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p1], this.y[gs.zp1][p1]);
                    p2loc = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p2], this.y[gs.zp0][p2]);
                    target = (p1loc + p2loc) / 2;
                    shift = gs.getFVMoveforPVDistance(target - p1loc);
                    v0 = this.x[gs.zp1];
                    v1 = p1;
                    v0[v1] = v0[v1] + shift[0];
                    v2 = this.y[gs.zp1];
                    v3 = p1;
                    v2[v3] = v2[v3] + shift[1];
                    v4 = this.x[gs.zp0];
                    v5 = p2;
                    v4[v5] = v4[v5] - shift[0];
                    v6 = this.y[gs.zp0];
                    v7 = p2;
                    v6[v7] = v6[v7] - shift[1];
                    fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp1][p1][0] = true;
                        this.touched[gs.zp0][p2][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp1][p1][1] = true;
                        this.touched[gs.zp0][p2][1] = true;
                        ** break;
                    }
                    break;
                }
                case 41: {
                    p = this.stack.pop();
                    switch (gs.freedomVector) {
                        case 0x40000000: {
                            this.touched[gs.zp0][p][0] = false;
                            ** break;
                        }
                        case 16384: {
                            this.touched[gs.zp0][p][1] = false;
                            ** break;
                        }
                    }
                    this.touched[gs.zp0][p][0] = false;
                    this.touched[gs.zp0][p][1] = false;
                    ** break;
                }
                case 42: {
                    func = this.stack.pop();
                    count = this.stack.pop();
                    function = this.functions.get(func);
                    for (i = 0; i < count; ++i) {
                        failed = this.execute(function, gs);
                        if (!failed) continue;
                        failedOnHinting = true;
                    }
                    if (this.printOut) {
                        System.out.println("LOOPCALL finished");
                        ** break;
                    }
                    break;
                }
                case 43: {
                    func = this.stack.pop();
                    function = this.functions.get(func);
                    failed = this.execute(function, gs);
                    if (failed) {
                        failedOnHinting = true;
                    }
                    if (this.printOut) {
                        System.out.println("CALL finished");
                        ** break;
                    }
                    break;
                }
                case 44: {
                    num = this.stack.pop();
                    start = currentPointer;
                    do {
                        if ((curr = program[++currentPointer]) == 64) {
                            ++currentPointer;
                            currentPointer += program[currentPointer];
                            continue;
                        }
                        if (curr == 65) {
                            ++currentPointer;
                            currentPointer += program[currentPointer] * 2;
                            continue;
                        }
                        if (curr >= 176 && curr <= 183) {
                            currentPointer += curr + 1 - 176;
                            continue;
                        }
                        if (curr < 184 || curr > 191) continue;
                        currentPointer += (curr + 1 - 184) * 2;
                    } while (curr != 45);
                    len = currentPointer - start - 1;
                    currentPointer = start;
                    function = new int[len];
                    for (i = 0; i < len; ++i) {
                        function[i] = program[++currentPointer];
                    }
                    this.functions.put(num, function);
                    ++currentPointer;
                    ** break;
                }
                case 45: {
                    ** break;
                }
                case 46: {
                    gs.rp0 = p = this.stack.pop();
                    gs.rp1 = p;
                    switch (gs.freedomVector) {
                        case 0x40000000: {
                            this.touched[gs.zp0][p][0] = true;
                            ** break;
                        }
                        case 16384: {
                            this.touched[gs.zp0][p][1] = true;
                            ** break;
                        }
                    }
                    this.touched[gs.zp0][p][0] = true;
                    this.touched[gs.zp0][p][1] = true;
                    ** break;
                }
                case 47: {
                    gs.rp0 = p = this.stack.pop();
                    gs.rp1 = p;
                    m = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p], this.y[gs.zp0][p]);
                    m = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(m))) - m;
                    shift = gs.getFVMoveforPVDistance(m);
                    v8 = this.x[gs.zp0];
                    v9 = p;
                    v8[v9] = v8[v9] + shift[0];
                    v10 = this.y[gs.zp0];
                    v11 = p;
                    v10[v11] = v10[v11] + shift[1];
                    fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp0][p][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp0][p][1] = true;
                        ** break;
                    }
                    break;
                }
                case 48: {
                    this.interpolateUntouchedPoints(48);
                    ** break;
                }
                case 49: {
                    this.interpolateUntouchedPoints(49);
                    ** break;
                }
                case 50: {
                    for (i = 0; i < gs.loop; ++i) {
                        p = this.stack.pop();
                        if (p > this.x[gs.zp2].length || gs.rp2 > this.x[gs.zp1].length) {
                            LogWriter.writeLog("Trying to use a point which doesn't exist! (SHP0, zone " + gs.zp2 + ')');
                            break;
                        }
                        newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][gs.rp2], this.y[gs.zp1][gs.rp2]);
                        oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp1][gs.rp2], this.y[2 + gs.zp1][gs.rp2]);
                        pMove = newRP - oldRP;
                        shift = gs.getFVMoveforPVDistance(pMove);
                        v12 = this.x[gs.zp2];
                        v13 = p;
                        v12[v13] = v12[v13] + shift[0];
                        v14 = this.y[gs.zp2];
                        v15 = p;
                        v14[v15] = v14[v15] + shift[1];
                        fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp2][p][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp2][p][1] = true;
                    }
                    gs.loop = 1;
                    ** break;
                }
                case 51: {
                    for (i = 0; i < gs.loop; ++i) {
                        p = this.stack.pop();
                        newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp1], this.y[gs.zp0][gs.rp1]);
                        oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp0][gs.rp1], this.y[2 + gs.zp0][gs.rp1]);
                        shift = newRP - oldRP;
                        move = gs.getFVMoveforPVDistance(shift);
                        v16 = this.x[gs.zp2];
                        v17 = p;
                        v16[v17] = v16[v17] + move[0];
                        v18 = this.y[gs.zp2];
                        v19 = p;
                        v18[v19] = v18[v19] + move[1];
                        if (move[0] != 0) {
                            this.touched[gs.zp2][p][0] = true;
                        }
                        if (move[1] == 0) continue;
                        this.touched[gs.zp2][p][1] = true;
                    }
                    gs.loop = 1;
                    ** break;
                }
                case 52: {
                    c = this.stack.pop();
                    contourLengths = new int[this.contour[1].length];
                    contourStarts = new int[this.contour[1].length];
                    contourCount = 0;
                    lastContour = 0;
                    contourStarts[0] = 0;
                    for (i = 0; i < this.contour[1].length; ++i) {
                        if (!this.contour[1][i]) continue;
                        contourStarts[contourCount + 1] = i + 1;
                        contourLengths[contourCount] = i + 1 - lastContour;
                        lastContour = i + 1;
                        ++contourCount;
                    }
                    newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][gs.rp2], this.y[gs.zp1][gs.rp2]);
                    oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp1][gs.rp2], this.y[2 + gs.zp1][gs.rp2]);
                    shift = newRP - oldRP;
                    move = gs.getFVMoveforPVDistance(shift);
                    for (i = contourStarts[c]; i < contourStarts[c] + contourLengths[c]; ++i) {
                        if (gs.zp1 != gs.zp2 && i == gs.rp2) continue;
                        v20 = this.x[gs.zp2];
                        v21 = i;
                        v20[v21] = v20[v21] + move[0];
                        v22 = this.y[gs.zp2];
                        v23 = i;
                        v22[v23] = v22[v23] + move[1];
                    }
                    break;
                }
                case 53: {
                    c = this.stack.pop();
                    contourLengths = new int[this.contour[1].length];
                    contourStarts = new int[this.contour[1].length];
                    contourCount = 0;
                    lastContour = 0;
                    contourStarts[0] = 0;
                    for (i = 0; i < this.contour[1].length; ++i) {
                        if (!this.contour[1][i]) continue;
                        contourStarts[contourCount + 1] = i + 1;
                        contourLengths[contourCount] = i + 1 - lastContour;
                        lastContour = i + 1;
                        ++contourCount;
                    }
                    newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp1], this.y[gs.zp0][gs.rp1]);
                    oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp0][gs.rp1], this.y[2 + gs.zp0][gs.rp1]);
                    shift = newRP - oldRP;
                    move = gs.getFVMoveforPVDistance(shift);
                    for (i = contourStarts[c]; i < contourStarts[c] + contourLengths[c]; ++i) {
                        if (gs.zp2 == gs.zp0 && i == gs.rp1) continue;
                        v24 = this.x[gs.zp2];
                        v25 = i;
                        v24[v25] = v24[v25] + move[0];
                        v26 = this.y[gs.zp2];
                        v27 = i;
                        v26[v27] = v26[v27] + move[1];
                    }
                    break;
                }
                case 54: {
                    z = this.stack.pop();
                    newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][gs.rp2], this.y[gs.zp1][gs.rp2]);
                    oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp1][gs.rp2], this.y[2 + gs.zp1][gs.rp2]);
                    shift = newRP - oldRP;
                    move = gs.getFVMoveforPVDistance(shift);
                    for (i = 0; i < this.x[z].length; ++i) {
                        if (z == gs.zp1 && i == gs.rp2) continue;
                        v28 = this.x[z];
                        v29 = i;
                        v28[v29] = v28[v29] + move[0];
                        v30 = this.y[z];
                        v31 = i;
                        v30[v31] = v30[v31] + move[1];
                    }
                    break;
                }
                case 55: {
                    z = this.stack.pop();
                    newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp1], this.y[gs.zp0][gs.rp1]);
                    oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp0][gs.rp1], this.y[2 + gs.zp0][gs.rp1]);
                    shift = newRP - oldRP;
                    move = gs.getFVMoveforPVDistance(shift);
                    for (i = 0; i < this.x[z].length; ++i) {
                        if (z == gs.zp0 && i == gs.rp1) continue;
                        v32 = this.x[z];
                        v33 = i;
                        v32[v33] = v32[v33] + move[0];
                        v34 = this.y[z];
                        v35 = i;
                        v34[v35] = v34[v35] + move[1];
                    }
                    break;
                }
                case 56: {
                    magnitude = this.stack.pop();
                    fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    for (i = 0; i < gs.loop; ++i) {
                        point = this.stack.pop();
                        v36 = this.x[gs.zp2];
                        v37 = point;
                        v36[v37] = (int)((double)v36[v37] + (double)magnitude * TTVM.getDoubleFromF2Dot14(fv[0]));
                        v38 = this.y[gs.zp2];
                        v39 = point;
                        v38[v39] = (int)((double)v38[v39] + (double)magnitude * TTVM.getDoubleFromF2Dot14(fv[1]));
                        if (fv[0] != 0) {
                            this.touched[gs.zp2][point][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp2][point][1] = true;
                    }
                    gs.loop = 1;
                    ** break;
                }
                case 57: {
                    for (i = 0; i < gs.loop; ++i) {
                        p = this.stack.pop();
                        if (p < 0 || p > this.x[gs.zp2].length || gs.rp1 > this.x[gs.zp0].length || gs.rp2 > this.x[gs.zp1].length) {
                            LogWriter.writeLog("Trying to use a point which doesn't exist! (IP, zone " + gs.zp2 + ')');
                            break;
                        }
                        originalRP1 = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][gs.rp1], this.y[2 + gs.zp0][gs.rp1]);
                        if (originalRP1 == (originalRP2 = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][gs.rp2], this.y[2 + gs.zp1][gs.rp2]))) continue;
                        originalP = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp2][p], this.y[2 + gs.zp2][p]);
                        pos = (double)(originalP - originalRP1) / (double)(originalRP2 - originalRP1);
                        newRP1 = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp1], this.y[gs.zp0][gs.rp1]);
                        newRP2 = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][gs.rp2], this.y[gs.zp1][gs.rp2]);
                        pMove = (int)(pos * (double)(newRP2 - newRP1) + (double)newRP1 + 0.5) - originalP;
                        shift = gs.getFVMoveforPVDistance(pMove);
                        v40 = this.x[gs.zp2];
                        v41 = p;
                        v40[v41] = v40[v41] + shift[0];
                        v42 = this.y[gs.zp2];
                        v43 = p;
                        v42[v43] = v42[v43] + shift[1];
                        fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp2][p][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp2][p][1] = true;
                    }
                    gs.loop = 1;
                    ** break;
                }
                case 58: {
                    d = this.stack.pop();
                    p = this.stack.pop();
                    shift = gs.getFVMoveforPVDistance(d - (TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p], this.y[gs.zp1][p]) - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0])));
                    if (gs.zp1 == 0) {
                        v44 = this.x[2];
                        v45 = p;
                        v44[v45] = v44[v45] + shift[0];
                        v46 = this.y[2];
                        v47 = p;
                        v46[v47] = v46[v47] + shift[1];
                    }
                    v48 = this.x[gs.zp1];
                    v49 = p;
                    v48[v49] = v48[v49] + shift[0];
                    v50 = this.y[gs.zp1];
                    v51 = p;
                    v50[v51] = v50[v51] + shift[1];
                    fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp1][p][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp1][p][1] = true;
                    }
                    gs.rp1 = gs.rp0;
                    gs.rp2 = p;
                    ** break;
                }
                case 59: {
                    d = this.stack.pop();
                    p = this.stack.pop();
                    shift = gs.getFVMoveforPVDistance(d - (TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p], this.y[gs.zp1][p]) - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0])));
                    if (gs.zp1 == 0) {
                        v52 = this.x[2];
                        v53 = p;
                        v52[v53] = v52[v53] + shift[0];
                        v54 = this.y[2];
                        v55 = p;
                        v54[v55] = v54[v55] + shift[1];
                    }
                    v56 = this.x[gs.zp1];
                    v57 = p;
                    v56[v57] = v56[v57] + shift[0];
                    v58 = this.y[gs.zp1];
                    v59 = p;
                    v58[v59] = v58[v59] + shift[1];
                    fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp1][p][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp1][p][1] = true;
                    }
                    gs.rp1 = gs.rp0;
                    gs.rp2 = p;
                    gs.rp0 = p;
                    ** break;
                }
                case 60: {
                    for (i = 0; i < gs.loop; ++i) {
                        p = this.stack.pop();
                        target = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0]);
                        pMove = target - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p], this.y[gs.zp1][p]);
                        shift = gs.getFVMoveforPVDistance(pMove);
                        v60 = this.x[gs.zp1];
                        v61 = p;
                        v60[v61] = v60[v61] + shift[0];
                        v62 = this.y[gs.zp1];
                        v63 = p;
                        v62[v63] = v62[v63] + shift[1];
                        fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp1][p][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp1][p][1] = true;
                    }
                    gs.loop = 1;
                    ** break;
                }
                case 61: {
                    gs.roundState = 8;
                    gs.gridPeriod = 1.0;
                    ** break;
                }
                case 62: {
                    cvtEntry = this.stack.pop();
                    p = this.stack.pop();
                    target = this.cvt.get(cvtEntry);
                    current = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p], this.y[gs.zp0][p]);
                    pMove = target - current;
                    shift = gs.getFVMoveforPVDistance(pMove);
                    if (gs.zp0 == 0) {
                        v64 = this.x[2];
                        v65 = p;
                        v64[v65] = v64[v65] + shift[0];
                        v66 = this.y[2];
                        v67 = p;
                        v66[v67] = v66[v67] + shift[1];
                    }
                    v68 = this.x[gs.zp0];
                    v69 = p;
                    v68[v69] = v68[v69] + shift[0];
                    v70 = this.y[gs.zp0];
                    v71 = p;
                    v70[v71] = v70[v71] + shift[1];
                    fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp0][p][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp0][p][1] = true;
                    }
                    gs.rp0 = gs.rp1 = p;
                    ** break;
                }
                case 63: {
                    cvtEntry = this.stack.pop();
                    p = this.stack.pop();
                    target = this.cvt.get(cvtEntry);
                    current = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p], this.y[gs.zp0][p]);
                    pMove = Math.abs(target - current);
                    if (gs.zp0 != 0 && pMove > gs.controlValueTableCutIn) {
                        target = current;
                    }
                    target = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(target)));
                    pMove = target - current;
                    shift = gs.getFVMoveforPVDistance(pMove);
                    if (gs.zp0 == 0) {
                        v72 = this.x[2];
                        v73 = p;
                        v72[v73] = v72[v73] + shift[0];
                        v74 = this.y[2];
                        v75 = p;
                        v74[v75] = v74[v75] + shift[1];
                    }
                    v76 = this.x[gs.zp0];
                    v77 = p;
                    v76[v77] = v76[v77] + shift[0];
                    v78 = this.y[gs.zp0];
                    v79 = p;
                    v78[v79] = v78[v79] + shift[1];
                    fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp0][p][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp0][p][1] = true;
                    }
                    gs.rp0 = gs.rp1 = p;
                    ** break;
                }
                case 64: {
                    ++currentPointer;
                    currentPointer = this.readFromIS(program[currentPointer], false, currentPointer, program);
                    ** break;
                }
                case 65: {
                    ++currentPointer;
                    currentPointer = this.readFromIS(program[currentPointer], true, currentPointer, program);
                    ** break;
                }
                case 66: {
                    value = this.stack.pop();
                    key = this.stack.pop();
                    this.storage[key] = value;
                    ** break;
                }
                case 67: {
                    key = this.stack.pop();
                    this.stack.push(this.storage[key], currentPointer, this.currentFunc);
                    ** break;
                }
                case 68: {
                    value = this.stack.pop();
                    key = this.stack.pop();
                    this.cvt.putInPixels(key, value);
                    ** break;
                }
                case 69: {
                    key = this.stack.pop();
                    this.stack.push(this.cvt.get(key), currentPointer, this.currentFunc);
                    ** break;
                }
                case 70: {
                    p = this.stack.pop();
                    this.stack.push(TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp2][p], this.y[gs.zp2][p]), currentPointer, this.currentFunc);
                    ** break;
                }
                case 71: {
                    p = this.stack.pop();
                    this.stack.push(TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp2][p], this.y[2 + gs.zp2][p]), currentPointer, this.currentFunc);
                    ** break;
                }
                case 72: {
                    value = this.stack.pop();
                    p = this.stack.pop();
                    current = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp2][p], this.y[gs.zp2][p]);
                    pMove = value - current;
                    shift = gs.getFVMoveforPVDistance(pMove);
                    if (gs.zp2 == 0) {
                        v80 = this.x[2];
                        v81 = p;
                        v80[v81] = v80[v81] + shift[0];
                        v82 = this.y[2];
                        v83 = p;
                        v82[v83] = v82[v83] + shift[1];
                    }
                    v84 = this.x[gs.zp2];
                    v85 = p;
                    v84[v85] = v84[v85] + shift[0];
                    v86 = this.y[gs.zp2];
                    v87 = p;
                    v86[v87] = v86[v87] + shift[1];
                    fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp2][p][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp2][p][1] = true;
                        ** break;
                    }
                    break;
                }
                case 73: {
                    p1 = this.stack.pop();
                    p2 = this.stack.pop();
                    distance = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p2], this.y[gs.zp0][p2]) - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p1], this.y[gs.zp1][p1]);
                    this.stack.push(distance, currentPointer, this.currentFunc);
                    ** break;
                }
                case 74: {
                    p1 = this.stack.pop();
                    p2 = this.stack.pop();
                    distance = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][p2], this.y[2 + gs.zp1][p2]) - TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][p1], this.y[2 + gs.zp0][p1]);
                    this.stack.push(distance, currentPointer, this.currentFunc);
                    ** break;
                }
                case 75: {
                    pvppem = TTGraphicsState.getCoordsOnVector(gs.projectionVector, (int)(this.ppem * 64.0), (int)(this.ppem * 64.0)) / 64;
                    if (pvppem < 0) {
                        pvppem = -pvppem;
                    }
                    this.stack.push(pvppem, currentPointer, this.currentFunc);
                    ** break;
                }
                case 76: {
                    this.stack.push((int)(this.ptSize * 64.0), currentPointer, this.currentFunc);
                    ** break;
                }
                case 77: {
                    gs.autoFlip = true;
                    ** break;
                }
                case 78: {
                    gs.autoFlip = false;
                    ** break;
                }
                case 79: {
                    this.stack.pop();
                    ** break;
                }
                case 80: {
                    right = this.stack.pop();
                    left = this.stack.pop();
                    if (left < right) {
                        this.stack.push(1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(0, currentPointer, this.currentFunc);
                    ** break;
                }
                case 81: {
                    right = this.stack.pop();
                    left = this.stack.pop();
                    if (left <= right) {
                        this.stack.push(1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(0, currentPointer, this.currentFunc);
                    ** break;
                }
                case 82: {
                    right = this.stack.pop();
                    left = this.stack.pop();
                    if (left > right) {
                        this.stack.push(1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(0, currentPointer, this.currentFunc);
                    ** break;
                }
                case 83: {
                    right = this.stack.pop();
                    left = this.stack.pop();
                    if (left >= right) {
                        this.stack.push(1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(0, currentPointer, this.currentFunc);
                    ** break;
                }
                case 84: {
                    right = this.stack.pop();
                    left = this.stack.pop();
                    if (left == right) {
                        this.stack.push(1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(0, currentPointer, this.currentFunc);
                    ** break;
                }
                case 85: {
                    right = this.stack.pop();
                    left = this.stack.pop();
                    if (left != right) {
                        this.stack.push(1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(0, currentPointer, this.currentFunc);
                    ** break;
                }
                case 86: {
                    value = this.stack.pop();
                    value = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(value)));
                    value = (value >> 6) % 2;
                    this.stack.push(value, currentPointer, this.currentFunc);
                    ** break;
                }
                case 87: {
                    value = this.stack.pop();
                    value = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(value)));
                    value = ((value >> 6) + 1) % 2;
                    this.stack.push(value, currentPointer, this.currentFunc);
                    ** break;
                }
                case 88: {
                    v88 = value = this.stack.pop() != 0;
                    if (!value) {
                        curr = 0;
                        nest = 0;
                        do {
                            if (curr == 89) {
                                --nest;
                            }
                            if ((curr = program[++currentPointer]) == 88) {
                                ++nest;
                            }
                            if (curr == 64) {
                                ++currentPointer;
                                currentPointer += program[currentPointer];
                                continue;
                            }
                            if (curr == 65) {
                                ++currentPointer;
                                currentPointer += program[currentPointer] * 2;
                                continue;
                            }
                            if (curr >= 176 && curr <= 183) {
                                currentPointer += curr + 1 - 176;
                                continue;
                            }
                            if (curr < 184 || curr > 191) continue;
                            currentPointer += (curr + 1 - 184) * 2;
                        } while (curr != 27 && curr != 89 || nest != 0);
                        ** break;
                    }
                    break;
                }
                case 89: {
                    ** break;
                }
                case 90: {
                    right = this.stack.pop() != 0;
                    v89 = left = this.stack.pop() != 0;
                    if (left && right) {
                        this.stack.push(1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(0, currentPointer, this.currentFunc);
                    ** break;
                }
                case 91: {
                    right = this.stack.pop() != 0;
                    v90 = left = this.stack.pop() != 0;
                    if (left || right) {
                        this.stack.push(1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(0, currentPointer, this.currentFunc);
                    ** break;
                }
                case 92: {
                    v91 = value = this.stack.pop() != 0;
                    if (!value) {
                        this.stack.push(1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(0, currentPointer, this.currentFunc);
                    ** break;
                }
                case 93: {
                    loop = this.stack.pop();
                    for (i = 0; i < loop; ++i) {
                        p = this.stack.pop();
                        arg = this.stack.pop();
                        ppem = gs.deltaBase + (arg >> 4);
                        if ((double)ppem != this.ppem) continue;
                        mag = (arg & 15) - 7;
                        if (mag <= 0) {
                            --mag;
                        }
                        pMove = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                        shift = gs.getFVMoveforPVDistance(pMove);
                        v92 = this.x[gs.zp0];
                        v93 = p;
                        v92[v93] = v92[v93] + shift[0];
                        v94 = this.y[gs.zp0];
                        v95 = p;
                        v94[v95] = v94[v95] + shift[1];
                        fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp0][p][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp0][p][1] = true;
                    }
                    break;
                }
                case 94: {
                    gs.deltaBase = this.stack.pop();
                    ** break;
                }
                case 95: {
                    gs.deltaShift = this.stack.pop();
                    ** break;
                }
                case 96: {
                    this.stack.push(this.stack.pop() + this.stack.pop(), currentPointer, this.currentFunc);
                    ** break;
                }
                case 97: {
                    right = this.stack.pop();
                    left = this.stack.pop();
                    this.stack.push(left - right, currentPointer, this.currentFunc);
                    ** break;
                }
                case 98: {
                    right = this.stack.pop();
                    left = this.stack.pop();
                    if (right != 0) {
                        this.stack.push(left * 64 / right, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(0, currentPointer, this.currentFunc);
                    ** break;
                }
                case 99: {
                    a = this.stack.pop();
                    b = this.stack.pop();
                    this.stack.push(a * b / 64, currentPointer, this.currentFunc);
                    ** break;
                }
                case 100: {
                    value = this.stack.pop();
                    if (value < 0) {
                        value = -value;
                    }
                    this.stack.push(value, currentPointer, this.currentFunc);
                    ** break;
                }
                case 101: {
                    this.stack.push(-this.stack.pop(), currentPointer, this.currentFunc);
                    ** break;
                }
                case 102: {
                    this.stack.push(this.stack.pop() >> 6 << 6, currentPointer, this.currentFunc);
                    ** break;
                }
                case 103: {
                    value = this.stack.pop();
                    if ((value & 63) != 0) {
                        value = (value >> 6) + 1 << 6;
                    }
                    this.stack.push(value, currentPointer, this.currentFunc);
                    ** break;
                }
                case 104: {
                    n = this.stack.pop();
                    n = TTVM.engineCompensation(n, 0);
                    num = TTVM.getDoubleFromF26Dot6(n);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(gs.round(num)), currentPointer, this.currentFunc);
                    ** break;
                }
                case 105: {
                    n = this.stack.pop();
                    n = TTVM.engineCompensation(n, 1);
                    num = TTVM.getDoubleFromF26Dot6(n);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(gs.round(num)), currentPointer, this.currentFunc);
                    ** break;
                }
                case 106: {
                    n = this.stack.pop();
                    n = TTVM.engineCompensation(n, 2);
                    num = TTVM.getDoubleFromF26Dot6(n);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(gs.round(num)), currentPointer, this.currentFunc);
                    ** break;
                }
                case 107: {
                    n = this.stack.pop();
                    n = TTVM.engineCompensation(n, 3);
                    num = TTVM.getDoubleFromF26Dot6(n);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(gs.round(num)), currentPointer, this.currentFunc);
                    ** break;
                }
                case 108: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 0), currentPointer, this.currentFunc);
                    ** break;
                }
                case 109: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 1), currentPointer, this.currentFunc);
                    ** break;
                }
                case 110: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 2), currentPointer, this.currentFunc);
                    ** break;
                }
                case 111: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 3), currentPointer, this.currentFunc);
                    ** break;
                }
                case 112: {
                    value = this.stack.pop();
                    key = this.stack.pop();
                    this.cvt.putInFUnits(key, value);
                    ** break;
                }
                case 113: {
                    loop = this.stack.pop();
                    for (i = 0; i < loop; ++i) {
                        p = this.stack.pop();
                        arg = this.stack.pop();
                        ppem = gs.deltaBase + 16 + (arg >> 4);
                        if ((double)ppem != this.ppem) continue;
                        mag = (arg & 15) - 7;
                        if (mag <= 0) {
                            --mag;
                        }
                        pMove = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                        shift = gs.getFVMoveforPVDistance(pMove);
                        v96 = this.x[gs.zp0];
                        v97 = p;
                        v96[v97] = v96[v97] + shift[0];
                        v98 = this.y[gs.zp0];
                        v99 = p;
                        v98[v99] = v98[v99] + shift[1];
                        fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp0][p][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp0][p][1] = true;
                    }
                    break;
                }
                case 114: {
                    loop = this.stack.pop();
                    for (i = 0; i < loop; ++i) {
                        p = this.stack.pop();
                        arg = this.stack.pop();
                        ppem = gs.deltaBase + 32 + (arg >> 4);
                        if ((double)ppem != this.ppem) continue;
                        mag = (arg & 15) - 7;
                        if (mag <= 0) {
                            --mag;
                        }
                        pMove = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                        shift = gs.getFVMoveforPVDistance(pMove);
                        v100 = this.x[gs.zp0];
                        v101 = p;
                        v100[v101] = v100[v101] + shift[0];
                        v102 = this.y[gs.zp0];
                        v103 = p;
                        v102[v103] = v102[v103] + shift[1];
                        fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp0][p][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp0][p][1] = true;
                    }
                    break;
                }
                case 115: {
                    loop = this.stack.pop();
                    for (i = 0; i < loop; ++i) {
                        cvtEntry = this.stack.pop();
                        arg = this.stack.pop();
                        ppem = gs.deltaBase + (arg >> 4);
                        if ((double)ppem != this.ppem) continue;
                        mag = (arg & 15) - 7;
                        if (mag <= 0) {
                            --mag;
                        }
                        change = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                        value = this.cvt.get(cvtEntry);
                        this.cvt.putInPixels(cvtEntry, value += change);
                    }
                    break;
                }
                case 116: {
                    loop = this.stack.pop();
                    for (i = 0; i < loop; ++i) {
                        cvtEntry = this.stack.pop();
                        arg = this.stack.pop();
                        ppem = gs.deltaBase + 16 + (arg >> 4);
                        if ((double)ppem != this.ppem) continue;
                        mag = (arg & 15) - 7;
                        if (mag <= 0) {
                            --mag;
                        }
                        change = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                        value = this.cvt.get(cvtEntry);
                        this.cvt.putInPixels(cvtEntry, value += change);
                    }
                    break;
                }
                case 117: {
                    loop = this.stack.pop();
                    for (i = 0; i < loop; ++i) {
                        cvtEntry = this.stack.pop();
                        arg = this.stack.pop();
                        ppem = gs.deltaBase + 32 + (arg >> 4);
                        if ((double)ppem != this.ppem) continue;
                        mag = (arg & 15) - 7;
                        if (mag <= 0) {
                            --mag;
                        }
                        change = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                        value = this.cvt.get(cvtEntry);
                        this.cvt.putInPixels(cvtEntry, value += change);
                    }
                    break;
                }
                case 118: {
                    gs.roundState = this.stack.pop();
                    gs.gridPeriod = 1.0;
                    ** break;
                }
                case 119: {
                    gs.roundState = this.stack.pop();
                    gs.gridPeriod = 0.7071067811865476;
                    ** break;
                }
                case 120: {
                    jump = this.stack.pop() != 0;
                    amount = this.stack.pop();
                    if (jump) {
                        currentPointer = currentPointer + amount - 1;
                        ** break;
                    }
                    break;
                }
                case 121: {
                    jump = this.stack.pop() != 0;
                    amount = this.stack.pop();
                    if (!jump) {
                        currentPointer = currentPointer + amount - 1;
                        ** break;
                    }
                    break;
                }
                case 122: {
                    gs.roundState = -1;
                    ** break;
                }
                case 124: {
                    gs.roundState = 64;
                    gs.gridPeriod = 1.0;
                    ** break;
                }
                case 125: {
                    gs.roundState = 68;
                    gs.gridPeriod = 1.0;
                    ** break;
                }
                case 126: {
                    this.stack.pop();
                    ** break;
                }
                case 127: {
                    this.stack.pop();
                    ** break;
                }
                case 128: {
                    for (i = 0; i < gs.loop; ++i) {
                        point = this.stack.pop();
                        this.curve[gs.zp0][point] = this.curve[gs.zp0][point] == false;
                    }
                    gs.loop = 1;
                    ** break;
                }
                case 129: {
                    high = this.stack.pop();
                    for (i = low = this.stack.pop(); i <= high; ++i) {
                        this.curve[gs.zp0][i] = true;
                    }
                    break;
                }
                case 130: {
                    high = this.stack.pop();
                    for (i = low = this.stack.pop(); i <= high; ++i) {
                        this.curve[gs.zp0][i] = false;
                    }
                    break;
                }
                case 133: {
                    this.stack.pop();
                    ** break;
                }
                case 134: {
                    p2 = this.stack.pop();
                    p1 = this.stack.pop();
                    xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp2][p2] - this.x[gs.zp1][p1]);
                    ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp2][p2] - this.y[gs.zp1][p1]);
                    dxdiff = TTVM.getDoubleFromF26Dot6(this.x[2 + gs.zp2][p2] - this.x[2 + gs.zp1][p1]);
                    dydiff = TTVM.getDoubleFromF26Dot6(this.y[2 + gs.zp2][p2] - this.y[2 + gs.zp1][p1]);
                    factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    dfactor = Math.sqrt(dxdiff * dxdiff + dydiff * dydiff);
                    gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(xdiff /= factor), TTVM.storeDoubleAsF2Dot14(ydiff /= factor));
                    gs.dualProjectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(dxdiff /= dfactor), TTVM.storeDoubleAsF2Dot14(dydiff /= dfactor));
                    ** break;
                }
                case 135: {
                    p2 = this.stack.pop();
                    p1 = this.stack.pop();
                    xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp2][p2] - this.x[gs.zp1][p1]);
                    ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp2][p2] - this.y[gs.zp1][p1]);
                    dxdiff = TTVM.getDoubleFromF26Dot6(this.x[2 + gs.zp2][p2] - this.x[2 + gs.zp1][p1]);
                    dydiff = TTVM.getDoubleFromF26Dot6(this.y[2 + gs.zp2][p2] - this.y[2 + gs.zp1][p1]);
                    factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    dfactor = Math.sqrt(dxdiff * dxdiff + dydiff * dydiff);
                    gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(ydiff /= factor), TTVM.storeDoubleAsF2Dot14(-(xdiff /= factor)));
                    gs.dualProjectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(dydiff /= dfactor), TTVM.storeDoubleAsF2Dot14(-(dxdiff /= dfactor)));
                    ** break;
                }
                case 136: {
                    selector = this.stack.pop();
                    result = 0;
                    if ((selector & 1) == 1) {
                        result += 3;
                    }
                    this.stack.push(result, currentPointer, this.currentFunc);
                    ** break;
                }
                case 137: {
                    func = this.stack.pop();
                    start = currentPointer;
                    while ((curr = program[++currentPointer]) != 45) {
                    }
                    len = currentPointer - start - 1;
                    currentPointer = start;
                    instruction = new int[len];
                    for (i = 0; i < len; ++i) {
                        instruction[i] = program[++currentPointer];
                    }
                    this.instructions.put(func, instruction);
                    ++currentPointer;
                    ** break;
                }
                case 138: {
                    top = this.stack.pop();
                    middle = this.stack.pop();
                    bottom = this.stack.pop();
                    this.stack.push(middle, currentPointer, this.currentFunc);
                    this.stack.push(top, currentPointer, this.currentFunc);
                    this.stack.push(bottom, currentPointer, this.currentFunc);
                    ** break;
                }
                case 139: {
                    value1 = this.stack.pop();
                    value2 = this.stack.pop();
                    if (value1 > value2) {
                        this.stack.push(value1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(value2, currentPointer, this.currentFunc);
                    ** break;
                }
                case 140: {
                    value1 = this.stack.pop();
                    value2 = this.stack.pop();
                    if (value1 < value2) {
                        this.stack.push(value1, currentPointer, this.currentFunc);
                        ** break;
                    }
                    this.stack.push(value2, currentPointer, this.currentFunc);
                    ** break;
                }
                case 141: {
                    this.stack.pop();
                    ** break;
                }
                case 142: {
                    s = this.stack.pop();
                    value = this.stack.pop();
                    if (s == 1) {
                        gs.instructControl = value;
                        ** break;
                    }
                    if (s == 2) {
                        this.useDefaultGS = value == 2;
                        ** break;
                    }
                    break;
                }
                case 176: {
                    if (this.printOut) {
                        System.out.println("PUSHB1    - Push bytes from IS to stack");
                    }
                    currentPointer = this.readFromIS(bytesToRead, false, currentPointer, program);
                    ** break;
                }
                case 184: {
                    if (this.printOut) {
                        System.out.println("PUSHW1    - Push words from IS to stack");
                    }
                    currentPointer = this.readFromIS(bytesToRead, true, currentPointer, program);
                    ** break;
                }
                default: {
                    if (code >= 192 && code < 224) {
                        args = code - 192;
                        if (this.printOut) {
                            System.out.println("MDRP      - Move direct relative point (" + Integer.toBinaryString(args) + ')');
                        }
                        setRP0toP = false;
                        useMinimumDistance = false;
                        roundDistance = false;
                        if ((args & 16) == 16) {
                            setRP0toP = true;
                        }
                        if ((args & 8) == 8) {
                            useMinimumDistance = true;
                        }
                        if ((args & 4) == 4) {
                            roundDistance = true;
                        }
                        distanceType = args & 3;
                        p = this.stack.pop();
                        originalDistance = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][p], this.y[2 + gs.zp1][p]) - TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][gs.rp0], this.y[2 + gs.zp0][gs.rp0]);
                        if (Math.abs(originalDistance) < gs.singleWidthCutIn) {
                            originalDistance = originalDistance > 0 ? gs.singleWidthValue : -gs.singleWidthValue;
                        }
                        originalDistance = TTVM.engineCompensation(originalDistance, distanceType);
                        if (roundDistance) {
                            originalDistance = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(originalDistance)));
                        }
                        if (useMinimumDistance && Math.abs(originalDistance) < gs.minimumDistance) {
                            originalDistance = originalDistance < 0 ? -gs.minimumDistance : gs.minimumDistance;
                        }
                        target = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0]) + originalDistance;
                        pVMove = target - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p], this.y[gs.zp1][p]);
                        shift = gs.getFVMoveforPVDistance(pVMove);
                        v104 = this.x[gs.zp1];
                        v105 = p;
                        v104[v105] = v104[v105] + shift[0];
                        v106 = this.y[gs.zp1];
                        v107 = p;
                        v106[v107] = v106[v107] + shift[1];
                        fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp1][p][0] = true;
                        }
                        if (fv[1] != 0) {
                            this.touched[gs.zp1][p][1] = true;
                        }
                        gs.rp1 = gs.rp0;
                        gs.rp2 = p;
                        if (setRP0toP) {
                            gs.rp0 = p;
                            ** break;
                        }
                        break;
                    }
                    if (code >= 224 && code <= 255) {
                        args = code - 224;
                        if (this.printOut) {
                            System.out.println("MIRP      - Move Indirect Relative Point(" + Integer.toBinaryString(args) + ')');
                        }
                        setRP0toP = (args & 16) == 16;
                        useMinimumDistance = (args & 8) == 8;
                        roundDistanceAndCheckCutIn = (args & 4) == 4;
                        distanceType = args & 3;
                        cvtEntry = this.cvt.get(this.stack.pop());
                        p = this.stack.pop();
                        distance = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][p], this.y[2 + gs.zp1][p]) - TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][gs.rp0], this.y[2 + gs.zp0][gs.rp0]);
                        if (Math.abs(distance - gs.singleWidthValue) < gs.singleWidthCutIn) {
                            distance = gs.singleWidthValue;
                        }
                        if (gs.zp1 == 0) {
                            this.x[2][p] = this.x[2 + gs.zp0][gs.rp0] + (int)(TTVM.getDoubleFromF2Dot14(TTGraphicsState.getVectorComponents(gs.freedomVector)[0]) * (double)cvtEntry);
                            this.x[0][p] = this.x[2][p];
                            this.y[2][p] = this.y[2 + gs.zp0][gs.rp0] + (int)(TTVM.getDoubleFromF2Dot14(TTGraphicsState.getVectorComponents(gs.freedomVector)[1]) * (double)cvtEntry);
                            this.y[0][p] = this.y[2][p];
                        }
                        if (gs.autoFlip && (distance < 0 && cvtEntry > 0 || distance > 0 && cvtEntry < 0)) {
                            cvtEntry = -cvtEntry;
                        }
                        if (roundDistanceAndCheckCutIn && gs.zp0 == gs.zp1 && (pMove = Math.abs(distance - cvtEntry)) < gs.controlValueTableCutIn) {
                            distance = cvtEntry;
                        }
                        distance = TTVM.engineCompensation(distance, distanceType);
                        if (roundDistanceAndCheckCutIn) {
                            distance = gs.round(distance);
                        }
                        if (useMinimumDistance && Math.abs(distance) < gs.minimumDistance) {
                            distance = distance > 0 ? gs.minimumDistance : -gs.minimumDistance;
                        }
                        target = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0]) + distance;
                        pVMove = target - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p], this.y[gs.zp1][p]);
                        shift = gs.getFVMoveforPVDistance(pVMove);
                        if (gs.zp1 == 0) {
                            v108 = this.x[2];
                            v109 = p;
                            v108[v109] = v108[v109] + shift[0];
                            v110 = this.y[2];
                            v111 = p;
                            v110[v111] = v110[v111] + shift[1];
                        }
                        v112 = this.x[gs.zp1];
                        v113 = p;
                        v112[v113] = v112[v113] + shift[0];
                        v114 = this.y[gs.zp1];
                        v115 = p;
                        v114[v115] = v114[v115] + shift[1];
                        fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp1][p][0] = true;
                        }
                        if (fv[1] != 0) {
                            this.touched[gs.zp1][p][1] = true;
                        }
                        gs.rp1 = gs.rp0;
                        gs.rp2 = p;
                        if (setRP0toP) {
                            gs.rp0 = p;
                            ** break;
                        }
                        break;
                    }
                    if (this.instructions.containsKey(code)) {
                        if (this.printOut) {
                            System.out.println("I 0x" + Integer.toHexString(code) + "    - Custom Instruction");
                        }
                        if (failed = this.execute(this.instructions.get(code), gs)) {
                            failedOnHinting = true;
                        }
                        if (this.printOut) {
                            System.out.println("I 0x" + Integer.toHexString(code) + " finished");
                            ** break;
                        }
                        break;
                    }
                    if (!LogWriter.isRunningFromIDE) break;
                    System.out.println("Unknown truetype opcode 0x" + Integer.toHexString(code) + " at line " + currentPointer);
lbl1370:
                    // 149 sources

                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage() + " at line " + currentPointer + "- hinting turned off");
            failedOnHinting = true;
        }
        if (failedOnHinting) {
            return -currentPointer;
        }
        return currentPointer;
    }

    private void interpolateUntouchedPoints(int direction) {
        int point;
        int i;
        int[] original;
        int[] points;
        boolean[] touched = new boolean[this.touched[1].length];
        if (direction == 49) {
            points = this.x[1];
            original = this.x[3];
            for (i = 0; i < this.touched[1].length; ++i) {
                touched[i] = this.touched[1][i][0];
            }
        } else {
            points = this.y[1];
            original = this.y[3];
            for (i = 0; i < this.touched[1].length; ++i) {
                touched[i] = this.touched[1][i][1];
            }
        }
        for (int contourStart = 0; contourStart < points.length; contourStart += point) {
            int[] touchedPointNumbers = new int[original.length];
            int touchedCount = 0;
            point = 0;
            do {
                if (!touched[contourStart + point]) continue;
                touchedPointNumbers[touchedCount] = contourStart + point;
                ++touchedCount;
            } while (!this.contour[1][contourStart + ++point - 1] && contourStart + point < this.contour[1].length);
            if (touchedCount == 1) {
                int shift = points[touchedPointNumbers[0]] - original[touchedPointNumbers[0]];
                for (int i2 = contourStart; i2 < contourStart + point; ++i2) {
                    if (touched[i2]) continue;
                    int n = i2;
                    points[n] = points[n] + shift;
                }
                continue;
            }
            if (touchedCount <= 1) continue;
            for (int i3 = 0; i3 < touchedCount; ++i3) {
                if (i3 + 1 >= touchedCount) {
                    TTVM.interpolateRange(touchedPointNumbers[i3] + 1, contourStart + point - 1, touchedPointNumbers[i3], touchedPointNumbers[0], points, original);
                    TTVM.interpolateRange(contourStart, touchedPointNumbers[0] - 1, touchedPointNumbers[i3], touchedPointNumbers[0], points, original);
                    continue;
                }
                TTVM.interpolateRange(touchedPointNumbers[i3] + 1, touchedPointNumbers[i3 + 1] - 1, touchedPointNumbers[i3], touchedPointNumbers[i3 + 1], points, original);
            }
        }
    }

    private static void interpolateRange(int start, int end, int ref1, int ref2, int[] points, int[] original) {
        int higherRef;
        int lowerRef;
        if (original[ref2] < original[ref1]) {
            lowerRef = ref2;
            higherRef = ref1;
        } else {
            lowerRef = ref1;
            higherRef = ref2;
        }
        for (int i = start; i <= end; ++i) {
            if (original[i] < original[lowerRef]) {
                int n = i;
                points[n] = points[n] + (points[lowerRef] - original[lowerRef]);
                continue;
            }
            if (original[i] > original[higherRef]) {
                int n = i;
                points[n] = points[n] + (points[higherRef] - original[higherRef]);
                continue;
            }
            double pos = (double)(original[i] - original[lowerRef]) / (double)(original[higherRef] - original[lowerRef]);
            points[i] = points[lowerRef] + (int)(pos * (double)(points[higherRef] - points[lowerRef]));
        }
    }

    private static int engineCompensation(int num, int characteristics) {
        switch (characteristics) {
            default: 
        }
        return num;
    }

    private int readFromIS(int number, boolean readWord, int currentPointer, int[] program) {
        for (int i = 0; i < number; ++i) {
            int data;
            ++currentPointer;
            if (!readWord) {
                data = program[currentPointer];
            } else {
                int d1 = program[currentPointer];
                int d2 = program[++currentPointer];
                data = TTVM.getIntFrom2Uint8(d1, d2);
            }
            this.stack.push(data, currentPointer, this.currentFunc);
        }
        return currentPointer;
    }

    private static int getIntFrom2Uint8(int high, int low) {
        return (high << 8) + low + (high >> 7 & 1) * -65536;
    }

    static double getDoubleFromF26Dot6(int a) {
        return (double)a / 64.0;
    }

    static double getDoubleFromF2Dot14(int a) {
        return (double)a / 16384.0;
    }

    static int storeDoubleAsF26Dot6(double a) {
        return (int)(a * 64.0 + 0.5);
    }

    private static int storeDoubleAsF2Dot14(double a) {
        return (int)(a * 16384.0 + 0.5);
    }

    private static int[] readProgramTable(FontFile2 currentFontFile, int table) {
        int[] program = new int[]{};
        int startPointer = currentFontFile.selectTable(table);
        if (startPointer == 0) {
            LogWriter.writeLog("No program table found: " + table);
        } else {
            int len = currentFontFile.getOffset(table);
            program = new int[len];
            for (int i = 0; i < len; ++i) {
                program[i] = currentFontFile.getNextUint8();
            }
        }
        return program;
    }

    private void runDebugger() {
        if (this.programToDebug == null) {
            JOptionPane.showMessageDialog(this.debugWindow, "No glyph program found to debug!");
            return;
        }
        this.debugWindow = new JFrame("TrueType Hinting Debugger");
        this.debugWindow.setSize(1000, 700);
        this.debugWindow.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton stepOverButton = new JButton("Step Over");
        stepOverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTVM.this.advanceDebugger(false);
            }
        });
        buttonPanel.add(stepOverButton);
        JButton stepIntoButton = new JButton("Step Into");
        stepIntoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTVM.this.advanceDebugger(true);
            }
        });
        buttonPanel.add(stepIntoButton);
        this.stepOutButton = new JButton("Step Out");
        this.stepOutButton.setEnabled(false);
        this.stepOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTVM.this.runDebuggerTo(TTVM.this.programToDebug.length);
            }
        });
        buttonPanel.add(this.stepOutButton);
        JButton restartButton = new JButton("Restart");
        restartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTVM.this.restartDebugger();
                TTVM.this.refreshDebugger(true);
            }
        });
        buttonPanel.add(restartButton);
        JButton backButton = new JButton("Back");
        backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTVM.this.runDebuggerTo(TTVM.this.debugPointer - 1);
            }
        });
        buttonPanel.add(backButton);
        this.debugWindow.add("North", buttonPanel);
        JPanel instructionPanel = new JPanel();
        instructionPanel.setLayout(new BorderLayout());
        instructionPanel.setBorder(new LineBorder(Color.BLACK));
        currentInstructionList = new JList();
        for (MouseMotionListener mouseMotionListener : currentInstructionList.getMouseMotionListeners()) {
            currentInstructionList.removeMouseMotionListener(mouseMotionListener);
        }
        for (EventListener eventListener : currentInstructionList.getMouseListeners()) {
            currentInstructionList.removeMouseListener((MouseListener)eventListener);
        }
        JScrollPane codePane = new JScrollPane(currentInstructionList){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                Dimension min = this.getMinimumSize();
                int w = pref.width < min.width ? min.width : pref.width;
                int h = pref.height < min.height ? min.height : pref.height;
                return new Dimension(w, h);
            }
        };
        codePane.setMinimumSize(new Dimension(150, 100));
        this.currentCode = new JLabel("Glyph program");
        instructionPanel.add("Center", codePane);
        instructionPanel.add("South", this.currentCode);
        this.debugWindow.add("West", instructionPanel);
        final JPanel glyphPanel = new JPanel();
        glyphPanel.setLayout(new BorderLayout());
        glyphPanel.setBorder(new LineBorder(Color.BLACK));
        this.debugGlyphDisplay = new JComponent(){

            @Override
            public void paint(Graphics g) {
                int val;
                int i;
                Graphics2D g2 = (Graphics2D)g;
                int w = this.getWidth();
                int h = this.getHeight();
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (i = 0; i < TTVM.this.x[1].length; ++i) {
                    val = TTVM.this.x[1][i];
                    if (val > maxX) {
                        maxX = val;
                    }
                    if (val < minX) {
                        minX = val;
                    }
                    if ((val = TTVM.this.y[1][i]) > maxY) {
                        maxY = val;
                    }
                    if (val >= minY) continue;
                    minY = val;
                }
                for (i = 0; i < TTVM.this.x[0].length; ++i) {
                    val = TTVM.this.x[0][i];
                    if (val > maxX) {
                        maxX = val;
                    }
                    if (val < minX) {
                        minX = val;
                    }
                    if ((val = TTVM.this.y[0][i]) > maxY) {
                        maxY = val;
                    }
                    if (val >= minY) continue;
                    minY = val;
                }
                int xRange = maxX - minX;
                double xScale = (double)w / (double)xRange;
                int yRange = maxY - minY;
                double yScale = (double)h / (double)yRange;
                double scale = xScale < yScale ? xScale : yScale;
                int borderWidth = 15;
                minX = (int)((double)minX - 15.0 / scale);
                maxX = (int)((double)maxX + 15.0 / scale);
                minY = (int)((double)minY - 15.0 / scale);
                maxY = (int)((double)maxY + 15.0 / scale);
                xRange = maxX - minX;
                yRange = maxY - minY;
                xScale = (double)w / (double)xRange;
                yScale = (double)h / (double)yRange;
                scale = xScale < yScale ? xScale : yScale;
                g2.translate(0, h);
                g2.scale(scale, -scale);
                g2.translate(-minX, -minY);
                g2.setPaint(Color.WHITE);
                g2.fillRect(minX, minY, (int)((double)w / scale), (int)((double)h / scale));
                g2.setPaint(new Color(180, 180, 255));
                g2.drawLine(0, minY, 0, (int)((double)h / scale));
                g2.drawLine(minX, 0, (int)((double)w / scale), 0);
                int len = (int)(3.0 / scale);
                for (int i2 = 0; i2 < TTVM.this.x[1].length; ++i2) {
                    int xVal = TTVM.this.x[1][i2];
                    int yVal = TTVM.this.y[1][i2];
                    if (TTVM.this.curve[1][i2]) {
                        g2.setPaint(Color.BLACK);
                        Ellipse2D.Double s = new Ellipse2D.Double((double)xVal - 2.0 / scale, (double)yVal - 2.0 / scale, 4.0 / scale, 4.0 / scale);
                        g2.fill(s);
                    } else {
                        g2.setPaint(Color.RED);
                        g2.drawLine(xVal - len, yVal - len, xVal + len, yVal + len);
                        g2.drawLine(xVal + len, yVal - len, xVal - len, yVal + len);
                    }
                    AffineTransform store = g2.getTransform();
                    g2.translate(xVal, yVal);
                    g2.scale(1.0 / scale, -1.0 / scale);
                    g2.drawString(String.valueOf(i2), 3, -3);
                    g2.setTransform(store);
                }
                if (TTVM.this.showInterpolatedShadow.isSelected()) {
                    int c = TTVM.this.x[1].length;
                    int[] xStore = new int[c];
                    System.arraycopy(TTVM.this.x[1], 0, xStore, 0, c);
                    int[] yStore = new int[c];
                    System.arraycopy(TTVM.this.y[1], 0, yStore, 0, c);
                    boolean[] curveStore = new boolean[c];
                    System.arraycopy(TTVM.this.curve[1], 0, curveStore, 0, c);
                    boolean[] contourStore = new boolean[c];
                    System.arraycopy(TTVM.this.contour[1], 0, contourStore, 0, c);
                    TTVM.this.interpolateUntouchedPoints(48);
                    TTVM.this.interpolateUntouchedPoints(49);
                    GeneralPath shape = TTVM.getPathFromPoints(TTVM.this.x[1], TTVM.this.y[1], TTVM.this.curve[1], TTVM.this.contour[1]);
                    g2.setPaint(new Color(255, 0, 0, 100));
                    g2.draw(shape);
                    g2.setPaint(new Color(0, 0, 0, 30));
                    g2.fill(shape);
                    System.arraycopy(xStore, 0, TTVM.this.x[1], 0, c);
                    System.arraycopy(yStore, 0, TTVM.this.y[1], 0, c);
                    System.arraycopy(curveStore, 0, TTVM.this.curve[1], 0, c);
                    System.arraycopy(contourStore, 0, TTVM.this.contour[1], 0, c);
                }
                GeneralPath shape = TTVM.getPathFromPoints(TTVM.this.x[1], TTVM.this.y[1], TTVM.this.curve[1], TTVM.this.contour[1]);
                g2.setPaint(new Color(100, 100, 255, 100));
                g2.fill(shape);
                g2.setPaint(Color.BLACK);
                g2.draw(shape);
                g2.setPaint(Color.BLUE);
                for (int i3 = 0; i3 < TTVM.this.x[0].length; ++i3) {
                    int xVal = TTVM.this.x[0][i3];
                    int yVal = TTVM.this.y[0][i3];
                    if (xVal == 0 && yVal == 0) continue;
                    if (TTVM.this.curve[0][i3]) {
                        Ellipse2D.Double s = new Ellipse2D.Double((double)xVal - 2.0 / scale, (double)yVal - 2.0 / scale, 4.0 / scale, 4.0 / scale);
                        g2.fill(s);
                    } else {
                        g2.drawLine(xVal - len, yVal - len, xVal + len, yVal + len);
                        g2.drawLine(xVal + len, yVal - len, xVal - len, yVal + len);
                    }
                    AffineTransform store = g2.getTransform();
                    g2.translate(xVal, yVal);
                    g2.scale(1.0 / scale, -1.0 / scale);
                    g2.drawString(String.valueOf(i3), 3, -3);
                    g2.setTransform(store);
                }
            }
        };
        this.debugGlyphDisplay.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                double eX = e.getX();
                double eY = e.getY();
                int w = TTVM.this.debugGlyphDisplay.getWidth();
                int h = TTVM.this.debugGlyphDisplay.getHeight();
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (int i = 0; i < TTVM.this.x[1].length; ++i) {
                    int val = TTVM.this.x[1][i];
                    if (val > maxX) {
                        maxX = val;
                    }
                    if (val < minX) {
                        minX = val;
                    }
                    if ((val = TTVM.this.y[1][i]) > maxY) {
                        maxY = val;
                    }
                    if (val >= minY) continue;
                    minY = val;
                }
                int xRange = maxX - minX;
                double xScale = (double)w / (double)xRange;
                int yRange = maxY - minY;
                double yScale = (double)h / (double)yRange;
                double scale = xScale < yScale ? xScale : yScale;
                int borderWidth = 15;
                minX = (int)((double)minX - 15.0 / scale);
                maxX = (int)((double)maxX + 15.0 / scale);
                minY = (int)((double)minY - 15.0 / scale);
                maxY = (int)((double)maxY + 15.0 / scale);
                xRange = maxX - minX;
                yRange = maxY - minY;
                xScale = (double)w / (double)xRange;
                yScale = (double)h / (double)yRange;
                scale = xScale < yScale ? xScale : yScale;
                eX = eX / scale + (double)minX;
                eY = (double)h - eY;
                eY = eY / scale + (double)minY;
                TTVM.this.debugXLabel.setText("  X: " + eX);
                TTVM.this.debugYLabel.setText("  Y: " + eY);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TTVM.this.debugXLabel.setText("  X: ");
                TTVM.this.debugYLabel.setText("  Y: ");
            }
        });
        glyphPanel.add("Center", this.debugGlyphDisplay);
        this.showInterpolatedShadow = new JCheckBox("Show Interpolated Shadow");
        this.showInterpolatedShadow.setSelected(true);
        this.showInterpolatedShadow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                glyphPanel.repaint();
            }
        });
        glyphPanel.add("North", this.showInterpolatedShadow);
        this.debugWindow.add("Center", glyphPanel);
        JPanel dataPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                Dimension min = this.getMinimumSize();
                Dimension max = this.getMaximumSize();
                int w = pref.width < min.width ? min.width : pref.width;
                int h = pref.height < min.height ? min.height : pref.height;
                w = w > max.width ? max.width : w;
                h = h > max.height ? max.height : h;
                return new Dimension(w, h);
            }
        };
        dataPanel.setMinimumSize(new Dimension(200, 100));
        dataPanel.setMaximumSize(new Dimension(200, 1000000));
        dataPanel.setLayout(new BorderLayout());
        dataPanel.setBorder(new LineBorder(Color.BLACK));
        JPanel jPanel = new JPanel(new BorderLayout());
        stackList = new JList();
        stackList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int i = stackList.locationToIndex(e.getPoint());
                if (i >= 0) {
                    stackList.setToolTipText("Pushed by " + TTVM.this.stack.getPushedBy(i));
                }
            }
        });
        JScrollPane stackScroll = new JScrollPane(stackList);
        jPanel.add("North", new JLabel("Stack:"));
        jPanel.add("Center", stackScroll);
        JPanel cvtPanel = new JPanel(new BorderLayout());
        cvtList = new JList<String>(this.cvt.getCVTForDebug());
        JScrollPane cvtScroll = new JScrollPane(cvtList);
        cvtPanel.add("North", new JLabel("CVT:"));
        cvtPanel.add("Center", cvtScroll);
        JPanel storagePanel = new JPanel(new BorderLayout());
        storageList = new JList<String>(this.getStorageAsArray());
        JScrollPane storageScroll = new JScrollPane(storageList);
        storagePanel.add("North", new JLabel("Storage:"));
        storagePanel.add("Center", storageScroll);
        dataPanel.add("North", jPanel);
        dataPanel.add("Center", cvtPanel);
        dataPanel.add("South", storagePanel);
        this.debugWindow.add("East", dataPanel);
        JPanel statePanel = new JPanel();
        statePanel.setLayout(new BorderLayout());
        statePanel.setBorder(new LineBorder(Color.BLACK));
        this.stateDisplay = new JComponent(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(Color.WHITE);
                g2.fillRect(0, 0, 81, 81);
                g2.setPaint(Color.BLACK);
                g2.drawRect(0, 0, 81, 81);
                g2.setPaint(Color.GRAY);
                g2.drawOval(0, 0, 81, 81);
                g2.drawLine(0, 40, 5, 40);
                g2.drawLine(81, 40, 76, 40);
                g2.drawLine(40, 0, 40, 5);
                g2.drawLine(40, 81, 40, 76);
                g2.drawLine(12, 12, 15, 15);
                g2.drawLine(69, 12, 66, 15);
                g2.drawLine(12, 69, 15, 66);
                g2.drawLine(69, 69, 66, 66);
                g2.setPaint(new Color(0, 100, 0));
                int[] vec = TTGraphicsState.getVectorComponents(((TTVM)TTVM.this).dGS.freedomVector);
                g2.drawLine(40, 40, 40 + vec[0] * 40 / 16384, 40 - vec[1] * 40 / 16384);
                g2.drawString("Freedom Vector", 84, 13);
                g2.drawString("(" + (double)vec[0] / 16384.0 + ", " + (double)vec[1] / 16384.0 + ')', 98, 23);
                g2.setPaint(Color.BLUE);
                vec = TTGraphicsState.getVectorComponents(((TTVM)TTVM.this).dGS.dualProjectionVector);
                g2.drawLine(41, 41, 41 + vec[0] * 40 / 16384, 41 - vec[1] * 40 / 16384);
                g2.drawString("Dual Projection Vector", 84, 65);
                g2.drawString("(" + (double)vec[0] / 16384.0 + ", " + (double)vec[1] / 16384.0 + ')', 98, 75);
                g2.setPaint(Color.MAGENTA);
                vec = TTGraphicsState.getVectorComponents(((TTVM)TTVM.this).dGS.projectionVector);
                g2.drawLine(41, 41, 41 + vec[0] * 40 / 16384, 41 - vec[1] * 40 / 16384);
                g2.drawString("Projection Vector", 84, 39);
                g2.drawString("(" + (double)vec[0] / 16384.0 + ", " + (double)vec[1] / 16384.0 + ')', 98, 49);
                g2.setPaint(Color.GRAY);
                g2.drawLine(240, 4, 240, 77);
                g2.setPaint(Color.BLACK);
                g2.drawString("zp0: " + ((TTVM)TTVM.this).dGS.zp0 + (((TTVM)TTVM.this).dGS.zp0 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 13);
                g2.drawString("zp1: " + ((TTVM)TTVM.this).dGS.zp1 + (((TTVM)TTVM.this).dGS.zp1 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 25);
                g2.drawString("zp2: " + ((TTVM)TTVM.this).dGS.zp2 + (((TTVM)TTVM.this).dGS.zp2 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 37);
                g2.drawString("rp0: " + ((TTVM)TTVM.this).dGS.rp0, 250, 51);
                g2.drawString("rp1: " + ((TTVM)TTVM.this).dGS.rp1, 250, 63);
                g2.drawString("rp2: " + ((TTVM)TTVM.this).dGS.rp2, 250, 75);
                g2.setPaint(Color.GRAY);
                g2.drawLine(404, 4, 404, 77);
                g2.setPaint(Color.BLACK);
                g2.drawString("Instruct Control: " + ((TTVM)TTVM.this).dGS.instructControl, 414, 13);
                g2.drawString("Auto Flip: " + ((TTVM)TTVM.this).dGS.autoFlip, 414, 30);
                g2.drawString("Delta Base: " + ((TTVM)TTVM.this).dGS.deltaBase, 414, 47);
                g2.drawString("Delta Shift: " + ((TTVM)TTVM.this).dGS.deltaShift, 414, 59);
                g2.drawString("Loop: " + ((TTVM)TTVM.this).dGS.loop, 414, 75);
                g2.setPaint(Color.GRAY);
                g2.drawLine(548, 4, 548, 77);
                g2.setPaint(Color.BLACK);
                g2.drawString("Round State: " + TTVM.this.dGS.getRoundStateAsString(), 558, 13);
                g2.drawString("Minimum Distance: " + ((TTVM)TTVM.this).dGS.minimumDistance, 558, 30);
                g2.drawString("CVT Cut In: " + ((TTVM)TTVM.this).dGS.controlValueTableCutIn, 558, 46);
                g2.drawString("Single Width Cut In: " + ((TTVM)TTVM.this).dGS.singleWidthCutIn, 558, 63);
                g2.drawString("Single Width Value: " + ((TTVM)TTVM.this).dGS.singleWidthValue, 558, 75);
            }
        };
        this.stateDisplay.setMinimumSize(new Dimension(700, 81));
        this.stateDisplay.setPreferredSize(new Dimension(700, 81));
        this.stateDisplay.setMaximumSize(new Dimension(700, 81));
        statePanel.add("West", this.stateDisplay);
        JPanel mousePanel = new JPanel();
        mousePanel.setLayout(new GridLayout(0, 1));
        this.debugXLabel = new JLabel("  X: "){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                Dimension min = this.getMinimumSize();
                int w = pref.width < min.width ? min.width : pref.width;
                int h = pref.height < min.height ? min.height : pref.height;
                return new Dimension(w, h);
            }
        };
        this.debugXLabel.setBackground(Color.WHITE);
        this.debugXLabel.setOpaque(true);
        this.debugXLabel.setBorder(new LineBorder(Color.BLACK));
        this.debugXLabel.setMinimumSize(new Dimension(200, 20));
        this.debugYLabel = new JLabel("  Y: ");
        this.debugYLabel.setBackground(Color.WHITE);
        this.debugYLabel.setOpaque(true);
        this.debugYLabel.setBorder(new LineBorder(Color.BLACK));
        this.debugYLabel.setMinimumSize(new Dimension(200, 20));
        mousePanel.add(this.debugXLabel);
        mousePanel.add(this.debugYLabel);
        statePanel.add("East", mousePanel);
        this.debugWindow.add("South", statePanel);
        try {
            this.dGS = (TTGraphicsState)this.graphicsState.clone();
        }
        catch (CloneNotSupportedException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        this.stack = new Stack();
        int twilightCount = this.maxp.getMaxTwilightPoints();
        System.arraycopy(this.x[3], 0, this.x[1], 0, this.x[1].length);
        this.x[0] = new int[twilightCount];
        this.x[2] = new int[twilightCount];
        System.arraycopy(this.y[3], 0, this.y[1], 0, this.y[1].length);
        this.y[0] = new int[twilightCount];
        this.y[2] = new int[twilightCount];
        System.arraycopy(this.touched[3], 0, this.touched[1], 0, this.touched[1].length);
        this.touched[0] = new boolean[twilightCount][2];
        this.touched[2] = new boolean[twilightCount][2];
        this.refreshDebugger(true);
        this.debugWindow.setVisible(true);
    }

    private static int midPt(int a, int b) {
        return a + (b - a) / 2;
    }

    private static GeneralPath getPathFromPoints(int[] x, int[] y, boolean[] curve, boolean[] contour) {
        int ptCount = x.length;
        int[] pX = new int[ptCount];
        System.arraycopy(x, 0, pX, 0, ptCount);
        int[] pY = new int[ptCount];
        System.arraycopy(y, 0, pY, 0, ptCount);
        boolean[] endOfContour = new boolean[ptCount];
        System.arraycopy(contour, 0, endOfContour, 0, ptCount);
        boolean[] onCurve = new boolean[ptCount];
        System.arraycopy(curve, 0, onCurve, 0, ptCount);
        int start = 0;
        int firstPt = -1;
        for (int ii = 0; ii < ptCount; ++ii) {
            if (endOfContour[ii]) {
                if (!(firstPt == -1 || onCurve[start] && onCurve[ii])) {
                    TTVM.resetValues(pX, pY, onCurve, start, firstPt, ii);
                }
                start = ii + 1;
                firstPt = -1;
                continue;
            }
            if (!onCurve[ii] || firstPt != -1) continue;
            firstPt = ii;
        }
        int c = pX.length;
        int fc = -1;
        for (int jj = 0; jj < c; ++jj) {
            if (!endOfContour[jj]) continue;
            fc = jj + 1;
            jj = c;
        }
        return TTVM.processPoints(ptCount, pX, pY, endOfContour, onCurve, c, fc);
    }

    private static GeneralPath processPoints(int ptCount, int[] pX, int[] pY, boolean[] endOfContour, boolean[] onCurve, int c, int fc) {
        boolean isFirstDraw = true;
        GeneralPath current_path = new GeneralPath(1);
        int x2 = 0;
        int y2 = 0;
        int x3 = 0;
        int y3 = 0;
        int x1 = pX[0];
        int y1 = pY[0];
        current_path.moveTo(x1, y1);
        int xs = 0;
        int ys = 0;
        int lc = 0;
        boolean isEnd = false;
        for (int j = 0; j < ptCount; ++j) {
            int p = j % fc;
            int p1 = (j + 1) % fc;
            int p2 = (j + 2) % fc;
            int pm1 = (j - 1) % fc;
            if (j == 0) {
                pm1 = fc - 1;
            }
            if (p1 < lc) {
                p1 += lc;
            }
            if (p2 < lc) {
                p2 += lc;
            }
            if (endOfContour[j]) {
                isEnd = true;
                if (onCurve[fc]) {
                    xs = pX[fc];
                    ys = pY[fc];
                } else {
                    xs = pX[j + 1];
                    ys = pY[j + 1];
                }
                lc = fc;
                for (int jj = j + 1; jj < c; ++jj) {
                    if (!endOfContour[jj]) continue;
                    fc = jj + 1;
                    jj = c;
                }
            }
            if (lc == fc && onCurve[p]) {
                j = c;
                continue;
            }
            if (onCurve[p] && onCurve[p1]) {
                x3 = pX[p1];
                y3 = pY[p1];
                current_path.lineTo(x3, y3);
                isFirstDraw = false;
            } else if (j < c - 3 && (fc - lc > 1 || fc == lc)) {
                boolean checkEnd = false;
                if (onCurve[p] && !onCurve[p1] && onCurve[p2]) {
                    x1 = pX[p];
                    y1 = pY[p];
                    x2 = pX[p1];
                    y2 = pY[p1];
                    x3 = pX[p2];
                    y3 = pY[p2];
                    ++j;
                    checkEnd = true;
                } else if (onCurve[p] && !onCurve[p1] && !onCurve[p2]) {
                    x1 = pX[p];
                    y1 = pY[p];
                    x2 = pX[p1];
                    y2 = pY[p1];
                    x3 = TTVM.midPt(pX[p1], pX[p2]);
                    y3 = TTVM.midPt(pY[p1], pY[p2]);
                    ++j;
                    checkEnd = true;
                } else if (!(onCurve[p] || onCurve[p1] || endOfContour[p2] && fc - p2 != 1)) {
                    x1 = TTVM.midPt(pX[pm1], pX[p]);
                    y1 = TTVM.midPt(pY[pm1], pY[p]);
                    x2 = pX[p];
                    y2 = pY[p];
                    x3 = TTVM.midPt(pX[p], pX[p1]);
                    y3 = TTVM.midPt(pY[p], pY[p1]);
                } else if (!onCurve[p] && onCurve[p1]) {
                    x1 = TTVM.midPt(pX[pm1], pX[p]);
                    y1 = TTVM.midPt(pY[pm1], pY[p]);
                    x2 = pX[p];
                    y2 = pY[p];
                    x3 = pX[p1];
                    y3 = pY[p1];
                }
                if (isFirstDraw) {
                    current_path.moveTo(x1, y1);
                    isFirstDraw = false;
                }
                if (!endOfContour[p] || p <= 0 || !endOfContour[p - 1]) {
                    current_path.curveTo(x1, y1, x2, y2, x3, y3);
                }
                if (checkEnd && endOfContour[j]) {
                    isEnd = true;
                    xs = pX[fc];
                    ys = pY[fc];
                    lc = fc;
                    for (int jj = j + 1; jj < c; ++jj) {
                        if (!endOfContour[jj]) continue;
                        fc = jj + 1;
                        jj = c;
                    }
                }
            }
            if (endOfContour[p]) {
                current_path.closePath();
            }
            if (!isEnd) continue;
            current_path.moveTo(xs, ys);
            isEnd = false;
        }
        return current_path;
    }

    private static void resetValues(int[] pX, int[] pY, boolean[] onCurve, int start, int firstPt, int ii) {
        int diff = firstPt - start;
        int pXlength = pX.length;
        int[] old_pX = new int[pXlength];
        System.arraycopy(pX, 0, old_pX, 0, pXlength);
        int[] old_pY = new int[pXlength];
        System.arraycopy(pY, 0, old_pY, 0, pXlength);
        boolean[] old_onCurve = new boolean[pXlength];
        System.arraycopy(onCurve, 0, old_onCurve, 0, pXlength);
        for (int oldPos = start; oldPos < ii + 1; ++oldPos) {
            int newPos = oldPos + diff;
            if (newPos > ii) {
                newPos -= ii - start + 1;
            }
            pX[oldPos] = old_pX[newPos];
            pY[oldPos] = old_pY[newPos];
            onCurve[oldPos] = old_onCurve[newPos];
        }
    }

    private void runDebuggerTo(int targetPointer) {
        if (targetPointer == this.debugPointer) {
            return;
        }
        int targetInstr = targetPointer;
        int diff = -1;
        if (targetInstr >= 0) {
            int add = 0;
            if (targetInstr >= this.programToDebug.length) {
                add = targetInstr - (this.programToDebug.length - 1);
                targetInstr = this.programToDebug.length - 1;
            }
            while (this.programToDebugIsData[targetInstr]) {
                --targetInstr;
            }
            diff = targetInstr - this.debugPointer + add;
        }
        int target = this.instructionsExecuted + diff;
        boolean skipFunctions = true;
        if (target < this.instructionsExecuted) {
            this.restartDebugger();
            skipFunctions = false;
        }
        int startLineCount = this.functionsLineCount;
        this.debuggerRunningInBackground = true;
        while (this.instructionsExecuted < target + (skipFunctions ? this.functionsLineCount - startLineCount : 0)) {
            this.stepInto = true;
            this.debugPointer = this.process(this.programToDebug[this.debugPointer], this.debugPointer, this.programToDebug, this.dGS);
            if (!this.stepInto && this.debugPointer < 0) {
                this.debugPointer = -this.debugPointer;
            }
            ++this.debugPointer;
            if (this.debugPointer != this.programToDebug.length || this.codeStack.empty()) continue;
            this.setCurrentCodeForDebug(this.codeStack.pop(), this.numberStack.pop() + 1, false);
        }
        this.debuggerRunningInBackground = false;
        this.setCurrentCodeForDebug(this.programToDebug, this.debugPointer, true);
        this.stepInto = false;
        this.instructionsExecuted = target;
    }

    private void restartDebugger() {
        this.stack = new Stack();
        try {
            this.dGS = (TTGraphicsState)this.graphicsState.clone();
            this.graphicsState.resetForGlyph();
        }
        catch (CloneNotSupportedException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        int twilightCount = this.maxp.getMaxTwilightPoints();
        System.arraycopy(this.x[3], 0, this.x[1], 0, this.x[1].length);
        this.x[0] = new int[twilightCount];
        this.x[2] = new int[twilightCount];
        System.arraycopy(this.y[3], 0, this.y[1], 0, this.y[1].length);
        this.y[0] = new int[twilightCount];
        this.y[2] = new int[twilightCount];
        System.arraycopy(this.touched[3], 0, this.touched[1], 0, this.touched[1].length);
        this.touched[0] = new boolean[twilightCount][2];
        this.touched[2] = new boolean[twilightCount][2];
        this.fontProgramRun = false;
        this.setScaleVars(this.scaler, this.ppem, this.ptSize);
        if (!this.codeStack.isEmpty()) {
            this.programToDebug = (int[])this.codeStack.get(0);
            this.programToDebugIsData = TTVM.getInstructionStreamIsData(this.programToDebug);
        }
        this.codeStack.clear();
        this.numberStack.clear();
        this.functionsLineCount = 0;
        this.debugPointer = 0;
        this.instructionsExecuted = 0;
        this.currentCode.setText("Glyph Program");
        this.stepOutButton.setEnabled(false);
    }

    private void advanceDebugger(final boolean stepIntoCall) {
        if (this.debugPointer < this.programToDebug.length) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    TTVM.this.stepInto = stepIntoCall;
                    TTVM.this.debugPointer = TTVM.this.process(TTVM.this.programToDebug[TTVM.this.debugPointer], TTVM.this.debugPointer, TTVM.this.programToDebug, TTVM.this.dGS);
                    if (!TTVM.this.stepInto && TTVM.this.debugPointer < 0) {
                        TTVM.this.debugPointer = -TTVM.this.debugPointer;
                    }
                    TTVM.this.stepInto = false;
                    TTVM.this.debugPointer++;
                    TTVM.this.refreshDebugger(false);
                    while (TTVM.this.debugPointer == TTVM.this.programToDebug.length && !TTVM.this.codeStack.empty()) {
                        TTVM.this.setCurrentCodeForDebug((int[])TTVM.this.codeStack.pop(), (Integer)TTVM.this.numberStack.pop() + 1, true);
                    }
                }
            };
            SwingUtilities.invokeLater(t);
        }
    }

    private String[] getStorageAsArray() {
        String[] result = new String[this.storage.length];
        for (int i = 0; i < this.storage.length; ++i) {
            result[i] = i + ": " + this.storage[i] + "       (" + NumberFormat.getNumberInstance().format((double)this.storage[i] / 64.0) + ')';
        }
        return result;
    }

    private void refreshDebugger(boolean programHasChanged) {
        if (programHasChanged) {
            currentInstructionList.setListData(TTVM.getInstructionsAsStringArray(this.programToDebug));
        }
        int start = this.debugPointer;
        int end = this.debugPointer;
        while (end + 1 < this.programToDebug.length && this.programToDebugIsData[end + 1]) {
            ++end;
        }
        currentInstructionList.setSelectionInterval(start, end);
        if (start != 0) {
            int forward = end + 3;
            if (forward >= this.programToDebug.length) {
                forward = this.programToDebug.length - 1;
            }
            currentInstructionList.ensureIndexIsVisible(forward);
            int back = start - 2;
            if (back < 0) {
                back = 0;
            }
            currentInstructionList.ensureIndexIsVisible(back);
            currentInstructionList.ensureIndexIsVisible(end);
        }
        currentInstructionList.ensureIndexIsVisible(start);
        stackList.setListData(this.stack.toStringArray());
        cvtList.setListData(this.cvt.getCVTForDebug());
        storageList.setListData(this.getStorageAsArray());
        this.stateDisplay.repaint();
        this.debugGlyphDisplay.repaint();
    }

    private void setCurrentCodeForDebug(int[] code, int pointer, boolean updateDisplay) {
        this.programToDebug = code;
        this.debugPointer = pointer;
        if (!updateDisplay) {
            return;
        }
        this.programToDebugIsData = TTVM.getInstructionStreamIsData(this.programToDebug);
        this.refreshDebugger(true);
        this.currentCode.setText(this.getCurrentFunc());
        this.stepOutButton.setEnabled(!"Glyph program".equals(this.currentFunc));
    }

    private String getCurrentFunc() {
        Object[] keySet;
        String function = "Glyph program";
        for (Object aKeySet1 : keySet = this.functions.keySet().toArray()) {
            if (this.functions.get(aKeySet1) != this.programToDebug) continue;
            function = "Function " + aKeySet1;
        }
        for (Object aKeySet : keySet = this.instructions.keySet().toArray()) {
            if (this.instructions.get(aKeySet) != this.programToDebug) continue;
            function = "Instruction " + aKeySet;
        }
        return function;
    }

    private void printCoords() {
        for (int i = 0; i < this.x[1].length; ++i) {
            System.out.print(i + "\t" + this.x[1][i] + '\t' + this.y[1][i] + '\t' + this.x[3][i] + '\t' + this.y[3][i]);
            System.out.println();
            if (!this.contour[1][i]) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println();
    }

    private static void print(int[] program) {
        String[] toPrint;
        System.out.println();
        for (String aToPrint : toPrint = TTVM.getInstructionsAsStringArray(program)) {
            System.out.println(aToPrint);
        }
        System.out.println();
        System.out.println();
    }

    private static String[] getInstructionsAsStringArray(int[] program) {
        if (program == null) {
            return new String[0];
        }
        String[] result = new String[program.length];
        StringBuilder depth = new StringBuilder();
        int[] notFoundCount = new int[65535];
        for (int n = 0; n < program.length; ++n) {
            boolean found = false;
            int test = program[n];
            if (test >= 192 && test <= 223) {
                test = 192;
            }
            if (test >= 224 && test <= 255) {
                test = 224;
            }
            if (test >= 176 && test <= 183) {
                test = 176;
            }
            if (test >= 184 && test <= 191) {
                test = 184;
            }
            for (Field declaredField : TTVM.class.getDeclaredFields()) {
                if (found) break;
                try {
                    int word;
                    int j;
                    if (Character.isLowerCase(declaredField.getName().charAt(0)) || declaredField.getName().contains("ZONE") || "ORIGINAL".equals(declaredField.getName()) || "OPCODE_DESCRIPTIONS".equals(declaredField.getName()) || declaredField.getInt(declaredField) != test) continue;
                    if ("ENDF".equals(declaredField.getName()) || "ELSE".equals(declaredField.getName()) || "EIF".equals(declaredField.getName())) {
                        depth.delete(0, 2);
                    }
                    result[n] = n + ": " + depth + declaredField.getName();
                    if ("NPUSHB".equals(declaredField.getName())) {
                        int count = program[++n];
                        result[n] = depth + "  count: " + count;
                        for (j = 0; j < count; ++j) {
                            result[++n] = depth + "   " + program[n];
                        }
                    } else if ("NPUSHW".equals(declaredField.getName())) {
                        int count = program[++n];
                        result[n] = depth + "  count: " + count;
                        for (j = 0; j < count; ++j) {
                            word = TTVM.getIntFrom2Uint8(program[++n], program[n + 1]);
                            result[n] = depth + "   (first half of number)";
                            result[++n] = depth + "   " + word;
                        }
                    } else if (program[n] >= 176 && program[n] <= 183) {
                        int count = program[n] - 175;
                        for (j = 0; j < count; ++j) {
                            result[++n] = depth + "   " + program[n];
                        }
                    } else if (program[n] >= 184 && program[n] <= 191) {
                        int count = program[n] - 183;
                        for (j = 0; j < count; ++j) {
                            word = TTVM.getIntFrom2Uint8(program[++n], program[n + 1]);
                            result[n] = depth + "   (first half of number)";
                            result[++n] = depth + "   " + word;
                        }
                    } else if ("FDEF".equals(declaredField.getName()) || "IDEF".equals(declaredField.getName()) || "ELSE".equals(declaredField.getName()) || "IF".equals(declaredField.getName())) {
                        depth.append("  ");
                    }
                    found = true;
                }
                catch (IllegalAccessException e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            if (found) continue;
            int n2 = program[n];
            notFoundCount[n2] = notFoundCount[n2] + 1;
            System.out.println(depth + "0x" + Integer.toHexString(program[n]) + "    (Unimplemented)");
        }
        for (int i = 0; i < 255; ++i) {
            if (notFoundCount[i] <= 0) continue;
            System.out.println(Integer.toHexString(i) + " not found " + notFoundCount[i] + " times.");
        }
        return result;
    }

    private static boolean[] getInstructionStreamIsData(int[] program) {
        if (program == null) {
            return new boolean[0];
        }
        boolean[] result = new boolean[program.length];
        block2: for (int n = 0; n < program.length; ++n) {
            boolean found = false;
            int test = program[n];
            if (test >= 192 && test <= 223) {
                test = 192;
            }
            if (test >= 224 && test <= 255) {
                test = 224;
            }
            for (Field declaredField : TTVM.class.getDeclaredFields()) {
                if (found) continue block2;
                try {
                    int j;
                    if (Character.isLowerCase(declaredField.getName().charAt(0)) || declaredField.getName().contains("ZONE") || "ORIGINAL".equals(declaredField.getName()) || "OPCODE_DESCRIPTIONS".equals(declaredField.getName()) || declaredField.getInt(declaredField) != test) continue;
                    result[n] = false;
                    if ("NPUSHB".equals(declaredField.getName())) {
                        int count = program[++n];
                        result[n] = true;
                        for (j = 0; j < count; ++j) {
                            result[++n] = true;
                        }
                    } else if ("NPUSHW".equals(declaredField.getName())) {
                        int count = program[++n];
                        result[n] = true;
                        for (j = 0; j < count; ++j) {
                            result[++n] = true;
                            result[++n] = true;
                        }
                    } else if (program[n] >= 176 && program[n] <= 183) {
                        int count = program[n] - 175;
                        for (j = 0; j < count; ++j) {
                            result[++n] = true;
                        }
                    } else if (program[n] >= 184 && program[n] <= 191) {
                        int count = program[n] - 183;
                        for (j = 0; j < count; ++j) {
                            result[++n] = true;
                            result[++n] = true;
                        }
                    }
                    found = true;
                }
                catch (IllegalAccessException e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return result;
    }

    static {
        OPCODE_DESCRIPTIONS = new String[]{"SVTCAy    - Set both vectors to y", "SVTCAx    - Set both vectors to x", "SPVTCAy   - Sets projection vector to y", "SPVTCAx   - Sets projection vector to x", "SFVTCAy   - Sets freedom vector to y", "SFVTCAx   - Sets freedom vector to x", "SPVTL0    - Set projection vector to line", "SPVTL1    - Set projection vector perpendicular to line", "SFVTL0    - Set freedom vector to line", "SFVTL1    - Set freedom vector perpendicular to line", "SPVFS     - Sets the projection vector from the stack", "SFVFS     - Sets the freedom vector from the stack", "GPV       - Gets the projection vector onto the stack", "GFV       - Gets the freedom vector onto the stack", "SFVTPV    - Sets freedom vector to projection vector", "ISECT     - Set point to intersection of lines", "SRP0      - Set rp0", "SRP1      - Set rp1", "SRP2      - Set rp2", "SZP0      - Sets zp0", "SZP1      - Sets zp1", "SZP2      - Sets zp2", "SZPS      - Sets all zone pointers", "SLOOP     - Sets loop variable", "RTG       - Sets round state to grid", "RTHG      - Sets round state to half grid", "SMD       - Sets minimum distance", "ELSE      - ELSE", "JMPR      - Jump", "SCVTCI    - Set control value table cut in", "SSWCI     - Set single width cut in", "SSW       - Set single width", "DUP       - Duplicate the top stack element", "POP       - Remove the top stack element", "CLEAR     - Clear the stack", "SWAP      - Swap the top two stack elements", "DEPTH     - Returns depth of stack", "CINDEX    - Copy Indexed element to top of stack", "MINDEX    - Move Indexed element to top of stack", "ALIGNPTS  - Move points along fv to average of their pv positions", "", "UTP       - Untouch point", "LOOPCALL  - Call a function many times", "CALL      - Call a function", "FDEF      - Define a function", "ENDF      - End a function definition", "MDAP0     - Sets a point as touched", "MDAP1     - Rounds a point along the pV and marks as touched", "IUPy      - Interpolate untouched points in the y axis", "IUPx      - Interpolate untouched points on the x axis", "SHP0      - Shift point using RP2", "SHP1      - Shift point using RP1", "SHC0      - Shift a contour using RP2", "SHC1      - Shift a contour using RP1", "SHZ0      - Shift a zone using RP2", "SHZ1      - Shift a zone using RP1", "SHPIX     - Move point along freedom vector", "IP        - Interpolate point", "MSIRP0    - Move stack indirect relative point", "MSIRP1    - Move stack indirect relative point", "ALIGNRP   - Align point to RP0", "RTDG      - Sets round state to double grid", "MIAP0     - Move point to CVT value", "MIAP1     - Move point to CVT using cut in and round", "NPUSHB    - Push N bytes from IS to stack", "NPUSHW    - Push N words from IS to stack", "WS        - Write Store", "RS        - Read Store", "WCVTP     - Write Control Value Table in Pixels", "RCVT      - Read Control Value Table", "GC0       - Get coords on the pv", "GC1       - Get original coords on the pv", "SCFS", "MD0       - Measure current distance", "MD1       - Measure original distance", "MPPEM     - Measure pixels per em in the direction of the projection vector", "MPS", "FLIPON    - Sets autoflip to true", "FLIPOFF   - Sets autoflip to false", "DEBUG     - Shouldn't be in live fonts", "LT        - Less Than", "LTEQ      - Less Than or Equal", "GT        - Greater Than", "GTEQ      - Greater Than or Equal", "EQ        - Equal", "NEQ       - Not Equal", "ODD       - Rounds, truncates, and returns if odd.", "EVEN      - Rounds, truncates, and returns if even", "IF        - IF", "EIF       - End IF", "AND       - Logical AND", "OR        - Logical OR", "NOT       - Logical NOT", "DELTAP1   - Delta exception p1", "SDB       - Set delta base", "SDS       - Set delta shift", "ADD       - Add two F26Dot6 numbers", "SUB       - Subtract a number from another", "DIV       - Divide two F26Dot6 numbers", "MUL       - Multiply two F26Dot6 numbers", "ABS       - Return the absolute value of a F26Dot6 number", "NEG       - Negate a number", "FLOOR     - Round a number down if it has a fractional component", "CEILING   - Round a number up if it has a fractional component", "ROUND00   - Round a number", "ROUND01   - Round a number", "ROUND10   - Round a number", "ROUND11   - Round a number", "NROUND00  - Compensate for engine characteristics", "NROUND01  - Compensate for engine characteristics", "NROUND10  - Compensate for engine characteristics", "NROUND11  - Compensate for engine characteristics", "WCVTF", "DELTAP2   - Delta exception p2", "DELTAP3   - Delta exception p3", "DELTAC1   - Delta exception c1", "DELTAC2   - Delta exception c2", "DELTAC3   - Delta exception c3", "SROUND    - Sets the roundState specifically", "S45ROUND  - Sets the round state for working at 45degrees", "JROT      - Jump Relative On True", "JROF      - Jump Relative On False", "ROFF      - Set round state to off", "", "RUTG      - Set round state to up to grid", "RDTG      - Set round state to down to grid", "SANGW     - deprecated", "AA        - deprecated", "FLIPPT    - Flips a number of points on/off the curve", "FLIPRGON  - Flips a range of points onto the curve", "FLIPRGOFF - Flips a range of points off the curve", "", "", "SCANCTRL  - We don't scan convert, so only pops a value", "SDPVTL0   - Sets dual projection vector to line", "SDPVTL1   - Sets dual projection vector perpendicular to line", "GETINFO   - Gets info about current glyph & font engine", "IDEF      - Define an instruction", "ROLL      - Roll the top three stack elements", "MAX       - Returns the maximum of two values", "MIN       - Returns the minimum of two values", "SCANTYPE  - We don't scan convert, so only pops a value", "INSTCTRL  - Allows for setting flags to do with glyph execution"};
    }

    private static class Stack
    implements Serializable {
        private int pointer;
        private int[] stack = new int[10];
        private String[] pushedByLine = new String[10];

        Stack() {
        }

        void push(int a, int currentPointer, String currentFunc) {
            if (this.pointer >= this.stack.length) {
                int[] newStack = new int[(int)((double)this.stack.length * 1.5)];
                System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
                this.stack = newStack;
                String[] newMBL = new String[(int)((double)this.stack.length * 1.5)];
                System.arraycopy(this.pushedByLine, 0, newMBL, 0, this.pushedByLine.length);
                this.pushedByLine = newMBL;
            }
            this.stack[this.pointer] = a;
            this.pushedByLine[this.pointer] = currentFunc + " Line " + currentPointer;
            ++this.pointer;
        }

        int pop() {
            --this.pointer;
            if (this.pointer >= 0) {
                return this.stack[this.pointer];
            }
            throw new RuntimeException("Popped an empty stack!");
        }

        int size() {
            return this.pointer;
        }

        int elementAt(int key) {
            return this.stack[this.pointer - key];
        }

        int remove(int key) {
            int valPos = this.pointer - key;
            int result = this.stack[valPos];
            int[] newStack = new int[this.stack.length];
            System.arraycopy(this.stack, 0, newStack, 0, valPos);
            System.arraycopy(this.stack, valPos + 1, newStack, valPos, this.stack.length - valPos - 1);
            this.stack = newStack;
            String[] newPBL = new String[this.stack.length];
            System.arraycopy(this.pushedByLine, 0, newPBL, 0, valPos);
            System.arraycopy(this.pushedByLine, valPos + 1, newPBL, valPos, this.stack.length - valPos - 1);
            this.pushedByLine = newPBL;
            --this.pointer;
            return result;
        }

        String[] toStringArray() {
            String[] result = new String[this.pointer];
            for (int i = this.pointer - 1; i >= 0; --i) {
                result[this.pointer - i - 1] = this.pointer - i - 1 + ": " + this.stack[i] + "       (" + NumberFormat.getNumberInstance().format((double)this.stack[i] / 64.0) + ')';
            }
            return result;
        }

        String getPushedBy(int i) {
            return this.pushedByLine[this.pointer - (i + 1)];
        }
    }
}

