/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.Table;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.StringUtils;

public class PdfJavaGlyphs
implements PdfGlyphs,
Serializable {
    protected boolean hasGIDtoCID;
    private Area[] cachedShapes;
    private AffineTransform[] cachedAt;
    public int[] CMAP_Translate;
    protected int glyphCount;
    public boolean isFontInstalled;
    public String defaultFont = "Lucida Sans";
    public String fontName = "default";
    public String logicalfontName = "default";
    private Map<Integer, String> chars = new HashMap<Integer, String>();
    private Map<Integer, String> displayValues = new HashMap<Integer, String>();
    private Map<Integer, String> embeddedChars = new HashMap<Integer, String>();
    private boolean isIdentity;
    private boolean isFontEmbedded;
    private boolean hasWidths = true;
    int objID;
    public String baseFontName = "";
    public boolean isSubsetted;
    public float[][] lastTrm = new float[3][3];
    private Font unscaledFont;
    public boolean isArialInstalledLocally;
    private int maxCharCount = 255;
    public boolean isCIDFont;
    public String font_family_name;
    public int style;
    private int size;
    private String weight;
    private String testFont;
    public static final FontRenderContext frc = new FontRenderContext(null, true, true);
    private static String[] fontList;
    private PdfGlyph[] cachedEmbeddedShapes;
    int localBias;
    int globalBias;

    public void flush() {
        this.cachedShapes = null;
        this.cachedAt = null;
    }

    @Override
    public String getBaseFontName() {
        return this.baseFontName;
    }

    public void setBaseFontName(String baseFontName) {
        this.baseFontName = baseFontName;
    }

    @Override
    public Area getStandardGlyph(float[][] Trm, int rawInt, String displayValue, float currentWidth, boolean isSTD) {
        Area transformedGlyph2 = this.getCachedShape(rawInt);
        if (transformedGlyph2 == null) {
            AffineTransform at;
            double dY = -1.0;
            double dX = 1.0;
            double y = 0.0;
            if (isSTD) {
                transformedGlyph2 = this.getGlyph(displayValue, currentWidth);
                if (transformedGlyph2 != null && rawInt == 146 && this.isArialInstalledLocally) {
                    y = -(transformedGlyph2.getBounds().height - transformedGlyph2.getBounds().y);
                }
            } else {
                GlyphVector gv1 = null;
                if (!this.isCIDFont || this.isFontInstalled) {
                    gv1 = this.getUnscaledFont().createGlyphVector(frc, displayValue);
                }
                if (gv1 != null) {
                    double glyphWidth;
                    double scaleFactor;
                    transformedGlyph2 = new Area(gv1.getOutline());
                    double glyphX = gv1.getOutline().getBounds2D().getX();
                    if (glyphX < 0.0) {
                        glyphX = -glyphX;
                        at = AffineTransform.getTranslateInstance(glyphX * 2.0, 0.0);
                        transformedGlyph2.transform(at);
                    }
                    if ((scaleFactor = (double)currentWidth / (glyphWidth = gv1.getVisualBounds().getWidth() + glyphX * 2.0)) < 1.0) {
                        dX *= scaleFactor;
                    }
                }
            }
            at = new AffineTransform(dX * (double)Trm[0][0], dX * (double)Trm[0][1], dY * (double)Trm[1][0], dY * (double)Trm[1][1], 0.0, y);
            if (transformedGlyph2 != null) {
                transformedGlyph2.transform(at);
            }
            this.setCachedShape(rawInt, transformedGlyph2, at);
        }
        return transformedGlyph2;
    }

    public Area getGlyph(String xx, float currentWidth) {
        boolean fontMatched = true;
        GlyphVector gv1 = null;
        if (!this.getUnscaledFont().canDisplay(xx.charAt(0))) {
            fontMatched = false;
        }
        if (!(this.isCIDFont && this.isFontEmbedded && fontMatched)) {
            if (fontMatched) {
                gv1 = this.getUnscaledFont().createGlyphVector(frc, xx);
            } else {
                Font tempFont = new Font(this.defaultFont, 0, 1);
                if (!tempFont.canDisplay(xx.charAt(0))) {
                    tempFont = new Font("lucida", 0, 1);
                }
                if (tempFont.canDisplay(xx.charAt(0))) {
                    gv1 = tempFont.createGlyphVector(frc, xx);
                }
            }
        }
        Area transformedGlyph2 = null;
        if (gv1 != null) {
            transformedGlyph2 = new Area(gv1.getOutline());
            double glyphX = gv1.getOutline().getBounds2D().getX();
            double width = gv1.getOutline().getBounds2D().getWidth();
            if (!this.hasWidths) {
                float leading = (float)((double)currentWidth - (width + glyphX + glyphX)) / 2.0f;
                if (leading > 0.0f) {
                    AffineTransform at = AffineTransform.getTranslateInstance(leading, 0.0);
                    transformedGlyph2.transform(at);
                }
            } else {
                double scaleFactor;
                AffineTransform at;
                if (glyphX < 0.0) {
                    glyphX = -glyphX;
                    at = AffineTransform.getTranslateInstance(glyphX, 0.0);
                    transformedGlyph2.transform(at);
                }
                if ((scaleFactor = (double)currentWidth / transformedGlyph2.getBounds2D().getWidth()) < 1.0) {
                    at = AffineTransform.getScaleInstance(scaleFactor, 1.0);
                    transformedGlyph2.transform(at);
                }
            }
        }
        return transformedGlyph2;
    }

    public final void setCachedShape(int idx, Area shape, AffineTransform at) {
        Area[] cache = this.cachedShapes;
        AffineTransform[] atCache = this.cachedAt;
        if (cache == null) {
            this.cachedShapes = cache = new Area[this.maxCharCount];
            this.cachedAt = atCache = new AffineTransform[this.maxCharCount];
        }
        cache[idx] = shape == null ? null : shape;
        if (shape != null && at != null) {
            atCache[idx] = at;
        }
    }

    public final AffineTransform getCachedTransform(int idx) {
        AffineTransform[] cache = this.cachedAt;
        if (cache == null) {
            return null;
        }
        return cache[idx];
    }

    public final Area getCachedShape(int idx) {
        Area[] cache = this.cachedShapes;
        if (cache == null) {
            return null;
        }
        Area currentShape = cache[idx];
        if (currentShape == null) {
            return null;
        }
        return currentShape;
    }

    public void init(int maxCharCount, boolean isCIDFont) {
        this.maxCharCount = maxCharCount;
        this.isCIDFont = isCIDFont;
    }

    public final void setFont(String name, int size) {
        int pointer;
        Font f;
        this.size = size;
        if (DecoderOptions.Helper != null && (f = DecoderOptions.Helper.setFont(this, StringUtils.convertHexChars(name), size)) != null) {
            this.style = f.getStyle();
            this.font_family_name = f.getFamily();
            this.unscaledFont = f;
            return;
        }
        this.font_family_name = name = StandardFonts.expandName(name);
        this.style = 0;
        String mappedName = null;
        if (this.font_family_name == null) {
            this.font_family_name = this.fontName;
        }
        this.testFont = this.font_family_name;
        if (this.font_family_name != null) {
            this.testFont = this.font_family_name.toLowerCase();
            pointer = this.font_family_name.indexOf(44);
            if (pointer == -1) {
                pointer = this.font_family_name.indexOf(45);
            }
            if (pointer != -1) {
                mappedName = FontMappings.fontSubstitutionAliasTable.get(this.testFont);
                this.weight = this.testFont.substring(pointer + 1, this.testFont.length());
                this.style = PdfJavaGlyphs.getWeight(this.weight);
                this.testFont = this.font_family_name = this.font_family_name.substring(0, pointer).toLowerCase();
                if (this.testFont.endsWith("mt")) {
                    this.testFont = this.testFont.substring(0, this.testFont.length() - 2);
                }
            }
        }
        if (mappedName == null) {
            mappedName = FontMappings.fontSubstitutionAliasTable.get(this.testFont);
        }
        if (mappedName != null && mappedName.equals("arialbd")) {
            mappedName = "arial-bold";
        }
        if (mappedName != null) {
            this.font_family_name = mappedName;
            pointer = this.font_family_name.indexOf(45);
            if (pointer != -1) {
                this.font_family_name = this.font_family_name.toLowerCase();
                this.weight = this.font_family_name.substring(pointer + 1, this.font_family_name.length());
                this.style = PdfJavaGlyphs.getWeight(this.weight);
                this.font_family_name = this.font_family_name.substring(0, pointer);
            }
            this.testFont = this.font_family_name.toLowerCase();
            if (this.testFont.endsWith("mt")) {
                this.testFont = this.testFont.substring(0, this.testFont.length() - 2);
            }
        }
    }

    private static int getWeight(String weight) {
        int style = 0;
        if (weight.endsWith("mt")) {
            weight = weight.substring(0, weight.length() - 2);
        }
        if (weight.contains("heavy")) {
            style = 1;
        } else if (weight.contains("bold")) {
            style = 1;
        }
        if (weight.contains("italic")) {
            style += 2;
        } else if (weight.contains("oblique")) {
            style += 2;
        }
        return style;
    }

    public final Font getUnscaledFont() {
        if (this.unscaledFont == null && this.font_family_name != null) {
            int i;
            if (fontList == null) {
                fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (int i2 = 0; i2 < fontList.length; ++i2) {
                    PdfJavaGlyphs.fontList[i2] = fontList[i2].toLowerCase();
                }
            }
            boolean isFound = false;
            int count = fontList.length;
            for (i = 0; i < count; ++i) {
                if (!fontList[i].equals(this.testFont) && (this.weight != null || !this.testFont.startsWith(fontList[i]))) continue;
                this.isFontInstalled = true;
                this.font_family_name = fontList[i];
                i = count;
                isFound = true;
            }
            if (!isFound) {
                count = fontList.length;
                for (i = 0; i < count; ++i) {
                    if (!fontList[i].equals(this.testFont) && (this.weight != null || !this.testFont.startsWith(fontList[i]))) continue;
                    this.isFontInstalled = true;
                    this.font_family_name = fontList[i];
                    i = count;
                }
            }
            if (this.isFontInstalled && this.font_family_name.equals("arial")) {
                this.isArialInstalledLocally = true;
            }
            if (!this.isFontInstalled) {
                if (this.weight == null) {
                    String test = this.font_family_name.toLowerCase();
                    this.style = PdfJavaGlyphs.getWeight(test);
                }
                this.font_family_name = this.defaultFont;
            }
            this.unscaledFont = new Font(this.font_family_name, this.style, this.size);
        }
        if (this.unscaledFont == null) {
            this.unscaledFont = new Font(this.defaultFont, 0, 1);
        }
        return this.unscaledFont;
    }

    protected final void setEmbeddedCachedShape(int idx, PdfGlyph shape) {
        PdfGlyph[] cache = this.cachedEmbeddedShapes;
        if (cache == null) {
            this.cachedEmbeddedShapes = cache = new PdfGlyph[this.maxCharCount];
        }
        if (idx < cache.length) {
            cache[idx] = shape;
        }
    }

    protected final PdfGlyph getEmbeddedCachedShape(int idx) {
        PdfGlyph[] cache = this.cachedEmbeddedShapes;
        if (cache == null) {
            return null;
        }
        if (idx < cache.length) {
            PdfGlyph currentShape = cache[idx];
            if (currentShape == null) {
                return null;
            }
            return currentShape;
        }
        return null;
    }

    @Override
    public PdfGlyph getEmbeddedGlyph(GlyphFactory factory, String glyph, float[][] trm, int rawInt, String displayValue, float currentWidth, String key) {
        return null;
    }

    public void setGIDtoCID(int[] cidToGIDMap) {
    }

    public void setEncodingToUse(boolean hasEncoding, int fontEncoding, boolean isCIDFont) {
    }

    public int readEmbeddedFont(boolean TTstreamisCID, byte[] fontDataAsArray, FontData fontData) {
        throw new RuntimeException("readEmbeddedFont in PdfJavaGlyphs should not be called");
    }

    public void setIsSubsetted(boolean b) {
        this.isSubsetted = b;
    }

    public void setT3Glyph(int key, int altKey, PdfGlyph glyph) {
    }

    public void setCharString(String s, byte[] bytes, int glyphNo) {
    }

    public boolean is1C() {
        return false;
    }

    public void setis1C(boolean b) {
    }

    public void setValuesForGlyph(int rawInt, String charGlyph, String displayValue, String embeddedChar) {
        Integer key = rawInt;
        this.chars.put(key, charGlyph);
        this.displayValues.put(key, displayValue);
        this.embeddedChars.put(key, embeddedChar);
    }

    @Override
    public String getDisplayValue(Integer key) {
        return this.displayValues.get(key);
    }

    @Override
    public String getCharGlyph(Integer key) {
        return this.chars.get(key);
    }

    @Override
    public String getEmbeddedEnc(Integer key) {
        return this.embeddedChars.get(key);
    }

    public Map<Integer, String> getDisplayValues() {
        return Collections.unmodifiableMap(this.displayValues);
    }

    public Map<Integer, String> getCharGlyphs() {
        return Collections.unmodifiableMap(this.chars);
    }

    public Map<Integer, String> getEmbeddedEncs() {
        return Collections.unmodifiableMap(this.embeddedChars);
    }

    public void setDisplayValues(Map<Integer, String> displayValues) {
        this.displayValues = displayValues;
    }

    public void setCharGlyphs(Map<Integer, String> chars) {
        this.chars = chars;
    }

    public void setEmbeddedEncs(Map<Integer, String> embeddedChars) {
        this.embeddedChars = embeddedChars;
    }

    public void setLocalBias(int i) {
        this.localBias = i;
    }

    public void setGlobalBias(int i) {
        this.globalBias = i;
    }

    public float getTTWidth(String charGlyph, int rawInt, boolean b) {
        throw new RuntimeException("getTTWidth should not be called");
    }

    public int getConvertedGlyph(int rawInt) {
        return -1;
    }

    public void setIsIdentity(boolean isIdentity) {
        this.isIdentity = isIdentity;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public void setFontEmbedded(boolean isSet) {
        this.isFontEmbedded = isSet;
    }

    public int getType() {
        return 0;
    }

    public void setHasWidths(boolean hasWidths) {
        this.hasWidths = hasWidths;
    }

    public int getCMAPValue(int rawInt) {
        if (this.CMAP_Translate == null) {
            return -1;
        }
        return this.CMAP_Translate[rawInt];
    }

    public void setIndexForCharString(int jj, String glyphName) {
    }

    public String getIndexForCharString(int jj) {
        return null;
    }

    public Map<String, byte[]> getCharStringData() {
        return null;
    }

    public void setGlyphCount(int nGlyphs) {
        this.glyphCount = nGlyphs;
    }

    public int getGlyphCount() {
        return this.glyphCount;
    }

    public void setRenderer(DynamicVectorRenderer current) {
    }

    public Table getTable(int id) {
        return null;
    }

    public boolean hasGIDtoCID() {
        return this.hasGIDtoCID;
    }

    public void setObjID(int objID) {
        this.objID = objID;
    }

    public boolean containsKey(String valueOf) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

