/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.util.TreeMap;

final class CmapSpec {
    private static final byte[] CHAR256 = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 0, 2, 2, 0, 0, 0, 0, 0, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] cmapData;
    private long[][] codeSpaceRange;
    public final TreeMap<Long, Integer> cidRange = new TreeMap();
    private int p;
    private final int len;

    CmapSpec(byte[] cmapData) {
        this.cmapData = cmapData;
        this.len = cmapData.length;
        this.codeSpaceRange = new long[1][2];
        this.codeSpaceRange[0][1] = 65535L;
        while (this.p < this.len) {
            long v;
            long v2;
            int cid;
            long start;
            int i;
            int count;
            String[] nn;
            if ((cmapData[this.p] & 0xFF) == 37) {
                this.skipLine();
                continue;
            }
            String line = this.getNextLine().trim();
            if (line.isEmpty()) continue;
            TreeMap<Long, Integer> bfRange = new TreeMap<Long, Integer>();
            TreeMap<Long, Integer> notDefRange = new TreeMap<Long, Integer>();
            if (line.contains("begincodespacerange")) {
                nn = line.split(" ");
                count = Integer.parseInt(nn[0]);
                this.codeSpaceRange = new long[count][2];
                for (i = 0; i < count; ++i) {
                    start = this.getIntOrHex();
                    long end = this.getIntOrHex();
                    this.codeSpaceRange[i][0] = start;
                    this.codeSpaceRange[i][1] = end;
                }
                continue;
            }
            if (line.contains("begincidrange")) {
                nn = line.split(" ");
                count = Integer.parseInt(nn[0]);
                for (i = 0; i < count; ++i) {
                    start = this.getIntOrHex();
                    long end = this.getIntOrHex();
                    cid = (int)this.getIntOrHex();
                    v2 = start << 32 | end;
                    this.cidRange.put(v2, cid);
                }
                continue;
            }
            if (line.contains("begincidchar")) {
                nn = line.split(" ");
                count = Integer.parseInt(nn[0]);
                for (i = 0; i < count; ++i) {
                    start = this.getIntOrHex();
                    int cid2 = (int)this.getIntOrHex();
                    v = start << 32 | start;
                    this.cidRange.put(v, cid2);
                }
                continue;
            }
            if (line.contains("beginnotdefrange")) {
                nn = line.split(" ");
                count = Integer.parseInt(nn[0]);
                for (i = 0; i < count; ++i) {
                    start = this.getIntOrHex();
                    long end = this.getIntOrHex();
                    cid = (int)this.getIntOrHex();
                    v2 = start << 32 | end;
                    notDefRange.put(v2, cid);
                }
                continue;
            }
            if (line.contains("beginnotdefchar")) {
                nn = line.split(" ");
                count = Integer.parseInt(nn[0]);
                for (i = 0; i < count; ++i) {
                    start = this.getIntOrHex();
                    int cid3 = (int)this.getIntOrHex();
                    v = start << 32 | start;
                    notDefRange.put(v, cid3);
                }
                continue;
            }
            if (line.contains("beginbfrange")) {
                nn = line.split(" ");
                count = Integer.parseInt(nn[0]);
                for (i = 0; i < count; ++i) {
                    start = this.getIntOrHex();
                    long end = this.getIntOrHex();
                    cid = (int)this.getIntOrHex();
                    v2 = start << 32 | end;
                    bfRange.put(v2, cid);
                }
                continue;
            }
            if (!line.contains("beginbfchar")) continue;
            nn = line.split(" ");
            count = Integer.parseInt(nn[0]);
            for (i = 0; i < count; ++i) {
                start = this.getIntOrHex();
                int cid4 = (int)this.getIntOrHex();
                v = start << 32 | start;
                bfRange.put(v, cid4);
            }
        }
    }

    private long getIntOrHex() {
        StringBuilder sb = new StringBuilder();
        while (this.p < this.len) {
            int v = this.cmapData[this.p] & 0xFF;
            if (v == 60) {
                ++this.p;
                while (this.p < this.len && (v = this.cmapData[this.p++] & 0xFF) != 62) {
                    sb.append((char)v);
                }
                String str = sb.toString();
                if (str.length() > 4) {
                    str = str.substring(0, 4);
                }
                return Long.parseLong(str, 16);
            }
            if (CmapSpec.isDigit(v)) {
                while (this.p < this.len && CmapSpec.isDigit(v = this.cmapData[this.p++] & 0xFF)) {
                    sb.append((char)v);
                }
                return Long.parseLong(sb.toString());
            }
            ++this.p;
        }
        return 0L;
    }

    private String getNextLine() {
        StringBuilder bb = new StringBuilder();
        int v = this.cmapData[this.p++] & 0xFF;
        block4: while (this.p < this.len) {
            switch (v) {
                case 13: {
                    if ((this.cmapData[this.p] & 0xFF) != 10) break block4;
                    ++this.p;
                    break block4;
                }
                case 10: {
                    break block4;
                }
                default: {
                    bb.append((char)v);
                    v = this.cmapData[this.p++] & 0xFF;
                    continue block4;
                }
            }
        }
        return bb.toString();
    }

    private void skipLine() {
        int v = this.cmapData[this.p++] & 0xFF;
        while (this.p < this.len) {
            switch (v) {
                case -1: 
                case 10: {
                    return;
                }
                case 13: {
                    if ((this.cmapData[this.p] & 0xFF) == 10) {
                        ++this.p;
                    }
                    return;
                }
            }
            v = this.cmapData[this.p++] & 0xFF;
        }
    }

    private static boolean isDigit(int ch) {
        return CHAR256[ch] == 4;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("codespacerange \n");
        for (long[] codeSpaceRange1 : this.codeSpaceRange) {
            sb.append(codeSpaceRange1[0]).append(" ... ").append(codeSpaceRange1[1]).append('\n');
        }
        sb.append("cidrange \n");
        Object object = this.cidRange.keySet().iterator();
        while (object.hasNext()) {
            Long key = (Long)object.next();
            int start = (int)(key >>> 32);
            int end = (int)(key & 0xFFFFFFFFL);
            int v = this.cidRange.get(key);
            sb.append(start).append(" ... ").append(end).append(" ==> ").append(v).append('\n');
        }
        return sb.toString();
    }
}

