/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.text.BaseTextExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SecureTransformerFactory;
import org.w3c.dom.Document;

public class ExtractStructuredText
extends BaseTextExtraction {
    public ExtractStructuredText(String fileName) {
        super(fileName);
        this.init();
    }

    public ExtractStructuredText(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    @Override
    void decodeFile(String file_name) throws PdfException {
        Document tree;
        this.fileName = file_name;
        if (this.openPDFFile() && (tree = this.getStructuredTextContent()) != null) {
            InputStream stylesheet = null;
            TransformerFactory transformerFactory = SecureTransformerFactory.newInstance();
            try {
                stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/text/xmlstyle.xslt");
                Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
                if (!tree.hasChildNodes()) {
                    return;
                }
                if (!tree.getDocumentElement().hasChildNodes()) {
                    tree.appendChild(tree.createComment("There is NO Structured text in the file to extract!!"));
                    tree.appendChild(tree.createComment("JPedal can only extract it if it has been added when PDF created"));
                    tree.appendChild(tree.createComment("Please read our blog post at https://blog.idrsolutions.com/2010/09/the-easy-way-to-discover-if-a-pdf-file-contains-structured-content/ "));
                }
                String name = "demo";
                int pointer = file_name.lastIndexOf(separator);
                if (pointer != -1) {
                    name = file_name.substring(pointer + 1, file_name.length() - 4);
                }
                String outputFile = this.output_dir + separator + name + ".xml";
                File output = new File(this.output_dir);
                if (!output.exists()) {
                    File createDir = new File(this.output_dir);
                    createDir.mkdirs();
                    output.createNewFile();
                }
                transformer.transform(new DOMSource(tree), new StreamResult(outputFile));
            }
            catch (Exception e) {
                throw new PdfException(e.getMessage());
            }
            catch (Error e) {
                throw new PdfException(e.getMessage());
            }
            finally {
                if (stylesheet != null) {
                    try {
                        stylesheet.close();
                    }
                    catch (Exception e) {
                        LogWriter.writeLog(e.getMessage());
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        int len = args.length;
        switch (len) {
            case 0: 
            case 1: {
                System.out.println("Example takes 2 parameters");
                System.out.println("Value 1 is the file name or directory of PDF files to process");
                System.out.println("Value 2 is Directory for writing the data as text files");
                System.exit(0);
            }
            case 2: {
                try {
                    ExtractStructuredText.writeAllStructuredTextOutlinesToDir(args[0], args[1]);
                }
                catch (PdfException e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                System.out.println("too many arguments entered - run with no values to see defaults");
                StringBuilder arguments = new StringBuilder();
                for (String arg : args) {
                    arguments.append(arg).append('\n');
                }
                System.out.println("you entered:\n" + arguments + "as the arguments");
                System.exit(0);
            }
        }
    }

    @Override
    void init() {
        this.type = BaseTextExtraction.ExtractTypes.STRUCTURED_TEXT;
        super.init();
    }

    public static void writeAllStructuredTextOutlinesToDir(String inputDir, String outputDir) throws PdfException {
        ExtractStructuredText extract = new ExtractStructuredText(inputDir);
        extract.setup(outputDir);
        extract.processFiles(inputDir);
        extract.closePDFfile();
    }

    private void setup(String outputDir) {
        if (!outputDir.endsWith(separator)) {
            outputDir = outputDir + separator;
        }
        this.output_dir = outputDir;
    }

    public Document getStructuredTextContent() {
        return this.decode_pdf.getMarkedContent();
    }
}

