/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.idrsolutions.image.tiff.TiffEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.examples.images.BaseImageExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.PdfImageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SecureDocumentBuilderFactory;
import org.jpedal.utils.SecureTransformerFactory;
import org.jpedal.utils.TimeNow;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtractImages
extends BaseImageExtraction {
    private boolean outputPagesInSeparateDirs = true;
    private String defaultOutputDir;
    private boolean writeOutMetadata = true;

    public ExtractImages(String fileName) {
        super(fileName);
        this.init();
    }

    public ExtractImages(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    private void setCreateMetsDataXMLfile(boolean writeOutMetadata) {
        this.writeOutMetadata = writeOutMetadata;
    }

    public static void writeAllImagesToDir(String inputDir, String outputDir, String imageType, boolean generateMetaData, boolean outputPagesInSepDirs) throws PdfException {
        ExtractImages extract = new ExtractImages(inputDir);
        extract.setup(outputDir, imageType, generateMetaData, outputPagesInSepDirs);
        extract.processFiles(inputDir);
        extract.closePDFfile();
    }

    @Override
    void decodeFile(String fileName) throws PdfException {
        if (this.openPDFFile()) {
            boolean start = true;
            int end = this.getPageCount();
            this.output_dir = this.defaultOutputDir == null ? this.user_dir + "images" + separator + this.name + separator : this.defaultOutputDir;
            File output_path = new File(this.output_dir);
            if (!output_path.exists()) {
                output_path.mkdirs();
            }
            for (int page = 1; page < end + 1; ++page) {
                int image_count = this.getImageCount(page);
                if (image_count > 0) {
                    File page_path;
                    String target = this.output_dir;
                    if (this.outputPagesInSeparateDirs) {
                        target = this.output_dir + separator + page;
                    }
                    if (!(page_path = new File(target)).exists()) {
                        page_path.mkdirs();
                    }
                }
                try {
                    this.writeImagesFromPage(image_count, page);
                }
                catch (Exception ex) {
                    throw new PdfException(ex.getMessage());
                }
                this.decode_pdf.flushObjectValues(true);
            }
        }
    }

    private void writeImagesFromPage(int image_count, int page) throws Exception {
        String outputDir = this.output_dir;
        if (this.outputPagesInSeparateDirs) {
            outputDir = this.output_dir + page + separator;
        }
        for (int i = 0; i < image_count; ++i) {
            String image_name = this.getImageName(page, i);
            BufferedImage image_to_save = this.getImage(page, image_name, false);
            ExtractImages.saveImage(image_to_save, outputDir + 'R' + image_name + '_' + page + '.' + this.imageType, this.imageType);
            image_to_save = this.getImage(page, image_name, true);
            if (image_to_save != null) {
                ExtractImages.saveImage(image_to_save, outputDir + image_name + '_' + page + '.' + this.imageType, this.imageType);
            }
            if (!this.writeOutMetadata) continue;
            this.outputMetaDataToXML(this.fileName, page, this.pdf_images, i, image_name);
        }
    }

    @Override
    void init() {
        this.type = BaseImageExtraction.ExtractTypes.IMAGES;
        super.init();
    }

    private static void saveImage(BufferedImage image_to_save, String fileName, String prefix) throws Exception {
        if (prefix.contains("tif")) {
            FileOutputStream os = new FileOutputStream(fileName);
            String tiffFlag = System.getProperty("org.jpedal.compress_tiff");
            boolean compressTiffs = tiffFlag != null;
            TiffEncoder tiffEncoder = new TiffEncoder();
            tiffEncoder.setCompressed(compressTiffs);
            tiffEncoder.write(image_to_save, os);
            os.flush();
            os.close();
        } else {
            DefaultImageHelper.write(image_to_save, prefix, fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputMetaDataToXML(String file_name, int page, PdfImageData pdf_images, int i, String image_name) {
        float x1 = pdf_images.getImageXCoord(i);
        float y1 = pdf_images.getImageYCoord(i);
        float w = pdf_images.getImageWidth(i);
        float h = pdf_images.getImageHeight(i);
        InputStream stylesheet = null;
        try {
            SecureDocumentBuilderFactory dbf = new SecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElement("meta");
            doc.appendChild(root);
            Comment creation = doc.createComment("Created " + TimeNow.getShortTimeNow());
            doc.appendChild(creation);
            Comment info = doc.createComment("Pixel Location of image x1,y1,x2,y2");
            doc.appendChild(info);
            Comment moreInfo = doc.createComment("x1,y1 is top left corner origin is bottom left corner");
            doc.appendChild(moreInfo);
            Element location = doc.createElement("PAGELOCATION");
            location.setAttribute("x1", String.valueOf(x1));
            location.setAttribute("y1", String.valueOf(y1 + h));
            location.setAttribute("x2", String.valueOf(x1 + w));
            location.setAttribute("y2", String.valueOf(y1));
            root.appendChild(location);
            Element fileName = doc.createElement("FILE");
            fileName.setAttribute("value", file_name);
            root.appendChild(fileName);
            stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/text/xmlstyle.xslt");
            TransformerFactory transformerFactory = SecureTransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
            String outputDir = this.output_dir;
            if (this.outputPagesInSeparateDirs) {
                outputDir = this.output_dir + page + separator;
            }
            transformer.transform(new DOMSource(doc), new StreamResult(outputDir + image_name + ".xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                stylesheet.close();
            }
            catch (Exception e) {
                LogWriter.writeLog(e.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        int len = args.length;
        if (len != 3) {
            System.out.println("Class takes 3 parameters: ");
            System.out.println("Value 1 is the file name or directory of PDF files to process");
            System.out.println("Value 2 is Directory for writing the images");
            System.out.println("Value 3 is image type (jpeg,tiff,png).");
            if (len > 3) {
                System.out.println("\nToo many arguments entered");
                StringBuilder arguments = new StringBuilder();
                for (String arg : args) {
                    arguments.append(arg).append('\n');
                }
                System.out.println("You entered:\n" + arguments);
            }
            System.exit(0);
        } else {
            try {
                ExtractImages.writeAllImagesToDir(args[0], args[1], args[2], true, false);
            }
            catch (PdfException e) {
                e.printStackTrace();
            }
        }
    }

    private void setOutputPagesInSeparateDirs(boolean outputPagesInSeparateDirs) {
        this.outputPagesInSeparateDirs = outputPagesInSeparateDirs;
    }

    public BufferedImage getImage(int page, int imageNumber, boolean imageAsDisplayed) throws PdfException {
        this.checkFileOpened();
        return this.getImage(page, this.getImageName(page, imageNumber), imageAsDisplayed);
    }

    private BufferedImage getImage(int page, String image_name, boolean imageAsDisplayed) throws PdfException {
        this.selectPage(page);
        if (imageAsDisplayed) {
            return this.decode_pdf.getObjectStore().loadStoredImage(image_name);
        }
        return this.decode_pdf.getObjectStore().loadStoredImage('R' + image_name);
    }

    private void setup(String outputDir, String imageType, boolean generateMetaData, boolean outputPagesInSepDirs) {
        this.imageType = imageType;
        if (outputDir != null) {
            if (!outputDir.endsWith(separator)) {
                outputDir = outputDir + separator;
            }
            this.defaultOutputDir = outputDir;
        }
        this.setCreateMetsDataXMLfile(generateMetaData);
        this.setOutputPagesInSeparateDirs(outputPagesInSepDirs);
    }

    public int getImageCount(int page) throws PdfException {
        this.checkFileOpened();
        this.selectPage(page);
        return this.pdf_images.getImageCount();
    }

    private String getImageName(int page, int imageNumber) throws PdfException {
        this.checkFileOpened();
        this.selectPage(page);
        return this.pdf_images.getImageName(imageNumber);
    }
}

