/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.idrsolutions.image.tiff.TiffEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jpedal.PdfDecoderServer;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.examples.images.BaseImageExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.ColorSpaceConvertor;

public final class ConvertPagesToHiResImages
extends BaseImageExtraction {
    private float JPEGcompression = -1.0f;

    public static void main(String[] args) {
        if (args != null && args.length > 1) {
            try {
                if (args.length == 2) {
                    ConvertPagesToHiResImages.writeAllPagesAsHiResImagesToDir(args[0], args[1], "png");
                }
                ConvertPagesToHiResImages.writeAllPagesAsHiResImagesToDir(args[0], args[1], args[2]);
            }
            catch (PdfException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        } else if (args == null) {
            System.out.println("null arguments entered");
        } else {
            System.out.println("wrong arguments entered");
            StringBuilder arguments = new StringBuilder();
            for (String arg : args) {
                arguments.append(arg).append('\n');
            }
            System.out.println("you entered:\n" + arguments + "as the arguments");
        }
    }

    public static void writeAllPagesAsHiResImagesToDir(String inputDir, String outputDir, String format) throws PdfException {
        HashMap<Integer, Object> mapValues = new HashMap<Integer, Object>();
        mapValues.put(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING, 2);
        mapValues.put(JPedalSettings.EXTRACT_AT_PAGE_SIZE, new String[]{"2000", "1600"});
        mapValues.put(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE, Boolean.TRUE);
        PdfDecoderServer.modifyJPedalParameters(mapValues);
        ConvertPagesToHiResImages convert = new ConvertPagesToHiResImages(inputDir);
        convert.setup(format, outputDir);
        convert.processFiles(inputDir);
        convert.closePDFfile();
    }

    public ConvertPagesToHiResImages(String fileName) {
        super(fileName);
        this.init();
    }

    public ConvertPagesToHiResImages(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    @Override
    void decodeFile(String pdfFile) throws PdfException {
        block8: {
            System.out.println(pdfFile);
            System.out.println(this.output_dir);
            if (!this.openPDFFile()) break block8;
            String separation = System.getProperty("org.jpedal.separation");
            if (separation != null) {
                Object[] sepValues = new Object[]{7, "", Boolean.FALSE};
                if (separation.equals("all")) {
                    sepValues = new Object[]{2, "image_and_shapes", Boolean.FALSE, 18, "image_without_shapes", Boolean.FALSE, 1, "text_and_shapes", Boolean.TRUE, 7, "all", Boolean.FALSE, 17, "text_without_shapes", Boolean.TRUE};
                }
                int sepCount = sepValues.length;
                for (int seps = 0; seps < sepCount; seps += 3) {
                    this.decode_pdf.setRenderMode((Integer)sepValues[seps]);
                    try {
                        this.extractPagesAsImages(this.output_dir, this.imageType, "_" + sepValues[seps + 1], (Boolean)sepValues[seps + 2]);
                        continue;
                    }
                    catch (IOException ex) {
                        throw new PdfException(ex.getMessage());
                    }
                }
            } else {
                try {
                    this.extractPagesAsImages(this.output_dir, this.imageType, "", false);
                }
                catch (IOException ex) {
                    throw new PdfException(ex.getMessage());
                }
            }
        }
    }

    private void extractPagesAsImages(String outputPath, String fileType, String prefix, boolean isTransparent) throws PdfException, IOException {
        File output_path = new File(this.output_dir);
        if (!output_path.exists()) {
            output_path.mkdirs();
        }
        boolean start = true;
        int end = this.getPageCount();
        String multiPageFlag = System.getProperty("org.jpedal.multipage_tiff");
        boolean isSingleOutputFile = multiPageFlag != null && multiPageFlag.equalsIgnoreCase("true");
        String tiffFlag = System.getProperty("org.jpedal.compress_tiff");
        boolean compressTiffs = tiffFlag != null && tiffFlag.equalsIgnoreCase("true");
        String rawJPEGComp = System.getProperty("org.jpedal.compression_jpeg");
        if (rawJPEGComp != null) {
            try {
                this.JPEGcompression = Float.parseFloat(rawJPEGComp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.JPEGcompression < 0.0f || this.JPEGcompression > 1.0f) {
                throw new RuntimeException("Invalid value for JPEG compression - must be between 0 and 1");
            }
            throw new RuntimeException("JPEG compression is not currently implemented. Please do not use");
        }
        String jpgFlag = System.getProperty("org.jpedal.jpeg_dpi");
        if (jpgFlag != null) {
            throw new RuntimeException("JPEG dpi is not currently implemented. Please do not use");
        }
        for (int pageNo = 1; pageNo < end + 1; ++pageNo) {
            boolean isGrayOnly;
            String outputFileName;
            BufferedImage imageToSave = this.getPageAsHiResImage(pageNo, isTransparent, null);
            this.decode_pdf.flushObjectValues(true);
            if (fileType.equals("jpg")) {
                imageToSave = ColorSpaceConvertor.convertToRGB(imageToSave);
            }
            if (isSingleOutputFile) {
                outputFileName = outputPath + "allPages" + prefix + '.' + fileType;
            } else {
                StringBuilder pageAsString = new StringBuilder(String.valueOf(pageNo));
                String maxPageSize = String.valueOf(end);
                int padding = maxPageSize.length() - pageAsString.length();
                for (int ii = 0; ii < padding; ++ii) {
                    pageAsString.insert(0, '0');
                }
                outputFileName = outputPath + "page" + pageAsString + prefix + '.' + fileType;
            }
            Iterator<Integer> colorspacesUsed = this.decode_pdf.getPageInfo(1);
            boolean bl = isGrayOnly = colorspacesUsed != null;
            while (colorspacesUsed != null && colorspacesUsed.hasNext()) {
                int nextID = colorspacesUsed.next();
                if (nextID == 1568372915 || nextID == 391471749) continue;
                isGrayOnly = false;
            }
            if (isGrayOnly) {
                BufferedImage image_to_save2 = new BufferedImage(imageToSave.getWidth(), imageToSave.getHeight(), 10);
                image_to_save2.getGraphics().drawImage(imageToSave, 0, 0, null);
                imageToSave = image_to_save2;
            }
            if (imageToSave == null) continue;
            if (fileType.startsWith("tif")) {
                File file;
                TiffEncoder tiffEncoder = new TiffEncoder();
                tiffEncoder.setCompressed(compressTiffs);
                if (isSingleOutputFile) {
                    file = new File(outputFileName);
                    if (pageNo == 1 && file.exists()) {
                        file.delete();
                        file.createNewFile();
                    }
                    tiffEncoder.append(imageToSave, outputFileName);
                } else {
                    file = new File(outputFileName);
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                    tiffEncoder.write(imageToSave, bos);
                    bos.flush();
                    bos.close();
                }
            } else {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(outputFileName)));
                ImageIO.write((RenderedImage)imageToSave, fileType, bos);
                bos.flush();
                bos.close();
            }
            imageToSave.flush();
        }
    }

    public BufferedImage getPageAsHiResImage(int page, boolean isTransparent, Map<Integer, Object> options) throws PdfException {
        return this.decode_pdf.getPageAsHiRes(page, options, isTransparent);
    }

    private void setup(String format, String outputDir) {
        if (!outputDir.endsWith(separator)) {
            outputDir = outputDir + separator;
        }
        this.imageType = format;
        this.output_dir = outputDir;
    }

    @Override
    void init() {
        FontMappings.setFontReplacements();
        this.type = BaseImageExtraction.ExtractTypes.RASTERIZED_PAGE;
        super.init();
    }
}

