/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorSpaces;
import org.jpedal.external.ImageHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ExampleImageDrawOnScreenHandler
implements ImageHandler {
    @Override
    public boolean alwaysIgnoreGenericHandler() {
        return false;
    }

    @Override
    public BufferedImage processImageData(GraphicsState gs, PdfObject XObject2) {
        return null;
    }

    @Override
    public boolean imageHasBeenScaled() {
        return false;
    }

    @Override
    public boolean drawImageOnscreen(BufferedImage image, int optionsApplied, AffineTransform upside_down, String currentImageFile, Graphics2D g2, boolean renderDirect, ObjectStore objectStoreRef, boolean isPrinting) {
        boolean isSlightlyRotated;
        double[] values = new double[6];
        upside_down.getMatrix(values);
        boolean bl = isSlightlyRotated = values[0] * values[1] != 0.0 || values[2] * values[3] != 0.0;
        if (isSlightlyRotated || image.getWidth() < 800 || renderDirect) {
            g2.drawImage(image, upside_down, null);
        } else {
            double dy = 0.0;
            double dx = 0.0;
            upside_down = new AffineTransform(values);
            boolean imageProcessed = true;
            try {
                AffineTransformOp invert = new AffineTransformOp(upside_down, ColorSpaces.hints);
                image = invert.filter(image, null);
            }
            catch (Exception ee) {
                imageProcessed = false;
                ee.printStackTrace();
            }
            catch (Error err) {
                imageProcessed = false;
                LogWriter.writeLog("Exception e " + err.getMessage());
            }
            if (imageProcessed) {
                Shape rawClip = null;
                if (isPrinting) {
                    double[] affValues = new double[6];
                    g2.getTransform().getMatrix(affValues);
                    dx = affValues[4] / affValues[0];
                    if (dx > 0.0) {
                        dx = -dx;
                    }
                    if ((dy = affValues[5] / affValues[3]) > 0.0) {
                        dy = -dy;
                    }
                    dy = -(dy + (double)image.getHeight());
                }
                if (dy != 0.0) {
                    rawClip = g2.getClip();
                    double xScale = g2.getTransform().getScaleX();
                    int xDiff = xScale < 1.0 ? (int)(1.0 / xScale) : (int)(xScale + 0.5);
                    double yScale = g2.getTransform().getScaleY();
                    int yDiff = yScale < 1.0 ? (int)(1.0 / yScale) : (int)(yScale + 0.5);
                    g2.clipRect((int)dx, (int)(dy + 1.5), image.getWidth() - xDiff, image.getHeight() - yDiff);
                }
                g2.drawImage((Image)image, (int)dx, (int)dy, null);
                if (rawClip != null) {
                    g2.setClip(rawClip);
                }
            } else {
                g2.drawImage(image, upside_down, null);
            }
        }
        return true;
    }
}

