/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.PdfDecoderInt;
import org.jpedal.PdfDecoderServer;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfObject;

public class PdfUtilities {
    private PdfFileInformation currentFileInformation;
    private byte[] byteArray;
    private boolean isOpen;
    private boolean hasEmbeddedFonts;
    private boolean testIfFontsEmbedded;
    private PdfPageData currentPageData;
    private PdfDecoderInt decode_pdf;
    private String password;
    private String fileName;

    public int getCommandCountForPageStream(int page) {
        this.decode_pdf.setExtractionMode(0);
        this.decode_pdf.decodePage(page);
        return this.decode_pdf.getDynamicRenderer().getValue(6);
    }

    public PdfUtilities(String fileName) {
        this.fileName = fileName;
        this.init();
    }

    public PdfUtilities(byte[] byteArray) {
        this.byteArray = byteArray;
        this.init();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void init() {
        FontMappings.setFontReplacements();
        this.decode_pdf = new PdfDecoderServer(false);
    }

    public int getPageCount() {
        this.checkFileOpened();
        return this.decode_pdf.getPageCount();
    }

    public boolean openPDFFile() throws PdfException {
        this.isOpen = false;
        try {
            if (this.fileName != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfFile(this.fileName);
                } else {
                    this.decode_pdf.openPdfFile(this.fileName, this.password);
                }
            } else if (this.byteArray != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfArray(this.byteArray);
                } else {
                    this.decode_pdf.openPdfArray(this.byteArray, this.password);
                }
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied()) {
                if (this.password == null) {
                    throw new PdfException("Unable to open encrypted PDF file - call setPassword(passsword) ");
                }
                if (this.password != null) {
                    throw new PdfException("Unable to open encrypted PDF file with password " + this.password);
                }
                this.isOpen = true;
            } else {
                this.isOpen = true;
                this.currentFileInformation = this.decode_pdf.getFileInformationData();
                this.currentPageData = this.decode_pdf.getPdfPageData();
            }
        }
        catch (PdfException e) {
            throw new PdfException(e.getMessage());
        }
        return this.isOpen;
    }

    public void closePDFfile() {
        this.checkFileOpened();
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.closePdfFile();
        }
        this.hasEmbeddedFonts = false;
        this.testIfFontsEmbedded = false;
    }

    public boolean hasEmbeddedFonts() {
        this.checkFileOpened();
        if (!this.testIfFontsEmbedded) {
            this.testIfFontsEmbedded = true;
            int pageCount = this.getPageCount();
            for (int page = 1; page < pageCount + 1; ++page) {
                this.decode_pdf.decodePage(page);
                this.hasEmbeddedFonts = this.decode_pdf.hasEmbeddedFonts();
                if (!this.hasEmbeddedFonts) continue;
                page = pageCount;
            }
        }
        return this.hasEmbeddedFonts;
    }

    public Map<String, String> getDocumentPropertyStringValuesAsMap() {
        this.checkFileOpened();
        String[] names = PdfFileInformation.getFieldNames();
        int count = names.length;
        String[] keys = this.currentFileInformation.getFieldValues();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            map.put(names[i], keys[i]);
        }
        return map;
    }

    public String getDocumentPropertyFieldsInXML() {
        this.checkFileOpened();
        return this.currentFileInformation.getFileXMLMetaData();
    }

    public float[] getPageDimensions(int page, PageUnits units, PageSizeType type) {
        this.checkFileOpened();
        float[] pageSize = new float[5];
        float factor = 0.0f;
        switch (units) {
            case Pixels: {
                factor = 1.0f;
                break;
            }
            case Inches: {
                factor = 72.0f;
                break;
            }
            case Centimetres: {
                factor = 28.346457f;
            }
        }
        switch (type) {
            case MediaBox: {
                pageSize[0] = (float)this.currentPageData.getMediaBoxX(page) / factor;
                pageSize[1] = (float)this.currentPageData.getMediaBoxY(page) / factor;
                pageSize[2] = (float)this.currentPageData.getMediaBoxWidth(page) / factor;
                pageSize[3] = (float)this.currentPageData.getMediaBoxHeight(page) / factor;
                break;
            }
            case CropBox: {
                pageSize[0] = (float)this.currentPageData.getCropBoxX(page) / factor;
                pageSize[1] = (float)this.currentPageData.getCropBoxY(page) / factor;
                pageSize[2] = (float)this.currentPageData.getCropBoxWidth(page) / factor;
                pageSize[3] = (float)this.currentPageData.getCropBoxHeight(page) / factor;
            }
        }
        pageSize[4] = this.currentPageData.getRotation(page);
        return pageSize;
    }

    private void checkFileOpened() {
        if (!this.isOpen) {
            throw new RuntimeException("PDF file needs to be opened with openPDFFile() method first");
        }
    }

    public int getPdfFilePermissions() {
        PdfObject encryptObj;
        int P = -1;
        if (this.decode_pdf != null && (encryptObj = this.decode_pdf.getIO().getPDFObject(1113489015)) != null) {
            P = encryptObj.getInt(32);
        }
        return P;
    }

    public static void showPermissionsAsString(int P) {
        int[] lookup = new int[32];
        int power = 1;
        for (int ptr = 0; ptr < 32; ++ptr) {
            lookup[ptr] = power;
            power *= 2;
        }
        System.out.println("PDF Security settings in Encryption Object");
        System.out.println("------------------------------------------");
        System.out.println("raw P value = " + Integer.toBinaryString(P));
        Object[] flags = new Object[]{3, "Printing", 4, "Modify", 5, "Copy/extract", 6, "Add/modify Annotation", 9, "Fill in existing forms", 10, "Extraction for accessibility", 11, "Document Assembly", 12, "Printing High-quality"};
        int count = flags.length;
        for (int ptr = 0; ptr < count; ptr += 2) {
            int bitToTest = (Integer)flags[ptr];
            String value = (String)flags[ptr + 1];
            if ((P & lookup[bitToTest]) == lookup[bitToTest]) {
                System.out.println(value + " (bit " + bitToTest + ") is allowed");
                continue;
            }
            System.out.println(value + " (bit " + bitToTest + ") is NOT allowed");
        }
    }

    public static enum PageSizeType {
        MediaBox,
        CropBox;

    }

    public static enum PageUnits {
        Pixels,
        Inches,
        Centimetres;

    }
}

