/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Graphics2D;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.Serializable;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.color.PatternDisplay;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

public class TilingPaint
implements PdfPaint,
Serializable {
    private final float xStep;
    private final float yStep;
    private final Rectangle2D rectBBox;
    private final BufferedImage image;
    private final int interpolation;
    private double[][] customScaleMatrix = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};

    @Override
    public void setScaling(double cropX, double cropH, float scaling, float textX, float textY) {
    }

    @Override
    public boolean isPattern() {
        return false;
    }

    @Override
    public boolean isTexture() {
        return true;
    }

    @Override
    public int getRGB() {
        return 0;
    }

    @Override
    public int getTransparency() {
        return 255;
    }

    public TilingPaint(PdfObject patternObj, byte[] streamData, PatternColorSpace colorSpace) {
        float[] inputs = patternObj.getFloatArray(1145198201);
        float[][] mm = inputs != null ? new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}} : new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        float[] rawBBox = patternObj.getFloatArray(303185736);
        float[] xy = Matrix.transformPoint(mm, rawBBox[0], rawBBox[1]);
        float[] xxyy = Matrix.transformPoint(mm, rawBBox[2], rawBBox[3]);
        float minX = Math.min(xy[0], xxyy[0]);
        float minY = Math.min(xy[1], xxyy[1]);
        float realW = Math.abs(xy[0] - xxyy[0]);
        float realH = Math.abs(xy[1] - xxyy[1]);
        float rawXStep = patternObj.getFloatNumber(591672680);
        float rawYStep = patternObj.getFloatNumber(591672681);
        xy = Matrix.transformPoint(mm, 0.0f, 0.0f);
        xxyy = Matrix.transformPoint(mm, rawXStep, rawYStep);
        float stepWidth = Math.abs(xy[0] - xxyy[0]);
        float stepHeight = Math.abs(xy[1] - xxyy[1]);
        int iw = Math.round(realW);
        int ih = Math.round(realH);
        iw = iw == 0 ? 1 : iw;
        ih = ih == 0 ? 1 : ih;
        int dim = iw * ih;
        float maxAllowed = 4000000.0f;
        if ((float)dim > 4000000.0f) {
            float scaleHuge = 4000000.0f / (float)dim;
            mm = new float[][]{{mm[0][0] * scaleHuge, 0.0f, 0.0f}, {0.0f, mm[1][1] * scaleHuge, 0.0f}, {mm[2][0] * scaleHuge, mm[2][1] * scaleHuge, 1.0f}};
            xy = Matrix.transformPoint(mm, rawBBox[0], rawBBox[1]);
            xxyy = Matrix.transformPoint(mm, rawBBox[2], rawBBox[3]);
            minX = Math.min(xy[0], xxyy[0]);
            minY = Math.min(xy[1], xxyy[1]);
            realW = Math.abs(xy[0] - xxyy[0]);
            realH = Math.abs(xy[1] - xxyy[1]);
            rawXStep = patternObj.getFloatNumber(591672680);
            rawYStep = patternObj.getFloatNumber(591672681);
            xy = Matrix.transformPoint(mm, 0.0f, 0.0f);
            xxyy = Matrix.transformPoint(mm, rawXStep, rawYStep);
            stepWidth = Math.abs(xy[0] - xxyy[0]);
            stepHeight = Math.abs(xy[1] - xxyy[1]);
            iw = Math.round(realW);
            ih = Math.round(realH);
            iw = iw == 0 ? 1 : iw;
            ih = ih == 0 ? 1 : ih;
            this.customScaleMatrix = new double[][]{{1.0f / scaleHuge, 0.0, 0.0}, {0.0, 1.0f / scaleHuge, 0.0}, {0.0, 0.0, 1.0}};
        }
        this.image = new BufferedImage(iw, ih, 2);
        ObjectStore localStore = new ObjectStore();
        float[][] nn = new float[3][3];
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(mm[i], 0, nn[i], 0, 3);
        }
        nn[2][0] = mm[2][0] - minX;
        nn[2][1] = mm[2][1] - minY;
        PatternDisplay glyphDisplay = colorSpace.decodePatternContent(patternObj, nn, streamData, localStore);
        this.interpolation = glyphDisplay.getSingleImagePattern() != null ? 3 : 1;
        Graphics2D g2 = this.image.createGraphics();
        glyphDisplay.setG2(g2);
        glyphDisplay.paint(null, null, null);
        this.rectBBox = new Rectangle2D.Float(minX, minY, realW, realH);
        this.xStep = stepWidth;
        this.yStep = stepHeight;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return new TilingContext(this.image, xform, this.rectBBox, this.customScaleMatrix, this.interpolation);
    }

    private static BufferedImage getScaled(BufferedImage image, int width, int height, int interpolation) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (imageWidth == width && imageHeight == height) {
            return image;
        }
        double scaleX = (double)width / (double)imageWidth;
        double scaleY = (double)height / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp scaleOP = new AffineTransformOp(scaleTransform, interpolation);
        return scaleOP.filter(image, new BufferedImage(width, height, image.getType()));
    }

    @Override
    public void setGlyphMatrix(float[][] gtm) {
    }

    private class TilingContext
    implements PaintContext {
        private final int[] imageData;
        private final double[][] toUserSpace;
        private final double offX;
        private final double offY;
        private double sx;
        private double sy;
        private final double srcW;
        private final double srcH;
        private int iw;
        private int ih;

        TilingContext(BufferedImage image, AffineTransform xform, Rectangle2D rectBBox, double[][] toCustom, int scalingType) {
            Object xformMatrix = new double[][]{{xform.getScaleX(), xform.getShearY(), 0.0}, {xform.getShearX(), xform.getScaleY(), 0.0}, {xform.getTranslateX(), xform.getTranslateY(), 1.0}};
            xformMatrix = Matrix.concatenate(xformMatrix, toCustom);
            this.toUserSpace = Matrix.inverse(xformMatrix);
            this.offX = rectBBox.getMinX();
            this.offY = rectBBox.getMinY();
            this.srcW = rectBBox.getWidth();
            this.srcH = rectBBox.getHeight();
            this.sx = Math.abs(xformMatrix[0][0]);
            this.sy = Math.abs(xformMatrix[1][1]);
            this.iw = (int)(this.sx * this.srcW);
            this.ih = (int)(this.sy * this.srcH);
            if (this.iw < 2 || this.ih < 2 || this.iw > 2000 || this.ih > 2000) {
                this.iw = image.getWidth();
                this.ih = image.getHeight();
                this.sx = 1.0;
                this.sy = 1.0;
            }
            BufferedImage destImage = TilingPaint.getScaled(image, this.iw, this.ih, TilingPaint.this.interpolation);
            this.imageData = ((DataBufferInt)destImage.getRaster().getDataBuffer()).getData();
        }

        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            BufferedImage img = new BufferedImage(w, h, 2);
            int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
            int p = 0;
            double[] src = new double[2];
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    src[0] = x + j;
                    src[1] = y + i;
                    Matrix.transformPixel(this.toUserSpace, src);
                    pixels[p++] = this.getTilingPixel(src[0], src[1]);
                }
            }
            return img.getRaster();
        }

        private int getTilingPixel(double xx, double yy) {
            double x = xx - this.offX;
            double y = yy - this.offY;
            double x_ = x % (double)TilingPaint.this.xStep;
            double y_ = y % (double)TilingPaint.this.yStep;
            if (y < 0.0) {
                y_ = (double)TilingPaint.this.yStep + y_;
            }
            if (x < 0.0) {
                x_ = (double)TilingPaint.this.xStep + x_;
            }
            if (x_ >= 0.0 && y_ >= 0.0 && x_ < this.srcW && y_ < this.srcH) {
                int ix = (int)(x_ * this.sx);
                int iy = (int)(y_ * this.sy);
                if (iy < this.ih && ix < this.iw) {
                    return this.imageData[iy * this.iw + ix];
                }
                iy = iy >= this.ih ? this.ih - 1 : iy;
                ix = ix >= this.iw ? this.iw - 1 : ix;
                return this.imageData[iy * this.iw + ix];
            }
            return 0;
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }
    }
}

