/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

class SeparationColorSpace
extends GenericColorSpace {
    GenericColorSpace altCS;
    ColorMapping colorMapper;
    float[] domain;

    SeparationColorSpace() {
    }

    SeparationColorSpace(ColorMapping colorMapper, float[] domain, GenericColorSpace altCS) {
        this.colorMapper = colorMapper;
        this.domain = domain;
        this.altCS = altCS;
        this.componentCount = 1;
        this.setType(-2073385820);
    }

    private void setColor(float value) {
        int elements = 1;
        if (this.domain != null) {
            elements = this.domain.length / 2;
        }
        float[] values = new float[elements];
        for (int j = 0; j < elements; ++j) {
            values[j] = value;
        }
        float[] operand = this.colorMapper.getOperandFloat(values);
        this.altCS.setColor(operand, operand.length);
    }

    @Override
    public void setColor(float[] operand, int opCount) {
        this.setColor(operand[0]);
    }

    @Override
    public void setColor(String[] operand, int opCount) {
        float[] f = new float[]{Float.parseFloat(operand[0])};
        this.setColor(f, 1);
    }

    @Override
    public void invalidateCaching(int color) {
        super.invalidateCaching(color);
        this.altCS.invalidateCaching(color);
        this.altCS.setColor(new PdfColor(color));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage JPEGToRGBImage(byte[] data, int ww, int hh, int pX, int pY) {
        BufferedImage image;
        ByteArrayInputStream in = null;
        ImageReader iir = null;
        ImageInputStream iin = null;
        try {
            in = new ByteArrayInputStream(data);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
            while (iterator.hasNext() && !(iir = iterator.next()).canReadRaster()) {
            }
            if (iir == null) {
                throw new IOException("Exception reading Image data");
            }
            ImageIO.setUseCache(false);
            iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            Raster ras = iir.readRaster(0, null);
            ras = SeparationColorSpace.cleanupRaster(ras, pX, pY, 1);
            int w = ras.getWidth();
            int h = ras.getHeight();
            DataBufferByte rgb = (DataBufferByte)ras.getDataBuffer();
            byte[] rawData = rgb.getData();
            if (this.altCS.getID() == 1568372915) {
                int aa = 0;
                while (aa < rawData.length) {
                    int n = aa++;
                    rawData[n] = (byte)(rawData[n] ^ 0xFF);
                }
                int[] bands = new int[]{0};
                image = new BufferedImage(w, h, 10);
                WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(rawData, rawData.length), w, h, w, 1, bands, null);
                image.setData(raster);
            } else {
                image = this.createImage(w, h, rawData);
            }
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (iir != null) {
                    iir.dispose();
                }
                if (iin != null) {
                    iin.close();
                }
            }
            catch (Exception ee) {
                LogWriter.writeLog("Problem closing  " + ee);
            }
        }
        return image;
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        BufferedImage image;
        try {
            image = this.createImage(w, h, data);
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't convert Separation colorspace data: " + ee);
        }
        return image;
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] rgb, int w, int h) {
        int pixelCount = 3 * w * h;
        byte[] imageData = new byte[pixelCount];
        int inpLen = this.domain.length / 2;
        if (inpLen == 1) {
            float last = -1.0f;
            int p = 0;
            int pp = 0;
            int ii = w * h;
            for (int i = 0; i < ii; ++i) {
                int tt;
                float cur;
                if (last == (cur = (float)(rgb[p++] & 0xFF) / 255.0f)) {
                    tt = this.altCS.getColor().getRGB();
                } else {
                    float[] operand = this.colorMapper.getOperandFloat(new float[]{cur});
                    this.altCS.setColor(operand, operand.length);
                    tt = this.altCS.getColor().getRGB();
                }
                imageData[pp++] = (byte)(tt >> 16 & 0xFF);
                imageData[pp++] = (byte)(tt >> 8 & 0xFF);
                imageData[pp++] = (byte)(tt & 0xFF);
                last = cur;
            }
        } else {
            float[] inputs = new float[inpLen];
            int p = 0;
            int pp = 0;
            int ii = w * h;
            for (int i = 0; i < ii; ++i) {
                for (int j = 0; j < inpLen; ++j) {
                    inputs[j] = (float)(rgb[p++] & 0xFF) / 255.0f;
                }
                float[] operand = this.colorMapper.getOperandFloat(inputs);
                this.altCS.setColor(operand, operand.length);
                int tt = this.altCS.getColor().getRGB();
                imageData[pp++] = (byte)(tt >> 16 & 0xFF);
                imageData[pp++] = (byte)(tt >> 8 & 0xFF);
                imageData[pp++] = (byte)(tt & 0xFF);
            }
        }
        return imageData;
    }

    BufferedImage createImage(int w, int h, byte[] rgb) {
        byte[] imageData = this.dataToRGBByteArray(rgb, w, h);
        BufferedImage image = new BufferedImage(w, h, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(imageData, w, h);
        image.setData(raster);
        return image;
    }

    @Override
    public byte[] convertIndexToRGB(byte[] data) {
        byte[] newdata = new byte[768];
        int inpLen = this.domain.length / 2;
        int palLen = data.length / inpLen;
        float[] inputs = new float[inpLen];
        int p = 0;
        int pp = 0;
        int ii = Math.min(256, palLen);
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < inpLen; ++j) {
                inputs[j] = (float)(data[p++] & 0xFF) / 255.0f;
            }
            float[] operand = this.colorMapper.getOperandFloat(inputs);
            this.altCS.setColor(operand, operand.length);
            int tt = this.altCS.getColor().getRGB();
            newdata[pp++] = (byte)(tt >> 16 & 0xFF);
            newdata[pp++] = (byte)(tt >> 8 & 0xFF);
            newdata[pp++] = (byte)(tt & 0xFF);
        }
        return newdata;
    }

    @Override
    public PdfPaint getColor() {
        return this.altCS.getColor();
    }
}

