/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.utils.ArrayUtils;
import org.jpedal.utils.LogWriter;

public class JPEGDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Raster getRasterFromJPEG(byte[] data, String type) {
        ByteArrayInputStream in = null;
        ImageReader iir = null;
        ImageInputStream iin = null;
        Raster ras = null;
        try {
            in = new ByteArrayInputStream(data);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
            while (iterator.hasNext() && !(iir = iterator.next()).canReadRaster()) {
            }
            if (iir == null) {
                throw new Exception("Exception reading Image data");
            }
            ImageIO.setUseCache(false);
            iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            ras = iir.readRaster(0, null);
        }
        catch (Exception ee) {
            LogWriter.writeLog("Problem closing  " + ee);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (iir != null) {
                    iir.dispose();
                }
                if (iin != null) {
                    iin.close();
                }
            }
            catch (Exception ee) {
                LogWriter.writeLog("Problem closing  " + ee);
            }
        }
        return ras;
    }

    static BufferedImage grayJPEGToRGBImage(byte[] data, int pX, int pY) {
        BufferedImage image = null;
        try {
            Raster ras = JPEGDecoder.getRasterFromJPEG(data, "JPEG");
            if (ras != null) {
                ras = GenericColorSpace.cleanupRaster(ras, pX, pY, 1);
                int w = ras.getWidth();
                int h = ras.getHeight();
                DataBufferByte rgb = (DataBufferByte)ras.getDataBuffer();
                byte[] rawData = rgb.getData();
                int byteLength = rawData.length;
                byte[] rgbData = new byte[byteLength * 3];
                int ptr = 0;
                for (byte aRawData : rawData) {
                    rgbData[ptr++] = aRawData;
                    rgbData[ptr++] = aRawData;
                    rgbData[ptr++] = aRawData;
                }
                int[] bands = new int[]{0, 1, 2};
                image = new BufferedImage(w, h, 1);
                WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(rgbData, rgbData.length), w, h, w * 3, 3, bands, null);
                image.setData(raster);
            }
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
        }
        return image;
    }

    public static byte[] getBytesFromJPEGWithImageIO(byte[] data, GenericColorSpace decodeColorData, PdfObject XObject2) {
        byte[] db = null;
        try {
            BufferedImage img = decodeColorData.JPEGToRGBImage(data, XObject2.getInt(959726687), XObject2.getInt(959926393), -1, -1);
            if (img.getType() == 1) {
                if ((img = ColorSpaceConvertor.convertColorspace(img, 5)) != null) {
                    Raster ras = img.getData();
                    db = ((DataBufferByte)ras.getDataBuffer()).getData();
                    for (int i = 0; i < db.length; i += 3) {
                        byte r;
                        byte b = db[i];
                        byte g = db[i + 1];
                        db[i] = r = db[i + 2];
                        db[i + 1] = g;
                        db[i + 2] = b;
                    }
                }
            } else {
                Raster ras = img.getData();
                db = ((DataBufferByte)ras.getDataBuffer()).getData();
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " with JPeg Image ");
        }
        return db;
    }

    public static byte[] getBytesFromJPEG(byte[] data, GenericColorSpace decodeColorData, PdfObject XObject2) {
        byte[] db = null;
        try {
            boolean isDeviceN;
            boolean isInverted = ArrayUtils.isArrayInverted(XObject2.getFloatArray(859785322));
            boolean isMask = XObject2 instanceof MaskObject;
            boolean bl = isDeviceN = decodeColorData.getType() == 960981604;
            if (!isDeviceN) {
                try {
                    db = ExternalHandlers.ImageLib.getBytesFromJPEG(isInverted, data, isMask);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Jpeg Data Corrupted Switching to Old Compression " + e);
                    db = JPEGDecoder.getBytesFromJPEGWithImageIO(data, decodeColorData, XObject2);
                }
            }
            if (db == null) {
                db = JPEGDecoder.getBytesFromJPEGWithImageIO(data, decodeColorData, XObject2);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception with JPeg Image " + e);
        }
        return db;
    }

    public static byte[] getUnconvertedBytesFromJPEG(byte[] data, int adobeColorTransform) throws Exception {
        return ExternalHandlers.ImageLib.getUnconvertedBytesFromJPEG(data, adobeColorTransform);
    }
}

