/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import org.jpedal.external.ExternalHandlers;

class FastColorSpaceCMYK
extends ColorSpace {
    FastColorSpaceCMYK() {
        super(9, 4);
    }

    @Override
    public float[] toRGB(float[] cv) {
        int c = (int)(cv[0] * 255.0f);
        int m = (int)(cv[1] * 255.0f);
        int y = (int)(cv[2] * 255.0f);
        int k = (int)(cv[3] * 255.0f);
        int[] rgb = ExternalHandlers.ImageLib.convertCMYKtoRGB(c, m, y, k);
        if (rgb == null) {
            float[] out = new float[4];
            out[0] = (1.0f - cv[0]) * (1.0f - cv[3]);
            out[1] = (1.0f - cv[1]) * (1.0f - cv[3]);
            out[2] = (1.0f - cv[2]) * (1.0f - cv[3]);
            return out;
        }
        return new float[]{(float)rgb[0] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[2] / 255.0f};
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

