/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.color.PdfColor;

public class DeviceGrayColorSpace
extends GenericColorSpace {
    public DeviceGrayColorSpace() {
        this.setType(1568372915);
        this.cs = ColorSpace.getInstance(1003);
    }

    @Override
    public final void setColor(String[] number_values, int opCount) {
        float[] colValues = new float[]{Float.parseFloat(number_values[0])};
        this.setColor(colValues, 1);
    }

    @Override
    public final void setColor(float[] operand, int length) {
        float tmp = operand[0];
        int val = tmp <= 1.0f ? (int)(255.0f * tmp) : (int)tmp;
        if (val < 0) {
            val = 0;
        }
        this.currentColor = new PdfColor(val, val, val);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w, int h) {
        byte[] newData = new byte[data.length * 3];
        int ptr = 0;
        for (byte aData : data) {
            newData[ptr++] = aData;
            newData[ptr++] = aData;
            newData[ptr++] = aData;
        }
        return newData;
    }

    @Override
    public byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        int count = index.length;
        byte[] newIndex = new byte[count * 3];
        for (int i = 0; i < count; ++i) {
            byte value = index[i];
            for (int j = 0; j < 3; ++j) {
                newIndex[i * 3 + j] = value;
            }
        }
        return newIndex;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] data, int w, int h, int pX, int pY) {
        return JPEGDecoder.grayJPEGToRGBImage(data, pX, pY);
    }
}

