/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import java.awt.Color;
import java.awt.geom.Point2D;
import org.jpedal.color.GenericColorSpace;

class ShadingUtils {
    ShadingUtils() {
    }

    public static Point2D findIntersect(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        double xD1 = p2.getX() - p1.getX();
        double xD2 = p4.getX() - p3.getX();
        double yD1 = p2.getY() - p1.getY();
        double yD2 = p4.getY() - p3.getY();
        double xD3 = p1.getX() - p3.getX();
        double yD3 = p1.getY() - p3.getY();
        double div = yD2 * xD1 - xD2 * yD1;
        double ua = (xD2 * yD3 - yD2 * xD3) / div;
        return new Point2D.Double(p1.getX() + ua * xD1, p1.getY() + ua * yD1);
    }

    public static Color interpolate2Color(Color first, Color second, float fraction) {
        float INT_TO_FLOAT = 0.003921569f;
        fraction = Math.min(fraction, 1.0f);
        fraction = Math.max(fraction, 0.0f);
        float R1 = (float)first.getRed() * 0.003921569f;
        float G1 = (float)first.getGreen() * 0.003921569f;
        float B1 = (float)first.getBlue() * 0.003921569f;
        float A1 = (float)first.getAlpha() * 0.003921569f;
        float R2 = (float)second.getRed() * 0.003921569f;
        float G2 = (float)second.getGreen() * 0.003921569f;
        float B2 = (float)second.getBlue() * 0.003921569f;
        float A2 = (float)second.getAlpha() * 0.003921569f;
        float DR = R2 - R1;
        float DG = G2 - G1;
        float DB = B2 - B1;
        float DA = A2 - A1;
        float red = R1 + DR * fraction;
        float green = G1 + DG * fraction;
        float blue = B1 + DB * fraction;
        float alpha = A1 + DA * fraction;
        red = Math.max(Math.min(red, 1.0f), 0.0f);
        green = Math.max(Math.min(green, 1.0f), 0.0f);
        blue = Math.max(Math.min(blue, 1.0f), 0.0f);
        alpha = Math.max(Math.min(alpha, 1.0f), 0.0f);
        return new Color(red, green, blue, alpha);
    }

    public static Point2D findDistancedPoint(double t, Point2D sp, Point2D c1, Point2D c2, Point2D ep) {
        double d = 1.0 - t;
        double dCube = d * d * d;
        double dSqr = d * d;
        double tCube = t * t * t;
        double tSqr = t * t;
        double xCoord = dCube * sp.getX() + 3.0 * t * dSqr * c1.getX() + 3.0 * tSqr * d * c2.getX() + tCube * ep.getX();
        double yCoord = dCube * sp.getY() + 3.0 * t * dSqr * c1.getY() + 3.0 * tSqr * d * c2.getY() + tCube * ep.getY();
        return new Point2D.Double(xCoord, yCoord);
    }

    static void setBackground(int w, int h, int[] data, GenericColorSpace shadingColorSpace, float[] background) {
        shadingColorSpace.setColor(background, 4);
        Color c = (Color)((Object)shadingColorSpace.getColor());
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int base = (i * w + j) * 4;
                data[base] = c.getRed();
                data[base + 1] = c.getGreen();
                data[base + 2] = c.getBlue();
                data[base + 3] = 255;
            }
        }
    }

    public static void setBackgroundColor(int w, int h, int[] data, GenericColorSpace shadingColorSpace, float[] background) {
        shadingColorSpace.setColor(background, 4);
        Color c = (Color)((Object)shadingColorSpace.getColor());
        int cint = 0xFF000000 | c.getRGB();
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                data[i * w + j] = cint;
            }
        }
    }
}

