/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

class RadialContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final float[] background;
    private final PDFFunction[] function;
    private boolean[] extended = new boolean[]{false, false};
    private float t0;
    private float t1 = 1.0f;
    private final float x0;
    private final float y0;
    private final float r0;
    private final float r1;
    private final float deltaX;
    private final float deltaY;
    private final float deltaR;
    private final float deltaC;
    private final float powerR0;
    private final Color colorT0;
    private final Color colorT1;
    private AffineTransform inversed = new AffineTransform();

    RadialContext(AffineTransform xForm, GenericColorSpace shadingColorSpace, float[] background, PdfObject shading, float[][] mm, PDFFunction[] function) {
        float[] domain;
        this.shadingColorSpace = shadingColorSpace;
        this.background = background;
        this.function = function;
        float[] src = shading.getFloatArray(1061308290);
        boolean[] extension = shading.getBooleanArray(1144345468);
        if (extension != null) {
            this.extended = extension;
        }
        if ((domain = shading.getFloatArray(1026641277)) != null) {
            this.t0 = domain[0];
            this.t1 = domain[1];
        }
        float[] coords = new float[src.length];
        System.arraycopy(src, 0, coords, 0, src.length);
        AffineTransform shadeAffine = new AffineTransform();
        if (mm != null) {
            shadeAffine = new AffineTransform(mm[0][0], mm[0][1], mm[1][0], mm[1][1], mm[2][0], mm[2][1]);
        }
        try {
            AffineTransform invXF = xForm.createInverse();
            AffineTransform invSH = shadeAffine.createInverse();
            invSH.concatenate(invXF);
            this.inversed = (AffineTransform)invSH.clone();
        }
        catch (NoninvertibleTransformException ex) {
            LogWriter.writeLog("Exception " + ex + ' ');
        }
        this.x0 = coords[0];
        this.y0 = coords[1];
        this.r0 = coords[2];
        float x1 = coords[3];
        float y1 = coords[4];
        this.r1 = coords[5];
        this.colorT0 = this.calculateColor(this.t0);
        this.colorT1 = this.calculateColor(this.t1);
        this.deltaX = x1 - this.x0;
        this.deltaY = y1 - this.y0;
        this.deltaR = this.r1 - this.r0;
        this.deltaC = this.deltaX * this.deltaX + this.deltaY * this.deltaY - this.deltaR * this.deltaR;
        this.powerR0 = this.r0 * this.r0;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    private Color calculateColor(float val) {
        float[] colValues = ShadingFactory.applyFunctions(this.function, new float[]{val});
        this.shadingColorSpace.setColor(colValues, colValues.length);
        return (Color)((Object)this.shadingColorSpace.getColor());
    }

    @Override
    public Raster getRaster(int startX, int startY, int w, int h) {
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            ShadingUtils.setBackgroundColor(w, h, data, this.shadingColorSpace, this.background);
        }
        float[] xy = new float[2];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                xy[0] = startX + x;
                xy[1] = startY + y;
                this.inversed.transform(xy, 0, xy, 0, 1);
                Color result = null;
                this.quadraticEquate(xy);
                if (xy[1] >= 0.0f && xy[1] <= 1.0f) {
                    result = this.calculateColor(this.getTfromS(xy[1]));
                } else if (this.extended[1] && xy[1] >= 0.0f && this.r1 + xy[1] * this.deltaR >= 0.0f) {
                    result = this.colorT1;
                } else if (xy[0] >= 0.0f && xy[0] <= 1.0f) {
                    result = this.calculateColor(this.getTfromS(xy[0]));
                } else if (this.extended[0] && xy[1] <= 0.0f && this.r1 + xy[1] * this.deltaR >= 0.0f) {
                    result = this.calculateColor(this.getTfromS(xy[1]));
                } else if (this.extended[0] && xy[0] <= 1.0f && this.r1 + xy[0] * this.deltaR >= 0.0f) {
                    result = this.colorT0;
                }
                if (result == null) continue;
                data[y * w + x] = 0xFF000000 | result.getRGB();
            }
        }
        return raster;
    }

    private float getTfromS(float s) {
        return s * (this.t1 - this.t0) + this.t0;
    }

    private void quadraticEquate(float[] xy) {
        float xDiff = xy[0] - this.x0;
        float yDiff = xy[1] - this.y0;
        float p = -xDiff * this.deltaX - yDiff * this.deltaY - this.r0 * this.deltaR;
        float q = xDiff * xDiff + yDiff * yDiff - this.powerR0;
        float sqrt = (float)Math.sqrt(p * p - this.deltaC * q);
        float sA = (sqrt - p) / this.deltaC;
        float sB = (-p - sqrt) / this.deltaC;
        if (this.deltaC < 0.0f) {
            xy[0] = sA;
            xy[1] = sB;
        } else {
            xy[0] = sB;
            xy[1] = sA;
        }
    }
}

