/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

class LatticeFormShadeContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final float[] background;
    private final float[][] toUserSpace;
    private final float[][] toShadeSpace;
    private final float[] decodeArr;
    private final PDFFunction[] function;
    private final int nComp;
    private final List<float[]> triCoords;
    private final List<Color> triColors;
    private final int triCount;

    LatticeFormShadeContext(AffineTransform xform, GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] sm, float[][] gm, PDFFunction[] function) {
        this.shadingColorSpace = shadingColorSpace;
        int bitsPerComponent = shadingObject.getInt(-1344207655);
        int bitsPerFlag = shadingObject.getInt(1500422077);
        int bitsPerCoordinate = shadingObject.getInt(-335950113);
        this.decodeArr = shadingObject.getFloatArray(859785322);
        this.function = function;
        this.background = background;
        this.nComp = (this.decodeArr.length - 4) / 2;
        int verticesPerRow = shadingObject.getInt(-1180057884);
        Object shadeMatrix = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        if (sm != null) {
            shadeMatrix = sm;
        }
        Object xformMatrix = new float[][]{{(float)xform.getScaleX(), (float)xform.getShearX(), 0.0f}, {(float)xform.getShearY(), (float)xform.getScaleY(), 0.0f}, {(float)xform.getTranslateX(), (float)xform.getTranslateY(), 1.0f}};
        if (gm != null) {
            float[][] g100 = new float[][]{{gm[0][0] / 100.0f, gm[0][1] / 100.0f, 0.0f}, {gm[1][0] / 100.0f, gm[1][1] / 100.0f, 0.0f}, {gm[2][0], gm[2][1], 1.0f}};
            xformMatrix = Matrix.concatenate(xformMatrix, Matrix.inverse(g100));
        }
        this.toUserSpace = Matrix.inverse(xformMatrix);
        this.toShadeSpace = Matrix.inverse(shadeMatrix);
        boolean hasSmallBits = bitsPerFlag < 8 || bitsPerComponent < 8 || bitsPerCoordinate < 8;
        BitReader reader = new BitReader(shadingObject.getDecodedStream(), hasSmallBits);
        double bitCoordScaling = 1.0 / (double)((1L << bitsPerCoordinate) - 1L);
        double bitCompScaling = 1.0 / (double)((1L << bitsPerComponent) - 1L);
        ArrayList trianglesPoints = new ArrayList();
        this.triColors = new ArrayList<Color>();
        ArrayList<Point2D> pList = new ArrayList<Point2D>();
        ArrayList<Color> cList = new ArrayList<Color>();
        while (reader.getPointer() < reader.getTotalBitLen()) {
            Point2D p = LatticeFormShadeContext.getPointCoords(reader, bitCoordScaling, bitsPerCoordinate, this.decodeArr);
            Color c = this.getPointColor(reader, bitCompScaling, bitsPerComponent);
            pList.add(p);
            cList.add(c);
        }
        int totalRows = pList.size() / verticesPerRow;
        for (int mm = 0; mm < totalRows - 1; ++mm) {
            int mRows = mm * totalRows;
            for (int nn = 0; nn < verticesPerRow - 1; ++nn) {
                int nm = nn + mRows;
                int[] t = new int[6];
                t[0] = nm;
                t[1] = t[3] = nm + 1;
                t[2] = t[4] = nm + verticesPerRow;
                t[5] = nm + verticesPerRow + 1;
                for (int aT : t) {
                    trianglesPoints.add(pList.get(aT));
                    this.triColors.add((Color)cList.get(aT));
                }
            }
        }
        this.triCoords = new ArrayList<float[]>();
        for (Point2D trianglesPoint : trianglesPoints) {
            float[] xy = new float[]{(float)trianglesPoint.getX(), (float)trianglesPoint.getY()};
            this.triCoords.add(xy);
        }
        this.triCount = this.triCoords.size() / 3;
        Matrix.show(shadeMatrix);
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    private static Point2D getPointCoords(BitReader reader, double bitScaling, int bps, float[] decode) {
        long x_ = reader.readBitsAsLong(bps);
        long y_ = reader.readBitsAsLong(bps);
        double x = (double)x_ * bitScaling * (double)(decode[1] - decode[0]) + (double)decode[0];
        double y = (double)y_ * bitScaling * (double)(decode[3] - decode[2]) + (double)decode[2];
        return new Point2D.Double(x, y);
    }

    private Color getPointColor(BitReader reader, double bitScaling, int bps) {
        float[] components = new float[this.nComp];
        int i = 0;
        int j = 4;
        while (i < this.nComp) {
            long ci = reader.readBitsAsLong(bps);
            components[i] = (float)((double)ci * bitScaling * (double)(this.decodeArr[j + 1] - this.decodeArr[j]) + (double)this.decodeArr[j]);
            ++i;
            j += 2;
        }
        return this.calculateColor(components);
    }

    @Override
    public Raster getRaster(int startX, int startY, int w, int h) {
        int rastSize = w * h * 4;
        int[] data = new int[rastSize];
        if (this.background != null) {
            ShadingUtils.setBackground(w, h, data, this.shadingColorSpace, this.background);
        }
        for (int i = 0; i < h; ++i) {
            block1: for (int j = 0; j < w; ++j) {
                float[] src = new float[]{startX + j, startY + i};
                src = Matrix.transformPoint(this.toUserSpace, src[0], src[1]);
                src = Matrix.transformPoint(this.toShadeSpace, src[0], src[1]);
                float x = src[0];
                float y = src[1];
                for (int t = 0; t < this.triCount; ++t) {
                    float y3;
                    int p = t * 3;
                    float[] temp = this.triCoords.get(p);
                    float x1 = temp[0];
                    float y1 = temp[1];
                    temp = this.triCoords.get(p + 1);
                    float x2 = temp[0];
                    float y2 = temp[1];
                    float x3 = (temp = this.triCoords.get(p + 2))[0];
                    if (!LatticeFormShadeContext.isInTriangle(x, y, x1, y1, x2, y2, x3, y3 = temp[1])) continue;
                    Color c1 = this.triColors.get(p);
                    Color c2 = this.triColors.get(p + 1);
                    Color c3 = this.triColors.get(p + 2);
                    float a = LatticeFormShadeContext.areaTriangle(x1, y1, x2, y2, x3, y3);
                    float a1 = LatticeFormShadeContext.areaTriangle(x, y, x1, y1, x2, y2);
                    float a2 = LatticeFormShadeContext.areaTriangle(x, y, x1, y1, x3, y3);
                    float a3 = LatticeFormShadeContext.areaTriangle(x, y, x2, y2, x3, y3);
                    int r = (int)(a1 / a * (float)c3.getRed() + a2 / a * (float)c2.getRed() + a3 / a * (float)c1.getRed());
                    int g = (int)(a1 / a * (float)c3.getGreen() + a2 / a * (float)c2.getGreen() + a3 / a * (float)c1.getGreen());
                    int b = (int)(a1 / a * (float)c3.getBlue() + a2 / a * (float)c2.getBlue() + a3 / a * (float)c1.getBlue());
                    int base = (i * w + j) * 4;
                    data[base] = r;
                    data[base + 1] = g;
                    data[base + 2] = b;
                    data[base + 3] = 255;
                    continue block1;
                }
            }
        }
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    private Color calculateColor(float[] val) {
        Color col;
        if (this.function != null) {
            float[] colValues = ShadingFactory.applyFunctions(this.function, val);
            this.shadingColorSpace.setColor(colValues, colValues.length);
            col = (Color)((Object)this.shadingColorSpace.getColor());
        } else {
            this.shadingColorSpace.setColor(val, val.length);
            col = (Color)((Object)this.shadingColorSpace.getColor());
        }
        return col;
    }

    private static float areaTriangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        return Math.abs((x1 - x3) * (y2 - y1) - (x1 - x2) * (y3 - y1));
    }

    private static boolean isInTriangle(float x, float y, float x1, float y1, float x2, float y2, float x3, float y3) {
        float dX = x - x3;
        float dY = y - y3;
        float dX21 = x3 - x2;
        float dY12 = y2 - y3;
        float D2 = dY12 * (x1 - x3) + dX21 * (y1 - y3);
        float s = dY12 * dX + dX21 * dY;
        float t = (y3 - y1) * dX + (x1 - x3) * dY;
        if (D2 < 0.0f) {
            return s <= 0.0f && t <= 0.0f && s + t >= D2;
        }
        return s >= 0.0f && t >= 0.0f && s + t <= D2;
    }
}

