/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.blends;

import java.awt.CompositeContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.CompositeUtil;

class BlendComposite
implements CompositeContext {
    private final float fixedAlpha;
    private final ColorModel srcModel;
    private final ColorModel dstModel;
    private final int bm;

    BlendComposite(ColorModel srcColorModel, ColorModel dstColorModel, int blendMode, float alpha) {
        this.srcModel = srcColorModel;
        this.dstModel = dstColorModel;
        this.fixedAlpha = alpha;
        this.bm = blendMode;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int snComp = this.srcModel.getNumComponents();
        int bnComp = this.dstModel.getNumComponents();
        int snColors = this.srcModel.getNumColorComponents();
        int bnColors = this.dstModel.getNumColorComponents();
        int width = Math.min(Math.min(src.getWidth(), dstIn.getWidth()), dstOut.getWidth());
        int height = Math.min(Math.min(src.getHeight(), dstIn.getHeight()), dstOut.getHeight());
        float[] sColors = new float[snComp];
        float[] bColors = new float[bnComp];
        boolean hasAlphaS = this.srcModel.hasAlpha();
        boolean hasAlphaB = this.dstModel.hasAlpha();
        Object srcPixel = null;
        Object dstPixel = null;
        float vv = 0.0f;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                dstPixel = dstIn.getDataElements(x, y, dstPixel);
                bColors = this.dstModel.getNormalizedComponents(dstPixel, bColors, 0);
                srcPixel = src.getDataElements(x, y, srcPixel);
                sColors = this.srcModel.getNormalizedComponents(srcPixel, sColors, 0);
                boolean isWhite = BlendComposite.isWhiteBackdrop(bColors);
                float aS = hasAlphaS ? sColors[snColors] : 1.0f;
                float aB = hasAlphaB ? bColors[bnColors] : 1.0f;
                float aR = aB + (aS *= this.fixedAlpha) - aS * aB;
                for (int i = 0; i < bnColors; ++i) {
                    float cS = sColors[i];
                    float cB = bColors[i];
                    vv = isWhite ? cS : BlendComposite.getVv(cS, cB, vv, this.bm);
                    bColors[i] = vv = CompositeUtil.composite(aS, aB, aR, cS, cB, vv);
                }
                if (hasAlphaB) {
                    bColors[bnColors] = aR;
                }
                dstPixel = this.dstModel.getDataElements(bColors, 0, dstPixel);
                dstOut.setDataElements(x, y, dstPixel);
            }
        }
    }

    private static float getVv(float cS, float cB, float vv, int bm) {
        switch (bm) {
            case 1451587725: {
                vv = CompositeUtil.blendMultiply(cS, cB);
                break;
            }
            case 1110792305: {
                vv = CompositeUtil.blendScreen(cS, cB);
                break;
            }
            case 1113290622: {
                vv = CompositeUtil.blendOverLay(cS, cB);
                break;
            }
            case 1111181679: {
                vv = CompositeUtil.blendDarken(cS, cB);
                break;
            }
            case 945843829: {
                vv = CompositeUtil.blendLighten(cS, cB);
                break;
            }
            case 2071170184: {
                vv = CompositeUtil.blendColorDodge(cS, cB);
                break;
            }
            case 1367441811: {
                vv = CompositeUtil.blendColorBurn(cS, cB);
                break;
            }
            case 1786342520: {
                vv = CompositeUtil.blendHardLight(cS, cB);
                break;
            }
            case 2020441219: {
                vv = CompositeUtil.blendSoftLight(cS, cB);
                break;
            }
            case 1802796208: {
                vv = CompositeUtil.blendDifference(cS, cB);
                break;
            }
            case -1955824744: {
                vv = CompositeUtil.blendExclusion(cS, cB);
            }
        }
        return vv;
    }

    private static boolean isWhiteBackdrop(float[] bColors) {
        for (float bColor : bColors) {
            if (bColor == 1.0f) continue;
            return false;
        }
        return true;
    }
}

