/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa.shadings;

import com.idrsolutions.pdf.acroforms.xfa.shadings.XFAShadeContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.PdfPaint;

class LinearShadeContext
extends XFAShadeContext {
    private final int xdir;
    private final int ydir;
    private final float[] coords;

    LinearShadeContext(float[] coords, int xDir, int yDir, PdfPaint startColor, PdfPaint endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.coords = coords;
        this.ydir = yDir;
        this.xdir = xDir;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xstart, int ystart, int w, int h) {
        int rastSize = w * h * 4;
        int[] data = new int[rastSize];
        double width = (this.coords[2] - this.coords[0]) * this.scaling;
        double height = (this.coords[3] - this.coords[1]) * this.scaling;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int[] fCol = this.interpolate(x + xstart, y + ystart, width, height);
                int base = (y * w + x) * 4;
                data[base] = fCol[0];
                data[base + 1] = fCol[1];
                data[base + 2] = fCol[2];
                data[base + 3] = 255;
            }
        }
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    private int[] interpolate(int x, int y, double width, double height) {
        int fb;
        int fg;
        int fr;
        int startCol = this.startColor.getRGB();
        int sr = startCol >> 16 & 0xFF;
        int sg = startCol >> 8 & 0xFF;
        int sb = startCol & 0xFF;
        int endCol = this.endColor.getRGB();
        int er = endCol >> 16 & 0xFF;
        int eg = endCol >> 8 & 0xFF;
        int eb = endCol & 0xFF;
        if (this.xdir != 0) {
            double endVal = (x = (int)((float)x - (this.coords[0] * this.scaling + (float)this.offX))) == 0 ? 0.0 : (double)x / width;
            double startVal = 1.0 - endVal;
            if (this.xdir == -1) {
                double tmp = endVal;
                endVal = startVal;
                startVal = tmp;
            }
            fr = (int)((double)sr * startVal + (double)er * endVal);
            fg = (int)((double)sg * startVal + (double)eg * endVal);
            fb = (int)((double)sb * startVal + (double)eb * endVal);
        } else {
            double endVal = (y = (int)((float)y - ((float)this.pHeight - this.coords[3] * this.scaling + (float)this.offY))) == 0 ? 0.0 : (double)y / height;
            double startVal = 1.0 - endVal;
            if (this.ydir == -1) {
                double tmp = endVal;
                endVal = startVal;
                startVal = tmp;
            }
            fr = (int)((double)sr * startVal + (double)er * endVal);
            fg = (int)((double)sg * startVal + (double)eg * endVal);
            fb = (int)((double)sb * startVal + (double)eb * endVal);
        }
        return new int[]{fr, fg, fb};
    }
}

