/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XFAUtils;
import org.jpedal.color.PdfColor;
import org.w3c.dom.Node;

public class XFontInfo {
    private String typeFace = "Courier";
    private int size = 10;
    private int weight;
    private int posture;
    private PdfColor color = new PdfColor(0, 0, 0);

    public XFontInfo(String typeFace, int size, int weight) {
        this.typeFace = typeFace;
        this.size = size;
        this.weight = weight;
    }

    public XFontInfo(String typeFace, int size, int weight, int posture, PdfColor color) {
        this.typeFace = typeFace;
        this.size = size;
        this.weight = weight;
        this.color = color;
        this.posture = posture;
    }

    public XFontInfo() {
        this.weight = 0;
        this.posture = 0;
    }

    public static XFontInfo getFontInfoFromNode(Node node) {
        int z;
        XFontInfo fontInfo = new XFontInfo();
        block15: for (z = 0; z < node.getAttributes().getLength(); ++z) {
            String itemName = node.getAttributes().item(z).getNodeName();
            String itemValue = node.getAttributes().item(z).getNodeValue();
            switch (itemName.hashCode()) {
                case -675792745: {
                    fontInfo.setTypeFace(itemValue);
                    continue block15;
                }
                case 3530753: {
                    fontInfo.size = (int)XFAUtils.convertToPoints(itemValue);
                    continue block15;
                }
                case -791592328: {
                    if (itemValue.hashCode() != 3029637) continue block15;
                    fontInfo.weight = 1;
                    continue block15;
                }
                case -391190328: {
                    fontInfo.posture = 2;
                }
            }
        }
        block16: for (z = 0; z < node.getChildNodes().getLength(); ++z) {
            Node fChild = node.getChildNodes().item(z);
            switch (fChild.getNodeName().hashCode()) {
                case 3143043: {
                    block17: for (int a = 0; a < fChild.getChildNodes().getLength(); ++a) {
                        Node fc = fChild.getChildNodes().item(a);
                        switch (fc.getNodeName().hashCode()) {
                            case 94842723: {
                                for (int c = 0; c < fc.getAttributes().getLength(); ++c) {
                                    String attName = fc.getAttributes().item(c).getNodeName();
                                    String attValue = fc.getAttributes().item(c).getNodeValue();
                                    switch (attName.hashCode()) {
                                        case 111972721: {
                                            String[] str = attValue.split(",");
                                            fontInfo.color = new PdfColor(Integer.parseInt(str[0]), Integer.parseInt(str[1]), Integer.parseInt(str[2]));
                                        }
                                    }
                                }
                                continue block17;
                            }
                        }
                    }
                    continue block16;
                }
            }
        }
        return fontInfo;
    }

    public String getTypeFace() {
        return this.typeFace;
    }

    public void setTypeFace(String typeFace) {
        this.typeFace = typeFace.replaceAll("'", "");
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getPosture() {
        return this.posture;
    }

    public PdfColor getColor() {
        return this.color;
    }

    public void setColor(PdfColor color) {
        this.color = color;
    }

    public String toString() {
        return "XFontInfo{typeFace=" + this.typeFace + ", size=" + this.size + ", weight=" + this.weight + ", posture=" + this.posture + ", color=" + this.color + '}';
    }
}

