/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import java.awt.Rectangle;
import org.jpedal.color.PdfColor;

public class XFAUtils {
    private static double convertToMilliPoints(String str) {
        if (!Character.isDigit(str.charAt(0)) && str.charAt(0) != '-') {
            return 0.0;
        }
        str = str.toLowerCase();
        double retValue = Double.parseDouble(str.substring(0, str.length() - 2));
        if (str.contains("pt")) {
            retValue *= 1000.0;
        } else if (str.contains("mm")) {
            retValue *= 2834.64567;
        } else if (str.contains("cm")) {
            retValue *= 28346.4567;
        } else if (str.contains("in")) {
            retValue *= 72000.0;
        } else if (str.contains("px")) {
            retValue *= 0.0;
        } else if (str.contains("em")) {
            retValue *= 12000.0;
        } else {
            System.err.println("xfa value not found for " + str);
        }
        return retValue;
    }

    public static double convertToPoints(String str) {
        return XFAUtils.convertToMilliPoints(str) / 1000.0;
    }

    public static Rectangle propotionate(double actualW, double actualH, double maxW, double maxH) {
        Rectangle rect = new Rectangle();
        double ratio = Math.min(maxW / actualW, maxH / actualH);
        rect.width = (int)(actualW * ratio);
        rect.height = (int)(actualH * ratio);
        return rect;
    }

    public static PdfColor getPdfColorFromStyle(String colorStr) {
        if (colorStr.startsWith("#")) {
            return new PdfColor(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
        }
        if (colorStr.contains(",")) {
            colorStr = colorStr.contains("(") ? colorStr.substring(colorStr.indexOf(40) + 1, colorStr.indexOf(41)) : colorStr;
            String[] arr = colorStr.split(",");
            return new PdfColor(Integer.parseInt(arr[0]), Integer.parseInt(arr[1]), Integer.parseInt(arr[2]));
        }
        return null;
    }

    public static String convertXFANameToZeroArrayFormat(String lifeCycleName) {
        String[] arr = lifeCycleName.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String s : arr) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            s = s.endsWith("]") ? s : s + "[0]";
            sb.append(s);
        }
        return sb.toString();
    }
}

