/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.objects.XFAField;
import java.awt.Rectangle;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class XFAFormObject
extends FormObject {
    private XFAField.XFARawDataType xfaRawDataType = XFAField.XFARawDataType.TEXTEDIT;
    private int layout;
    private String script;
    private String scriptType;
    private int heightOfCaption;
    private int widthOfCaption;
    private int captionPosition;
    private int outline;
    private int choiceShown;
    private int borderStroke;
    private int activity = -1;
    private String typeface;
    private int numericValue;
    private boolean editable;
    private int marginBottomInset;
    private int marginTopInset;
    private int marginLeftInset;
    private int marginRightInset;
    private int submitDataFormat;
    private String submitURL;
    private int submitTextEncode;
    private int longMedium;
    private int shortMedium;
    private String stdPaperName;
    private float verticalAlign;

    protected XFAFormObject() {
        this.isXFAObject = true;
        this.F = 4;
    }

    @Override
    public PdfObject duplicate() {
        XFAFormObject newObject = (XFAFormObject)super.duplicate();
        newObject.activity = this.activity;
        newObject.borderStroke = this.borderStroke;
        newObject.captionPosition = this.captionPosition;
        newObject.choiceShown = this.choiceShown;
        newObject.heightOfCaption = this.heightOfCaption;
        newObject.layout = this.layout;
        newObject.longMedium = this.longMedium;
        newObject.numericValue = this.numericValue;
        newObject.marginBottomInset = this.marginBottomInset;
        newObject.marginTopInset = this.marginTopInset;
        newObject.marginLeftInset = this.marginLeftInset;
        newObject.marginRightInset = this.marginRightInset;
        newObject.outline = this.outline;
        newObject.shortMedium = this.shortMedium;
        newObject.submitDataFormat = this.submitDataFormat;
        newObject.submitTextEncode = this.submitTextEncode;
        newObject.widthOfCaption = this.widthOfCaption;
        newObject.script = this.script;
        newObject.scriptType = this.scriptType;
        newObject.stdPaperName = this.stdPaperName;
        newObject.submitURL = this.submitURL;
        newObject.typeface = this.typeface;
        newObject.editable = this.editable;
        newObject.verticalAlign = this.verticalAlign;
        return newObject;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n  layout=");
        buf.append(this.layout);
        buf.append("\n  scriptname=");
        buf.append(this.script);
        buf.append("\n  heightofcaption=");
        buf.append(this.heightOfCaption);
        buf.append("\n  widthofcaption=");
        buf.append(this.widthOfCaption);
        buf.append("\n  captionposition=");
        buf.append(this.captionPosition);
        buf.append("\n  outline=");
        buf.append(this.outline);
        buf.append("\n  choiceshown=");
        buf.append(this.choiceShown);
        buf.append("\n  borderstroke=");
        buf.append(this.borderStroke);
        buf.append("\n  activity=");
        buf.append(this.activity);
        buf.append("\n  typeface=");
        buf.append(this.typeface);
        buf.append("\n  numericvalue=");
        buf.append(this.numericValue);
        buf.append("\n  editable=");
        buf.append(this.editable);
        buf.append("\n  maginbottom=");
        buf.append(this.marginBottomInset);
        buf.append("\n  margintop=");
        buf.append(this.marginTopInset);
        buf.append("\n  marginleft=");
        buf.append(this.marginLeftInset);
        buf.append("\n  marginright=");
        buf.append(this.marginRightInset);
        buf.append("\n  submitdataformat=");
        buf.append(this.submitDataFormat);
        buf.append("\n  submiturl=");
        buf.append(this.submitURL);
        buf.append("\n  submittextencoding=");
        buf.append(this.submitTextEncode);
        buf.append("\n  longmedium=");
        buf.append(this.longMedium);
        buf.append("\n  shortmedium=");
        buf.append(this.shortMedium);
        buf.append("\n  stdpapername=");
        buf.append(this.stdPaperName);
        buf.append("\n  verticalalign=");
        buf.append(this.verticalAlign);
        return super.toString() + buf;
    }

    public int getBorderStroke() {
        return this.borderStroke;
    }

    protected void setBorderStroke(String attValue) {
        if (attValue.equals("solid")) {
            this.borderStroke = 5;
        } else if (attValue.equals("dashed")) {
            this.borderStroke = 1;
        } else if (attValue.equals("dotted")) {
            this.borderStroke = 2;
        } else if (attValue.equals("dashDot")) {
            this.borderStroke = 3;
        } else if (attValue.equals("dashDotDot")) {
            this.borderStroke = 4;
        } else if (attValue.equals("lowered")) {
            this.borderStroke = 6;
            this.getDictionary(4643).setName(35, "I".getBytes());
        } else if (attValue.equals("raised")) {
            this.borderStroke = 7;
            this.getDictionary(4643).setName(35, "B".getBytes());
        } else if (attValue.equals("etched")) {
            this.borderStroke = 8;
        } else if (attValue.equals("embossed")) {
            this.borderStroke = 9;
            this.getDictionary(4643).setName(35, "B".getBytes());
        } else {
            LogWriter.writeLog("[forms] XFAFormObject.setBorderStroke not taking " + attValue);
        }
    }

    protected void setXYWH(double[] coords) {
        if (this.BBox == null) {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        this.BBox.x = (int)coords[0];
        this.BBox.y = (int)coords[1];
        this.BBox.width = (int)coords[2];
        this.BBox.height = (int)coords[3];
    }

    public XFAField.XFARawDataType getXFARawDataType() {
        return this.xfaRawDataType;
    }

    protected void setXFARawDataType(XFAField.XFARawDataType type) {
        this.xfaRawDataType = type;
    }
}

