/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webm;

import com.idrsolutions.image.webm.BitDecoder;
import com.idrsolutions.image.webm.LittleReader;
import com.idrsolutions.image.webm.LookUp;
import com.idrsolutions.image.webm.MacroBlock;
import com.idrsolutions.image.webm.SegmentQuants;
import com.idrsolutions.image.webm.SubBlock;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.List;

class Frame {
    private static final int BLOCK_TYPES = 4;
    private static final int COEF_BANDS = 8;
    private static final int MAX_ENTROPY_TOKENS = 12;
    private static final int MAX_MODE_LF_DELTAS = 4;
    private static final int MAX_REF_LF_DELTAS = 4;
    private static final int PREV_COEF_CONTEXTS = 3;
    private final int[][][][] coefProbs;
    private boolean debug;
    private int filterLevel;
    private int filterType;
    private int frameType;
    private final LittleReader reader;
    private int height;
    private int mbCols;
    private int macroBlockNoCoeffSkip;
    private int mbRows;
    private MacroBlock[][] macroBlocks;
    private int macroBlockSegementAbsoluteDelta;
    private int[] macroBlockSegmentTreeProbs;
    private final int[] modeLoopFilterDeltas = new int[4];
    private int modeRefLoopFilterDeltaEnabled;
    private int multiTokenPartition;
    private int offset;
    private final int[] refLoopFilterDeltas = new int[4];
    private int segmentationIsEnabled;
    private SegmentQuants segmentQuants;
    private int sharpnessLevel;
    private BitDecoder tokenBoolDecoder;
    private final List<BitDecoder> tokenBitDecoders;
    private int mBlockMap;
    private int width;

    Frame(LittleReader stream) {
        this.reader = stream;
        this.offset = this.reader.getPosition();
        this.coefProbs = LookUp.getClonedDCP();
        this.tokenBitDecoders = new ArrayList<BitDecoder>();
    }

    private void createMacroBlocks() {
        this.macroBlocks = new MacroBlock[this.mbCols + 2][this.mbRows + 2];
        for (int x = 0; x < this.mbCols + 2; ++x) {
            for (int y = 0; y < this.mbRows + 2; ++y) {
                this.macroBlocks[x][y] = new MacroBlock(x, y, this.debug);
            }
        }
    }

    public void decodeFrame(boolean debug) {
        int modeRefLoopFilterDeltaUpdate;
        this.debug = debug;
        this.segmentQuants = new SegmentQuants();
        this.reader.seek(this.offset++);
        int c = this.reader.getUINT8();
        this.frameType = Frame.getBitAsInt(c, 0);
        if (this.frameType != 0) {
            return;
        }
        int firstPartitionLengthInBytes = Frame.getBitAsInt(c, 5);
        firstPartitionLengthInBytes += Frame.getBitAsInt(c, 6) << 1;
        firstPartitionLengthInBytes += Frame.getBitAsInt(c, 7) << 2;
        c = this.reader.getUINT8();
        firstPartitionLengthInBytes += c << 3;
        c = this.reader.getUINT8();
        firstPartitionLengthInBytes += c << 11;
        this.reader.getUINT8();
        this.reader.getUINT8();
        this.reader.getUINT8();
        c = this.reader.getUINT8();
        this.offset += 6;
        int hBytes = c;
        this.reader.seek(this.offset++);
        c = this.reader.getUINT8();
        this.width = (hBytes += c << 8) & 0x3FFF;
        this.reader.seek(this.offset++);
        int vBytes = c = this.reader.getUINT8();
        this.reader.seek(this.offset++);
        c = this.reader.getUINT8();
        this.height = (vBytes += c << 8) & 0x3FFF;
        int tWidth = this.width;
        int tHeight = this.height;
        if ((tWidth & 0xF) != 0) {
            tWidth += 16 - (tWidth & 0xF);
        }
        if ((tHeight & 0xF) != 0) {
            tHeight += 16 - (tHeight & 0xF);
        }
        this.mbRows = tHeight >> 4;
        this.mbCols = tWidth >> 4;
        this.createMacroBlocks();
        BitDecoder bc = new BitDecoder(this.reader, this.offset);
        if (this.frameType == 0) {
            bc.getLiteral(2);
        }
        this.segmentationIsEnabled = bc.getBit();
        if (this.segmentationIsEnabled > 0) {
            this.mBlockMap = bc.getBit();
            int mBlockData = bc.getBit();
            if (mBlockData > 0) {
                this.processmBlockData(bc);
            }
        }
        int simpleFilter = bc.getBit();
        this.filterLevel = bc.getLiteral(6);
        this.sharpnessLevel = bc.getLiteral(3);
        this.modeRefLoopFilterDeltaEnabled = bc.getBit();
        if (this.modeRefLoopFilterDeltaEnabled > 0 && (modeRefLoopFilterDeltaUpdate = bc.getBit()) > 0) {
            int i;
            for (i = 0; i < 4; ++i) {
                if (bc.getBit() <= 0) continue;
                this.refLoopFilterDeltas[i] = bc.getLiteral(6);
                if (bc.getBit() <= 0) continue;
                int n = i;
                this.refLoopFilterDeltas[n] = this.refLoopFilterDeltas[n] * -1;
            }
            for (i = 0; i < 4; ++i) {
                if (bc.getBit() <= 0) continue;
                this.modeLoopFilterDeltas[i] = bc.getLiteral(6);
                if (bc.getBit() <= 0) continue;
                int n = i;
                this.modeLoopFilterDeltas[n] = this.modeLoopFilterDeltas[n] * -1;
            }
        }
        this.filterType = this.filterLevel == 0 ? 0 : (simpleFilter > 0 ? 1 : 2);
        this.setupTokenDecoder(bc, firstPartitionLengthInBytes, this.offset);
        bc.seek();
        this.segmentQuants.parse(bc, this.segmentationIsEnabled == 1, this.macroBlockSegementAbsoluteDelta == 1);
        bc.getBit();
        if (this.frameType != 0) {
            bc.getBit();
        }
        this.decodeFrameStep2(bc);
    }

    private void decodeFrameStep2(BitDecoder bc) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 3; ++k) {
                    for (int l = 0; l < 11; ++l) {
                        int newp;
                        if (bc.getProbBit(LookUp.PROB_COS[i][j][k][l]) <= 0) continue;
                        this.coefProbs[i][j][k][l] = newp = bc.getLiteral(8);
                    }
                }
            }
        }
        this.macroBlockNoCoeffSkip = bc.getBit();
        if (this.frameType == 0) {
            this.readModes(bc);
        }
        int ibc = 0;
        int num_part = 1 << this.multiTokenPartition;
        for (int mb_row = 0; mb_row < this.mbRows; ++mb_row) {
            if (num_part > 1) {
                this.tokenBoolDecoder = this.tokenBitDecoders.get(ibc);
                this.tokenBoolDecoder.seek();
                this.decodeMacroBlockRow(mb_row);
                if (++ibc != num_part) continue;
                ibc = 0;
                continue;
            }
            this.decodeMacroBlockRow(mb_row);
        }
        if (this.filterType > 0 && this.filterLevel != 0) {
            Frame.filterFrame(this);
        }
    }

    private void processmBlockData(BitDecoder bc) {
        int value;
        int i;
        this.macroBlockSegementAbsoluteDelta = bc.getBit();
        for (i = 0; i < 4; ++i) {
            value = 0;
            if (bc.getBit() > 0) {
                value = bc.getLiteral(LookUp.BITS_MACRO[0]);
                if (bc.getBit() > 0) {
                    value = -value;
                }
            }
            this.segmentQuants.segQuants[i].index = value;
        }
        for (i = 0; i < 4; ++i) {
            value = 0;
            if (bc.getBit() > 0) {
                value = bc.getLiteral(LookUp.BITS_MACRO[1]);
                if (bc.getBit() > 0) {
                    value = -value;
                }
            }
            this.segmentQuants.segQuants[i].strength = value;
        }
        if (this.mBlockMap > 0) {
            this.macroBlockSegmentTreeProbs = new int[3];
            for (i = 0; i < 3; ++i) {
                value = bc.getBit() > 0 ? bc.getLiteral(8) : 255;
                this.macroBlockSegmentTreeProbs[i] = value;
            }
        }
    }

    private void decodeMacroBlockRow(int mbRow) {
        for (int mbCol = 0; mbCol < this.mbCols; ++mbCol) {
            MacroBlock mb = this.getMacroBlock(mbCol, mbRow);
            mb.decodeMacroBlock(this);
            mb.dequantMacroBlock(this);
        }
    }

    public SubBlock getTopRightSubBlock(SubBlock sb, SubBlock.Layer plane) {
        MacroBlock mb = sb.macroBlock;
        int x = mb.getSubblockX(sb);
        int y = mb.getSubblockY(sb);
        if (plane == SubBlock.Layer.Y1) {
            if (y == 0 && x < 3) {
                MacroBlock mb2 = this.getMacroBlock(mb.getX(), mb.getY() - 1);
                SubBlock r = mb2.getSubBlock(SubBlock.Layer.Y1, x + 1, 3);
                return r;
            }
            if (y == 0 && x == 3) {
                MacroBlock mb2 = this.getMacroBlock(mb.getX() + 1, mb.getY() - 1);
                SubBlock r = mb2.getSubBlock(SubBlock.Layer.Y1, 0, 3);
                if (mb2.getX() == this.mbCols) {
                    int[][] dest = new int[4][4];
                    for (int b = 0; b < 4; ++b) {
                        for (int a = 0; a < 4; ++a) {
                            dest[a][b] = mb2.getY() < 0 ? 127 : this.getMacroBlock(mb.getX(), mb.getY() - 1).getSubBlock(SubBlock.Layer.Y1, 3, 3).getDest()[3][3];
                        }
                    }
                    r = new SubBlock(mb2, null, null, SubBlock.Layer.Y1);
                    r.dest = dest;
                }
                return r;
            }
            if (y > 0 && x < 3) {
                SubBlock r = mb.getSubBlock(SubBlock.Layer.Y1, x + 1, y - 1);
                return r;
            }
            SubBlock sb2 = mb.getSubBlock(sb.getLayer(), 3, 0);
            return this.getTopRightSubBlock(sb2, SubBlock.Layer.Y1);
        }
        throw new IllegalArgumentException("bad input: getAboveRightSubBlock()");
    }

    public SubBlock getTopSubBlock(SubBlock sb, SubBlock.Layer plane) {
        SubBlock r = sb.getAbove();
        if (r == null) {
            MacroBlock mb = sb.macroBlock;
            int x = mb.getSubblockX(sb);
            MacroBlock mb2 = this.getMacroBlock(mb.getX(), mb.getY() - 1);
            while (plane == SubBlock.Layer.Y2 && mb2.getYMode() == 4) {
                mb2 = this.getMacroBlock(mb2.getX(), mb2.getY() - 1);
            }
            r = mb2.getBottomSubBlock(x, sb.getLayer());
        }
        return r;
    }

    private static int getBitAsInt(int data, int bit) {
        int r = data & 1 << bit;
        if (r > 0) {
            return 1;
        }
        return 0;
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bi = new BufferedImage(this.width, this.height, 1);
        int[] pixels = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
        int p = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int yy = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.Layer.Y1, x % 16 / 4, y % 16 / 4).getDest()[x % 4][y % 4];
                int u = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.Layer.U, x / 2 % 8 / 4, y / 2 % 8 / 4).getDest()[x / 2 % 4][y / 2 % 4];
                int v = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.Layer.V, x / 2 % 8 / 4, y / 2 % 8 / 4).getDest()[x / 2 % 4][y / 2 % 4];
                int a0 = 1192 * (yy - 16);
                int a1 = 1634 * (v -= 128);
                int a2 = 832 * v;
                int a3 = 400 * (u -= 128);
                int a4 = 2066 * u;
                int r = a0 + a1 >> 10;
                int g = a0 - a2 - a3 >> 10;
                int b = a0 + a4 >> 10;
                int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
                int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
                b = b > 255 ? 255 : (b < 0 ? 0 : b);
                pixels[p++] = r << 16 | g << 8 | b;
            }
        }
        return bi;
    }

    public int[][][][] getCoefProbs() {
        return this.coefProbs;
    }

    public SubBlock getLeftSubBlock(SubBlock sb, SubBlock.Layer plane) {
        SubBlock r = sb.getLeft();
        if (r == null) {
            MacroBlock mb = sb.macroBlock;
            int y = mb.getSubblockY(sb);
            MacroBlock mb2 = this.getMacroBlock(mb.getX() - 1, mb.getY());
            while (plane == SubBlock.Layer.Y2 && mb2.getYMode() == 4) {
                mb2 = this.getMacroBlock(mb2.getX() - 1, mb2.getY());
            }
            r = mb2.getRightSubBlock(y, sb.getLayer());
        }
        return r;
    }

    public MacroBlock getMacroBlock(int mbCol, int mbRow) {
        return this.macroBlocks[mbCol + 1][mbRow + 1];
    }

    public SegmentQuants getSegmentQuants() {
        return this.segmentQuants;
    }

    public BitDecoder getTokenBoolDecoder() {
        this.tokenBoolDecoder.seek();
        return this.tokenBoolDecoder;
    }

    private void readModes(BitDecoder bc) {
        int mb_row = -1;
        int prob_skip_false = 0;
        if (this.macroBlockNoCoeffSkip > 0) {
            prob_skip_false = bc.getLiteral(8);
        }
        while (++mb_row < this.mbRows) {
            int mb_col = -1;
            while (++mb_col < this.mbCols) {
                MacroBlock mb = this.getMacroBlock(mb_col, mb_row);
                if (this.segmentationIsEnabled > 0 && this.mBlockMap > 0) {
                    mb.key = bc.getTree(LookUp.MB_SEG_TREE, this.macroBlockSegmentTreeProbs);
                }
                if (this.modeRefLoopFilterDeltaEnabled > 0) {
                    int level = this.filterLevel;
                    level = (level += this.refLoopFilterDeltas[0]) < 0 ? 0 : (level > 63 ? 63 : level);
                    mb.setFilterLevel(level);
                } else {
                    mb.setFilterLevel(this.segmentQuants.segQuants[mb.key].strength);
                }
                int mb_skip_coeff = this.macroBlockNoCoeffSkip > 0 ? bc.getProbBit(prob_skip_false) : 0;
                mb.setSkipCoeff(mb_skip_coeff);
                int y_mode = Frame.readYMode(bc);
                mb.setYMode(y_mode);
                if (y_mode == 4) {
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            SubBlock sb = mb.getYSubBlock(j, i);
                            SubBlock top = this.getTopSubBlock(sb, SubBlock.Layer.Y1);
                            SubBlock left = this.getLeftSubBlock(sb, SubBlock.Layer.Y1);
                            int mode = Frame.readSubBlockMode(bc, top.mode, left.mode);
                            sb.setMode(mode);
                        }
                    }
                    if (this.modeRefLoopFilterDeltaEnabled > 0) {
                        int level = mb.getFilterLevel();
                        level = (level += this.modeLoopFilterDeltas[0]) < 0 ? 0 : (level > 63 ? 63 : level);
                        mb.setFilterLevel(level);
                    }
                } else {
                    int BMode;
                    switch (y_mode) {
                        case 0: {
                            BMode = 0;
                            break;
                        }
                        case 1: {
                            BMode = 2;
                            break;
                        }
                        case 2: {
                            BMode = 3;
                            break;
                        }
                        case 3: {
                            BMode = 1;
                            break;
                        }
                        default: {
                            BMode = 0;
                        }
                    }
                    for (int x = 0; x < 4; ++x) {
                        for (int y = 0; y < 4; ++y) {
                            SubBlock sb = mb.getYSubBlock(x, y);
                            sb.setMode(BMode);
                        }
                    }
                }
                int mode = Frame.readUvMode(bc);
                mb.setUvMode(mode);
            }
        }
    }

    private int readPartitionSize(int l) {
        this.reader.seek(l);
        return this.reader.getUINT8() + (this.reader.getUINT8() << 8) + (this.reader.getUINT8() << 16);
    }

    private static int readSubBlockMode(BitDecoder bc, int A, int L) {
        return bc.getTree(LookUp.SUBBLOCK_MODE_TREE, LookUp.FRAMES_SUBBLOCK[A][L]);
    }

    private static int readUvMode(BitDecoder bc) {
        return bc.getTree(LookUp.UV_MODE_TREE, LookUp.UV_FRAME_PROB);
    }

    private static int readYMode(BitDecoder bc) {
        return bc.getTree(LookUp.Y_FRAME_TREE, LookUp.FRAME_YMODE_PROB);
    }

    private void setupTokenDecoder(BitDecoder bc, int first_partition_length_in_bytes, int offset) {
        int partStart;
        int partition = partStart = offset + first_partition_length_in_bytes;
        this.multiTokenPartition = bc.getLiteral(2);
        int num_part = 1 << this.multiTokenPartition;
        if (num_part > 1) {
            partition += 3 * (num_part - 1);
        }
        for (int i = 0; i < num_part; ++i) {
            int partSize;
            if (i < num_part - 1) {
                partSize = this.readPartitionSize(partStart + i * 3);
                bc.seek();
            } else {
                partSize = this.reader.getSize() - partition;
            }
            this.tokenBitDecoders.add(new BitDecoder(this.reader, partition));
            partition += partSize;
        }
        this.tokenBoolDecoder = this.tokenBitDecoders.get(0);
    }

    private static int common_adjust(boolean use_outer_taps, Segment seg) {
        int p1 = Frame.getSigned(seg.P1);
        int p0 = Frame.getSigned(seg.P0);
        int q0 = Frame.getSigned(seg.Q0);
        int q1 = Frame.getSigned(seg.Q1);
        int a = Frame.sClamp((use_outer_taps ? Frame.sClamp(p1 - q1) : 0) + 3 * (q0 - p0));
        int b = Frame.sClamp(a + 3) >> 3;
        a = Frame.sClamp(a + 4) >> 3;
        seg.Q0 = Frame.getUnsigned(q0 - a);
        seg.P0 = Frame.getUnsigned(p0 + b);
        return a;
    }

    private static boolean doY(int I, int E, int p3, int p2, int p1, int p0, int q0, int q1, int q2, int q3) {
        return Frame.abs(p0 - q0) * 2 + Frame.abs(p1 - q1) / 2 <= E && Frame.abs(p3 - p2) <= I && Frame.abs(p2 - p1) <= I && Frame.abs(p1 - p0) <= I && Frame.abs(q3 - q2) <= I && Frame.abs(q2 - q1) <= I && Frame.abs(q1 - q0) <= I;
    }

    private static Segment getSegH(SubBlock rsb, SubBlock lsb, int a) {
        Segment seg = new Segment();
        int[][] rdest = rsb.getDest();
        int[][] ldest = lsb.getDest();
        seg.P0 = ldest[3][a];
        seg.P1 = ldest[2][a];
        seg.P2 = ldest[1][a];
        seg.P3 = ldest[0][a];
        seg.Q0 = rdest[0][a];
        seg.Q1 = rdest[1][a];
        seg.Q2 = rdest[2][a];
        seg.Q3 = rdest[3][a];
        return seg;
    }

    private static Segment getSegV(SubBlock bsb, SubBlock tsb, int a) {
        Segment seg = new Segment();
        int[][] bdest = bsb.getDest();
        int[][] tdest = tsb.getDest();
        seg.P0 = tdest[a][3];
        seg.P1 = tdest[a][2];
        seg.P2 = tdest[a][1];
        seg.P3 = tdest[a][0];
        seg.Q0 = bdest[a][0];
        seg.Q1 = bdest[a][1];
        seg.Q2 = bdest[a][2];
        seg.Q3 = bdest[a][3];
        return seg;
    }

    private static boolean hev(int threshold, int p1, int p0, int q0, int q1) {
        return Frame.abs(p1 - p0) > threshold || Frame.abs(q1 - q0) > threshold;
    }

    private static void filterFrame(Frame frame) {
        if (frame.filterType == 2) {
            Frame.filterUV(frame);
            Frame.filterY(frame);
        } else if (frame.filterType == 1) {
            Frame.filterNorm(frame);
        }
    }

    private static void filterNorm(Frame frame) {
        for (int y = 0; y < frame.mbRows; ++y) {
            for (int x = 0; x < frame.mbCols; ++x) {
                SubBlock bsb;
                SubBlock tsb;
                int c;
                Segment seg;
                int a;
                int b;
                int sub_bedge_limit;
                MacroBlock rmb = frame.getMacroBlock(x, y);
                MacroBlock bmb = frame.getMacroBlock(x, y);
                int loop_filter_level = rmb.getFilterLevel();
                if (loop_filter_level == 0) continue;
                int iLimit = rmb.getFilterLevel();
                int sharpnessLevel = frame.sharpnessLevel;
                if (sharpnessLevel > 0 && (iLimit >>= sharpnessLevel > 4 ? 2 : 1) > 9 - sharpnessLevel) {
                    iLimit = 9 - sharpnessLevel;
                }
                if (iLimit == 0) {
                    iLimit = 1;
                }
                if ((sub_bedge_limit = (loop_filter_level << 1) + iLimit) < 1) {
                    sub_bedge_limit = 1;
                }
                int mbedge_limit = sub_bedge_limit + 4;
                if (x > 0) {
                    MacroBlock lmb = frame.getMacroBlock(x - 1, y);
                    for (b = 0; b < 4; ++b) {
                        SubBlock rsb = rmb.getSubBlock(SubBlock.Layer.Y1, 0, b);
                        SubBlock lsb = lmb.getSubBlock(SubBlock.Layer.Y1, 3, b);
                        for (a = 0; a < 4; ++a) {
                            seg = Frame.getSegH(rsb, lsb, a);
                            Frame.normalizeSegment(mbedge_limit, seg);
                            Frame.setSegH(rsb, lsb, seg, a);
                        }
                    }
                }
                if (!rmb.isSkip_inner_lf()) {
                    for (int a2 = 1; a2 < 4; ++a2) {
                        for (b = 0; b < 4; ++b) {
                            SubBlock lsb = rmb.getSubBlock(SubBlock.Layer.Y1, a2 - 1, b);
                            SubBlock rsb = rmb.getSubBlock(SubBlock.Layer.Y1, a2, b);
                            for (c = 0; c < 4; ++c) {
                                seg = Frame.getSegH(rsb, lsb, c);
                                Frame.normalizeSegment(sub_bedge_limit, seg);
                                Frame.setSegH(rsb, lsb, seg, c);
                            }
                        }
                    }
                }
                if (y > 0) {
                    MacroBlock tmb = frame.getMacroBlock(x, y - 1);
                    for (b = 0; b < 4; ++b) {
                        tsb = tmb.getSubBlock(SubBlock.Layer.Y1, b, 3);
                        bsb = bmb.getSubBlock(SubBlock.Layer.Y1, b, 0);
                        for (a = 0; a < 4; ++a) {
                            seg = Frame.getSegV(bsb, tsb, a);
                            Frame.normalizeSegment(mbedge_limit, seg);
                            Frame.setSegV(bsb, tsb, seg, a);
                        }
                    }
                }
                if (rmb.isSkip_inner_lf()) continue;
                for (int a3 = 1; a3 < 4; ++a3) {
                    for (b = 0; b < 4; ++b) {
                        tsb = bmb.getSubBlock(SubBlock.Layer.Y1, b, a3 - 1);
                        bsb = bmb.getSubBlock(SubBlock.Layer.Y1, b, a3);
                        for (c = 0; c < 4; ++c) {
                            seg = Frame.getSegV(bsb, tsb, c);
                            Frame.normalizeSegment(sub_bedge_limit, seg);
                            Frame.setSegV(bsb, tsb, seg, c);
                        }
                    }
                }
            }
        }
    }

    private static void filterUV(Frame frame) {
        for (int y = 0; y < frame.mbRows; ++y) {
            for (int x = 0; x < frame.mbCols; ++x) {
                MacroBlock rmb = frame.getMacroBlock(x, y);
                int level = rmb.getFilterLevel();
                if (level == 0) continue;
                if (x > 0) {
                    Frame.filterFirst(frame, x, y, rmb, level);
                }
                if (!rmb.isSkip_inner_lf()) {
                    Frame.filterSecond(frame, rmb, level);
                }
                if (y > 0) {
                    Frame.filterThird(frame, x, y, rmb, level);
                }
                if (rmb.isSkip_inner_lf()) continue;
                Frame.filterFourth(frame, x, y, rmb, level);
            }
        }
    }

    private static void filterFirst(Frame frame, int x, int y, MacroBlock rmb, int level) {
        MacroBlock lmb = frame.getMacroBlock(x - 1, y);
        int sLevel = frame.sharpnessLevel;
        int iLimit = Frame.getiLimit(rmb, sLevel);
        int limitMBE = (level + 2 << 1) + iLimit;
        int hev_threshold = Frame.getHev_threshold(frame, level);
        for (int b = 0; b < 2; ++b) {
            SubBlock rsbU = rmb.getSubBlock(SubBlock.Layer.U, 0, b);
            SubBlock lsbU = lmb.getSubBlock(SubBlock.Layer.U, 1, b);
            SubBlock rsbV = rmb.getSubBlock(SubBlock.Layer.V, 0, b);
            SubBlock lsbV = lmb.getSubBlock(SubBlock.Layer.V, 1, b);
            for (int a = 0; a < 4; ++a) {
                Segment seg = Frame.getSegH(rsbU, lsbU, a);
                Frame.filterMB(hev_threshold, iLimit, limitMBE, seg);
                Frame.setSegH(rsbU, lsbU, seg, a);
                seg = Frame.getSegH(rsbV, lsbV, a);
                Frame.filterMB(hev_threshold, iLimit, limitMBE, seg);
                Frame.setSegH(rsbV, lsbV, seg, a);
            }
        }
    }

    private static void filterSecond(Frame frame, MacroBlock rmb, int level) {
        int hev_threshold = Frame.getHev_threshold(frame, level);
        int sLevel = frame.sharpnessLevel;
        int iLimit = Frame.getiLimit(rmb, sLevel);
        int limitSBE = (level << 1) + iLimit;
        for (int a = 1; a < 2; ++a) {
            for (int b = 0; b < 2; ++b) {
                SubBlock lsbU = rmb.getSubBlock(SubBlock.Layer.U, a - 1, b);
                SubBlock rsbU = rmb.getSubBlock(SubBlock.Layer.U, a, b);
                SubBlock lsbV = rmb.getSubBlock(SubBlock.Layer.V, a - 1, b);
                SubBlock rsbV = rmb.getSubBlock(SubBlock.Layer.V, a, b);
                for (int c = 0; c < 4; ++c) {
                    Segment seg = Frame.getSegH(rsbU, lsbU, c);
                    Frame.filterSB(hev_threshold, iLimit, limitSBE, seg);
                    Frame.setSegH(rsbU, lsbU, seg, c);
                    seg = Frame.getSegH(rsbV, lsbV, c);
                    Frame.filterSB(hev_threshold, iLimit, limitSBE, seg);
                    Frame.setSegH(rsbV, lsbV, seg, c);
                }
            }
        }
    }

    private static void filterThird(Frame frame, int x, int y, MacroBlock rmb, int level) {
        MacroBlock tmb = frame.getMacroBlock(x, y - 1);
        MacroBlock bmb = frame.getMacroBlock(x, y);
        int sLevel = frame.sharpnessLevel;
        int iLimit = Frame.getiLimit(rmb, sLevel);
        int limitMBE = (level + 2 << 1) + iLimit;
        int hev_threshold = Frame.getHev_threshold(frame, level);
        for (int b = 0; b < 2; ++b) {
            SubBlock tsbU = tmb.getSubBlock(SubBlock.Layer.U, b, 1);
            SubBlock bsbU = bmb.getSubBlock(SubBlock.Layer.U, b, 0);
            SubBlock tsbV = tmb.getSubBlock(SubBlock.Layer.V, b, 1);
            SubBlock bsbV = bmb.getSubBlock(SubBlock.Layer.V, b, 0);
            for (int a = 0; a < 4; ++a) {
                Segment seg = Frame.getSegV(bsbU, tsbU, a);
                Frame.filterMB(hev_threshold, iLimit, limitMBE, seg);
                Frame.setSegV(bsbU, tsbU, seg, a);
                seg = Frame.getSegV(bsbV, tsbV, a);
                Frame.filterMB(hev_threshold, iLimit, limitMBE, seg);
                Frame.setSegV(bsbV, tsbV, seg, a);
            }
        }
    }

    private static void filterFourth(Frame frame, int x, int y, MacroBlock rmb, int level) {
        MacroBlock bmb = frame.getMacroBlock(x, y);
        int sLevel = frame.sharpnessLevel;
        int hev_threshold = Frame.getHev_threshold(frame, level);
        int iLimit = Frame.getiLimit(rmb, sLevel);
        int limitSBE = (level << 1) + iLimit;
        for (int a = 1; a < 2; ++a) {
            for (int b = 0; b < 2; ++b) {
                SubBlock tsbU = bmb.getSubBlock(SubBlock.Layer.U, b, a - 1);
                SubBlock bsbU = bmb.getSubBlock(SubBlock.Layer.U, b, a);
                SubBlock tsbV = bmb.getSubBlock(SubBlock.Layer.V, b, a - 1);
                SubBlock bsbV = bmb.getSubBlock(SubBlock.Layer.V, b, a);
                for (int c = 0; c < 4; ++c) {
                    Segment seg = Frame.getSegV(bsbU, tsbU, c);
                    Frame.filterSB(hev_threshold, iLimit, limitSBE, seg);
                    Frame.setSegV(bsbU, tsbU, seg, c);
                    seg = Frame.getSegV(bsbV, tsbV, c);
                    Frame.filterSB(hev_threshold, iLimit, limitSBE, seg);
                    Frame.setSegV(bsbV, tsbV, seg, c);
                }
            }
        }
    }

    private static int getiLimit(MacroBlock rmb, int sLevel) {
        int iLimit = rmb.getFilterLevel();
        if (sLevel > 0 && (iLimit >>= sLevel > 4 ? 2 : 1) > 9 - sLevel) {
            iLimit = 9 - sLevel;
        }
        if (iLimit == 0) {
            iLimit = 1;
        }
        return iLimit;
    }

    private static void filterY(Frame frame) {
        for (int y = 0; y < frame.mbRows; ++y) {
            for (int x = 0; x < frame.mbCols; ++x) {
                MacroBlock rmb = frame.getMacroBlock(x, y);
                int level = rmb.getFilterLevel();
                if (level == 0) continue;
                if (x > 0) {
                    Frame.filterYFirst(frame, x, y, rmb, level);
                }
                if (!rmb.isSkip_inner_lf()) {
                    Frame.filterYSecond(frame, rmb, level);
                }
                if (y > 0) {
                    Frame.filterYThird(frame, x, y, rmb, level);
                }
                if (rmb.isSkip_inner_lf()) continue;
                Frame.filterYFourth(frame, x, y, rmb, level);
            }
        }
    }

    private static void filterYFirst(Frame frame, int x, int y, MacroBlock rmb, int level) {
        int hev_threshold = Frame.getHev_threshold(frame, level);
        int sharpnessLevel = frame.sharpnessLevel;
        int iLimit = Frame.getiLimit(rmb, sharpnessLevel);
        MacroBlock lmb = frame.getMacroBlock(x - 1, y);
        int mbedge_limit = (level + 2 << 1) + iLimit;
        for (int b = 0; b < 4; ++b) {
            SubBlock rsb = rmb.getSubBlock(SubBlock.Layer.Y1, 0, b);
            SubBlock lsb = lmb.getSubBlock(SubBlock.Layer.Y1, 3, b);
            for (int a = 0; a < 4; ++a) {
                Segment seg = Frame.getSegH(rsb, lsb, a);
                Frame.filterMB(hev_threshold, iLimit, mbedge_limit, seg);
                Frame.setSegH(rsb, lsb, seg, a);
            }
        }
    }

    private static void filterYSecond(Frame frame, MacroBlock rmb, int level) {
        int hev_threshold = Frame.getHev_threshold(frame, level);
        int sharpnessLevel = frame.sharpnessLevel;
        int iLimit = Frame.getiLimit(rmb, sharpnessLevel);
        int sub_bedge_limit = (level << 1) + iLimit;
        for (int a = 1; a < 4; ++a) {
            for (int b = 0; b < 4; ++b) {
                SubBlock lsb = rmb.getSubBlock(SubBlock.Layer.Y1, a - 1, b);
                SubBlock rsb = rmb.getSubBlock(SubBlock.Layer.Y1, a, b);
                for (int c = 0; c < 4; ++c) {
                    Segment seg = Frame.getSegH(rsb, lsb, c);
                    Frame.filterSB(hev_threshold, iLimit, sub_bedge_limit, seg);
                    Frame.setSegH(rsb, lsb, seg, c);
                }
            }
        }
    }

    private static void filterYThird(Frame frame, int x, int y, MacroBlock rmb, int level) {
        MacroBlock tmb = frame.getMacroBlock(x, y - 1);
        MacroBlock bmb = frame.getMacroBlock(x, y);
        int sharpnessLevel = frame.sharpnessLevel;
        int hev_threshold = Frame.getHev_threshold(frame, level);
        int iLimit = Frame.getiLimit(rmb, sharpnessLevel);
        int mbedge_limit = (level + 2 << 1) + iLimit;
        for (int b = 0; b < 4; ++b) {
            SubBlock tsb = tmb.getSubBlock(SubBlock.Layer.Y1, b, 3);
            SubBlock bsb = bmb.getSubBlock(SubBlock.Layer.Y1, b, 0);
            for (int a = 0; a < 4; ++a) {
                Segment seg = Frame.getSegV(bsb, tsb, a);
                Frame.filterMB(hev_threshold, iLimit, mbedge_limit, seg);
                Frame.setSegV(bsb, tsb, seg, a);
            }
        }
    }

    private static void filterYFourth(Frame frame, int x, int y, MacroBlock rmb, int level) {
        MacroBlock bmb = frame.getMacroBlock(x, y);
        int sharpnessLevel = frame.sharpnessLevel;
        int hev_threshold = Frame.getHev_threshold(frame, level);
        int iLimit = Frame.getiLimit(rmb, sharpnessLevel);
        int sub_bedge_limit = (level << 1) + iLimit;
        for (int a = 1; a < 4; ++a) {
            for (int b = 0; b < 4; ++b) {
                SubBlock tsb = bmb.getSubBlock(SubBlock.Layer.Y1, b, a - 1);
                SubBlock bsb = bmb.getSubBlock(SubBlock.Layer.Y1, b, a);
                for (int c = 0; c < 4; ++c) {
                    Segment seg = Frame.getSegV(bsb, tsb, c);
                    Frame.filterSB(hev_threshold, iLimit, sub_bedge_limit, seg);
                    Frame.setSegV(bsb, tsb, seg, c);
                }
            }
        }
    }

    private static int getHev_threshold(Frame frame, int level) {
        int hev_threshold = 0;
        if (frame.frameType == 0) {
            if (level >= 40) {
                hev_threshold = 2;
            } else if (level >= 15) {
                hev_threshold = 1;
            }
        } else if (level >= 40) {
            hev_threshold = 3;
        } else if (level >= 20) {
            hev_threshold = 2;
        } else if (level >= 15) {
            hev_threshold = 1;
        }
        return hev_threshold;
    }

    private static void filterMB(int hev_threshold, int iLimit, int eLimit, Segment seg) {
        int p3 = Frame.getSigned(seg.P3);
        int p2 = Frame.getSigned(seg.P2);
        int p1 = Frame.getSigned(seg.P1);
        int p0 = Frame.getSigned(seg.P0);
        int q0 = Frame.getSigned(seg.Q0);
        int q1 = Frame.getSigned(seg.Q1);
        int q2 = Frame.getSigned(seg.Q2);
        int q3 = Frame.getSigned(seg.Q3);
        if (Frame.doY(iLimit, eLimit, q3, q2, q1, q0, p0, p1, p2, p3)) {
            if (!Frame.hev(hev_threshold, p1, p0, q0, q1)) {
                int w = Frame.sClamp(Frame.sClamp(p1 - q1) + 3 * (q0 - p0));
                int a = 27 * w + 63 >> 7;
                seg.Q0 = Frame.getUnsigned(q0 - a);
                seg.P0 = Frame.getUnsigned(p0 + a);
                a = 18 * w + 63 >> 7;
                seg.Q1 = Frame.getUnsigned(q1 - a);
                seg.P1 = Frame.getUnsigned(p1 + a);
                a = 9 * w + 63 >> 7;
                seg.Q2 = Frame.getUnsigned(q2 - a);
                seg.P2 = Frame.getUnsigned(p2 + a);
            } else {
                Frame.common_adjust(true, seg);
            }
        }
    }

    private static void setSegH(SubBlock rsb, SubBlock lsb, Segment seg, int a) {
        int[][] rdest = rsb.getDest();
        int[][] ldest = lsb.getDest();
        ldest[3][a] = seg.P0;
        ldest[2][a] = seg.P1;
        ldest[1][a] = seg.P2;
        ldest[0][a] = seg.P3;
        rdest[0][a] = seg.Q0;
        rdest[1][a] = seg.Q1;
        rdest[2][a] = seg.Q2;
        rdest[3][a] = seg.Q3;
    }

    private static void setSegV(SubBlock bsb, SubBlock tsb, Segment seg, int a) {
        int[][] bdest = bsb.getDest();
        int[][] tdest = tsb.getDest();
        tdest[a][3] = seg.P0;
        tdest[a][2] = seg.P1;
        tdest[a][1] = seg.P2;
        tdest[a][0] = seg.P3;
        bdest[a][0] = seg.Q0;
        bdest[a][1] = seg.Q1;
        bdest[a][2] = seg.Q2;
        bdest[a][3] = seg.Q3;
    }

    private static void normalizeSegment(int eLimit, Segment seg) {
        if (Frame.abs(seg.P0 - seg.Q0) * 2 + Frame.abs(seg.P1 - seg.Q1) / 2 <= eLimit) {
            Frame.common_adjust(true, seg);
        }
    }

    private static void filterSB(int hev_threshold, int interior_limit, int edge_limit, Segment seg) {
        int p3 = Frame.getSigned(seg.P3);
        int p2 = Frame.getSigned(seg.P2);
        int p1 = Frame.getSigned(seg.P1);
        int p0 = Frame.getSigned(seg.P0);
        int q0 = Frame.getSigned(seg.Q0);
        int q1 = Frame.getSigned(seg.Q1);
        int q2 = Frame.getSigned(seg.Q2);
        int q3 = Frame.getSigned(seg.Q3);
        if (Frame.doY(interior_limit, edge_limit, q3, q2, q1, q0, p0, p1, p2, p3)) {
            boolean hv = Frame.hev(hev_threshold, p1, p0, q0, q1);
            int a = Frame.common_adjust(hv, seg) + 1 >> 1;
            if (!hv) {
                seg.Q1 = Frame.getUnsigned(q1 - a);
                seg.P1 = Frame.getUnsigned(p1 + a);
            }
        }
    }

    private static int getSigned(int v) {
        return v - 128;
    }

    private static int getUnsigned(int v) {
        return Frame.sClamp(v) + 128;
    }

    private static int abs(int v) {
        return v < 0 ? -v : v;
    }

    private static int sClamp(int v) {
        int r = v;
        if (v < -128) {
            r = -128;
        }
        if (v > 127) {
            r = 127;
        }
        return r;
    }

    private static class Segment {
        int P0;
        int P1;
        int P2;
        int P3;
        int Q0;
        int Q1;
        int Q2;
        int Q3;

        private Segment() {
        }
    }
}

