/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import com.idrsolutions.image.BitReader;
import com.idrsolutions.image.DataByteBig;
import com.idrsolutions.image.DataByteLittle;
import com.idrsolutions.image.DataFileBig;
import com.idrsolutions.image.DataFileLittle;
import com.idrsolutions.image.DataReader;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.ToolACMYK;
import com.idrsolutions.image.ToolARGB;
import com.idrsolutions.image.ToolBinary;
import com.idrsolutions.image.ToolCMYK;
import com.idrsolutions.image.ToolGray;
import com.idrsolutions.image.ToolGray16;
import com.idrsolutions.image.ToolIndex;
import com.idrsolutions.image.ToolRGB;
import com.idrsolutions.image.ToolYCBCR;
import com.idrsolutions.image.Tooler;
import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.image.tiff.CCITT;
import com.idrsolutions.image.tiff.Deflate;
import com.idrsolutions.image.tiff.IFD;
import com.idrsolutions.image.tiff.LZW;
import com.idrsolutions.image.tiff.PackBits;
import com.idrsolutions.image.tiff.Tile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class TiffDecoder
extends JDeliImage {
    private DataReader reader;
    private int pageCount;
    private final List<IFD> ifds = new ArrayList<IFD>();

    public TiffDecoder(byte[] rawTiffData) throws Exception {
        int a = rawTiffData[0] & 0xFF;
        int b = rawTiffData[1] & 0xFF;
        if (a == 77 && b == 77) {
            this.reader = new DataByteBig(rawTiffData);
        } else if (a == 73 && b == 73) {
            this.reader = new DataByteLittle(rawTiffData);
        }
        this.reader.skip(2);
        int magicNumber = this.reader.getU16();
        if (magicNumber != 42) {
            if (magicNumber == 43) {
                throw new Exception("Big Tiff File Support not added");
            }
            throw new Exception("This is not a valid Tiff File");
        }
        int ifdOffset = this.reader.getU32();
        while (ifdOffset != 0 && ifdOffset < this.reader.getLength()) {
            IFD ifd = TiffDecoder.getIFD(this.reader, ifdOffset);
            this.ifds.add(ifd);
            ifdOffset = ifd.nextIFD;
            ++this.pageCount;
        }
    }

    public TiffDecoder(RandomAccessFile raf) throws Exception {
        int a = raf.read() & 0xFF;
        int b = raf.read() & 0xFF;
        raf.seek(0L);
        if (a == 77 && b == 77) {
            this.reader = new DataFileBig(raf);
        } else if (a == 73 && b == 73) {
            this.reader = new DataFileLittle(raf);
        } else {
            throw new IOException("This is not a valid Tiff File");
        }
        this.reader.skip(2);
        int magicNumber = this.reader.getU16();
        if (magicNumber != 42) {
            if (magicNumber == 43) {
                throw new Exception("Big Tiff File Support not added");
            }
            throw new Exception("This is not a valid Tiff File");
        }
        int ifdOffset = this.reader.getU32();
        while (ifdOffset != 0 && ifdOffset < this.reader.getLength()) {
            IFD ifd = TiffDecoder.getIFD(this.reader, ifdOffset);
            this.ifds.add(ifd);
            ifdOffset = ifd.nextIFD;
            ++this.pageCount;
        }
    }

    public BufferedImage read() throws Exception {
        return this.read(1);
    }

    public BufferedImage read(int pageNumber) throws Exception {
        if (pageNumber == 0) {
            throw new Exception("PageNumber should start from 1");
        }
        if (pageNumber > this.pageCount) {
            throw new Exception("PageNumber should not be greater than Total page count");
        }
        IFD ifd = this.ifds.get(pageNumber - 1);
        return TiffDecoder.generateImageFromIFD(this.reader, ifd);
    }

    public String getXMPMetaData() throws Exception {
        return this.getXMPMetaData(1);
    }

    public String getXMPMetaData(int pageNumber) throws Exception {
        if (pageNumber == 0) {
            throw new Exception("PageNumber should start from 1");
        }
        if (pageNumber > this.pageCount) {
            throw new Exception("PageNumber should not be greater than Total page count");
        }
        IFD ifd = this.ifds.get(pageNumber - 1);
        return ifd.xmpMeta;
    }

    private static IFD getIFD(DataReader reader, int ifdOffset) throws IOException {
        reader.moveTo(ifdOffset);
        int nEntries = reader.getU16();
        IFD ifd = new IFD();
        block28: for (int i = 0; i < nEntries; ++i) {
            int fieldName = reader.getU16();
            int fieldType = reader.getU16();
            int nValues = reader.getU32();
            switch (fieldName) {
                case 256: {
                    ifd.imageWidth = TiffDecoder.getShortOrInt(reader, fieldType);
                    if (ifd.imageWidth <= 0xFFFFFF) continue block28;
                    ifd.imageWidth &= 0xFFFF;
                    continue block28;
                }
                case 257: {
                    ifd.imageHeight = TiffDecoder.getShortOrInt(reader, fieldType);
                    if (ifd.imageHeight <= 0xFFFFFF) continue block28;
                    ifd.imageHeight &= 0xFFFF;
                    continue block28;
                }
                case 258: {
                    TiffDecoder.readBPS(reader, ifd, nValues);
                    continue block28;
                }
                case 259: {
                    ifd.compressionType = reader.getU16();
                    reader.getU16();
                    continue block28;
                }
                case 262: {
                    ifd.photometric = reader.getU16();
                    reader.getU16();
                    continue block28;
                }
                case 278: {
                    ifd.rowsPerStrip = TiffDecoder.getShortOrInt(reader, fieldType);
                    continue block28;
                }
                case 273: {
                    TiffDecoder.readStripOffsets(reader, ifd, fieldType, nValues);
                    continue block28;
                }
                case 279: {
                    TiffDecoder.readStripByteCounts(reader, ifd, fieldType, nValues);
                    continue block28;
                }
                case 277: {
                    ifd.samplesPerPixel = reader.getU16();
                    reader.getU16();
                    continue block28;
                }
                case 320: {
                    int cmapOffset = reader.getU32();
                    int current = reader.getPosition();
                    ifd.colorMap = TiffDecoder.readColorMap(reader, cmapOffset, nValues);
                    reader.moveTo(current);
                    continue block28;
                }
                case 284: {
                    ifd.planarConfiguration = reader.getU16();
                    reader.getU16();
                    continue block28;
                }
                case 322: {
                    ifd.tileWidth = TiffDecoder.getShortOrInt(reader, fieldType);
                    continue block28;
                }
                case 323: {
                    ifd.tileLength = TiffDecoder.getShortOrInt(reader, fieldType);
                    continue block28;
                }
                case 324: {
                    TiffDecoder.readTileOffsets(reader, ifd, fieldType, nValues);
                    continue block28;
                }
                case 325: {
                    TiffDecoder.readTileByteCounts(reader, ifd, fieldType, nValues);
                    continue block28;
                }
                case 347: {
                    TiffDecoder.readJpegTables(reader, ifd, nValues);
                    continue block28;
                }
                case 519: {
                    TiffDecoder.readJpegQTables(reader, ifd, fieldType, nValues);
                    continue block28;
                }
                case 520: {
                    TiffDecoder.readJpegDCTables(reader, ifd, fieldType, nValues);
                    continue block28;
                }
                case 521: {
                    TiffDecoder.readJpegACTables(reader, ifd, fieldType, nValues);
                    continue block28;
                }
                case 34675: {
                    TiffDecoder.readICC(reader, ifd, nValues);
                    continue block28;
                }
                case 266: {
                    ifd.fillOrder = reader.getU32();
                    continue block28;
                }
                case 292: {
                    ifd.t4Options = reader.getU32();
                    continue block28;
                }
                case 293: {
                    ifd.t6Options = reader.getU32();
                    continue block28;
                }
                case 317: {
                    ifd.predictor = reader.getU16();
                    reader.getU16();
                    continue block28;
                }
                case 339: {
                    TiffDecoder.getSampleFormat(reader, ifd, fieldType, nValues);
                    continue block28;
                }
                case 700: {
                    TiffDecoder.readXMP(reader, ifd, nValues);
                    continue block28;
                }
                default: {
                    reader.getU32();
                }
            }
        }
        ifd.nextIFD = reader.getU32();
        if (ifd.rowsPerStrip <= 0 || ifd.rowsPerStrip > ifd.imageHeight) {
            ifd.rowsPerStrip = ifd.imageHeight;
        }
        if (ifd.bps[0] == 0 || ifd.bps[0] > 64) {
            ifd.bps[0] = 1;
        }
        if (ifd.fillOrder != 2) {
            ifd.fillOrder = 1;
        }
        return ifd;
    }

    private static void getSampleFormat(DataReader reader, IFD ifd, int fieldType, int nValues) throws IOException {
        if (nValues == 1) {
            ifd.sampleFormat = new int[1];
            ifd.sampleFormat[0] = reader.getU16();
            reader.getU16();
        } else {
            int sampleOffset = reader.getU32();
            int current = reader.getPosition();
            ifd.sampleFormat = TiffDecoder.readOffsets(reader, sampleOffset, nValues, fieldType);
            reader.moveTo(current);
        }
    }

    private static void readBPS(DataReader reader, IFD ifd, int nValues) throws IOException {
        ifd.bps = new int[nValues];
        switch (nValues) {
            case 1: {
                ifd.bps[0] = reader.getU16();
                reader.getU16();
                break;
            }
            case 2: {
                ifd.bps[0] = reader.getU16();
                ifd.bps[1] = reader.getU16();
                break;
            }
            default: {
                int sampleOffset = reader.getU32();
                int current = reader.getPosition();
                ifd.bps = TiffDecoder.readBitsPerSamples(reader, sampleOffset, nValues);
                reader.moveTo(current);
            }
        }
    }

    private static void readICC(DataReader reader, IFD ifd, int nValues) throws IOException {
        int iccOffset = reader.getU32();
        int current = reader.getPosition();
        reader.moveTo(iccOffset);
        ifd.iccProfile = new byte[nValues];
        reader.read(ifd.iccProfile);
        reader.moveTo(current);
    }

    private static void readStripOffsets(DataReader reader, IFD ifd, int fieldType, int nValues) throws IOException {
        if (nValues == 1) {
            ifd.stripOffsets = new int[1];
            ifd.stripOffsets[0] = reader.getU32();
        } else {
            int stripOffset = reader.getU32();
            int cur = reader.getPosition();
            ifd.stripOffsets = TiffDecoder.readOffsets(reader, stripOffset, nValues, fieldType);
            reader.moveTo(cur);
        }
    }

    private static void readStripByteCounts(DataReader reader, IFD ifd, int fieldType, int nValues) throws IOException {
        if (nValues == 1) {
            ifd.stripByteCounts = new int[1];
            ifd.stripByteCounts[0] = reader.getU32();
        } else {
            int stripOffset = reader.getU32();
            int current = reader.getPosition();
            ifd.stripByteCounts = TiffDecoder.readStripTileByteCounts(reader, stripOffset, nValues, fieldType);
            reader.moveTo(current);
        }
    }

    private static void readTileOffsets(DataReader reader, IFD ifd, int fieldType, int nValues) throws IOException {
        if (nValues == 1) {
            ifd.tileOffsets = new int[1];
            ifd.tileOffsets[0] = reader.getU32();
        } else {
            int stripOffset = reader.getU32();
            int cur = reader.getPosition();
            ifd.tileOffsets = TiffDecoder.readOffsets(reader, stripOffset, nValues, fieldType);
            reader.moveTo(cur);
        }
    }

    private static void readTileByteCounts(DataReader reader, IFD ifd, int fieldType, int nValues) throws IOException {
        if (nValues == 1) {
            ifd.tileByteCounts = new int[1];
            ifd.tileByteCounts[0] = reader.getU32();
        } else {
            int stripOffset = reader.getU32();
            int cur = reader.getPosition();
            ifd.tileByteCounts = TiffDecoder.readStripTileByteCounts(reader, stripOffset, nValues, fieldType);
            reader.moveTo(cur);
        }
    }

    private static void readXMP(DataReader reader, IFD ifd, int nValues) throws IOException {
        int xmpOffset = reader.getU32();
        int current = reader.getPosition();
        byte[] xmbBytes = new byte[nValues];
        reader.moveTo(xmpOffset);
        reader.read(xmbBytes);
        ifd.xmpMeta = new String(xmbBytes);
        reader.moveTo(current);
    }

    private static void readJpegTables(DataReader reader, IFD ifd, int nValues) throws IOException {
        int tableOffset = reader.getU32();
        int cc = reader.getPosition();
        reader.moveTo(tableOffset);
        byte[] tableBytes = new byte[nValues];
        reader.read(tableBytes);
        reader.moveTo(cc);
        ifd.jpegTables = new byte[nValues - 2];
        System.arraycopy(tableBytes, 0, ifd.jpegTables, 0, nValues - 2);
    }

    private static void readJpegQTables(DataReader reader, IFD ifd, int fieldType, int nValues) throws IOException {
        if (nValues == 1) {
            ifd.jpegQOffsets = new int[1];
            ifd.jpegQOffsets[0] = reader.getU32();
        } else {
            int stripOffset = reader.getU32();
            int cur = reader.getPosition();
            ifd.jpegQOffsets = TiffDecoder.readOffsets(reader, stripOffset, nValues, fieldType);
            reader.moveTo(cur);
        }
    }

    private static void readJpegACTables(DataReader reader, IFD ifd, int fieldType, int nValues) throws IOException {
        if (nValues == 1) {
            ifd.jpegACOffsets = new int[1];
            ifd.jpegACOffsets[0] = reader.getU32();
        } else {
            int stripOffset = reader.getU32();
            int cur = reader.getPosition();
            ifd.jpegACOffsets = TiffDecoder.readOffsets(reader, stripOffset, nValues, fieldType);
            reader.moveTo(cur);
        }
    }

    private static void readJpegDCTables(DataReader reader, IFD ifd, int fieldType, int nValues) throws IOException {
        if (nValues == 1) {
            ifd.jpegDCOffsets = new int[1];
            ifd.jpegDCOffsets[0] = reader.getU32();
        } else {
            int stripOffset = reader.getU32();
            int cur = reader.getPosition();
            ifd.jpegDCOffsets = TiffDecoder.readOffsets(reader, stripOffset, nValues, fieldType);
            reader.moveTo(cur);
        }
    }

    private static int getShortOrInt(DataReader reader, int fieldType) throws IOException {
        int value;
        if (fieldType == 3) {
            value = reader.getU16();
            reader.getU16();
        } else {
            value = reader.getU32();
        }
        return value;
    }

    private static BufferedImage getDataFromStrips(DataReader reader, IFD ifd) throws Exception {
        int stripSamples;
        int iw = ifd.imageWidth;
        int ih = ifd.imageHeight;
        boolean isPlanar = ifd.planarConfiguration == 2;
        int rps = ifd.rowsPerStrip;
        int sampleLen = 0;
        int n = stripSamples = isPlanar ? 1 : ifd.bps.length;
        if (isPlanar) {
            sampleLen = ifd.bps[0];
        } else {
            for (int i = 0; i < ifd.bps.length; ++i) {
                sampleLen += ifd.bps[i];
            }
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            for (int t = 0; t < ifd.stripOffsets.length; ++t) {
                byte[] output;
                int balance;
                int stripMod;
                int balance2;
                reader.moveTo(ifd.stripOffsets[t]);
                byte[] tileData = new byte[ifd.stripByteCounts[t]];
                reader.read(tileData);
                int height = isPlanar ? ((balance2 = ih - rps * (stripMod = t % (ifd.stripOffsets.length / ifd.samplesPerPixel))) < rps ? balance2 : rps) : ((balance = ih - rps * t) < rps ? balance : rps);
                int expectation = ((iw * sampleLen + 7) / 8 * 8 * height + 7) / 8;
                switch (ifd.compressionType) {
                    case 1: {
                        output = tileData;
                        break;
                    }
                    case 2: {
                        output = new byte[expectation];
                        CCITT fax = new CCITT(ifd.fillOrder, iw);
                        fax.decompress1D(output, tileData, 0, height);
                        break;
                    }
                    case 3: {
                        output = new byte[expectation];
                        CCITT fax = new CCITT(ifd.fillOrder, iw);
                        fax.decompressFax3(output, tileData, height, ifd.t4Options);
                        break;
                    }
                    case 4: {
                        output = new byte[expectation];
                        CCITT fax = new CCITT(ifd.fillOrder, iw);
                        fax.decompressFax4(output, tileData, height);
                        break;
                    }
                    case 5: {
                        output = new byte[expectation];
                        LZW lzw = new LZW();
                        lzw.decompress(output, tileData);
                        break;
                    }
                    case 6: {
                        throw new Exception("Old style jpeg compression is not supported");
                    }
                    case 7: {
                        if (ifd.jpegTables != null) {
                            int ifdLen = ifd.jpegTables.length;
                            byte[] temp = new byte[ifdLen + tileData.length - 2];
                            System.arraycopy(ifd.jpegTables, 0, temp, 0, ifdLen);
                            System.arraycopy(tileData, 2, temp, ifdLen, tileData.length - 2);
                            tileData = temp;
                        }
                        JpegDecoder decoder = new JpegDecoder();
                        output = decoder.readComponentsAsRawBytes(tileData);
                        break;
                    }
                    case 32773: {
                        int exp = (iw * height * sampleLen + 7) / 8;
                        output = PackBits.decompress(tileData, exp);
                        break;
                    }
                    case 8: 
                    case 32946: {
                        output = Deflate.decompress(tileData);
                        break;
                    }
                    default: {
                        output = tileData;
                        System.err.println("unrecognized compression found");
                    }
                }
                if (ifd.predictor == 2) {
                    for (int j = 0; j < height; ++j) {
                        int count = stripSamples * (j * iw + 1);
                        for (int i = stripSamples; i < iw * stripSamples; ++i) {
                            int n2 = count;
                            output[n2] = (byte)(output[n2] + output[count - stripSamples]);
                            ++count;
                        }
                    }
                }
                if (ifd.photometric == 0) {
                    TiffDecoder.doWhiteIsZero(output);
                }
                bos.write(output);
            }
            BufferedImage bufferedImage = TiffDecoder.generateImage(ifd, bos.toByteArray());
            return bufferedImage;
        }
    }

    private static BufferedImage generateImage(IFD ifd, byte[] data) {
        Tooler tl;
        boolean isFloat;
        int nComp = ifd.bps.length;
        int bps = ifd.bps[0];
        boolean isPlanar = ifd.planarConfiguration == 2;
        int shift = bps < 8 ? 8 - bps : bps - 8;
        boolean bl = isFloat = ifd.sampleFormat[0] == 3;
        if (ifd.colorMap != null) {
            return TiffDecoder.generateImageFromColorMap(ifd, data);
        }
        if (nComp == 1) {
            switch (ifd.bps[0]) {
                case 1: 
                case 2: 
                case 4: {
                    tl = TiffDecoder.useToolBinary(ifd, bps, data);
                    break;
                }
                case 8: {
                    tl = TiffDecoder.useToolGray(ifd, data);
                    break;
                }
                case 16: {
                    tl = TiffDecoder.useToolGray16(ifd, isFloat, data, bps);
                    break;
                }
                default: {
                    tl = TiffDecoder.useDefaultTooler(ifd, data, bps, isFloat, shift, isPlanar);
                    break;
                }
            }
        } else {
            switch (ifd.photometric) {
                case 5: {
                    if (nComp == 4) {
                        tl = new ToolCMYK(ifd.imageWidth, ifd.imageHeight);
                        break;
                    }
                    tl = new ToolACMYK(ifd.imageWidth, ifd.imageHeight);
                    break;
                }
                case 6: {
                    tl = new ToolYCBCR(ifd.imageWidth, ifd.imageHeight);
                    break;
                }
                default: {
                    tl = nComp == 3 ? new ToolRGB(ifd.imageWidth, ifd.imageHeight) : new ToolARGB(ifd.imageWidth, ifd.imageHeight);
                }
            }
            if (isPlanar) {
                data = TiffDecoder.handleIsPlanar(ifd, nComp, data, bps, isFloat, shift);
                bps = 8;
                isFloat = false;
            }
            switch (bps) {
                case 8: {
                    tl.setData(data);
                    break;
                }
                default: {
                    TiffDecoder.handleDefaultBps(data, ifd, nComp, bps, isFloat, shift, tl);
                }
            }
        }
        return tl.getBufferedImage();
    }

    private static void handleDefaultBps(byte[] data, IFD ifd, int nComp, int bps, boolean isFloat, int shift, Tooler tl) {
        BitReader br = new BitReader(data);
        int height = ifd.imageHeight;
        int width = ifd.imageWidth;
        int stripSamples = ifd.bps.length;
        int iw8 = width * bps * stripSamples % 8;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int v = 0;
                for (int i = 0; i < nComp; ++i) {
                    int t = bps == 32 ? br.readBits(16) << 16 | br.readBits(16) : br.readBits(bps);
                    t = isFloat ? (int)(TiffDecoder.toFloat(t, bps) * 255.0f) : (bps < 8 ? t << shift : t >> shift);
                    v = v << 8 | t;
                }
                tl.set(x, y, v);
            }
            if (iw8 == 0) continue;
            br.readBits(8 - iw8);
        }
    }

    private static byte[] handleIsPlanar(IFD ifd, int nComp, byte[] data, int bps, boolean isFloat, int shift) {
        BitReader br = new BitReader(data);
        int width = ifd.imageWidth;
        int height = ifd.imageHeight;
        int stripSamples = 1;
        int iw8 = width * bps * stripSamples % 8;
        byte[] temp = new byte[width * height * nComp];
        for (int j = 0; j < nComp; ++j) {
            int q = 0;
            for (int i = 0; i < height; ++i) {
                for (int k = 0; k < width; ++k) {
                    int v = bps == 32 ? br.readBits(16) << 16 | br.readBits(16) : br.readBits(bps);
                    v = isFloat ? (int)(255.0f * TiffDecoder.toFloat(v, bps)) : (bps < 8 ? v << shift : v >> shift);
                    temp[nComp * q + j] = (byte)v;
                    ++q;
                }
                if (iw8 == 0) continue;
                br.readBits(8 - iw8);
            }
        }
        return temp;
    }

    private static Tooler useToolBinary(IFD ifd, int bps, byte[] data) {
        ToolBinary tl = new ToolBinary(ifd.imageWidth, ifd.imageHeight, bps);
        tl.setData(data);
        return tl;
    }

    private static Tooler useToolGray(IFD ifd, byte[] data) {
        ToolGray tl = new ToolGray(ifd.imageWidth, ifd.imageHeight);
        tl.setData(data);
        return tl;
    }

    private static Tooler useToolGray16(IFD ifd, boolean isFloat, byte[] data, int bps) {
        int width = ifd.imageWidth;
        int height = ifd.imageHeight;
        ToolGray16 tl = new ToolGray16(width, height);
        if (isFloat) {
            int p = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int v = (data[p++] & 0xFF) << 8 | data[p++] & 0xFF;
                    v = (int)(65535.0f * TiffDecoder.toFloat(v, bps));
                    tl.set(x, y, v);
                }
            }
        } else {
            tl.setData(data);
        }
        return tl;
    }

    private static Tooler useDefaultTooler(IFD ifd, byte[] data, int bps, boolean isFloat, int shift, boolean isPlanar) {
        int width = ifd.imageWidth;
        int height = ifd.imageHeight;
        int stripSamples = isPlanar ? 1 : ifd.bps.length;
        int iw8 = width * bps * stripSamples % 8;
        ToolGray tl = new ToolGray(width, height);
        BitReader br = new BitReader(data);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int v = bps == 32 ? br.readBits(16) << 16 | br.readBits(16) : br.readBits(bps);
                v = isFloat ? (int)(255.0f * TiffDecoder.toFloat(v, bps)) : (bps < 8 ? v << shift : v >> shift);
                tl.set(x, y, v);
            }
            if (iw8 == 0) continue;
            br.readBits(8 - iw8);
        }
        return tl;
    }

    private static BufferedImage generateImageFromColorMap(IFD ifd, byte[] data) {
        Tooler tl;
        int bps = ifd.bps[0];
        boolean isPlanar = ifd.planarConfiguration == 2;
        int stripSamples = isPlanar ? 1 : ifd.bps.length;
        int iw8 = ifd.imageWidth * bps * stripSamples % 8;
        switch (bps) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                byte[] rr = new byte[1 << bps];
                byte[] gg = new byte[1 << bps];
                byte[] bb = new byte[1 << bps];
                int p = 0;
                int ii = Math.min(ifd.colorMap.length / 3, rr.length);
                for (int i = 0; i < ii; ++i) {
                    rr[i] = ifd.colorMap[p++];
                    gg[i] = ifd.colorMap[p++];
                    bb[i] = ifd.colorMap[p++];
                }
                tl = new ToolIndex(ifd.imageWidth, ifd.imageHeight, bps, rr, gg, bb);
                tl.setData(data);
                break;
            }
            default: {
                tl = new ToolRGB(ifd.imageWidth, ifd.imageHeight);
                BitReader br = new BitReader(data);
                for (int y = 0; y < ifd.imageHeight; ++y) {
                    for (int x = 0; x < ifd.imageWidth; ++x) {
                        int v = br.readBits(bps);
                        int r = ifd.colorMap[v * 3] & 0xFF;
                        int g = ifd.colorMap[v * 3 + 1] & 0xFF;
                        int b = ifd.colorMap[v * 3 + 2] & 0xFF;
                        v = r << 16 | g << 8 | b;
                        tl.set(x, y, v);
                    }
                    if (iw8 == 0) continue;
                    br.readBits(8 - iw8);
                }
            }
        }
        return tl.getBufferedImage();
    }

    private static BufferedImage getImageFromTiles(DataReader reader, IFD ifd) throws Exception {
        if (ifd.tileOffsets == null) {
            ifd.tileOffsets = ifd.stripOffsets;
        }
        if (ifd.tileByteCounts == null) {
            ifd.tileByteCounts = ifd.stripByteCounts;
        }
        int iw = ifd.imageWidth;
        int ih = ifd.imageHeight;
        int tw = ifd.tileWidth;
        int th = ifd.tileLength;
        int bps = ifd.bps[0];
        boolean isPlanar = ifd.planarConfiguration == 2;
        int tileComp = isPlanar ? 1 : ifd.samplesPerPixel;
        boolean hasPalette = ifd.colorMap != null;
        int xTiles = (iw + (tw - 1)) / tw;
        int yTiles = (ih + (th - 1)) / th;
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        int sampleLen = 0;
        if (ifd.planarConfiguration == 2) {
            sampleLen = ifd.bps[0];
        } else {
            for (int i = 0; i < ifd.bps.length; ++i) {
                sampleLen += ifd.bps[i];
            }
        }
        int tt = ifd.tileOffsets.length;
        for (int t = 0; t < tt; ++t) {
            byte[] output;
            reader.moveTo(ifd.tileOffsets[t]);
            byte[] tileData = new byte[ifd.tileByteCounts[t]];
            reader.read(tileData);
            int expectation = ((tw * sampleLen + 7) / 8 * 8 * th + 7) / 8;
            switch (ifd.compressionType) {
                case 1: {
                    output = tileData;
                    break;
                }
                case 2: {
                    output = new byte[expectation];
                    CCITT fax = new CCITT(ifd.fillOrder, tw);
                    fax.decompress1D(output, tileData, 0, th);
                    break;
                }
                case 3: {
                    output = new byte[expectation];
                    CCITT fax = new CCITT(ifd.fillOrder, tw);
                    fax.decompressFax3(output, tileData, th, ifd.t4Options);
                    break;
                }
                case 4: {
                    output = new byte[expectation];
                    CCITT fax = new CCITT(ifd.fillOrder, tw);
                    fax.decompressFax4(output, tileData, th);
                    break;
                }
                case 5: {
                    output = new byte[expectation];
                    LZW lzw = new LZW();
                    lzw.decompress(output, tileData);
                    break;
                }
                case 6: {
                    throw new Exception("Old style jpeg compression is not supported");
                }
                case 7: {
                    if (ifd.jpegTables != null) {
                        int ifdLen = ifd.jpegTables.length;
                        byte[] temp = new byte[ifdLen + tileData.length - 2];
                        System.arraycopy(ifd.jpegTables, 0, temp, 0, ifdLen);
                        System.arraycopy(tileData, 2, temp, ifdLen, tileData.length - 2);
                        tileData = temp;
                    }
                    JpegDecoder decoder = new JpegDecoder();
                    output = decoder.readComponentsAsRawBytes(tileData);
                    break;
                }
                case 32773: {
                    int exp = (tw * th * sampleLen + 7) / 8;
                    output = PackBits.decompress(tileData, exp);
                    break;
                }
                case 8: 
                case 32946: {
                    output = Deflate.decompress(tileData);
                    break;
                }
                default: {
                    throw new IOException("unrecognized compression found handling Tiff Data");
                }
            }
            if (ifd.predictor == 2) {
                TiffDecoder.doPredictor2(output, tw, th, tileComp);
            }
            if (ifd.photometric == 0) {
                TiffDecoder.doWhiteIsZero(output);
            }
            Tile tile = new Tile();
            tile.data = TiffDecoder.getTileData(ifd, tw, th, bps, tileComp, hasPalette, output);
            tiles.add(tile);
        }
        int[][] tileDim = new int[th * yTiles][tw * xTiles];
        if (isPlanar) {
            TiffDecoder.planarizeTile(ifd, xTiles, tw, th, tileDim, tiles);
        } else {
            TiffDecoder.normalizeTile(xTiles, tw, th, tileDim, tiles, tileComp);
        }
        if (ifd.samplesPerPixel == 4 && ifd.photometric == 2) {
            TiffDecoder.convertRGBAtoARGB(tileDim);
        }
        return TiffDecoder.getImageFromTileData(ifd, tileDim);
    }

    private static void doPredictor2(byte[] output, int tw, int th, int tileComp) {
        for (int j = 0; j < th; ++j) {
            int count = tileComp * (j * tw + 1);
            for (int i = tileComp; i < tw * tileComp; ++i) {
                int n = count;
                output[n] = (byte)(output[n] + output[count - tileComp]);
                ++count;
            }
        }
    }

    private static void doWhiteIsZero(byte[] output) {
        for (int i = 0; i < output.length; ++i) {
            output[i] = (byte)(output[i] & 0xFF ^ 0xFF);
        }
    }

    private static void convertRGBAtoARGB(int[][] tileDim) {
        for (int[] tileDim1 : tileDim) {
            for (int j = 0; j < tileDim[0].length; ++j) {
                int value = tileDim1[j];
                int r = value >> 24 & 0xFF;
                int g = value >> 16 & 0xFF;
                int b = value >> 8 & 0xFF;
                int a = value & 0xFF;
                tileDim1[j] = a << 24 | r << 16 | g << 8 | b;
            }
        }
    }

    private static byte[] getTileData(IFD ifd, int tw, int th, int bps, int tileComp, boolean hasPalette, byte[] output) {
        byte[] tileData;
        int iw8 = tw * bps * tileComp % 8;
        if (bps != 8) {
            tileData = new byte[th * tw * tileComp];
            BitReader bitReader = new BitReader(output);
            int bp = 0;
            if (bps == 1) {
                for (int i = 0; i < th; ++i) {
                    for (int j = 0; j < tw; ++j) {
                        for (int k = 0; k < tileComp; ++k) {
                            tileData[bp++] = hasPalette ? (byte)bitReader.readBits(1) : (byte)(bitReader.readBits(1) * 255);
                        }
                    }
                    if (iw8 == 0) continue;
                    bitReader.readBits(8 - iw8);
                }
            } else if (bps < 8) {
                int shift = 8 - bps;
                for (int i = 0; i < th; ++i) {
                    for (int j = 0; j < tw; ++j) {
                        for (int k = 0; k < tileComp; ++k) {
                            tileData[bp++] = hasPalette ? (byte)bitReader.readBits(bps) : (byte)(bitReader.readBits(bps) << shift);
                        }
                    }
                    if (iw8 == 0) continue;
                    bitReader.readBits(8 - iw8);
                }
            } else {
                int shift = bps - 8;
                int sampleFormat = ifd.sampleFormat[0];
                if (hasPalette) {
                    tileData = new byte[th * tw * 3];
                    for (int i = 0; i < th; ++i) {
                        for (int j = 0; j < tw; ++j) {
                            int v = bitReader.readBits(bps) * 3;
                            tileData[bp++] = ifd.colorMap[v++];
                            tileData[bp++] = ifd.colorMap[v++];
                            tileData[bp++] = ifd.colorMap[v];
                        }
                        if (iw8 == 0) continue;
                        bitReader.readBits(8 - iw8);
                    }
                } else {
                    for (int i = 0; i < th; ++i) {
                        for (int j = 0; j < tw; ++j) {
                            for (int k = 0; k < tileComp; ++k) {
                                tileData[bp++] = sampleFormat == 3 ? (byte)(TiffDecoder.toFloat(bitReader.readBits(bps), bps) * 255.0f) : (byte)(bitReader.readBits(bps) >> shift);
                            }
                        }
                        if (iw8 == 0) continue;
                        bitReader.readBits(8 - iw8);
                    }
                }
            }
        } else {
            tileData = output;
        }
        return tileData;
    }

    private static BufferedImage getImageFromTileData(IFD ifd, int[][] tileDim) {
        BufferedImage image = TiffDecoder.allocateBufferedImage(ifd);
        int bp = 0;
        int iw = ifd.imageWidth;
        int ih = ifd.imageHeight;
        switch (ifd.photometric) {
            case 6: {
                int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                TiffDecoder.updateYCBCR(iw, ih, tileDim, intPixels);
                break;
            }
            case 2: {
                int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < ih; ++i) {
                    for (int j = 0; j < iw; ++j) {
                        intPixels[bp++] = tileDim[i][j];
                    }
                }
                break;
            }
            case 5: {
                int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                TiffDecoder.updateCMYK(iw, ih, tileDim, intPixels);
                break;
            }
            case 3: {
                TiffDecoder.updateRGBPalette(iw, ih, tileDim, image, ifd);
                break;
            }
            default: {
                byte[] bytePixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < ih; ++i) {
                    for (int j = 0; j < iw; ++j) {
                        bytePixels[bp++] = (byte)tileDim[i][j];
                    }
                }
            }
        }
        return image;
    }

    private static void updateYCBCR(int iw, int ih, int[][] tileDim, int[] intPixels) {
        int bp = 0;
        for (int i = 0; i < ih; ++i) {
            for (int j = 0; j < iw; ++j) {
                int val = tileDim[i][j];
                int yy = val >> 16 & 0xFF;
                int cb = val >> 8 & 0xFF;
                int cr = val & 0xFF;
                int u2 = (cb -= 128) >> 2;
                int v35 = ((cr -= 128) >> 3) + (cr >> 5);
                int r = yy + cr + (cr >> 2) + v35;
                int g = yy - (u2 + (cb >> 4) + (cb >> 5)) - ((cr >> 1) + v35 + (cr >> 4));
                int b = yy + cb + (cb >> 1) + u2 + (cb >> 6);
                int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                b = b < 0 ? 0 : (b > 255 ? 255 : b);
                intPixels[bp++] = r << 16 | g << 8 | b;
            }
        }
    }

    private static void updateCMYK(int iw, int ih, int[][] tileDim, int[] intPixels) {
        int bp = 0;
        EnumeratedSpace cmyk = new EnumeratedSpace();
        for (int i = 0; i < ih; ++i) {
            for (int j = 0; j < iw; ++j) {
                int val = tileDim[i][j];
                byte c = (byte)(val >> 24 & 0xFF);
                byte m = (byte)(val >> 16 & 0xFF);
                byte y = (byte)(val >> 8 & 0xFF);
                byte k = (byte)(val & 0xFF);
                byte[] rgb = cmyk.getRGB(c, m, y, k);
                int n = bp;
                bp = (byte)(bp + 1);
                intPixels[n] = (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | rgb[2] & 0xFF;
            }
        }
    }

    private static void updateRGBPalette(int iw, int ih, int[][] tileDim, BufferedImage image, IFD ifd) {
        int bp = 0;
        if (ifd.bps[0] > 8) {
            int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < ih; ++i) {
                for (int j = 0; j < iw; ++j) {
                    intPixels[bp++] = tileDim[i][j];
                }
            }
        } else {
            byte[] bytePixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < ih; ++i) {
                for (int j = 0; j < iw; ++j) {
                    bytePixels[bp++] = (byte)tileDim[i][j];
                }
            }
        }
    }

    private static void planarizeTile(IFD ifd, int xTiles, int tw, int th, int[][] tileDim, List<Tile> tiles) {
        int tp = 0;
        int planarTiles = tiles.size() / ifd.samplesPerPixel;
        for (int z = 0; z < ifd.samplesPerPixel; ++z) {
            for (int t = 0; t < planarTiles; ++t) {
                Tile tile = tiles.get(tp++);
                byte[] output = tile.data;
                int p = t % xTiles;
                int q = t / xTiles;
                int tx = p * tw;
                int ty = q * th;
                int bp = 0;
                for (int i = 0; i < th; ++i) {
                    int iPos = ty + i;
                    for (int j = 0; j < tw; ++j) {
                        int jPos = tx + j;
                        int value = output[bp++] & 0xFF;
                        tileDim[iPos][jPos] = tileDim[iPos][jPos] << 8 | value;
                    }
                }
            }
        }
    }

    private static void normalizeTile(int xTiles, int tw, int th, int[][] tileDim, List<Tile> tiles, int tileComp) {
        for (int t = 0; t < tiles.size(); ++t) {
            Tile tile = tiles.get(t);
            byte[] output = tile.data;
            int p = t % xTiles;
            int q = t / xTiles;
            int tx = p * tw;
            int ty = q * th;
            int bp = 0;
            for (int i = 0; i < th; ++i) {
                int iPos = ty + i;
                for (int j = 0; j < tw; ++j) {
                    int jPos = tx + j;
                    int value = 0;
                    for (int k = tileComp; k > 0; --k) {
                        value |= (output[bp++] & 0xFF) << 8 * (k - 1);
                    }
                    tileDim[iPos][jPos] = value;
                }
            }
        }
    }

    private static BufferedImage generateImageFromIFD(DataReader reader, IFD ifd) throws Exception {
        if (ifd.tileWidth != 0) {
            return TiffDecoder.getImageFromTiles(reader, ifd);
        }
        return TiffDecoder.getDataFromStrips(reader, ifd);
    }

    private static BufferedImage allocateBufferedImage(IFD ifd) {
        int imageWidth = ifd.imageWidth;
        int imageHeight = ifd.imageHeight;
        if (ifd.photometric == 3) {
            if (ifd.bps[0] > 8) {
                return new BufferedImage(imageWidth, imageHeight, 1);
            }
            IndexColorModel indexedCM = new IndexColorModel(8, ifd.colorMap.length / 3, ifd.colorMap, 0, false);
            WritableRaster ras = indexedCM.createCompatibleWritableRaster(ifd.imageWidth, ifd.imageHeight);
            return new BufferedImage(indexedCM, ras, false, null);
        }
        switch (ifd.samplesPerPixel) {
            case 0: 
            case 1: 
            case 2: {
                return new BufferedImage(imageWidth, imageHeight, 10);
            }
            case 3: {
                return new BufferedImage(imageWidth, imageHeight, 1);
            }
            case 4: {
                if (ifd.photometric == 5) {
                    return new BufferedImage(imageWidth, imageHeight, 1);
                }
                return new BufferedImage(imageWidth, imageHeight, 2);
            }
        }
        return new BufferedImage(imageWidth, imageHeight, 2);
    }

    private static int[] readBitsPerSamples(DataReader reader, int offset, int nSamples) throws IOException {
        reader.moveTo(offset);
        int[] temp = new int[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            temp[i] = reader.getU16();
        }
        return temp;
    }

    private static int[] readOffsets(DataReader reader, int offset, int nOffsets, int fieldType) throws IOException {
        reader.moveTo(offset);
        int[] temp = new int[nOffsets];
        if (fieldType == 3) {
            for (int i = 0; i < nOffsets; ++i) {
                temp[i] = reader.getU16();
            }
        } else {
            for (int i = 0; i < nOffsets; ++i) {
                temp[i] = reader.getU32();
            }
        }
        return temp;
    }

    private static int[] readStripTileByteCounts(DataReader reader, int offset, int nCount, int fieldType) throws IOException {
        reader.moveTo(offset);
        int[] temp = new int[nCount];
        if (fieldType == 3) {
            for (int i = 0; i < nCount; ++i) {
                temp[i] = reader.getU16();
            }
        } else {
            for (int i = 0; i < nCount; ++i) {
                temp[i] = reader.getU32();
            }
        }
        return temp;
    }

    private static byte[] readColorMap(DataReader reader, int cmapOffset, int nValues) throws IOException {
        int sv;
        int j;
        reader.moveTo(cmapOffset);
        int totalColors = nValues / 3;
        byte[] rr = new byte[totalColors];
        byte[] gg = new byte[totalColors];
        byte[] bb = new byte[totalColors];
        for (j = 0; j < totalColors; ++j) {
            sv = reader.getU16();
            rr[j] = (byte)(sv >> 8);
        }
        for (j = 0; j < totalColors; ++j) {
            sv = reader.getU16();
            gg[j] = (byte)(sv >> 8);
        }
        for (j = 0; j < totalColors; ++j) {
            sv = reader.getU16();
            bb[j] = (byte)(sv >> 8);
        }
        byte[] temp = new byte[nValues];
        int p = 0;
        for (int i = 0; i < totalColors; ++i) {
            temp[p++] = rr[i];
            temp[p++] = gg[i];
            temp[p++] = bb[i];
        }
        return temp;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    private static float toFloat(int hbits, int bps) {
        switch (bps) {
            case 16: {
                int mant = hbits & 0x3FF;
                int exp = hbits & 0x7C00;
                if (exp == 31744) {
                    exp = 261120;
                } else if (exp != 0) {
                    if (mant == 0 && (exp += 114688) > 115712) {
                        return Float.intBitsToFloat((hbits & 0x8000) << 16 | exp << 13 | 0x3FF);
                    }
                } else if (mant != 0) {
                    exp = 115712;
                    do {
                        exp -= 1024;
                    } while (((mant <<= 1) & 0x400) == 0);
                    mant &= 0x3FF;
                }
                return Float.intBitsToFloat((hbits & 0x8000) << 16 | (exp | mant) << 13);
            }
            case 24: {
                return Float.intBitsToFloat(hbits << 8);
            }
        }
        return Float.intBitsToFloat(hbits);
    }
}

