/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

class CCITT {
    private static final short[] WHITERUN = new short[]{6430, 6400, 6400, 6400, 3225, 3225, 3225, 3225, 944, 944, 944, 944, 976, 976, 976, 976, 1456, 1456, 1456, 1456, 1488, 1488, 1488, 1488, 718, 718, 718, 718, 718, 718, 718, 718, 750, 750, 750, 750, 750, 750, 750, 750, 1520, 1520, 1520, 1520, 1552, 1552, 1552, 1552, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 654, 654, 654, 654, 654, 654, 654, 654, 1072, 1072, 1072, 1072, 1104, 1104, 1104, 1104, 1136, 1136, 1136, 1136, 1168, 1168, 1168, 1168, 1200, 1200, 1200, 1200, 1232, 1232, 1232, 1232, 622, 622, 622, 622, 622, 622, 622, 622, 1008, 1008, 1008, 1008, 1040, 1040, 1040, 1040, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 1712, 1712, 1712, 1712, 1744, 1744, 1744, 1744, 846, 846, 846, 846, 846, 846, 846, 846, 1264, 1264, 1264, 1264, 1296, 1296, 1296, 1296, 1328, 1328, 1328, 1328, 1360, 1360, 1360, 1360, 1392, 1392, 1392, 1392, 1424, 1424, 1424, 1424, 686, 686, 686, 686, 686, 686, 686, 686, 910, 910, 910, 910, 910, 910, 910, 910, 1968, 1968, 1968, 1968, 2000, 2000, 2000, 2000, 2032, 2032, 2032, 2032, 16, 16, 16, 16, 10257, 10257, 10257, 10257, 12305, 12305, 12305, 12305, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 878, 878, 878, 878, 878, 878, 878, 878, 1904, 1904, 1904, 1904, 1936, 1936, 1936, 1936, -18413, -18413, -16365, -16365, -14317, -14317, -10221, -10221, 590, 590, 590, 590, 590, 590, 590, 590, 782, 782, 782, 782, 782, 782, 782, 782, 1584, 1584, 1584, 1584, 1616, 1616, 1616, 1616, 1648, 1648, 1648, 1648, 1680, 1680, 1680, 1680, 814, 814, 814, 814, 814, 814, 814, 814, 1776, 1776, 1776, 1776, 1808, 1808, 1808, 1808, 1840, 1840, 1840, 1840, 1872, 1872, 1872, 1872, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, 14353, 14353, 14353, 14353, 16401, 16401, 16401, 16401, 22547, 22547, 24595, 24595, 20497, 20497, 20497, 20497, 18449, 18449, 18449, 18449, 26643, 26643, 28691, 28691, 30739, 30739, -32749, -32749, -30701, -30701, -28653, -28653, -26605, -26605, -24557, -24557, -22509, -22509, -20461, -20461, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232};
    private static final short[] BLACKRUN = new short[]{62, 62, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 588, 588, 588, 588, 588, 588, 588, 588, 1680, 1680, 20499, 22547, 24595, 26643, 1776, 1776, 1808, 1808, -24557, -22509, -20461, -18413, 1904, 1904, 1936, 1936, -16365, -14317, 782, 782, 782, 782, 814, 814, 814, 814, -12269, -10221, 10257, 10257, 12305, 12305, 14353, 14353, 16403, 18451, 1712, 1712, 1744, 1744, 28691, 30739, -32749, -30701, -28653, -26605, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 750, 750, 750, 750, 1616, 1616, 1648, 1648, 1424, 1424, 1456, 1456, 1488, 1488, 1520, 1520, 1840, 1840, 1872, 1872, 1968, 1968, 8209, 8209, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 1552, 1552, 1584, 1584, 2000, 2000, 2032, 2032, 976, 976, 1008, 1008, 1040, 1040, 1072, 1072, 1296, 1296, 1328, 1328, 718, 718, 718, 718, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 4113, 4113, 6161, 6161, 848, 848, 880, 880, 912, 912, 944, 944, 622, 622, 622, 622, 654, 654, 654, 654, 1104, 1104, 1136, 1136, 1168, 1168, 1200, 1200, 1232, 1232, 1264, 1264, 686, 686, 686, 686, 1360, 1360, 1392, 1392, 12, 12, 12, 12, 12, 12, 12, 12, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390};
    private static final short[] MOREBLACKS = new short[]{28679, 28679, 31752, -32759, -31735, -30711, -29687, -28663, 29703, 29703, 30727, 30727, -27639, -26615, -25591, -24567};
    private static final short[] FIRSTBLACKS = new short[]{3226, 6412, 200, 168, 38, 38, 134, 134, 100, 100, 100, 100, 68, 68, 68, 68};
    private static final short[] BLACKS2BIT = new short[]{292, 260, 226, 226};
    private static final int[] LEFTBITS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private static final int[] CURBITS = new int[]{0, 128, 192, 224, 240, 248, 252, 254, 255};
    private static final byte[] LITTLEENDIANS = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2, 1, -127, 65, -63, 33, -95, 97, -31, 17, -111, 81, -47, 49, -79, 113, -15, 9, -119, 73, -55, 41, -87, 105, -23, 25, -103, 89, -39, 57, -71, 121, -7, 5, -123, 69, -59, 37, -91, 101, -27, 21, -107, 85, -43, 53, -75, 117, -11, 13, -115, 77, -51, 45, -83, 109, -19, 29, -99, 93, -35, 61, -67, 125, -3, 3, -125, 67, -61, 35, -93, 99, -29, 19, -109, 83, -45, 51, -77, 115, -13, 11, -117, 75, -53, 43, -85, 107, -21, 27, -101, 91, -37, 59, -69, 123, -5, 7, -121, 71, -57, 39, -89, 103, -25, 23, -105, 87, -41, 55, -73, 119, -9, 15, -113, 79, -49, 47, -81, 111, -17, 31, -97, 95, -33, 63, -65, 127, -1};
    private static final byte[] Codes2D = new byte[]{80, 88, 23, 71, 30, 30, 62, 62, 4, 4, 4, 4, 4, 4, 4, 4, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41};
    private byte[] input;
    private byte[] output;
    private int[] prevItems;
    private int[] curItems;
    private int processItem;
    private int compression = 2;
    private int changingElemSize;
    private int bitP;
    private int bp;
    private int dim1;
    private int bitsToPut;
    private final int endianOrder;
    private final int w;

    CCITT(int fillOrder, int w) {
        this.endianOrder = fillOrder;
        this.w = w;
        this.bitP = 0;
        this.bp = 0;
        this.prevItems = new int[w + 1];
        this.curItems = new int[w + 1];
    }

    public void decompress1D(byte[] output, byte[] input, int startX, int height) {
        this.input = input;
        this.output = output;
        int lineOffset = 0;
        int scanlineStride = (this.w + 7) / 8;
        this.bitP = 0;
        this.bp = 0;
        for (int i = 0; i < height; ++i) {
            this.processNextLine(lineOffset, startX);
            lineOffset += scanlineStride;
        }
    }

    public void decompressFax3(byte[] output, byte[] input, int height, int t4) {
        this.input = input;
        this.output = output;
        this.compression = 3;
        this.bitP = 0;
        this.bp = 0;
        this.dim1 = t4 & 1;
        int scanlineStride = (this.w + 7) / 8;
        int[] b = new int[2];
        this.dim1 = t4 & 1;
        this.bitsToPut = (t4 & 4) >> 2;
        if (this.readEndOfLine(true) != 1) {
            throw new RuntimeException("TIFFFaxDecoder3");
        }
        int lineOffset = 0;
        this.processNextLine(lineOffset, 0);
        lineOffset += scanlineStride;
        for (int lines = 1; lines < height; ++lines) {
            if (this.readEndOfLine(false) == 0) {
                int[] temp = this.prevItems;
                this.prevItems = this.curItems;
                this.curItems = temp;
                int currIndex = 0;
                int a0 = -1;
                boolean isWhite = true;
                int bitOffset = 0;
                this.processItem = 0;
                while (bitOffset < this.w) {
                    this.updateNextChangeItem(a0, isWhite, b);
                    int b1 = b[0];
                    int b2 = b[1];
                    int entry = this.readBalanceBits(7);
                    entry = Codes2D[entry] & 0xFF;
                    int code = (entry & 0x78) >>> 3;
                    int bits = entry & 7;
                    if (code == 0) {
                        if (!isWhite) {
                            this.invertToBlack(lineOffset, bitOffset, b2 - bitOffset);
                        }
                        bitOffset = a0 = b2;
                        this.movePointers(7 - bits);
                        continue;
                    }
                    if (code == 1) {
                        int number;
                        this.movePointers(7 - bits);
                        if (isWhite) {
                            number = this.decodeWhiteCodeWord();
                            this.curItems[currIndex++] = bitOffset += number;
                            number = this.decodeBlackCodeWord();
                            this.invertToBlack(lineOffset, bitOffset, number);
                            this.curItems[currIndex++] = bitOffset += number;
                        } else {
                            number = this.decodeBlackCodeWord();
                            this.invertToBlack(lineOffset, bitOffset, number);
                            this.curItems[currIndex++] = bitOffset += number;
                            number = this.decodeWhiteCodeWord();
                            this.curItems[currIndex++] = bitOffset += number;
                        }
                        a0 = bitOffset;
                        continue;
                    }
                    if (code <= 8) {
                        int a1 = b1 + (code - 5);
                        this.curItems[currIndex++] = a1;
                        if (!isWhite) {
                            this.invertToBlack(lineOffset, bitOffset, a1 - bitOffset);
                        }
                        bitOffset = a0 = a1;
                        isWhite = !isWhite;
                        this.movePointers(7 - bits);
                        continue;
                    }
                    throw new RuntimeException("TIFFFaxDecoder4");
                }
                this.curItems[currIndex++] = bitOffset;
                this.changingElemSize = currIndex;
            } else {
                this.processNextLine(lineOffset, 0);
            }
            lineOffset += scanlineStride;
        }
    }

    public void decompressFax4(byte[] output, byte[] input, int height) {
        this.input = input;
        this.output = output;
        this.compression = 4;
        this.bitP = 0;
        this.bp = 0;
        int scanlineStride = (this.w + 7) / 8;
        int[] b = new int[2];
        int[] cce = this.curItems;
        this.changingElemSize = 0;
        cce[this.changingElemSize++] = this.w;
        cce[this.changingElemSize++] = this.w;
        int lineOffset = 0;
        for (int lines = 0; lines < height; ++lines) {
            int a0 = -1;
            boolean isWhite = true;
            int[] temp = this.prevItems;
            this.prevItems = this.curItems;
            this.curItems = temp;
            cce = temp;
            int currIndex = 0;
            int bitOffset = 0;
            this.processItem = 0;
            while (bitOffset < this.w) {
                this.updateNextChangeItem(a0, isWhite, b);
                int b1 = b[0];
                int b2 = b[1];
                int entry = this.readBalanceBits(7);
                entry = Codes2D[entry] & 0xFF;
                int code = (entry & 0x78) >>> 3;
                int bits = entry & 7;
                if (code == 0) {
                    if (!isWhite) {
                        this.invertToBlack(lineOffset, bitOffset, b2 - bitOffset);
                    }
                    bitOffset = a0 = b2;
                    this.movePointers(7 - bits);
                    continue;
                }
                if (code == 1) {
                    int number;
                    this.movePointers(7 - bits);
                    if (isWhite) {
                        number = this.decodeWhiteCodeWord();
                        cce[currIndex++] = bitOffset += number;
                        number = this.decodeBlackCodeWord();
                        this.invertToBlack(lineOffset, bitOffset, number);
                        cce[currIndex++] = bitOffset += number;
                    } else {
                        number = this.decodeBlackCodeWord();
                        this.invertToBlack(lineOffset, bitOffset, number);
                        cce[currIndex++] = bitOffset += number;
                        number = this.decodeWhiteCodeWord();
                        cce[currIndex++] = bitOffset += number;
                    }
                    a0 = bitOffset;
                    continue;
                }
                if (code <= 8) {
                    int a1 = b1 + (code - 5);
                    cce[currIndex++] = a1;
                    if (!isWhite) {
                        this.invertToBlack(lineOffset, bitOffset, a1 - bitOffset);
                    }
                    bitOffset = a0 = a1;
                    isWhite = !isWhite;
                    this.movePointers(7 - bits);
                    continue;
                }
                if (code == 11) {
                    if (this.readBalanceBits(3) != 7) {
                        throw new RuntimeException("TIFFFaxDecoder5");
                    }
                    int zeros = 0;
                    boolean exit = false;
                    while (!exit) {
                        while (this.readBalanceBits(1) != 1) {
                            ++zeros;
                        }
                        if (zeros > 5) {
                            if (!isWhite && (zeros -= 6) > 0) {
                                cce[currIndex++] = bitOffset;
                            }
                            bitOffset += zeros;
                            if (zeros > 0) {
                                isWhite = true;
                            }
                            if (this.readBalanceBits(1) == 0) {
                                if (!isWhite) {
                                    cce[currIndex++] = bitOffset;
                                }
                                isWhite = true;
                            } else {
                                if (isWhite) {
                                    cce[currIndex++] = bitOffset;
                                }
                                isWhite = false;
                            }
                            exit = true;
                        }
                        if (zeros == 5) {
                            if (!isWhite) {
                                cce[currIndex++] = bitOffset;
                            }
                            bitOffset += 5;
                            isWhite = true;
                            continue;
                        }
                        cce[currIndex++] = bitOffset += zeros;
                        this.invertToBlack(lineOffset, bitOffset, 1);
                        ++bitOffset;
                        isWhite = false;
                    }
                    continue;
                }
                throw new RuntimeException("TIFFFaxDecoder5");
            }
            if (currIndex <= this.w) {
                cce[currIndex++] = bitOffset;
            }
            this.changingElemSize = currIndex;
            lineOffset += scanlineStride;
        }
    }

    private void processNextLine(int lineOffset, int bitOffset) {
        boolean isWhite = true;
        this.changingElemSize = 0;
        while (bitOffset < this.w) {
            int code;
            int bits;
            int isT;
            short entry;
            int current;
            block14: while (isWhite) {
                current = this.readBits(10);
                entry = WHITERUN[current];
                isT = entry & 1;
                bits = entry >>> 1 & 0xF;
                switch (bits) {
                    case 12: {
                        int twoBits = this.readBalanceBits(2);
                        current = current << 2 & 0xC | twoBits;
                        entry = MOREBLACKS[current];
                        bits = entry >>> 1 & 7;
                        code = entry >>> 4 & 0xFFF;
                        bitOffset += code;
                        this.movePointers(4 - bits);
                        continue block14;
                    }
                    case 0: {
                        throw new RuntimeException("TIFFFaxDecoder0");
                    }
                    case 15: {
                        this.movePointers(12);
                        return;
                    }
                }
                code = entry >>> 5 & 0x7FF;
                bitOffset += code;
                this.movePointers(10 - bits);
                if (isT != 0) continue;
                isWhite = false;
                this.curItems[this.changingElemSize++] = bitOffset;
            }
            if (bitOffset == this.w) {
                if (this.compression != 2 || this.bitP == 0) break;
                ++this.bp;
                this.bitP = 0;
                break;
            }
            block15: while (!isWhite) {
                current = this.readBalanceBits(4);
                entry = FIRSTBLACKS[current];
                bits = entry >>> 1 & 0xF;
                code = entry >>> 5 & 0x7FF;
                switch (code) {
                    case 100: {
                        current = this.readBits(9);
                        entry = BLACKRUN[current];
                        isT = entry & 1;
                        bits = entry >>> 1 & 0xF;
                        code = entry >>> 5 & 0x7FF;
                        switch (bits) {
                            case 12: {
                                this.movePointers(5);
                                current = this.readBalanceBits(4);
                                entry = MOREBLACKS[current];
                                bits = entry >>> 1 & 7;
                                code = entry >>> 4 & 0xFFF;
                                this.invertToBlack(lineOffset, bitOffset, code);
                                bitOffset += code;
                                this.movePointers(4 - bits);
                                continue block15;
                            }
                            case 15: {
                                this.movePointers(12);
                                return;
                            }
                        }
                        this.invertToBlack(lineOffset, bitOffset, code);
                        bitOffset += code;
                        this.movePointers(9 - bits);
                        if (isT != 0) continue block15;
                        isWhite = true;
                        this.curItems[this.changingElemSize++] = bitOffset;
                        continue block15;
                    }
                    case 200: {
                        current = this.readBalanceBits(2);
                        entry = BLACKS2BIT[current];
                        code = entry >>> 5 & 0x7FF;
                        bits = entry >>> 1 & 0xF;
                        this.invertToBlack(lineOffset, bitOffset, code);
                        this.movePointers(2 - bits);
                        isWhite = true;
                        this.curItems[this.changingElemSize++] = bitOffset += code;
                        continue block15;
                    }
                }
                this.invertToBlack(lineOffset, bitOffset, code);
                this.movePointers(4 - bits);
                isWhite = true;
                this.curItems[this.changingElemSize++] = bitOffset += code;
            }
            if (bitOffset != this.w) continue;
            if (this.compression != 2 || this.bitP == 0) break;
            ++this.bp;
            this.bitP = 0;
            break;
        }
        this.curItems[this.changingElemSize++] = bitOffset;
    }

    private void invertToBlack(int lineOffset, int bitOffset, int numBits) {
        int bitNum = 8 * lineOffset + bitOffset;
        int lastBit = bitNum + numBits;
        int byteNum = bitNum >> 3;
        int shift = bitNum & 7;
        if (shift > 0) {
            byte val = this.output[byteNum];
            for (int maskVal = 1 << 7 - shift; maskVal > 0 && bitNum < lastBit; maskVal >>= 1, ++bitNum) {
                val = (byte)(val | maskVal);
            }
            this.output[byteNum] = val;
        }
        byteNum = bitNum >> 3;
        while (bitNum < lastBit - 7) {
            this.output[byteNum++] = -1;
            bitNum += 8;
        }
        while (bitNum < lastBit) {
            int n = byteNum = bitNum >> 3;
            this.output[n] = (byte)(this.output[n] | 1 << 7 - (bitNum & 7));
            ++bitNum;
        }
    }

    private int decodeWhiteCodeWord() {
        int runLength = 0;
        boolean isWhite = true;
        block5: while (isWhite) {
            int code;
            int current = this.readBits(10);
            short entry = WHITERUN[current];
            int isT = entry & 1;
            int bits = entry >>> 1 & 0xF;
            switch (bits) {
                case 12: {
                    int twoBits = this.readBalanceBits(2);
                    current = current << 2 & 0xC | twoBits;
                    entry = MOREBLACKS[current];
                    bits = entry >>> 1 & 7;
                    code = entry >>> 4 & 0xFFF;
                    runLength += code;
                    this.movePointers(4 - bits);
                    continue block5;
                }
                case 0: {
                    throw new RuntimeException("TIFFFaxDecoder0");
                }
                case 15: {
                    throw new RuntimeException("TIFFFaxDecoder1");
                }
            }
            code = entry >>> 5 & 0x7FF;
            runLength += code;
            this.movePointers(10 - bits);
            if (isT != 0) continue;
            isWhite = false;
        }
        return runLength;
    }

    private int decodeBlackCodeWord() {
        int runLength = 0;
        boolean isWhite = false;
        block8: while (!isWhite) {
            int current = this.readBalanceBits(4);
            short entry = FIRSTBLACKS[current];
            int bits = entry >>> 1 & 0xF;
            int code = entry >>> 5 & 0x7FF;
            switch (code) {
                case 100: {
                    current = this.readBits(9);
                    entry = BLACKRUN[current];
                    int isT = entry & 1;
                    bits = entry >>> 1 & 0xF;
                    code = entry >>> 5 & 0x7FF;
                    switch (bits) {
                        case 12: {
                            this.movePointers(5);
                            current = this.readBalanceBits(4);
                            entry = MOREBLACKS[current];
                            bits = entry >>> 1 & 7;
                            code = entry >>> 4 & 0xFFF;
                            runLength += code;
                            this.movePointers(4 - bits);
                            continue block8;
                        }
                        case 15: {
                            throw new RuntimeException("TIFFFaxDecoder2");
                        }
                    }
                    runLength += code;
                    this.movePointers(9 - bits);
                    if (isT != 0) continue block8;
                    isWhite = true;
                    continue block8;
                }
                case 200: {
                    current = this.readBalanceBits(2);
                    entry = BLACKS2BIT[current];
                    code = entry >>> 5 & 0x7FF;
                    runLength += code;
                    bits = entry >>> 1 & 0xF;
                    this.movePointers(2 - bits);
                    isWhite = true;
                    continue block8;
                }
            }
            runLength += code;
            this.movePointers(4 - bits);
            isWhite = true;
        }
        return runLength;
    }

    private boolean findEndOfLine() {
        int bitIndexMax = this.input.length * 8 - 1;
        int bitIndex = this.bp * 8 + this.bitP;
        while (bitIndex <= bitIndexMax - 12) {
            int next12Bits = this.readBits(12);
            bitIndex += 12;
            while (next12Bits != 1 && bitIndex < bitIndexMax) {
                next12Bits = (next12Bits & 0x7FF) << 1 | this.readBalanceBits(1) & 1;
                ++bitIndex;
            }
            if (next12Bits != 1) continue;
            this.movePointers(12);
            return true;
        }
        return false;
    }

    private int readEndOfLine(boolean isFirstEOL) {
        if (this.dim1 == 0 && !this.findEndOfLine()) {
            throw new RuntimeException("TIFFFaxDecoder9");
        }
        if (this.bitsToPut == 0) {
            int next12Bits = this.readBits(12);
            if (isFirstEOL && next12Bits == 0 && this.readBits(4) == 1) {
                this.bitsToPut = 1;
                return 1;
            }
            if (next12Bits != 1) {
                throw new RuntimeException("TIFFFaxDecoder6");
            }
        } else if (this.bitsToPut == 1) {
            int bitsLeft = 8 - this.bitP;
            if (this.readBits(bitsLeft) != 0) {
                throw new RuntimeException("TIFFFaxDecoder8");
            }
            if (bitsLeft < 4 && this.readBits(8) != 0) {
                throw new RuntimeException("TIFFFaxDecoder8");
            }
            int next8 = this.readBits(8);
            if (isFirstEOL && (next8 & 0xF0) == 16) {
                this.bitsToPut = 0;
                this.movePointers(4);
            } else {
                while (next8 != 1) {
                    if (next8 != 0) {
                        throw new RuntimeException("TIFFFaxDecoder8");
                    }
                    next8 = this.readBits(8);
                }
            }
        }
        if (this.dim1 == 0) {
            return 1;
        }
        return this.readBalanceBits(1);
    }

    private int readBits(int bitsToGet) {
        byte next2next;
        byte next;
        byte b;
        int l = this.input.length - 1;
        int bp = this.bp;
        switch (this.endianOrder) {
            case 1: {
                b = this.input[bp];
                if (bp == l) {
                    next = 0;
                    next2next = 0;
                    break;
                }
                if (bp + 1 == l) {
                    next = this.input[bp + 1];
                    next2next = 0;
                    break;
                }
                next = this.input[bp + 1];
                next2next = this.input[bp + 2];
                break;
            }
            case 2: {
                b = LITTLEENDIANS[this.input[bp] & 0xFF];
                if (bp == l) {
                    next = 0;
                    next2next = 0;
                    break;
                }
                if (bp + 1 == l) {
                    next = LITTLEENDIANS[this.input[bp + 1] & 0xFF];
                    next2next = 0;
                    break;
                }
                next = LITTLEENDIANS[this.input[bp + 1] & 0xFF];
                next2next = LITTLEENDIANS[this.input[bp + 2] & 0xFF];
                break;
            }
            default: {
                throw new RuntimeException("TIFFFaxDecoder7");
            }
        }
        int bitsLeft = 8 - this.bitP;
        int bitsFromNextByte = bitsToGet - bitsLeft;
        int bitsFromNext2NextByte = 0;
        if (bitsFromNextByte > 8) {
            bitsFromNext2NextByte = bitsFromNextByte - 8;
            bitsFromNextByte = 8;
        }
        ++this.bp;
        int i1 = (b & LEFTBITS[bitsLeft]) << bitsToGet - bitsLeft;
        int i2 = (next & CURBITS[bitsFromNextByte]) >>> 8 - bitsFromNextByte;
        if (bitsFromNext2NextByte != 0) {
            i2 <<= bitsFromNext2NextByte;
            int i3 = (next2next & CURBITS[bitsFromNext2NextByte]) >>> 8 - bitsFromNext2NextByte;
            i2 |= i3;
            ++this.bp;
            this.bitP = bitsFromNext2NextByte;
        } else if (bitsFromNextByte == 8) {
            this.bitP = 0;
            ++this.bp;
        } else {
            this.bitP = bitsFromNextByte;
        }
        return i1 | i2;
    }

    private int readBalanceBits(int bitsToGet) {
        int i1;
        byte next;
        byte b;
        int l = this.input.length - 1;
        int bp = this.bp;
        switch (this.endianOrder) {
            case 1: {
                b = this.input[bp];
                if (bp == l) {
                    next = 0;
                    break;
                }
                next = this.input[bp + 1];
                break;
            }
            case 2: {
                b = LITTLEENDIANS[this.input[bp] & 0xFF];
                if (bp == l) {
                    next = 0;
                    break;
                }
                next = LITTLEENDIANS[this.input[bp + 1] & 0xFF];
                break;
            }
            default: {
                throw new RuntimeException("TIFFFaxDecoder7");
            }
        }
        int bitsLeft = 8 - this.bitP;
        int bitsFromNextByte = bitsToGet - bitsLeft;
        int shift = bitsLeft - bitsToGet;
        if (shift >= 0) {
            i1 = (b & LEFTBITS[bitsLeft]) >>> shift;
            this.bitP += bitsToGet;
            if (this.bitP == 8) {
                this.bitP = 0;
                ++this.bp;
            }
        } else {
            i1 = (b & LEFTBITS[bitsLeft]) << -shift;
            int i2 = (next & CURBITS[bitsFromNextByte]) >>> 8 - bitsFromNextByte;
            i1 |= i2;
            ++this.bp;
            this.bitP = bitsFromNextByte;
        }
        return i1;
    }

    private void movePointers(int reverseBits) {
        int i;
        if (reverseBits > 8) {
            this.bp -= reverseBits / 8;
            reverseBits %= 8;
        }
        if ((i = this.bitP - reverseBits) < 0) {
            --this.bp;
            this.bitP = 8 + i;
        } else {
            this.bitP = i;
        }
    }

    private void updateNextChangeItem(int a0, boolean isWhite, int[] ret) {
        int i;
        int start;
        int[] pce = this.prevItems;
        int ces = this.changingElemSize;
        int n = start = this.processItem > 0 ? this.processItem - 1 : 0;
        start = isWhite ? (start &= 0xFFFFFFFE) : (start |= 1);
        for (i = start; i < ces; i += 2) {
            int temp = pce[i];
            if (temp <= a0) continue;
            this.processItem = i;
            ret[0] = temp;
            break;
        }
        if (i + 1 < ces) {
            ret[1] = pce[i + 1];
        }
    }
}

