/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

import com.idrsolutions.image.BitReader;
import com.idrsolutions.image.DataByteBig;
import com.idrsolutions.image.DataFileBig;
import com.idrsolutions.image.DataReader;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.png.Info;
import com.idrsolutions.image.tiff.Deflate;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PngDecoder
extends JDeliImage {
    private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR = 1229472850;
    private static final int PLTE = 1347179589;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private static final int tRNS = 1951551059;
    private static final int cHRM = 1665684045;
    private static final int gAMA = 1732332865;
    private static final int iCCP = 1766015824;
    private static final int sBIT = 1933723988;
    private static final int sRGB = 1934772034;
    private static final int tEXt = 1950701684;
    private static final int iTXt = 1767135348;
    private static final int zTXt = 2052348020;
    private static final int bKGD = 1649100612;
    private static final int hIST = 1749635924;
    private static final int pHYs = 1883789683;
    private static final int sPLT = 1934642260;
    private static final int tIME = 1950960965;
    private static final int COLORTYPE_GRAY = 0;
    private static final int COLORTYPE_RGB = 2;
    private static final int COLORTYPE_PALETTE = 3;
    private static final int COLORTYPE_GRAYALPHA = 4;
    private static final int COLORTYPE_RGBALPHA = 6;
    private static final int[] LEFTVALUES = new int[]{1, 3, 7, 15, 31, 63, 127, 255};
    private static final boolean debug = false;

    public BufferedImage read(byte[] pngRawData) throws Exception {
        Info info = new Info();
        DataByteBig reader = new DataByteBig(pngRawData);
        byte[] pngData = PngDecoder.getUncompressedPngData(info, reader);
        List<byte[]> scanList = PngDecoder.getScanList(pngData, info);
        PngDecoder.filterScans(scanList, info);
        if (info.interlace == 1) {
            scanList = PngDecoder.fillInterlaced(scanList, info);
        }
        reader.close();
        return PngDecoder.getImageFromList(scanList, info);
    }

    public BufferedImage read(File file) throws Exception {
        Info info = new Info();
        DataFileBig reader = new DataFileBig(file);
        byte[] pngData = PngDecoder.getUncompressedPngData(info, reader);
        List<byte[]> scanList = PngDecoder.getScanList(pngData, info);
        PngDecoder.filterScans(scanList, info);
        if (info.interlace == 1) {
            scanList = PngDecoder.fillInterlaced(scanList, info);
        }
        reader.close();
        return PngDecoder.getImageFromList(scanList, info);
    }

    private static byte[] getUncompressedPngData(Info info, DataReader reader) throws Exception {
        byte[] temp = new byte[8];
        reader.read(temp);
        for (int i = 0; i < 8; ++i) {
            if (SIGNATURE[i] == temp[i]) continue;
            throw new IOException("Not a valid PNG File");
        }
        try (ByteArrayOutputStream iDataStream = new ByteArrayOutputStream();){
            block21: while (reader.getPosition() < reader.getLength()) {
                int chunkLen = reader.getU32();
                int chunkType = reader.getU32();
                temp = new byte[chunkLen];
                reader.read(temp);
                reader.getU32();
                switch (chunkType) {
                    case 1229472850: {
                        info.width = (temp[0] & 0xFF) << 24 | (temp[1] & 0xFF) << 16 | (temp[2] & 0xFF) << 8 | temp[3] & 0xFF;
                        info.height = (temp[4] & 0xFF) << 24 | (temp[5] & 0xFF) << 16 | (temp[6] & 0xFF) << 8 | temp[7] & 0xFF;
                        info.bps = temp[8] & 0xFF;
                        info.colorType = temp[9] & 0xFF;
                        info.compression = temp[10] & 0xFF;
                        info.filter = temp[11] & 0xFF;
                        info.interlace = temp[12] & 0xFF;
                        continue block21;
                    }
                    case 1347179589: {
                        info.rr = new byte[temp.length / 3];
                        info.gg = new byte[temp.length / 3];
                        info.bb = new byte[temp.length / 3];
                        int i = 0;
                        for (int p = 0; p < info.rr.length; ++p) {
                            info.rr[p] = temp[i++];
                            info.gg[p] = temp[i++];
                            info.bb[p] = temp[i++];
                        }
                        continue block21;
                    }
                    case 1229209940: {
                        iDataStream.write(temp);
                        continue block21;
                    }
                    case 1229278788: {
                        continue block21;
                    }
                    case 1951551059: {
                        info.trnsData = (byte[])temp.clone();
                        continue block21;
                    }
                    case 1665684045: {
                        continue block21;
                    }
                    case 1732332865: {
                        continue block21;
                    }
                    case 1766015824: {
                        int ni = PngDecoder.findNullIndex(temp);
                        if (ni == -1) continue block21;
                        info.compressionMethod = temp[ni + 1];
                        if (info.compressionMethod != 0) continue block21;
                        int csLen = temp.length - (ni + 2);
                        byte[] cp = new byte[csLen];
                        System.arraycopy(temp, ni + 2, cp, 0, csLen);
                        cp = Deflate.decompress(cp);
                        info.cs = new ICC_ColorSpace(ICC_Profile.getInstance(cp));
                        continue block21;
                    }
                    case 1649100612: 
                    case 1749635924: 
                    case 1767135348: 
                    case 1883789683: 
                    case 1933723988: 
                    case 1934642260: 
                    case 1934772034: 
                    case 1950701684: 
                    case 1950960965: 
                    case 2052348020: {
                        continue block21;
                    }
                }
                System.out.println("tag not found");
            }
            iDataStream.close();
            byte[] pngData = iDataStream.toByteArray();
            byte[] byArray = Deflate.decompress(pngData);
            return byArray;
        }
    }

    private static List<byte[]> getScanList(byte[] pngData, Info info) {
        ArrayList<byte[]> scanList = new ArrayList<byte[]>();
        int scanFillLen = info.getScaneLineLength();
        if (info.interlace == 0) {
            info.filters = new byte[info.height];
            int p = 0;
            for (int i = 0; i < info.height; ++i) {
                byte[] b = new byte[scanFillLen];
                info.filters[i] = pngData[p++];
                System.arraycopy(pngData, p, b, 0, scanFillLen);
                p += scanFillLen;
                scanList.add(b);
            }
        } else {
            int xLeft = info.width % 8;
            int yLeft = info.height % 8;
            int[] furtherX = new int[7];
            int[] furtherY = new int[7];
            if (xLeft != 0) {
                furtherX[0] = 1;
                furtherX[1] = xLeft >> 2;
                furtherX[2] = (xLeft >> 2) + 1;
                furtherX[3] = xLeft + 1 >> 2;
                furtherX[4] = xLeft + 1 >> 1;
                furtherX[5] = xLeft >> 1;
                furtherX[6] = xLeft;
            }
            if (yLeft != 0) {
                furtherY[0] = 1;
                furtherY[1] = 1;
                furtherY[2] = yLeft >> 2;
                furtherY[3] = (yLeft >> 2) + 1;
                furtherY[4] = yLeft + 1 >> 2;
                furtherY[5] = yLeft + 1 >> 1;
                furtherY[6] = yLeft >> 1;
            }
            int nComp = info.colorType == 3 ? 1 : info.getNComp();
            int[] totalCols = new int[]{1, 1, 2, 2, 4, 4, 8};
            int[] totalRows = new int[]{1, 1, 1, 2, 2, 4, 4};
            int p = 0;
            try (ByteArrayOutputStream filterBos = new ByteArrayOutputStream();){
                for (int i = 0; i < 7; ++i) {
                    int jj = (info.height >> 3) * totalRows[i] + furtherY[i];
                    int totalPoints = (info.width >> 3) * totalCols[i] + furtherX[i];
                    int scanLen = totalPoints * info.bps * nComp + 7 >> 3;
                    for (int j = 0; j < jj; ++j) {
                        filterBos.write(pngData[p++]);
                        byte[] temp = new byte[scanLen];
                        System.arraycopy(pngData, p, temp, 0, scanLen);
                        p += scanLen;
                        scanList.add(temp);
                    }
                }
                info.filters = filterBos.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return scanList;
    }

    private static void filterScans(List<byte[]> scanList, Info info) {
        block7: {
            if (info.colorType == 3 || info.bps < 8) break block7;
            int nComp = info.getNComp();
            if (info.bps == 16) {
                byte[] prevScan = null;
                int p = 0;
                for (byte[] scan : scanList) {
                    byte filter = info.filters[p++];
                    byte[] curScan = new byte[scan.length >> 1];
                    int k = 0;
                    for (int i = 0; i < curScan.length; ++i) {
                        curScan[i] = scan[k++];
                        ++k;
                    }
                    if (filter != 0) {
                        PngDecoder.filterBytes(filter, curScan, prevScan, curScan.length / nComp, nComp);
                    }
                    k = 0;
                    for (byte aCurScan : curScan) {
                        scan[k++] = aCurScan;
                        ++k;
                    }
                    prevScan = (byte[])curScan.clone();
                }
            } else {
                int ii = scanList.size();
                for (int i = 0; i < ii; ++i) {
                    byte[] prevScan;
                    byte filter = info.filters[i];
                    byte[] curScan = scanList.get(i);
                    byte[] byArray = prevScan = i == 0 ? null : scanList.get(i - 1);
                    if (filter == 0) continue;
                    PngDecoder.filterBytes(filter, curScan, prevScan, curScan.length / nComp, nComp);
                }
            }
        }
    }

    private static List<byte[]> fillInterlaced(List<byte[]> scanList, Info info) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i = 0; i < info.height; ++i) {
            byte[] temp = new byte[info.getScaneLineLength()];
            result.add(temp);
        }
        int nComp = info.colorType == 3 ? 1 : info.getNComp();
        int xLeft = info.width % 8;
        int yLeft = info.height % 8;
        int[] furtherX = new int[7];
        int[] furtherY = new int[7];
        if (xLeft != 0) {
            furtherX[0] = 1;
            furtherX[1] = xLeft >> 2;
            furtherX[2] = (xLeft >> 2) + 1;
            furtherX[3] = xLeft + 1 >> 2;
            furtherX[4] = xLeft + 1 >> 1;
            furtherX[5] = xLeft >> 1;
            furtherX[6] = xLeft;
        }
        if (yLeft != 0) {
            furtherY[0] = 1;
            furtherY[1] = 1;
            furtherY[2] = yLeft >> 2;
            furtherY[3] = (yLeft >> 2) + 1;
            furtherY[4] = yLeft + 1 >> 2;
            furtherY[5] = yLeft + 1 >> 1;
            furtherY[6] = yLeft >> 1;
        }
        int[] totalCols = new int[]{1, 1, 2, 2, 4, 4, 8};
        int[] totalRows = new int[]{1, 1, 1, 2, 2, 4, 4};
        int p = 0;
        int[] startScans = new int[]{0, 0, 4, 0, 2, 0, 1};
        int[] countScans = new int[]{8, 8, 8, 4, 4, 2, 2};
        int[] starts = new int[]{0, 4, 0, 2, 0, 1, 0};
        int[] counts = new int[]{8, 8, 4, 4, 2, 2, 1};
        byte[] pixels = new byte[info.bps * nComp / 8];
        int pixLen = info.bps * nComp;
        for (int i = 0; i < 7; ++i) {
            int jj = (info.height >> 3) * totalRows[i] + furtherY[i];
            int totalPoints = (info.width >> 3) * totalCols[i] + furtherX[i];
            for (int j = 0; j < jj; ++j) {
                byte[] interScan = scanList.get(p++);
                ByteBuffer buffer = ByteBuffer.wrap(interScan);
                BitReader reader = new BitReader(interScan);
                byte[] imgScan = (byte[])result.get(startScans[i]);
                switch (i) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        int z;
                        int x = starts[i];
                        if (info.bps < 8) {
                            for (z = 0; z < totalPoints; ++z) {
                                int pixel = reader.readBits(pixLen);
                                PngDecoder.fillBits(imgScan, x, pixel, pixLen);
                                x += counts[i];
                            }
                        } else {
                            for (z = 0; z < totalPoints; ++z) {
                                buffer.get(pixels);
                                System.arraycopy(pixels, 0, imgScan, x * pixels.length, pixels.length);
                                x += counts[i];
                            }
                        }
                        break;
                    }
                    case 6: {
                        System.arraycopy(interScan, 0, imgScan, 0, interScan.length);
                    }
                }
                int n = i;
                startScans[n] = startScans[n] + countScans[i];
            }
        }
        return result;
    }

    private static void fillBits(byte[] imgScan, int x, int pixel, int pixLen) {
        if (pixLen == 8) {
            imgScan[x] = (byte)pixel;
            return;
        }
        int bp = x * pixLen >> 3;
        int vv = imgScan[bp] & 0xFF;
        int l = x * pixLen % 8;
        int r = 8 - l;
        int m = r - pixLen;
        imgScan[bp] = (byte)(vv >> r << r | pixel << m | vv & LEFTVALUES[m]);
    }

    private static BufferedImage getImageFromList(List<byte[]> scanList, Info info) {
        switch (info.colorType) {
            case 0: 
            case 4: {
                return PngDecoder.getGrayImage(scanList, info);
            }
            case 2: 
            case 6: {
                return PngDecoder.getRGBImage(scanList, info);
            }
            case 3: {
                return PngDecoder.getPaletteImage(scanList, info);
            }
        }
        return null;
    }

    private static BufferedImage getPaletteImage(List<byte[]> scanList, Info info) {
        IndexColorModel cm;
        int width = info.width;
        int height = info.height;
        int bps = info.bps;
        BufferedImage img = null;
        int p = 0;
        int scaneLine = (width * bps + 7) / 8;
        if (info.trnsData == null) {
            cm = new IndexColorModel(bps, info.rr.length, info.rr, info.gg, info.bb);
        } else {
            byte[] aa = new byte[info.rr.length];
            Arrays.fill(aa, (byte)-1);
            System.arraycopy(info.trnsData, 0, aa, 0, Math.min(info.rr.length, info.trnsData.length));
            cm = new IndexColorModel(bps, info.rr.length, info.rr, info.gg, info.bb, aa);
        }
        switch (bps) {
            case 1: 
            case 2: 
            case 4: {
                img = new BufferedImage(width, height, 12, cm);
                break;
            }
            case 8: {
                img = new BufferedImage(width, height, 13, cm);
            }
        }
        if (img != null) {
            byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
            for (byte[] scan : scanList) {
                System.arraycopy(scan, 0, imgData, p * scaneLine, scaneLine);
                ++p;
            }
        }
        return img;
    }

    private static BufferedImage getRGBImage(List<byte[]> scanList, Info info) {
        float[] rgb;
        int width = info.width;
        int height = info.height;
        int bps = info.bps;
        int p = 0;
        int nComp = info.getNComp();
        int scanLen = width * nComp;
        BufferedImage img = info.colorType == 2 ? new BufferedImage(width, height, 5) : new BufferedImage(width, height, 6);
        byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        if (bps == 8) {
            for (byte[] scan : scanList) {
                System.arraycopy(scan, 0, imgData, p * scanLen, scanLen);
                ++p;
            }
        } else {
            for (byte[] scan : scanList) {
                int k = 0;
                byte[] curScan = new byte[scanLen];
                for (int j = 0; j < scanLen; ++j) {
                    curScan[j] = scan[k++];
                    ++k;
                }
                System.arraycopy(curScan, 0, imgData, p * scanLen, scanLen);
                ++p;
            }
        }
        p = 0;
        if (info.colorType == 2) {
            if (info.cs != null) {
                rgb = new float[3];
                for (int i = 0; i < imgData.length; i += 3) {
                    rgb[0] = (float)(imgData[i] & 0xFF) / 255.0f;
                    rgb[1] = (float)(imgData[i + 1] & 0xFF) / 255.0f;
                    rgb[2] = (float)(imgData[i + 2] & 0xFF) / 255.0f;
                    rgb = info.cs.toRGB(rgb);
                    imgData[i] = (byte)(rgb[0] * 255.0f);
                    imgData[i + 1] = (byte)(rgb[1] * 255.0f);
                    imgData[i + 2] = (byte)(rgb[2] * 255.0f);
                }
            }
            while (p < imgData.length) {
                byte t0 = imgData[p];
                imgData[p] = imgData[p + 2];
                imgData[p + 2] = t0;
                p += 3;
            }
        } else {
            if (info.cs != null) {
                rgb = new float[3];
                for (int i = 0; i < imgData.length; i += 4) {
                    rgb[0] = (float)(imgData[i] & 0xFF) / 255.0f;
                    rgb[1] = (float)(imgData[i + 1] & 0xFF) / 255.0f;
                    rgb[2] = (float)(imgData[i + 2] & 0xFF) / 255.0f;
                    rgb = info.cs.toRGB(rgb);
                    imgData[i] = (byte)(rgb[0] * 255.0f);
                    imgData[i + 1] = (byte)(rgb[1] * 255.0f);
                    imgData[i + 2] = (byte)(rgb[2] * 255.0f);
                }
            }
            while (p < imgData.length) {
                byte t3;
                byte t0 = imgData[p];
                byte t1 = imgData[p + 1];
                byte t2 = imgData[p + 2];
                imgData[p] = t3 = imgData[p + 3];
                imgData[p + 1] = t2;
                imgData[p + 2] = t1;
                imgData[p + 3] = t0;
                p += 4;
            }
        }
        return img;
    }

    private static BufferedImage getGrayImage(List<byte[]> scanList, Info info) {
        int width = info.width;
        int height = info.height;
        int bps = info.bps;
        BufferedImage img = null;
        int p = 0;
        int nComp = info.getNComp();
        int scaneLine = (width * bps * nComp + 7) / 8;
        byte[] bits2Pal = new byte[]{0, 85, -86, -1};
        byte[] bits4Pal = new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1};
        switch (bps) {
            case 1: {
                img = new BufferedImage(width, height, 12);
                byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                for (byte[] scan : scanList) {
                    System.arraycopy(scan, 0, imgData, p * scaneLine, scaneLine);
                    ++p;
                }
                break;
            }
            case 2: {
                IndexColorModel cm = new IndexColorModel(2, 4, bits2Pal, bits2Pal, bits2Pal);
                img = new BufferedImage(width, height, 12, cm);
                byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                for (byte[] scan : scanList) {
                    System.arraycopy(scan, 0, imgData, p * scaneLine, scaneLine);
                    ++p;
                }
                break;
            }
            case 4: {
                IndexColorModel cm = new IndexColorModel(4, 16, bits4Pal, bits4Pal, bits4Pal);
                img = new BufferedImage(width, height, 12, cm);
                byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                for (byte[] scan : scanList) {
                    System.arraycopy(scan, 0, imgData, p * scaneLine, scaneLine);
                    ++p;
                }
                break;
            }
            case 8: {
                if (info.getNComp() == 2) {
                    img = new BufferedImage(width, height, 6);
                    byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                    for (byte[] scan : scanList) {
                        int k = 0;
                        for (int j = 0; j < width; ++j) {
                            byte r = scan[k++];
                            byte a = scan[k++];
                            imgData[p++] = a;
                            imgData[p++] = r;
                            imgData[p++] = r;
                            imgData[p++] = r;
                        }
                    }
                } else {
                    img = new BufferedImage(width, height, 10);
                    byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                    for (byte[] scan : scanList) {
                        System.arraycopy(scan, 0, imgData, p * scaneLine, scaneLine);
                        ++p;
                    }
                    if (info.cs == null) break;
                    float[] rgb = new float[1];
                    for (int i = 0; i < imgData.length; ++i) {
                        rgb[0] = (float)(imgData[i] & 0xFF) / 255.0f;
                        rgb = info.cs.toRGB(rgb);
                        imgData[i] = (byte)(rgb[0] * 255.0f);
                    }
                }
                break;
            }
            case 16: {
                img = new BufferedImage(width, height, 11);
                short[] imgDataShort = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
                for (byte[] scan : scanList) {
                    int k = 0;
                    for (int j = 0; j < width; ++j) {
                        imgDataShort[p++] = (short)((scan[k++] & 0xFF) << 8 | scan[k++] & 0xFF);
                    }
                }
                break;
            }
        }
        return img;
    }

    private static void filterBytes(int mode, byte[] curScan, byte[] prevScan, int width, int nComp) {
        switch (mode) {
            case 1: {
                for (int i = 0; i < width; ++i) {
                    for (int j = 0; j < nComp; ++j) {
                        int off = j + i * nComp;
                        int prevOff = j + (i - 1) * nComp;
                        int a = i == 0 ? 0 : curScan[prevOff] & 0xFF;
                        int x = curScan[off] & 0xFF;
                        curScan[off] = (byte)(a + x & 0xFF);
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < width; ++i) {
                    for (int j = 0; j < nComp; ++j) {
                        int off = j + i * nComp;
                        int x = curScan[off] & 0xFF;
                        int b = prevScan != null ? prevScan[off] & 0xFF : 0;
                        curScan[off] = (byte)(x + b & 0xFF);
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < width; ++i) {
                    for (int j = 0; j < nComp; ++j) {
                        int off = j + i * nComp;
                        int x = curScan[off] & 0xFF;
                        int prevOff = j + (i - 1) * nComp;
                        int a = i == 0 ? 0 : curScan[prevOff] & 0xFF;
                        int b = prevScan != null ? prevScan[off] & 0xFF : 0;
                        curScan[off] = (byte)(x + (a + b >> 1) & 0xFF);
                    }
                }
                break;
            }
            case 4: {
                if (prevScan == null) {
                    for (int i = 0; i < width; ++i) {
                        for (int j = 0; j < nComp; ++j) {
                            int off = j + i * nComp;
                            int prevOff = j + (i - 1) * nComp;
                            int a = i == 0 ? 0 : curScan[prevOff] & 0xFF;
                            int x = curScan[off] & 0xFF;
                            curScan[off] = (byte)(a + x & 0xFF);
                        }
                    }
                } else {
                    for (int i = 0; i < width; ++i) {
                        for (int j = 0; j < nComp; ++j) {
                            int off = j + i * nComp;
                            int x = curScan[off] & 0xFF;
                            int prevOff = j + (i - 1) * nComp;
                            int a = i == 0 ? 0 : curScan[prevOff] & 0xFF;
                            int b = prevScan[off] & 0xFF;
                            int c = i == 0 ? 0 : prevScan[prevOff] & 0xFF;
                            int p = a + b - c;
                            int pa = Math.abs(p - a);
                            int pb = Math.abs(p - b);
                            int pc = Math.abs(p - c);
                            int pr = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
                            curScan[off] = (byte)(x + pr & 0xFF);
                        }
                    }
                }
                break;
            }
        }
    }

    private static int findNullIndex(byte[] temp) {
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i] != 0) continue;
            return i;
        }
        return -1;
    }
}

